

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppDeconfigureUnprotectedVMs.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  AppDeconfigureUnprotectedVMs.sp		                      */
/*                                                                            */
/*  Description :  It will deconfigure the Unprotected VMs					  */
/*					(which are marked for deconfigure)						  */
/*				  															  */
/******************************************************************************/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppDeconfigureUnprotectedVMs.sp,v $ $Id: AppDeconfigureUnprotectedVMs.sp,v 1.1.2.1 2020/03/20 19:24:02 scheppuri Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppDeconfigureUnprotectedVMs')
BEGIN
	print '>>> Drop Stored Procedure: AppDeconfigureUnprotectedVMs <<<'
	drop procedure AppDeconfigureUnprotectedVMs
END
IF EXISTS (select * from GxQscripts where name='AppDeconfigureUnprotectedVMs')
	delete from GxQscripts where name = 'AppDeconfigureUnprotectedVMs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeconfigureUnprotectedVMs')
	delete from GXDBVersions where aliasname = 'AppDeconfigureUnprotectedVMs'
GO
print '... Creating Procedure: AppDeconfigureUnprotectedVMs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppDeconfigureUnprotectedVMs
AS
  DECLARE @retVal INT
SET NOCOUNT ON
BEGIN
SET @retVal = 0
DECLARE @noOfDaysToKeepUnProtectedVMs INTEGER
SET     @noOfDaysToKeepUnProtectedVMs = 30
--Get parameter to consider number of days to keep VMs after stopped getting backedup
SELECT @noOfDaysToKeepUnProtectedVMs = isnull(value, 30)
FROM Gxglobalparam WITH (NOLOCK)
WHERE name = 'NumberOfDaysToKeepUnProtectedVMs'
DECLARE @VMdeconfigureTime INTEGER
SET @VMdeconfigureTime = dbo.GetUnixTime(GETUTCDATE()) - @noOfDaysToKeepUnProtectedVMs * 24 * 3600
IF OBJECT_ID('tempdb.dbo.#ConfigureOrDeConfigureVMBackupsets_vmClientIdList') IS NOT NULL
    DROP TABLE #ConfigureOrDeConfigureVMBackupsets_vmClientIdList
CREATE TABLE #ConfigureOrDeConfigureVMBackupsets_vmClientIdList (
    vmClientId INT,
    vmBackupSetId INT,
    PRIMARY KEY (vmClientId, vmBackupSetId)
)
--DeConfigure VM clients which are marked for deconfigure and the expiry time has reached
INSERT INTO #ConfigureOrDeConfigureVMBackupsets_vmClientIdList
	SELECT distinct VMClientId,ChildBackupSetId FROM APP_VMBackupSet vmb
inner join APP_BackupSetProp bsProp on bsProp.attrName = 'Marked For Deconfigure' AND bsProp.componentNameId = vmb.ChildBackupSetId AND bsProp.modified = 0
	and isnull(bsProp.attrVal,0) !=0 and cast(bsProp.attrval as int) < @VMdeconfigureTime
IF EXISTS (SELECT 1 from #ConfigureOrDeConfigureVMBackupsets_vmClientIdList)
BEGIN
	EXEC ConfigureOrDeConfigureVMBackupsets 0
END
SET	@retVal = @@ERROR
SELECT	@retVal
SET NOCOUNT OFF
END
GO


IF EXISTS (select * from GxQscripts where name = 'AppDeconfigureUnprotectedVMs')
	delete from GxQscripts where name = 'AppDeconfigureUnprotectedVMs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeconfigureUnprotectedVMs')
	delete from GXDBVersions where aliasname = 'AppDeconfigureUnprotectedVMs'
GO

insert into GXDBVersions values(2, 'AppDeconfigureUnprotectedVMs',  '00010001000200010000', 'AppDeconfigureUnprotectedVMs', '00010001000200010000')
GO

