

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppDeconfigureAllEntities.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppDeconfigureAllEntities')
BEGIN
	print '>>> Drop Stored Procedure: AppDeconfigureAllEntities <<<'
	drop procedure AppDeconfigureAllEntities
END
IF EXISTS (select * from GxQscripts where name='AppDeconfigureAllEntities')
	delete from GxQscripts where name = 'AppDeconfigureAllEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeconfigureAllEntities')
	delete from GXDBVersions where aliasname = 'AppDeconfigureAllEntities'
GO
print '... Creating Procedure: AppDeconfigureAllEntities'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppDeconfigureAllEntities
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--   PARAMETERS   &   OUTPUTS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @EntityId integer,
  @ClientId integer = 0,
  @EntityType integer 
AS
  DECLARE @errorCode integer 
  DECLARE @errorString nvarchar(max)
BEGIN
SET NOCOUNT ON
-- hierarchy - lowest to highest
-- subclient, backupset, instance,agent,client
-- Use case - we are trying to reset the status based on the entity level provided
BEGIN TRY
IF @EntityType = 7
BEGIN
	update APP_Application set subclientStatus = subclientStatus | 2
	where APP_Application.id = @EntityId
	and subclientStatus <> (subclientStatus | 2)
END
ELSE IF @EntityType= 6
BEGIN
	update APP_Application set subclientStatus = subclientStatus | 2
	where APP_Application.backupset = @EntityId
	and subclientStatus <> (subclientStatus | 2)
	update APP_BackupSetName set status = status | 2
	where APP_BackupSetName.id = @EntityId
	and status <> (status | 2)
END
ELSE IF @EntityType = 5
BEGIN
	update APP_Application set subclientStatus = subclientStatus | 2
	where APP_Application.instance = @EntityId
	and subclientStatus <> (subclientStatus | 2)
	update APP_BackupSetName set status = status | 2
	where APP_BackupSetName.id IN
		(select backupset from APP_Application where instance = @EntityId)
	and status <> (status | 2)
	update APP_InstanceName set status = status | 2
	where APP_InstanceName.id = @EntityId and APP_InstanceName.id <> 1
	and status <> (status | 2)
END
ELSE IF @EntityType = 4
BEGIN
	update APP_Application set subclientStatus = subclientStatus | 2
	where APP_Application.appTypeId = @EntityId and APP_Application.clientId = @clientId
	and subclientStatus <> (subclientStatus | 2)
	update APP_BackupSetName set status = status | 2
	where APP_BackupSetName.id IN
		(select backupset from APP_Application where appTypeId = @EntityId and clientId = @clientId)
	and status <> (status | 2)
	update APP_InstanceName set status = status | 2
	where APP_InstanceName.id IN
		(select instance from APP_Application where appTypeId = @EntityId and clientId = @clientId and instance != 1)
	and status <> (status | 2)
	update APP_IDAName set status = status | 2
	where APP_IDAName.appTypeid = @EntityId and APP_IDAName.clientId = @clientId
	and status <> (status | 2)
END
ELSE IF @EntityType =3
BEGIN
	update APP_ClientProp
	set attrVal = '1'
	where attrName LIKE 'sys:apptype: deleted%' AND attrVal = '0' AND modified = 0 AND 	componentNameId =@EntityID
	update APP_ClientProp
	set attrVal = '1'
	where attrName LIKE 'PlatformDeleted 4' AND attrVal = '0' AND modified = 0 AND 	componentNameId =@EntityID
	update APP_ClientProp
	set attrVal = '1'
	where attrName = 'deleted' AND attrVal = '0' AND modified = 0 AND 	componentNameId =@EntityID
	update APP_BackupSetName set status = status | 2
	where APP_BackupSetName.id IN
		(select backupset from APP_Application where clientId = @EntityId)
	and status <> (status | 2)
	update APP_InstanceName set status = status | 2
	where APP_InstanceName.id IN
		(select instance from APP_Application where clientId = @EntityId and instance != 1)
	and status <> (status | 2)
	update APP_Application set subclientStatus = subclientStatus | 2
	where APP_Application.clientId = @EntityId
	and subclientStatus <> (subclientStatus | 2)
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode   = 1
	SET @errorString = 'Problem Executing AppDeleteAllEntities Error Message [' + ERROR_MESSAGE() + '].'
END CATCH
	SELECT @errorCode,@errorString
END
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--  END
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'AppDeconfigureAllEntities')
	delete from GxQscripts where name = 'AppDeconfigureAllEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeconfigureAllEntities')
	delete from GXDBVersions where aliasname = 'AppDeconfigureAllEntities'
GO

insert into GXDBVersions values(2, 'AppDeconfigureAllEntities',  '00000000000000000000', 'AppDeconfigureAllEntities', '00000000000000000000')
GO

