

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppDeactivateLaptopForUser.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +================================================================================================+
--  |   Procedure:  AppDeactivateLaptopForUser()
--  |
--  | Description:  SP for disassociating laptop to pseudo client
--  |
--  |       Input:  list of userIds table with userId as the column name,executing user Id and locale id
--  |      Output:  ErrorCode, ErrorString to determine status of the operation
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  snagendra  	To deactivate a laptop client for a list of users
--  +================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppDeactivateLaptopForUser <<<'

IF EXISTS (select * from sysobjects where name='AppDeactivateLaptopForUser')
	drop procedure AppDeactivateLaptopForUser
IF EXISTS (select * from GxQscripts where name='AppDeactivateLaptopForUser')
	delete from GxQscripts where name = 'AppDeactivateLaptopForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeactivateLaptopForUser')
	delete from GXDBVersions where aliasname = 'AppDeactivateLaptopForUser'
GO
print '... Creating Procedure: AppDeactivateLaptopForUser'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppDeactivateLaptopForUser
  @userTbl varchar(100),
  @execUserId INT,
  @localeId INT
AS
  DECLARE @errorCode integer
  DECLARE @errorString nvarchar(max)
SET @errorCode = 0
SET @errorString = ''
BEGIN TRY
	DECLARE @isUserAdmin            integer =0
	Create table #reassociateUsers ( userId INT primary key)
	declare @stmtbuff       nvarchar(MAX)
	-- Verify if the exec user has admin management on the input clients.
    EXECUTE sec_isUserAdmin   @i_userid = @execUserId ,@o_isUserAdmin = @isUserAdmin  OUTPUT
    IF ( @isUserAdmin <> 1 )
    BEGIN
			SET @errorCode = 1
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (81 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
			SET @errorString = REPLACE(@errorString, '^1%s', (SELECT login FROM UMUSERS where id = @execUserId) )
			--SET @errorString = REPLACE(@errorString, '^2%s', (SELECT name FROM APP_CLIENT where id = @pseudoClientId))
			GOTO GENERATE_OUTPUT
	END
	DECLARE @clientsAssociatedToUsers table (clientId INT,
                                             userId INT,
											 usercentric INT,
											 activatedMode INT,
											 PRIMARY KEY (clientId, userId))
	SET @stmtbuff = 'INSERT INTO #reassociateUsers SELECT userId FROM ' + @userTbl
	EXEC (@stmtbuff)
	-- Need All clients Associated to this user.
	-- Initially set activated Mode to device centric
	INSERT INTO @clientsAssociatedToUsers
	SELECT distinct owners.ClientID,owners.userId,0,1 FROM sec_getClientOwners(1)
	owners where owners.userId IN ( SELECT userId FROM #reassociateUsers )
	-- SELECT All user centric and its associated physical clients.
	MERGE @clientsAssociatedToUsers as DEST
	USING (
				SELECT componentNameId,attrName,attrval FROM
				APP_CLIENTPROP JOIN  @clientsAssociatedToUsers
				ON componentNameId = clientId
WHERE attrname IN ('User Centric Client','Physical Client Id')
			) AS SRC
ON (DEST.clientId = SRC.componentNameId and SRC.attrName = 'User Centric Client')
	WHEN MATCHED THEN UPDATE  SET userCentric = '1',activatedMode = -1
	WHEN NOT MATCHED BY TARGET THEN
			INSERT (clientId,userId,usercentric,activatedMode) VALUES
			(SRC.attrval,0,0,2);
    -- REMOVE PHYSICAL CLIENT ID, dont rename the prop as the user is removed and old value is not needed.
	-- REMOVE PLAN ID, dont rename the prop as the user is removed and old value is not needed.
	UPDATE app_clientprop set attrval = 0
WHERE attrname IN ('Physical Client Id','Associated Plan')
	and componentNameId IN (SELECT distinct clientId FROM @clientsAssociatedToUsers)
	DELETE app_clientprop
WHERE attrname = 'Activated Mode'
	AND componentNameId  IN (SELECT distinct clientId FROM @clientsAssociatedToUsers)
	-- Deconfigure the user centric clients
	UPDATE APP_CLIENT SET STATUS |= 2
	WHERE id IN (SELECT distinct clientId FROM @clientsAssociatedToUsers
                            where userCentric = 1)
	MERGE  App_ClientProp as Dest
            USING (SELECT distinct clientId FROM @clientsAssociatedToUsers
                            where userCentric = 1) AS Src
            on  Dest.componentNameId = Src.clientId
                AND Dest.attrName = 'PlatformDeleted 4'
                AND Dest.modified = 0
            WHEN MATCHED
                THEN UPDATE SET attrVal = '1'
            WHEN NOT MATCHED THEN
            INSERT (componentNameId, attrName, attrType, attrVal, created, modified , ccpId)
            Values( Src.clientId, 'PlatformDeleted 4', 1, '1', dbo.GetUnixTime(GetUTCDate()), 0, 0);
	-- REFRESH SMART CLIENT GROUPS - Update all clients of these users.
	IF OBJECT_ID('tempdb.dbo.#AppSCGUpdateClientExtTable') IS NOT NULL
		DROP TABLE #AppSCGUpdateClientExtTable
	CREATE TABLE #AppSCGUpdateClientExtTable (
		clientId		INT PRIMARY KEY
	)
	INSERT INTO #AppSCGUpdateClientExtTable(clientId)
		SELECT distinct clientId FROM @clientsAssociatedToUsers
	-- clientId=-1 process #AppSCGUpdateClientExtTable Temp Table
	EXEC AppSCGUpdateClient 1, -1
    DECLARE @cId INT=0
    DECLARE @uId INT=0
    DECLARE @activatedMode INT=0
	-- Fix work queue spb to take in a table of clientIds.
	DECLARE wqCursor CURSOR STATIC FOR
        Select [clientId],[userId],[activatedMode] FROM @clientsAssociatedToUsers
        WHERE activatedMode in (1,2) and userCentric = 0
        OPEN wqCursor
        FETCH NEXT From wqCursor INTO @cId,@uId,@activatedMode
        WHILE @@FETCH_STATUS = 0
		BEGIN
				--Push OSC on reactivate or deactivate
				DECLARE @workQOutPutTbl table (errCode INT,errString nvarchar(max))
			    INSERT INTO @workQOutPutTbl
				EXEC AppWorkQueueSubmitRequest 4, 0, 0, @cId, 0, '' -- WORK_TOKEN_OSC
				SELECT @errorCode = errCode, @errorString = errString FROM @workQOutPutTbl
				DECLARE @workQueueXML XML
				DECLARE @workQueueParam nvarchar(max)
				SET @workQueueXML = (   SELECT
                                        (SELECT
                                            (  SELECT '0' AS '@enable',  --SYNC_PAUSED
                                                    '8' AS '@featureType'-- ACTIVATION
                                                    FOR XML PATH('featureDetails'), TYPE
                                            ),
                                            (
                                                SELECT
                                                    (case(@activatedMode)
                                                        when 2 then U.login
                                                        when 1 then 'AllUsers'
                                                        end) as '@userName',
				                                id as '@userId'
				                                FROM UMUSers U
				                                where U.id = @uId
				                                FOR XML PATH('user'),TYPE
                                            )
                                        FOR XML PATH('userFeatureList'), TYPE)
                                        FOR XML PATH('App_UpdateFeatureList'), TYPE
                                    )
				 SET @workQueueParam = CAST(@workQueueXML AS NVARCHAR(MAX))
				--Push token param on deactivation
				INSERT INTO @workQOutPutTbl
				EXEC AppWorkQueueSubmitRequest 28/*WORK_TOKEN_FEATURE_LIST*/, 0, 0, @cId, 0, @workQueueParam
				SELECT @errorCode = errCode, @errorString = errString FROM @workQOutPutTbl
        FETCH NEXT From wqCursor INTO @cId,@uId,@activatedMode
        END
        CLOSE       wqCursor
        DEALLOCATE  wqCursor
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
            SET @errorCode = ERROR_NUMBER()
            SET @errorString = 'Error during sp execution. Error Message :' + ERROR_MESSAGE()
END  CATCH
GENERATE_OUTPUT:
		drop table #reassociateUsers
GO

IF EXISTS (select * from GxQscripts where name = 'AppDeactivateLaptopForUser')
	delete from GxQscripts where name = 'AppDeactivateLaptopForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeactivateLaptopForUser')
	delete from GXDBVersions where aliasname = 'AppDeactivateLaptopForUser'
GO

insert into GXDBVersions values(2, 'AppDeactivateLaptopForUser',  '00000000000000000000', 'AppDeactivateLaptopForUser', '00000000000000000000')
GO

