

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppDeactivateLaptop.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +================================================================================================+
--  |   Procedure:  AppDeactivateLaptop()
--  |
--  | Description:  SP for disassociating laptop to pseudo client
--  |
--  |       Input:  Physical client(laptop) ID, pseudo client id, user id
--  |      Output:  ErrorCode, ErrorString to determine status of the operation
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  snagendra  	To deactivate a laptop client
--  +================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppDeactivateLaptop')
BEGIN
	print '>>> Drop Stored Procedure: AppDeactivateLaptop <<<'
	drop procedure AppDeactivateLaptop
END
IF EXISTS (select * from GxQscripts where name='AppDeactivateLaptop')
	delete from GxQscripts where name = 'AppDeactivateLaptop'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeactivateLaptop')
	delete from GXDBVersions where aliasname = 'AppDeactivateLaptop'
GO
print '... Creating Procedure: AppDeactivateLaptop'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppDeactivateLaptop
  @userId INT,
  @localeId INT,
  @physicalClientId INT,
  @pseudoClientId INT,
  @deactivate INT
AS
  DECLARE @errorCode integer
  DECLARE @errorString nvarchar(max)
DECLARE @planId INTEGER
DECLARE @userCentric INTEGER
SET @errorCode = 0
SET @errorString = ''
SET @planId = 0
BEGIN TRY
	DECLARE @now BIGINT = dbo.GetUnixTime(GetUTCDate())
	DECLARE @val INT
	DECLARE @clientGroupId INT
	DECLARE @workQueueParam NVARCHAR(MAX)
	IF @deactivate = 1
	BEGIN
		-- Get the activated Mode
		--NOT_ACTIVATED 0
		--ACTIVATED_MODE_DEVICE_CENTRIC 1
		--ACTIVATED_MODE_USER_CENTRIC 2
		DECLARE @activatedMode INT = ISNULL((SELECT attrval FROM APP_CLIENTPROP
WHERE attrname = 'Activated Mode' and modified = 0 AND componentNameId=@physicalClientId),0)
		-- Not activated. No need to deactivate.
IF @activatedMode = 0
		BEGIN
SET @errorCode = (2846 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2846 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
			GOTO GENERATE_OUTPUT
		END
        --How should it behave in case of software uninstall. How to impose user validation on uninstall?
        --User centric mode - software uninstalled?
        --Installer always sends it 0
        IF (@userId <> 0)
        BEGIN
		    -- User has permissions to deactivate. Do security check
		    If dbo.isClientOwner(@pseudoClientId,@userId) <> 1
		    BEGIN
				DECLARE @userHasCapability INT = 0
EXEC sec_checkPermissionOnEntity @userId, 2, @userHasCapability OUTPUT, 3, @pseudoClientId
				IF @userHasCapability = 0
				BEGIN
SET @errorCode = (2172 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2845 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
					SET @errorString = REPLACE(@errorString, '^1%s', ISNULL((SELECT login FROM UMUSERS where id = @userId),N'' ))
					SET @errorString = REPLACE(@errorString, '^2%s', ISNULL((SELECT name FROM APP_CLIENT where id = @pseudoClientId),N''))
					GOTO GENERATE_OUTPUT
				END
		    END
IF NOT EXISTS (SELECT componentNameId FROM App_clientProp where attrname = 'Physical Client Id' and componentNameId = @pseudoclientId
		    and attrval = @physicalClientId and modified=0) AND @pseudoClientId <> @physicalClientId
		    BEGIN
SET @errorCode = (2172 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2846 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
                --SET @errorString = 'Incorrect request. Cannot deassociate.'
			    GOTO GENERATE_OUTPUT
		    END
        END
		SET @val = 0
		-- Software is uninstalled on physical
IF @activatedMode = 1
        BEGIN
            SET @pseudoClientId = @physicalClientId
			DELETE app_clientprop
WHERE attrname = 'Activated Mode'
			AND componentNameId  =  @physicalClientId
			-- Get the current plan id before removal
DECLARE @oldPlanId INT = (ISNULL((SELECT attrVal FROM APP_CLIENTPROP WHERE attrname = 'Associated Plan'
			AND componentNameId =  @physicalClientId AND modified=0), 0))
			IF (@oldPlanId > 0)
			BEGIN
SET @clientGroupId = dbo.AppPlanGetEntityValueV2(@oldPlanId, 'Assigned client group', 2)
			END
			-- REMOVE PLAN
			UPDATE app_clientprop set attrval = 0
WHERE attrname = 'Associated Plan'
			AND componentNameId =  @physicalClientId AND modified=0 AND attrVal <> N'0'
        END
ELSE IF (@activatedMode = 2 )
		BEGIN
			DECLARE @userCentricClients table ( clientId INTEGER)
			IF @pseudoClientId = NULL OR @pseudoClientId = 0
			BEGIN
				-- Software uninstall on laptop, userid and pseudoclient is unavailable
				-- deconfigure all user centric clients and
				-- Get all user client clients with this physical clientid set as laptop
				INSERT INTO @userCentricClients
				SELECT componentNameId FROM APP_CLIENTPROP
WHERE attrname = 'Physical Client Id'
				AND attrval = CAST(@physicalClientId AS VARCHAR(10)) AND modified=0
			END
			ELSE
			BEGIN
				INSERT INTO @userCentricClients
				SELECT @pseudoClientId
			END
			-- RESTORE PHYSICAL CLIENT ID BY RENAMING PROPERTY NAME
UPDATE app_clientprop set attrname = 'Physical Client Id on hold'
			WHERE
attrname = 'Physical Client Id'
			AND componentNameId  IN (SELECT clientId FROM @userCentricClients) AND modified=0
			-- REMOVE PLAN
			UPDATE app_clientprop set attrval = 0
WHERE attrname = 'Associated Plan'
			AND componentNameId IN (SELECT clientId FROM @userCentricClients) AND modified=0
			--Deconfigure all pseudoclients
			UPDATE APP_CLIENT SET STATUS |= 2
			WHERE id IN (SELECT clientId FROM @userCentricClients)
			MERGE  App_ClientProp as Dest
            USING (SELECT DISTINCT clientId FROM @userCentricClients) AS Src
            on  Dest.componentNameId = Src.clientId
                AND Dest.attrName = 'PlatformDeleted 4'
                AND Dest.modified = 0
            WHEN MATCHED  AND Dest.attrVal <> N'1'
                THEN UPDATE SET attrVal = '1'
            WHEN NOT MATCHED THEN
            INSERT (componentNameId, attrName, attrType, attrVal, created, modified , ccpId)
            Values( Src.clientId, 'PlatformDeleted 4', 1, '1', @now, 0, 0);
			-- Last User centric client then release physical client.
IF (SELECT COUNT(componentNameId) FROM App_clientProp where attrname = 'Physical Client Id'
					and attrval = @physicalClientId and modified=0)  = 0
			BEGIN
				DELETE app_clientprop
WHERE attrname = 'Activated Mode'
				AND componentNameId  =  @physicalClientId
			END
		END
	END
	ELSE
	BEGIN
		-- Associate pseudo client of user mapped to another physical client
		-- Reassociate if pseudoclient is not given, just user and physical is given
		-- With just user Id, we might end up with many user centric clients
		-------------------------------------------------------------------------------------------------------------------------------------------
--- CODE BELOW HERE IS FROM AppGetPlanForUser.spb  ----------
-- in order to use variables to be declared are : INPUT : @userId INT, OUTPUT @plandId INT, userCentric INT
-- also "SPBodies\AppPlanConstants.spb" should be included before using this snippet
-- Check If user preference for activation of laptop as user centric client is disabled
-- As per discussion with Bhavyan - We will refer only those user groups which are assigned to a plan to determine user activation type
-- Sequence - User->Global Level->Company Level(for Sp11 at advance settings)->User Group Level
-- Item higher in priority order is checked for for User Centric preference only.
-- If someone has "Device Centric" set at higher level in priority but still has user centric down the line, then we will use user centric
DECLARE @userOrgId INT = dbo.AppGetOrganizationForUser(@userId)
DECLARE @priTable AS TABLE (fIsUserCentric INT, PriorityLevel INT)
INSERT INTO @priTable
    SELECT UUP.attrVal, 1 from UMUsers UU WITH(NOLOCK) INNER JOIN UMUsersProp UUP WITH(NOLOCK) ON UU.id=UUP.componentNameId
WHERE UU.id = @userId AND (UUP.attrName = 'Prefer Machine Centric Client' AND UUP.attrType = 7)
	UNION ALL
SELECT value, 2 from GXGlobalParam WITH(NOLOCK) where name='Prefer Machine Centric Client' AND value=N'0'
	UNION ALL
SELECT CAST(attrval AS INT), 3 FROM App_CompanyProp WITH(NOLOCK) WHERE attrname='Prefer Machine Centric Client' AND componentNameId=@userOrgId AND attrval=N'0' AND  cs_attrName = checksum('Prefer Machine Centric Client')
	UNION ALL
    SELECT UGP.attrVal, 4  from UMUserGroup UUG WITH(NOLOCK)
		INNER JOIN UMGroupsProp UGP WITH(NOLOCK) ON UGP.componentNameId=UUG.groupId
INNER JOIN App_PlanProp APP WITH(NOLOCK) ON APP.attrVal=CAST(UUG.groupId AS NVARCHAR(64)) AND APP.attrName IN ('Assigned user group', 'Associated internal user group', 'Associated external user group')
WHERE UUG.userId = @userId AND (UGP.attrName = 'Prefer Machine Centric Client' AND UGP.attrType = 7 and UGP.attrVal='0')
DECLARE @fIsPreferenceMachineCentric INT = ISNULL((select TOP 1 fIsUserCentric  from @priTable order by PriorityLevel),1)
IF (@fIsPreferenceMachineCentric IS NOT NULL AND @fIsPreferenceMachineCentric = 1) OR (@fIsPreferenceMachineCentric IS NULL)
BEGIN
    SET @userCentric = 0
END ELSE BEGIN
    SET @userCentric = 1
END
-- check for direct plan association
SELECT @planId = CAST(attrVal AS INT) FROM UMUsersProp UUP WITH(NOLOCK)
	INNER JOIN App_Plan AP
ON UUP.attrVal=CAST(AP.id AS NVARCHAR(64)) AND ((AP.flag & 0x00004) = 0) AND ((AP.flag & 0x40000000) = 0)
WHERE UUP.componentNameId = @userId AND UUP.attrName = 'Associated Plan' AND UUP.modified=0
-- if there was no direct association try to get plan associated with the group to which user belongs
IF @planId IS NULL OR @planId = 0
BEGIN
	-- For device centric user, all type of group are OK as default preference is - Device Centric
    SET @planId = (SELECT  TOP 1 AP.id
                    FROM App_Plan AP WITH(NOLOCK)
						INNER JOIN UMUserGroup UUG WITH(NOLOCK)
							ON UUG.userId=@userId
						INNER JOIN UMGroupsProp UGP WITH(NOLOCK)
ON UGP.componentNameId=UUG.groupId AND UGP.attrName = 'Associated Plan' AND UGP.modified=0 AND CAST(AP.id AS NVARCHAR(64))=UGP.attrVal
						INNER JOIN App_PlanProp APP WITH(NOLOCK)
ON APP.componentNameId=AP.id AND APP.attrName IN ('Associated internal user group', 'Associated external user group') AND APP.modified=0
WHERE ((AP.flag & 0x00004) = 0) AND ((AP.flag & 0x40000000) = 0) AND APP.attrVal=CAST(UGP.componentNameId AS NVARCHAR(64)))
END
-- if user does not belong to any group and there was no direct plan association try to find organization to which user belongs
IF @planId IS NULL  OR @planId = 0 BEGIN
	-- To ensure we refer to the latest setting as per index in table (in case of multiple enteries)
    SELECT @planId =AP.id FROM APP_CompanyProp ACP WITH(NOLOCK)
		INNER JOIN App_Plan AP WITH(NOLOCK)
ON ACP.attrValInt=AP.id AND ((AP.flag & 0x00004) = 0) AND ((AP.flag & 0x40000000) = 0)
WHERE ACP.componentNameId=@userOrgId AND ACP.attrName='Default Laptop Plan' AND ACP.cs_attrName=checksum('Default Laptop Plan') AND ACP.modified=0
    IF (@planId IS NOT NULL)  AND (@planId <> 0)
    BEGIN
        DECLARE @planUserGroupId INT = 0
SELECT @planUserGroupId = attrval from App_PlanProp WITH(NOLOCK) WHERE componentNameId=@planId AND attrName = 'Assigned user group' AND modified=0
        Merge UMUsersProp As UUP
        USING (SELECT @userId) as SRC(userId)
ON SRC.userId = UUP.componentNameId AND UUP.attrName = 'Associated Plan' AND UUP.modified=0
            WHEN MATCHED THEN
                UPDATE SET attrVal = @planId
            WHEN NOT MATCHED THEN
INSERT(componentNameId, attrName, attrVal, attrType, created, modified ) VALUES(@userId, 'Associated Plan', @planId, 7, dbo.GetUnixTime(GetDate()), 0);
		IF NOT EXISTS (SELECT 1 FROM UMUserGroup WHERE userId=@userId AND groupId=@planUserGroupId)
		BEGIN
			INSERT INTO UMUserGroup
				VALUES (@userId, @planUserGroupId, 0)
		END
    END
END
--- CODE ABOVE HERE IS FROM AppGetPlanForUser.spb  ----------
		-------------------------------------------------------------------------------------------------------------------------------------------
		IF @pseudoClientId = NULL OR @pseudoClientId = 0
		BEGIN
			SET @errorCode = 3
            SET @errorString = 'No information about the pseudoclient to reassociate.'
			GOTO GENERATE_OUTPUT
		END
		SET @val = @physicalClientId
		IF @pseudoClientId <> @physicalClientId
		BEGIN
				-- RESTORE PHYSICAL CLIENT ID BY RENAMING PROPERTY NAME
				UPDATE app_clientprop set attrval = @val
WHERE attrname = 'Physical Client Id'
				AND componentNameId  =  @pseudoclientId AND modified = 0
				IF @@ROWCOUNT = 0
				BEGIN
					INSERT INTO App_ClientProp VALUES
(@pseudoClientId, 'Physical Client Id', 10, @val, @now, 0, 0)
				END
				MERGE App_ClientProp
				USING (SELECT @physicalClientId) AS SRC(id)
ON componentNameId=SRC.id AND attrName='Activated Mode'
				WHEN MATCHED THEN
UPDATE SET attrval=2
				WHEN NOT MATCHED THEN
						INSERT (componentNameId, attrName, attrType, attrVal, created, modified , ccpId)
VALUES (@physicalClientId, 'Activated Mode', 10,2, @now, 0, 0);
		END
		BEGIN
			-- We should handle and check user current state wrt to his current plan and old plan.
DELETE APP_ClientProp WHERE attrname = 'Associated Plan'
			AND componentNameId =  @pseudoclientId
			INSERT INTO App_ClientProp VALUES
(@pseudoClientId, 'Associated Plan', 10, @planId, @now, 0, 0)
		END
SET @clientGroupId = dbo.AppPlanGetEntityValueV2(@planId, 'Assigned client group', 2)
	END
	--Push work token to refresh smart client group
	SET @workQueueParam = '<App_ProcessSCGUpdate><processinginstructioninfo><user userId="' + CAST(@userId as nvarchar(max)) + '"/></processinginstructioninfo></App_ProcessSCGUpdate>'
	DECLARE @workQOutPutTbl table (errCode INT,errString nvarchar(max))
	IF (@clientGroupId IS NOT NULL AND @clientGroupId > 0)
	BEGIN
		EXEC AppSCGUpdateClient 1, @pseudoClientId, @clientGroupId
	END
	ELSE
	BEGIN
		INSERT INTO @workQOutPutTbl
		EXEC AppWorkQueueSubmitRequest 29, 0, 0, @pseudoclientId, 0, @workQueueParam  -- WORK_TOKEN_SCG_UPDATE_CLIENT
		SELECT @errorCode = errCode, @errorString = errString FROM @workQOutPutTbl
	END
	--Push OSC on reactivate or deactivate
    INSERT INTO @workQOutPutTbl
    EXEC AppWorkQueueSubmitRequest 4, 0, 0, @physicalClientId, 0, '' -- WORK_TOKEN_OSC
    SELECT @errorCode = errCode, @errorString = errString FROM @workQOutPutTbl
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
            SET @errorCode = ERROR_NUMBER()
            SET @errorString = 'Error During SP Execution. Error Message :' + ERROR_MESSAGE()
END  CATCH
GENERATE_OUTPUT:
		SELECT @errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'AppDeactivateLaptop')
	delete from GxQscripts where name = 'AppDeactivateLaptop'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeactivateLaptop')
	delete from GXDBVersions where aliasname = 'AppDeactivateLaptop'
GO

insert into GXDBVersions values(2, 'AppDeactivateLaptop',  '00000000000000000000', 'AppDeactivateLaptop', '00000000000000000000')
GO

