

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppDeactivateCompany.sp] ---------- 

--  +=============================================================================================+
--  |						Name: AppDeactivateCompany()
--  | Description: Allows for deactivation and activation of company for provided companyId
--  |
--  |       Input: XML, deactivate(0/1)
--  |      Output: ErrorCode, ErrorString and domainName
--  |      Author: sravanan
--  +=============================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppDeactivateCompany')
BEGIN
	print '>>> Drop Stored Procedure: AppDeactivateCompany <<<'
	drop procedure AppDeactivateCompany
END
IF EXISTS (select * from GxQscripts where name='AppDeactivateCompany')
	delete from GxQscripts where name = 'AppDeactivateCompany'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeactivateCompany')
	delete from GXDBVersions where aliasname = 'AppDeactivateCompany'
GO
print '... Creating Procedure: AppDeactivateCompany'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppDeactivateCompany
  @i_xmlText XML,
  @deactivate INT
AS
  DECLARE @errorCode integer
  DECLARE @errorString nvarchar(max)
  DECLARE @domainName nvarchar(510)
DECLARE @providerId INT = 0
DECLARE @localeId INT = 0
DECLARE @userId INT = 0
DECLARE @canManageProvider INT = 0
DECLARE @clientGroupId INT = 0
DECLARE @appId INT = 0
DECLARE @instance INT = 0
DECLARE @companyId INT = 0
DECLARE @isUserMSPAdmin INTEGER = 0
DECLARE @loginDisabled INT
DECLARE @backupDisabled INT
DECLARE @restoreDisabled INT
DECLARE @nowTime  INT = dbo.GetUnixTime(GETUTCDATE())
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	SET @errorCode = 0
	SET @errorString = ''
	SET @domainName = ''
	IF @deactivate = 1
	BEGIN
			SET @localeId = ISNULL(@i_xmlText.value('(//Api_DeactivateOrganizationRequest/processinginstructioninfo/locale/@localeId)[1]', 'int') , 0)
			SET @userId = ISNULL (( SELECT ref.value('@userId', 'INT')
							FROM @i_xmlText.nodes ('Api_DeactivateOrganizationRequest/processinginstructioninfo/user') R(ref)), 0)
			SET @providerId = ISNULL(@i_xmlText.value('(//Api_DeactivateOrganizationRequest/company/@providerId)[1]', 'INT'),0)
			SET @domainName = ISNULL(@i_xmlText.value('(//Api_DeactivateOrganizationRequest/company/@providerDomainName)[1]', 'nvarchar(510)'),'')
			SET @loginDisabled = ISNULL(@i_xmlText.value('(//Api_DeactivateOrganizationRequest/deactivateOptions/@disableLogin)[1]', 'INT'),1)
			SET @backupDisabled = ISNULL(@i_xmlText.value('(//Api_DeactivateOrganizationRequest/deactivateOptions/@disableBackup)[1]', 'INT'),1)
			SET @restoreDisabled = ISNULL(@i_xmlText.value('(//Api_DeactivateOrganizationRequest/deactivateOptions/@disableRestore)[1]', 'INT'),1)
	END
	ELSE
	BEGIN
			SET @localeId = ISNULL(@i_xmlText.value('(//Api_ActivateOrganizationRequest/processinginstructioninfo/locale/@localeId)[1]', 'int') , 0)
			SET @userId = ISNULL (( SELECT ref.value('@userId', 'INT')
							FROM @i_xmlText.nodes ('Api_ActivateOrganizationRequest/processinginstructioninfo/user') R(ref)), 0)
			SET @providerId = ISNULL(@i_xmlText.value('(//Api_ActivateOrganizationRequest/company/@providerId)[1]', 'INT'),0)
			SET @domainName = ISNULL(@i_xmlText.value('(//Api_ActivateOrganizationRequest/company/@providerDomainName)[1]', 'nvarchar(510)'),'')
	END
	SET @companyId = ISNULL(dbo.AppGetCompanyForProvider(@providerId),0)
	-- Invalid companyId in the request given so error out
	IF (@companyId = 0 OR @companyId <> @providerId)
	BEGIN
SET @errorCode = (3465 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3465 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
		GOTO SCRIPT_EXIT
	END
	-- Input is obtained via REST Api
	IF @domainName = ''
	BEGIN
		SET @domainName = ISNULL((SELECT domainName FROM UMDSProviders WITH (NOLOCK) WHERE id = @companyId),'')
	END
	IF(@userId > 0)
	BEGIN
EXEC sec_checkPermissionOnEntity @userId, 1, @canManageProvider OUTPUT, 61, @companyId
	END
	DECLARE @userCompanyId INT =0
	--get company id of the logged in user
	SET @userCompanyId = dbo.AppGetOrganizationForUser(@userId)
	--User cannot deactivate it's own company
	IF @canManageProvider <> 1 OR @companyId=@userCompanyId
	BEGIN
SET @errorCode = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString =  (SELECT message FROM EvLocaleMsgs WHERE messageId = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
		GOTO SCRIPT_EXIT
	END
SET @clientGroupId = ISNULL((SELECT attrValInt FROM App_CompanyProp WITH (NOLOCK) WHERE attrName = 'Associated Smart Client Group'
							AND componentNameId = @companyId),0)
SELECT @appId = id, @instance = instance FROM APP_Application WITH (NOLOCK) WHERE appTypeId = 1000
	IF @deactivate = 1
	BEGIN
		-- Do not disable the impersonate user accounts that we create inside a company. Even after deactivation, these operations should continue working.
		-- Tokens will be created for these impersonate user accounts.
DECLARE @impOptrUserFlg INT = CAST(0x8000 AS INT)
DECLARE @impViewUserFlg INT = CAST(0x20000 AS INT)
		-- Update the flag at UMDSProvider level
UPDATE UMDSProviders SET flags = flags|0x0010 WHERE id = @companyId AND ((flags & 0x0010) = 0)
		-- Update the enabled column at user level. This will prevent logins of users belonging to this company
		IF @loginDisabled = 1
		BEGIN
			UPDATE UMUsers SET enabled = 0 WHERE umdsproviderId IN (SELECT @companyId
				UNION SELECT id from UMDSProviders WITH (NOLOCK) WHERE ownerCompany = @companyId) AND enabled = 1
				AND (flags & @impOptrUserFlg = 0) AND (flags & @impViewUserFlg = 0)
			-- disable all saml apps associated with the company, and hence login or auto-user creation via the saml app.
			UPDATE ATP
			SET ATP.isEnabled = 0 From App_ThirdPartyApp ATP with (nolock)
			inner join UMDSProviderProp umdsProp with (nolock)
				on ATP.id = umdsProp.attrVal
			inner join UMDSProviders umds with (nolock)
				on umds.id = umdsProp.componentNameId
WHERE umds.serviceType = 11 AND umds.ownerCompany =  @companyId AND umdsProp.attrName = 'SAML IDP' AND ATP.isEnabled = 1
		END
		-- Disable Backup(opType: 4) and Restore(opType: 5) job activity on smart client group by setting action = 1 (DISABLEACTIVITY)
		-- action = 2 (ENABLEACTIVITY)
		IF @backupDisabled = 1 AND @clientGroupId <> 0
		BEGIN
UPDATE JMJobAction SET action = 1 WHERE clientId = 1 AND appType = 0 AND mediaAgentID = 1
				AND opType = 4 AND action = 2 AND clientGroupId = @clientGroupId
			IF @@ROWCOUNT = 0
			BEGIN
INSERT INTO JMJobAction VALUES(1,1,0,4,1,
					@appId,@clientGroupId,0,0,0,@instance,'')
			END
		END
		IF @restoreDisabled = 1 AND @clientGroupId <> 0
		BEGIN
UPDATE JMJobAction SET action = 1 WHERE clientId = 1 AND appType = 0 AND mediaAgentID = 1
				AND opType = 5 AND action = 2 AND clientGroupId = @clientGroupId
			IF @@ROWCOUNT = 0
			BEGIN
INSERT INTO JMJobAction VALUES(1,1,0,5,1,
					@appId,@clientGroupId,0,0,0,@instance,'')
			END
		END
		-- Need to delete any open sessions belonging to existing users of company
		IF @loginDisabled = 1
		BEGIN
			DELETE FROM UMQSDKSessions WHERE userId IN (SELECT id FROM UMUsers WITH (NOLOCK) WHERE umdsproviderId IN (SELECT @companyId
				UNION SELECT id from UMDSProviders WITH (NOLOCK) WHERE ownerCompany = @companyId) )
		END
		-- Update the App_CompanyProp table to reflect the options(login,backup,restore) set while deactivation
UPDATE App_CompanyProp SET attrVal = @loginDisabled WHERE attrName = 'Disable Login' AND
			componentNameId = @companyId
		IF @@ROWCOUNT = 0
		BEGIN
			INSERT into App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@companyId, 'Disable Login', 7, @loginDisabled, @nowTime, 0)
		END
UPDATE App_CompanyProp SET attrVal = @backupDisabled WHERE attrName = 'Disable Backup' AND
			componentNameId = @companyId
		IF @@ROWCOUNT = 0
		BEGIN
			INSERT into App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@companyId, 'Disable Backup', 7, @backupDisabled, @nowTime, 0)
		END
UPDATE App_CompanyProp SET attrVal = @restoreDisabled WHERE attrName = 'Disable Restore' AND
			componentNameId = @companyId
		IF @@ROWCOUNT = 0
		BEGIN
			INSERT into App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@companyId, 'Disable Restore', 7, @restoreDisabled, @nowTime, 0)
		END
		--While editing options in deactivation request, the MSP admin might set few to true. Hence handling the below cases
		IF @loginDisabled = 0
		BEGIN
			UPDATE UMUsers SET enabled = 1 WHERE umdsproviderId IN (SELECT @companyId
				UNION SELECT id from UMDSProviders WITH (NOLOCK) WHERE ownerCompany = @companyId) AND enabled = 0
			--enable saml apps!
			UPDATE ATP
			SET ATP.isEnabled = 1 From App_ThirdPartyApp ATP with (nolock)
			inner join UMDSProviderProp umdsProp with (nolock)
				on ATP.id = umdsProp.attrVal
			inner join UMDSProviders umds with (nolock)
				on umds.id = umdsProp.componentNameId
WHERE umds.serviceType = 11 AND umds.ownerCompany =  @companyId AND umdsProp.attrName = 'SAML IDP' AND ATP.isEnabled = 0
		END
		-- Enable Backup(opType: 4) and Restore(opType: 5) job activity on smart client group
		IF @backupDisabled = 0
		BEGIN
DELETE FROM JMJobAction WHERE clientId = 1 AND appType = 0 AND mediaAgentID = 1
				AND opType = 4 AND clientGroupId = @clientGroupId
		END
		IF @restoreDisabled = 0
		BEGIN
DELETE FROM JMJobAction WHERE clientId = 1 AND appType = 0 AND mediaAgentID = 1
				AND opType = 5 AND clientGroupId = @clientGroupId
		END
		-- Update the deactivation time for the company. This is required for reports to be generated
UPDATE App_CompanyProp SET attrVal = @nowTime WHERE attrName = 'Deactivation time' AND
			componentNameId = @companyId
		IF @@ROWCOUNT = 0
		BEGIN
			INSERT into App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@companyId, 'Deactivation time', 7, @nowTime, @nowTime, 0)
		END
	END
	ELSE
	BEGIN
		-- activate
		-- Update the flag at UMDSProvider level
UPDATE UMDSProviders SET flags = (flags& ~CAST(0x0010 AS INT)) WHERE id = @companyId AND ((flags & 0x0010) <> 0)
		-- Update the enabled flag at User level
		UPDATE UMUsers SET enabled = 1 WHERE umdsproviderId IN (SELECT @companyId
				UNION SELECT id from UMDSProviders WITH (NOLOCK) WHERE ownerCompany = @companyId) AND enabled = 0
		--enable saml apps
		UPDATE ATP
		SET ATP.isEnabled = 1 From App_ThirdPartyApp ATP with (nolock)
		inner join UMDSProviderProp umdsProp with (nolock)
			on ATP.id = umdsProp.attrVal
		inner join UMDSProviders umds with (nolock)
			on umds.id = umdsProp.componentNameId
WHERE umds.serviceType = 11 AND umds.ownerCompany =  @companyId AND umdsProp.attrName = 'SAML IDP' AND ATP.isEnabled = 0
		-- Enable Backup(opType: 4) and Restore(opType: 5) job activity on smart client group
DELETE FROM JMJobAction WHERE clientId = 1 AND appType = 0 AND mediaAgentID = 1
				AND ( opType = 4 OR opType = 5) AND clientGroupId = @clientGroupId AND @clientGroupId <> 0
		-- Enable login, backup and Restore for this company
UPDATE App_CompanyProp SET attrVal = '0' WHERE attrName = 'Disable Login' AND attrVal = '1' AND componentNameId = @companyId
UPDATE App_CompanyProp SET attrVal = '0' WHERE attrName = 'Disable Backup' AND attrVal = '1' AND componentNameId = @companyId
UPDATE App_CompanyProp SET attrVal = '0' WHERE attrName = 'Disable Restore' AND attrVal = '1' AND componentNameId = @companyId
		-- Update the activation time for the company. This is required for reports to be generated
UPDATE App_CompanyProp SET attrVal = @nowTime WHERE attrName = 'Activation time' AND
			componentNameId = @companyId
		IF @@ROWCOUNT = 0
		BEGIN
			INSERT into App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@companyId, 'Activation time', 7, @nowTime, @nowTime, 0)
		END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = ERROR_NUMBER()
	SET @errorString = 'Error During SP Execution. Error Message :' + ERROR_MESSAGE()
END CATCH
SCRIPT_EXIT:
	SELECT @errorCode, @errorString, @domainName
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppDeactivateCompany')
	delete from GxQscripts where name = 'AppDeactivateCompany'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDeactivateCompany')
	delete from GXDBVersions where aliasname = 'AppDeactivateCompany'
GO

insert into GXDBVersions values(2, 'AppDeactivateCompany',  '00000000000000000000', 'AppDeactivateCompany', '00000000000000000000')
GO

