

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppDataSetListing.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppDataSetListing.sp,v $ $Id: AppDataSetListing.sp,v 1.9.2.10 2019/02/22 00:17:05 csunderland Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppDataSetListing')
BEGIN
	print '>>> Drop Stored Procedure: AppDataSetListing <<<'
	drop procedure AppDataSetListing
END
IF EXISTS (select * from GxQscripts where name='AppDataSetListing')
	delete from GxQscripts where name = 'AppDataSetListing'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDataSetListing')
	delete from GXDBVersions where aliasname = 'AppDataSetListing'
GO
print '... Creating Procedure: AppDataSetListing'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppDataSetListing
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_deployed int,
  @i_userId int,
  @i_localeId int,
  @i_showHidden INTEGER=0,
  @i_tenantAdmin INTEGER=0
AS
SET NOCOUNT ON
BEGIN
DECLARE @origCCId int = 2
DECLARE @t_userCaps   TABLE(userId INT, nodeCap bigint, childCap bigint)
INSERT INTO @t_userCaps
EXEC dbo.sec_NoNiDaNodeAccess @i_userId , @origCCId, 2018, @origCCId
DECLARE @isViewAllCap INT = 0
IF (ISNULL((SELECT nodeCap & CAST(POWER(2.0, 1 - 1) AS bigint) FROM @t_userCaps), 0) <> 0)
    SET @isViewAllCap = 1;
--IF (@isViewAllCap = 0)
--	EXECUTE sec_userHasCapability @i_userId, 0, @isViewAllCap OUTPUT, 0, 1, '126,127'
IF object_id('tempdb.dbo.#APPDataSetListing_Objects') is not null DROP TABLE #APPDataSetListing_Objects
CREATE TABLE #APPDataSetListing_Objects (datasetId INT)
IF (@isViewAllCap = 1)
BEGIN
	INSERT INTO #APPDataSetListing_Objects SELECT datasetId FROM APP_DataSet
END
ELSE
BEGIN
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 129, 126, '#APPDataSetListing_Objects'
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 129, 127, '#APPDataSetListing_Objects'
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 129, 128, '#APPDataSetListing_Objects'
END
Declare @roleId int
Declare @providerId int
Declare @errCode int
Declare @errString nvarchar(1024)
EXEC AppGetUserRoleType @i_userId, @roleId OUTPUT, @providerId OUTPUT, @errCode OUTPUT, @errString OUTPUT
IF (@i_deployed = 1)
BEGIN
	SELECT d.*
	FROM APP_DataSetHistory h
	INNER JOIN APP_DataSet d ON h.dataSetId = d.datasetId AND h.version = d.deployedVersion
	WHERE d.reportId = 0
	AND (@i_showHidden = 1 OR d.flags & 1 = 0) --skip hidden datasets
	AND (
		d.datasetId IN (SELECT datasetId FROM #APPDataSetListing_Objects) OR
		flags & 2 > 0 OR
(@roleId = 0 AND d.flags & 64 > 0) OR
(@roleId = 1 AND d.flags & 16 > 0) OR
(@roleId = 2 AND d.flags & 32 > 0)
		)
END
ELSE
BEGIN
	SELECT *
	FROM APP_DataSet d
	WHERE reportId = 0
	AND (@i_showHidden = 1 OR flags & 1 = 0) --skip hidden datasets
	AND deployedVersion IS NOT NULL
	AND (
		datasetId IN (SELECT datasetId FROM #APPDataSetListing_Objects) OR
		flags & 2 > 0 OR
(@roleId = 0 AND flags & 64 > 0) OR
(@roleId = 1 AND flags & 16 > 0) OR
(@roleId = 2 AND flags & 32 > 0)
		)
END
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppDataSetListing')
	delete from GxQscripts where name = 'AppDataSetListing'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDataSetListing')
	delete from GXDBVersions where aliasname = 'AppDataSetListing'
GO

insert into GXDBVersions values(2, 'AppDataSetListing',  '00010009000200100000', 'AppDataSetListing', '00010009000200100000')
GO

