

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppDataSetGetTask.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppDataSetGetTask.sp,v $ $Id: AppDataSetGetTask.sp,v 1.2.40.1 2018/03/27 07:59:12 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppDataSetGetTask <<<'

IF EXISTS (select * from sysobjects where name='AppDataSetGetTask')
	drop procedure AppDataSetGetTask
IF EXISTS (select * from GxQscripts where name='AppDataSetGetTask')
	delete from GxQscripts where name = 'AppDataSetGetTask'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDataSetGetTask')
	delete from GXDBVersions where aliasname = 'AppDataSetGetTask'
GO
print '... Creating Procedure: AppDataSetGetTask'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppDataSetGetTask
  @i_engineName nvarchar(255)
AS
SET NOCOUNT ON
BEGIN TRAN
DECLARE @dataSetId INT = 0
DECLARE @now INT
DECLARE @lockResult INT
EXEC @lockResult = sp_getapplock @Resource = 'AppDataSetGetTask', @LockMode = 'Exclusive', @LockTimeout = 3000 --Time to wait for the lock
IF @lockResult <> 0
BEGIN
 ROLLBACK TRAN
 RAISERROR('Procedure Already Running - Concurrent execution is not supported.',16,9)
 RETURN(1)
END
SET @now = dbo.GetUnixTime(GETUTCDATE())
SELECT @dataSetId = ISNULL(datasetId, 0)
FROM APP_DataSet
WHERE nextCollectTime < @now
AND collectionStatus = 0
AND offline = 1
AND nextCollectTime > 0
AND queryId > 0
ORDER BY nextCollectTime
IF @dataSetId > 0
BEGIN
	UPDATE APP_DataSet
	SET collectionStatus = 1,
		collectionEngine = @i_engineName
	WHERE datasetId = @dataSetId
	SELECT *
	FROM APP_DataSet
	Where datasetId = @dataSetId
END
COMMIT TRAN
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppDataSetGetTask')
	delete from GxQscripts where name = 'AppDataSetGetTask'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDataSetGetTask')
	delete from GXDBVersions where aliasname = 'AppDataSetGetTask'
GO

insert into GXDBVersions values(2, 'AppDataSetGetTask',  '00010002004000010000', 'AppDataSetGetTask', '00010002004000010000')
GO

