

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppDataSetDeploy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppDataSetDeploy.sp,v $ $Id: AppDataSetDeploy.sp,v 1.4.12.3 2018/03/27 08:00:47 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppDataSetDeploy <<<'

IF EXISTS (select * from sysobjects where name='AppDataSetDeploy')
	drop procedure AppDataSetDeploy
IF EXISTS (select * from GxQscripts where name='AppDataSetDeploy')
	delete from GxQscripts where name = 'AppDataSetDeploy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDataSetDeploy')
	delete from GXDBVersions where aliasname = 'AppDataSetDeploy'
GO
print '... Creating Procedure: AppDataSetDeploy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppDataSetDeploy
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_dataSetId int,
  @i_definition XML,
  @i_queryId int,
  @i_offline int,
  @i_collectionTable nvarchar(256),
  @i_nextCollectTime int,
  @i_userId int,
  @i_localeId int
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_ErrorCode int
  DECLARE @o_ErrorString nvarchar(max)
SET @o_ErrorCode = 0
SET @o_ErrorString = ''
DECLARE @version int
SELECT @version = version
FROM APP_DataSet
WHERE dataSetId = @i_dataSetId
IF NOT EXISTS(SELECT * FROM APP_DataSetHistory WHERE dataSetId = @i_dataSetId AND version = @version)
BEGIN
	SET @o_ErrorCode = 1
	SET	@o_ErrorString = 'unable to find history information for data set'
	GOTO FINISH
END
UPDATE APP_DataSet
SET definition = @i_definition,
	deployedVersion = @version,
	deployed = 1,
	offline=@i_offline,
	queryId = @i_queryId,
	collectionTable = @i_collectionTable,
	nextCollectTime = @i_nextCollectTime
WHERE dataSetId = @i_dataSetId
UPDATE APP_DataSetHistory
SET definition = @i_definition,
	deployed = 1,
	deployTime = dbo.GetUnixTime(GETUTCDATE())
WHERE dataSetId = @i_dataSetId
AND version = @version
FINISH:
SELECT @o_ErrorCode AS o_ErrorCode, @o_ErrorString AS o_ErrorString
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppDataSetDeploy')
	delete from GxQscripts where name = 'AppDataSetDeploy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppDataSetDeploy')
	delete from GXDBVersions where aliasname = 'AppDataSetDeploy'
GO

insert into GXDBVersions values(2, 'AppDataSetDeploy',  '00010004001200030000', 'AppDataSetDeploy', '00010004001200030000')
GO

