

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCredPropsUpd.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCredPropsUpd.sp,v $ $Id: AppCredPropsUpd.sp,v 1.67.12.14 2020/08/20 01:59:05 shebbarshankar Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================================+
--	|    AppCredPropsUpd   - Globally Update Username passwords Accross all CS objects	|
--	|																					|
--	|		ASSUMPTIONS:																|
--	|			1. All credentials must already be in DB to be operated on  (won't		|
--	|				.. create new credentials on the fly)								|
--	|			2. Will always consider all descendants of objects selected as being	|
--	|				.. included.														|
--	|			3. Cannot have username change w/o password change						|
--	|																					|
--	|		STEPS:																		|
--	|			1. CREATE TEMPORARY TABLES AND VARIABLES								|
--	|			2. EXTRACT RAW DATA TO TABLES AND VARIABLES								|
--	|			3. COOK RAW DATA TO GET REAL CS OBJECTS									|
--	|			4. DISCOVER ALL USERNAMES/PASSWORDS FOR EXTENDED OBJECTS				|
--	|			5. CHECK USER SECURITY 													|
--	|			6. LOOP FOR ALL THE CREDENTIALS SAVED									|
--	|				6a CHECK FOR USER/LOGIN MATCH TO "OLD" CREDENTIALS					|
--	|				6b WRITE NEW USERNAME/PASSWORDS TO DB								|
--	|				6c WRITE OUT TO GUI AUDIT TRAIL										|
--				7.  CLEANUP AND RETURN RESULTS TO CALLER								|
--	+===================================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppCredPropsUpd')
BEGIN
	print '>>> Drop Stored Procedure: AppCredPropsUpd <<<'
	drop procedure AppCredPropsUpd
END
IF EXISTS (select * from GxQscripts where name='AppCredPropsUpd')
	delete from GxQscripts where name = 'AppCredPropsUpd'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCredPropsUpd')
	delete from GXDBVersions where aliasname = 'AppCredPropsUpd'
GO
print '... Creating Procedure: AppCredPropsUpd'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCredPropsUpd
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
-----------------------------------------------------------
  @xmlString varchar(MAX)
-----------------------------------------------------------
AS
SET NOCOUNT ON
DECLARE	@function        AS varchar(80)                = 'AppCredPropsUpd'
DECLARE @errorCode		 AS integer					   = 0
DECLARE @errorWstring	 AS nvarchar(2048)			   = N''
DECLARE @errorString	 AS varchar(2048)			   = ''
DECLARE @brAlertTrace	 AS varchar(256)               = (select value from gxglobalParam Where name = 'bralertTrace')
Declare @xmlout			 AS XML
DECLARE @dateTime		AS DATETIME = getDate()			-- Common Date/Time Stamp for everything done here
if @brAlertTrace <> 0									-- Put a copy of input data to table TrackNotificationProcs
	exec br_ntTrace '.. AppCredPropsUpd', 0, @dateTime, 0, 0, @xmlString
BEGIN TRY
--	******************************************************
--	*** 1. HERE IS WHERE WE WILL EXTRACT THE XML TO:	**
--	******************************************************
DECLARE @iDoc							AS integer =0
DECLARE	@userId							integer			-- User who is initiating this action
DECLARE @localeId						integer			-- LocaleId of user who initiated action (for error reporting)
DECLARE @options		 				integer
DECLARE @reason							nvarchar(2048)
DECLARE	@oldUserName					varchar(256)
DECLARE	@oldDomainName					varchar(256)
DECLARE @oldUserPassword				varchar(256)
DECLARE @oldUserPasswordV5				varchar(256)
--DECLARE @oldUserPasswordV3			varchar(256)
DECLARE @isPreview						INT = 0
DECLARE @isSkipPasswordCheck			INT = 0
DECLARE @outputText						nvarchar(1024)
DECLARE	@newUserName					varchar(256)
DECLARE	@newDomainName					varchar(256)
DECLARE @newUserPassword				varchar(256)
DECLARE @newUserPasswordV5				varchar(256)
DECLARE @umdsDomainName					varchar(256)
DECLARE @umdsNewUserName				varchar(256)
--DECLARE @newUserPasswordV3				varchar(256)
DECLARE	@objectCount				as	integer = 0
--- Variables for our Cursor --
DECLARE	@clientGroupId					integer
DECLARE	@clientId						integer
DECLARE @appTypeId						integer
DECLARE @instanceId						integer
DECLARE @backupsetId					integer
DECLARE @subClientId					integer
DECLARE	@type							integer
-----------------------------------------------
---  SOME LOCAL VARIABLES					---
-----------------------------------------------
DECLARE @skipUserNamecheck	AS integer			= 0
DECLARE @skipPassWordcheck	AS integer			= 0
DECLARE	@isUserNameChange	AS integer			= 0				-- For convenience
DECLARE	@isPasswordChange	AS integer			= 0
DECLARE	@isAllClients		AS integer			= 0
DECLARE	@isAllAppTypes		AS integer			= 0
DECLARE @nowTime    		AS integer 			= dbo.GetUnixTime (GetUTCdate())
DECLARE @rowCount			AS integer			= 0
DECLARE @tranStarted		AS integer			= 0  		-- Since we delay starting transaction ....
DECLARE @GENERIC_USERNAME_MSG AS integer = (1060 | (CAST(POWER(2, 24) AS BIGINT) * 83))
DECLARE @GENERIC_PASSWORD_MSG AS integer = (1061 | (CAST(POWER(2, 24) AS BIGINT) * 83))
DECLARE @GENERIC_USERNAME_PASSWORD_PREVIEW AS integer = (1298 | (CAST(POWER(2, 24) AS BIGINT) * 83))
DECLARE @SKIP_AUDIT_TRAIL	AS integer			= 0
----------------------------------------------------------
---	SOME TEMPORARY TABLES WE WILL BE USING:			   ---
----------------------------------------------------------
DECLARE @associations table  (					-- loosely copied from "security" table
	 [type]					int NOT null default 0,
	 [isExcluded]			int NOT null default 0,
	 [commCellId]			int NOT null default 0,
	 [clientGroupId]		int NOT null default 0,
	 [clientId]				int NOT null default 0,
	 [appTypeId]			int NOT null default 0,
	 [instanceId]			int NOT null default 0,
	 [backupsetId]			int NOT null default 0,
	 [subClientId]			int NOT null default 0,
	 [mediaAgentId]			int NOT null default 0,
	 [libraryId]			int NOT null default 0,
	 [archGroupId]			int NOT null default 0,
	 [flag]					int NOT null default 0
 )
DECLARE @extendedObjects table  (					-- loosely copied from "security" table
	 [id]                  INTEGER NOT NULL IDENTITY (1,1),            -- PRIMARY KEY FOR THIS TABLE
	 [type]					int NOT null default 0,
	 [commCellId]			int NOT null default 0,
	 [clientGroupId]		int NOT null default 0,
	 [clientId]				int NOT null default 0,
	 [appTypeId]			int NOT null default 0,
	 [instanceId]			int NOT null default 0,
	 [backupsetId]			int NOT null default 0,
	 [subClientId]			int NOT null default 0,
	 [mediaAgentId]			int NOT null default 0,
	 [libraryId]			int NOT null default 0,
	 [archGroupId]			int NOT null default 0,
--	 [vtContainerId]		int NOT null default 0,
--	 [vtPolicyId]			int NOT null default 0,
--	 [vtShelfId]			int NOT null default 0,
--	 [reviewSetId]			int NOT null default 0,
--	 [querySetId]			int NOT null default 0,
--	 [downloadSetId]		int NOT null default 0,
--	 [ermId]				int NOT null default 0,
--	 [legalHoldId]			int NOT null default 0,
--	 [tagId]				int NOT null default 0,
--	 [cdPolicyId]			int NOT null default 0,
--	 [complianceReportId]	int NOT null default 0,
	 [taskId]				int NOT null default 0,
	 [flag]					int NOT null default 0
 )
 DECLARE @credsMatch table  (
	[credPropsId]		int NOT null,
	[extendedObjId]		int NOT null,
	[tableTypeId]		int NOT null,
	[tableId]			int NOT null,
	[componentNameId]	int NOT null,
	[attrDomainName]	nvarchar(1024) NOT null,
	[attrName]			nvarchar(1024) NOT null,
	[attrType]          integer NOT null,
	[attrVal]           nvarchar(MAX)NOT null,
	[isPassword]		integer not null
)
DECLARE @INSERT_PROP_RESULTS table (			-- THIS TABLE WILL BE USED TO CAPTURE THE RESULT SETS FROM THE
	errorCode 			integer,				-- .. VARIOUS "AppInsertXProp" stored procedures
	hasChanged			integer,
	propId				integer,
	errorString			varchar(1024)
)
 DECLARE @clientGroups table  (					-- Used for processing clientGroups and other occaisions where we
	[clientGroupId]		int NOT null,			-- are looking to avoid duplicating clients
	[clientId]			int NOT null
)
DECLARE @previewTable table (
	[id]					INTEGER NOT NULL IDENTITY (1,1),            -- PRIMARY KEY FOR THIS TABLE
	[type]					int,
	[commCellId]			int,
	[commCellName]			nvarchar(1024),
	[clientGroupId]			int,
	[clientGroupName]		nvarchar(1024),
	[clientId]				int,
	[clientName]			nvarchar(1024),
	[appTypeId]				int,
	[appTypeName]			nvarchar(1024),
	[instanceId]			int,
	[instanceName]			nvarchar(1024),
	[backupsetId]			int,
	[backupSetName]			nvarchar(1024),
	[subClientId]			int,
	[subClientName]			nvarchar(1024),
	[mediaAgentId]			int,
	[mediaAgentName]		nvarchar(1024),
	[libraryId]				int,
	[libraryName]			nvarchar(1024),
	[archGroupId]			int,
	[archGroupName]			nvarchar(1024),
	[vtContainerId]			int,
	[vtContainerName]		nvarchar(1024),
	[vtPolicyId]			int,
	[vtPolicyName]			nvarchar(1024),
	[vtShelfId]				int,
	[vtShelfName]			nvarchar(1024),
	[taskId]				int,
	[taskName]				nvarchar(1024),
	[subTaskId]				int,
	[subTaskName]			nvarchar(1024),
	[alertId]				int,
	[alertName]				nvarchar(1024),
	[storagePoolId]			int,
	[storagePoolName]		nvarchar(1024),
	[mountPathId]			int,
	[mountPathName]			nvarchar(1024),
	[domainId]				int,
	[domainName]			nvarchar(1024),
	[changesId]				int,
	[changes]				nvarchar(1024),
	[credentialId]			int,
	[credentialName]		nvarchar(1024)
)
	DECLARE @opMsgId			INTEGER
	DECLARE @opEvMsgId			INTEGER
	DECLARE @opId 				INTEGER
	DECLARE @paramMsgId			INTEGER
	DECLARE @paramData 			NVARCHAR(1024)
	DECLARE @dataIsEvent		INTEGER
	DECLARE @prePswdRow			INTEGER
	DECLARE @preUserRow			INTEGER
--	set @objectCount = ISNULL((select count(*) from @credsMatch),0)
--
-- DECLARE TEMP VARIABLES FOR OUR CURSOR:
	DECLARE @credPropsId		INTEGER
	DECLARE @extendedObjId		INTEGER
	DECLARE @tableTypeId		INTEGER
	DECLARE @tableId			INTEGER
	DECLARE @componentNameId	INTEGER
	DECLARE @componentName		VARCHAR(1024)
	DECLARE @attrVal			VARCHAR(1024)   -- Intentionally NOT nvarchar()!!
	DECLARE @attrDomain			VARCHAR(1024)
	DECLARE @isPassword			INTEGER
--
	DECLARE @lastTableTypeId	 as INTEGER = 0 -- WILL USE THESE (2) TO DETERMINE WHETHER OR NOT WE CAN GROUP	MULTIPLE USER/PW
	DECLARE @lastComponentNameId as INTEGER = 0	-- CHANGES UNDER THE SAME AUDIT TRAIL MESSAGE AS WELL AS "ECONOMIZE" ON SECURITY CHECKS
	DECLARE @secCapability		 as INTEGER = 2 -- AGENT MGMT Capability(Could change if SP expanded to handle other types of objects)
	DECLARE @secObjectType		 as INTEGER = 0 --  Redefined based on what type of object
--
	DECLARE @objId				INTEGER
	DECLARE @objName			NVARCHAR(1024)
--
	DECLARE	@cvEntityType		INTEGER
	DECLARE @isPit				INTEGER
--
	DECLARE @encryptionType		INTEGER
	DECLARE @attrName			NVARCHAR(1024)
	DECLARE @newAtrVal			NVARCHAR(1024)
	--DECLARE @binValue			VARBINARY(255)
	--DECLARE @nValue				NVARCHAR(255)
	DECLARE @isValidPswd		INTEGER=0
	DECLARE	@isPasswordType3	INTEGER
--
--	******************************************************
--	*** 2.  EXTRACT FROM THE XML						**
--	******************************************************
	exec sp_xml_preparedocument @iDoc OUTPUT, @xmlString
	set @options			=  ISNULL((select * from OPENXML(@iDoc, 'GuiServer_ModifyCredsReq', @options)
									WITH (options int '@options')), 0)
	IF  (@options & 2) <> 0
		SET @SKIP_AUDIT_TRAIL = 1
	set @reason				=  ISNULL((select * from OPENXML(@iDoc, 'GuiServer_ModifyCredsReq', @reason)
									WITH (reason varchar(2048) '@reason')), '')
	set	@localeId			=  ISNULL((select * from OPENXML(@iDoc, 'GuiServer_ModifyCredsReq/header', @localeId)
									WITH (localeId int '@localeId')), 99)
	set	@userId				=  ISNULL((select * from OPENXML(@iDoc, 'GuiServer_ModifyCredsReq/header', @userId)
									WITH (userId int '@userId')), 99)
--	OLD AND NEW CREDENTIALS:
--	------------------------
	set @oldUserName		=  ISNULL((select * from OPENXML(@iDoc, 'GuiServer_ModifyCredsReq/credsInfo/oldCredentials', @oldUserName)
									WITH (userName varchar(256) '@userName')), '')
	IF CHARINDEX('\', @oldUserName) > 0
		SET @umdsDomainName		=  (SELECT LEFT(@oldUserName, CHARINDEX('\',@oldUserName)-1))
	set @oldUserPassword	=  ISNULL((select * from OPENXML(@iDoc, 'GuiServer_ModifyCredsReq/credsInfo/oldCredentials', @oldUserPassword)
									WITH (password varchar(256) '@password')), '')
	set @oldUserPasswordV5	=  ISNULL((select * from OPENXML(@iDoc, 'GuiServer_ModifyCredsReq/credsInfo/oldCredentialsV5', @oldUserPasswordV5)
									WITH (password varchar(256) '@password')), '')
	set @oldDomainName		=  ISNULL((select * from OPENXML(@iDoc, 'GuiServer_ModifyCredsReq/credsInfo/oldCredentials', @oldDomainName)
									WITH (userName varchar(256) '@domainName')), '')
	--set @oldUserPasswordV3	=  ISNULL((select * from OPENXML(@iDoc, 'GuiServer_ModifyCredsReq/credsInfo/oldCredentials/userPass3', @oldUserPasswordV3)
	--								WITH (password varchar(256) '@password')), '')
	set @newUserName		=  ISNULL((select * from OPENXML(@iDoc, 'GuiServer_ModifyCredsReq/credsInfo/newCredentials', @newUserName)
									WITH (userName varchar(256) '@userName')), '')
	IF CHARINDEX('\', @newUserName) > 0
		SET @umdsNewUserName	=  (SELECT RIGHT(@newUserName, (LEN(@newUserName) - CHARINDEX('\',@newUserName))))
	ELSE
		SET @umdsNewUserName	= @newUserName
	set @newUserPassword	=  ISNULL((select * from OPENXML(@iDoc, 'GuiServer_ModifyCredsReq/credsInfo/newCredentials', @newUserPassword)
									WITH (password varchar(256) '@password')), '')
	set @newUserPasswordV5	=  ISNULL((select * from OPENXML(@iDoc, 'GuiServer_ModifyCredsReq/credsInfo/newCredentialsV5', @newUserPasswordV5)
									WITH (password varchar(256) '@password')), '')
	set @newDomainName		=  ISNULL((select * from OPENXML(@iDoc, 'GuiServer_ModifyCredsReq/credsInfo/newCredentials', @newDomainName)
									WITH (userName varchar(256) '@domainName')), '')
	--set @newUserPasswordV3	=  ISNULL((select * from OPENXML(@iDoc, 'GuiServer_ModifyCredsReq/credsInfo/newCredentials/userPass3', @newUserPasswordV3)
	--								WITH (password varchar(256) '@password')), '')
	set @isPreview	=  ISNULL((select * from OPENXML(@iDoc, 'GuiServer_ModifyCredsReq', @isPreview)
									WITH (preview int '@preview')), @isPreview)
	set @isSkipPasswordCheck	=  ISNULL((select * from OPENXML(@iDoc, 'GuiServer_ModifyCredsReq', @isSkipPasswordCheck)
									WITH (skipPasswordCheck int '@skipPasswordCheck')), @isSkipPasswordCheck)
IF @isPreview <> 0
BEGIN
SET @GENERIC_USERNAME_MSG = (1212 | (CAST(POWER(2, 24) AS BIGINT) * 83))
SET @GENERIC_PASSWORD_MSG = (1213 | (CAST(POWER(2, 24) AS BIGINT) * 83))
END
	IF @oldUserName <> @newUserName AND @newUserName <> ''
        SET @isUserNameChange = 1
	IF (@oldUserPassword <> @newUserPassword  AND @newUserPassword <> '') OR @isSkipPasswordCheck = 1
        SET @isPasswordChange = 1
IF OBJECT_ID('tempdb.dbo.#tempAppGetApplicationSecurityObjects') IS NOT Null DROP TABLE #tempAppGetApplicationSecurityObjects
create table  #tempAppGetApplicationSecurityObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	DECLARE @userCapsAtCommcell BIGINT = 0
	DECLARE @skipSecurityCheck INT = 0
EXEC sec_getUserObjects @userId, 0, 0, '#tempAppGetApplicationSecurityObjects'
    SELECT @userCapsAtCommcell = @userCapsAtCommcell | sec.capabilities
FROM #tempAppGetApplicationSecurityObjects sec
        WHERE       commCellId <> 0
                    AND clientGroupId = 0 AND clientId = 0 AND appTypeId = 0
                    AND instanceId = 0 AND backupsetId = 0 AND subClientId = 0
                    AND mediaAgentId = 0 AND libraryId = 0 AND archGroupId = 0
                    AND vtPolicyId = 0 AND vtcontainerId = 0 AND vtShelfId = 0
                    AND reviewSetId = 0 AND querySetId = 0 AND downloadSetId = 0
                    AND tagId = 0 AND legalHoldId = 0 AND ermId = 0
                    AND cdPolicyId = 0 AND complianceReportId = 0 AND taskId = 0
                    AND workflowId=0 AND logMonitoringPolicyId=0 AND arrayId=0
                    AND cloudId=0 AND userGroupId=0 AND providerId=0 AND entityId1=0
                    AND entityId2=0 AND entityId3=0 AND entityId4=0 AND entityId5=0
                    AND entityId6=0 AND entityId7=0 AND entityId8=0 AND entityId9=0
	INSERT @associations(type, isExcluded, commcellId, clientGroupId, clientId, appTypeId, instanceId, backupsetId, subclientId, mediaAgentId, libraryId, archGroupId)
		SELECT  _type_,
				 ISNULL(exclude,            0),
				 ISNULL(commCellId,			2),
				 ISNULL(clientGroupId,		0),
				 ISNULL(clientId,			0),
				 ISNULL(applicationId,		0),
				 ISNULL(instanceId,			0),
				 ISNULL(backupsetId,		0),
				 ISNULL(subclientId,		0),
				 ISNULL(mediaAgentId,		0),
				 ISNULL(libraryId,			0),
				 ISNULL(storagePolicyId,	0)
				FROM OPENXML(@iDoc, 'GuiServer_ModifyCredsReq/credsInfo/associations', 0)
				 with	(
						_type_			integer	'./@_type_',
						exclude			integer './flags/@exclude',
						commCellId		integer './@commCellId',
						clientGroupId	integer './@clientGroupId',
						clientId		integer	'./@clientId',
						applicationId	integer	'./@applicationId',
						instanceId		integer	'./@instanceId',
						backupsetId		integer	'./@backupsetId',
						subclientId		integer	'./@subclientId',
						mediaAgentId	integer	'./@mediaAgentId',
						libraryId		integer	'./@libraryId',
						storagePolicyId	integer	'./@storagePolicyId'
						)
--	******************************************************
--	*** 3. COOK RAW DATA TO GET REAL CS OBJECTS			**
--	******************************************************
--
----------------------------------------------------------
-- COMPLETE THE EXTENDED OBJECTS TABLE SO WE HAVE ALL	--
-- .. THE OBJECTS PASSED FROM GUI AND THEIR DESCENDENTS	--
--
-- THESE DON'T HAVE DESCENDENTS:
-- COMMCELL_ENTITY=1, SUBCLIENT_ENTITY = 7,LIBRARY_ENTITY=9,
-- MEDIAAGENT_ENTITY = 11, STORAGE_POLICY_ENTITY = 17
----------------------------------------------------------
INSERT @extendedObjects(type, commCellId, clientGroupId, clientId, appTypeId, instanceId, backupsetId, subClientId, [mediaAgentId], [libraryId], [archGroupId])
	   SELECT type, commCellId, clientGroupId, clientId, appTypeId, instanceId, backupsetId, subClientId,  [mediaAgentId], [libraryId], [archGroupId]
		 FROM @associations
		 WHERE type in (1, 7, 9, 11, 17) AND isExcluded = 0
IF EXISTS (Select type FROM @associations where type = 2 AND isExcluded = 0)			-- ARE "ALL CLIENTS" SELECTED?
BEGIN
	SET @isAllClients =1
	INSERT @extendedObjects (type, commcellId, clientId, appTypeId, instanceId, backupsetId)
		VALUES(2, 2, 0, 0, 0, 0)
END
ELSE
BEGIN
	DECLARE descendCursor CURSOR STATIC FOR
			SELECT [type], [clientGroupId], [clientId], [appTypeId], [instanceId], [backupsetId]
			FROM @associations
			WHERE type NOT IN ( 7, 9, 11, 17) AND isExcluded = 0
		OPEN descendCursor
		FETCH NEXT FROM descendCursor INTO @type, @clientGroupId, @clientId, @appTypeId, @instanceId, @backupsetId
		WHILE @@FETCH_STATUS = 0
		BEGIN
			IF @type <> 3		-- DON'T DO THIS FOR CLIENT_ENTITY OBJECTS, AS CLIENT MAY HAVE ALREADY BEEN ADDED THRU CLIENTGROUPS!
			INSERT @extendedObjects (type, commcellId, clientGroupId, clientId, appTypeId, instanceId, backupsetId)
				VALUES(@type, 0, @clientGroupId, @clientId, @appTypeId, @instanceId, @backupsetId)
			IF @type = 6    --EntityType_BACKUPSET_ENTITY
			BEGIN
				INSERT @extendedObjects(type, commCellId, clientId, appTypeId, instanceId, backupsetId, subClientId)
					SELECT  @type, 0, clientId, appTypeId, instance, @backupsetId, id
					FROM app_application
					  WHERE [backupset] = @backupsetId  -- backupset is unique enough!
			END
			IF @type = 5   --EntityType_INSTANCE_ENTITY
			BEGIN
				INSERT @extendedObjects(type, commCellId, clientId, appTypeId, instanceId, backupsetId, subClientId)
					SELECT  DISTINCT @type, 0, clientId, appTypeId, instance, backupset, 0
					FROM app_application
					  WHERE [instance] = @instanceId AND [appTypeId]=@appTypeId AND [clientId] = @clientId  -- instanceId is not unique enough
				INSERT @extendedObjects(type, commCellId, clientId, appTypeId, instanceId, backupsetId, subClientId)
					SELECT  DISTINCT @type, 0, clientId, appTypeId, instance, backupset, id
					FROM app_application
					  WHERE [instance] = @instanceId AND [appTypeId]=@appTypeId AND [clientId] = @clientId  -- instanceId is not unique enough
			END
			IF @type = 3 OR @type = 28   --EntityType_CLIENT_ENTITY, EntityType_CLIENTGROUP_ENTITY
			BEGIN
				DELETE @clientGroups			-- Make sure table is empty before we start!
				IF @type = 3 AND NOT EXISTS( select id from @extendedObjects where [clientId] = @clientId and appTypeId = 0 and TYPE in (2,28))
					INSERT @clientGroups(clientGroupId, clientId)
						VALUES (0, @clientId)
				ELSE   -- type=28
				BEGIN
					INSERT @clientGroups(clientGroupId, clientId)
						SELECT DISTINCT @clientGroupId, clientId
						FROM app_application AS APP
							WHERE APP.clientId in (select clientId from APP_ClientGroupAssoc where clientGroupId  = @clientGroupId)
							    AND APP.clientId NOT IN (select XO.clientId from @extendedObjects AS XO where XO.appTypeId = 0)
				END
				INSERT @extendedObjects(type, commCellId, clientGroupId, clientId, appTypeId, instanceId, backupsetId, subClientId)
					SELECT DISTINCT @type, 0, @clientGroupId, clientId, 0, 0, 0, 0
						FROM app_application
							WHERE clientId IN (Select distinct clientId from @clientGroups)
				SET @rowCount=@@rowcount
				IF @rowCount = 0				-- ALREADY HAVE THIS CLIENT FROM ANOTHER SOURCE? (Selected Client, other Client Group)
				   GOTO NEXT_DESCENDCURSOR
				INSERT @extendedObjects(type, commCellId, clientGroupId, clientId, appTypeId, instanceId, backupsetId, subClientId)
						SELECT DISTINCT @type, 0, @clientGroupId, clientId, appTypeId, instance, backupset, id
							FROM app_application
								WHERE clientId IN (Select distinct clientId from @clientGroups)
				INSERT @extendedObjects(type, commCellId, clientGroupId, clientId, appTypeId, instanceId, backupsetId, subClientId)
						SELECT DISTINCT @type, 0, @clientGroupId, clientId, appTypeId, instance, backupset, 0
							FROM app_application
								WHERE clientId IN (Select distinct clientId from @clientGroups)
				INSERT @extendedObjects(type, commCellId, clientGroupId, clientId, appTypeId, instanceId, backupsetId, subClientId)
						SELECT DISTINCT @type, 0, @clientGroupId, clientId, appTypeId, instance, 0, 0
							FROM app_application
								WHERE clientId IN (Select distinct clientId from @clientGroups)
				INSERT @extendedObjects(type, commCellId, clientGroupId, clientId, appTypeId, instanceId, backupsetId, subClientId)
						SELECT DISTINCT @type, 0, @clientGroupId, clientId, appTypeId, 0, 0, 0
							FROM app_application
								WHERE clientId IN (Select distinct clientId from @clientGroups)
			END
			IF @type = 4   --EntityType_APPTYPE_ENTITY
			BEGIN
				INSERT @extendedObjects(type, commCellId, clientId, appTypeId, instanceId, backupsetId, subClientId)
					SELECT  DISTINCT @type, 0, clientId, appTypeId, instance, 0,         0
					FROM app_application
					  WHERE  [appTypeId]=@appTypeId AND [clientId] = @clientId  -- instanceId is not unique enough
				INSERT @extendedObjects(type, commCellId, clientId, appTypeId, instanceId, backupsetId, subClientId)
					SELECT  DISTINCT @type, 0, clientId, appTypeId, instance, backupset, 0
					FROM app_application
					  WHERE  [appTypeId]=@appTypeId AND [clientId] = @clientId  -- instanceId is not unique enough
				INSERT @extendedObjects(type, commCellId, clientId, appTypeId, instanceId, backupsetId, subClientId)
					SELECT  DISTINCT @type, 0, clientId, appTypeId, instance, backupset, id
					FROM app_application
					  WHERE [appTypeId]=@appTypeId AND [clientId] = @clientId  -- instanceId is not unique enough
			END
NEXT_DESCENDCURSOR:
			FETCH NEXT FROM descendCursor INTO @type, @clientGroupId, @clientId, @appTypeId, @instanceId, @backupsetId
		END
		CLOSE descendCursor
		DEALLOCATE descendCursor
	------------------------------------------------------
	--  CLEAN THE LIST OF OBJECTS ON THE "EXCLUDED" LIST:
	------------------------------------------------------
		DECLARE descendCursor CURSOR STATIC FOR
			SELECT [type], [clientId], [appTypeId], [instanceId], [backupsetId], [subClientId]
			FROM @associations
			WHERE type NOT IN ( 7, 9, 11, 17) AND isExcluded = 1
		OPEN descendCursor
		FETCH NEXT FROM descendCursor INTO @type, @clientId, @appTypeId, @instanceId, @backupsetId, @subClientId
		WHILE @@FETCH_STATUS = 0
		BEGIN
			IF @TYPE in (3, 4, 5, 6, 7)   -- subClient to Client types
				DELETE @extendedObjects
					WHERE  [clientId]    =@clientId
					  AND ([appTypeId]   =@appTypeId   	OR @appTypeId = 0)
					  AND ([instanceId]  =@instanceId 	OR @instanceId = 0)
					  AND ([backupSetId] =@backupsetId	OR @backupsetId = 0)
					  AND ([subClientId] =@subClientId	OR @subClientId = 0)
			FETCH NEXT FROM descendCursor INTO @type, @clientId, @appTypeId, @instanceId, @backupsetId, @subClientId
		END
		CLOSE descendCursor
		DEALLOCATE descendCursor
	--	CLEAN THE LIST OF OBJECTS WE KNOW CANNOT HAVE ANY PROPERTIES:
		DELETE @extendedObjects
			WHERE not exists (select id from app_application where  clientId = clientId AND appTypeId =appTypeId)
				AND type in (3, 4, 5, 6, 7)
				or appTypeId = 1000
END									-- (NOT ALL CLIENTS SELECTED)
--	******************************************************************
--	*** 4. DISCOVER ALL USERNAMES/PASSWORDS FOR EXTENDED OBJECTS	**
--	******************************************************************
------------------------------------------------------------------------------------------------------------------------------------------
-- WE NOW HAVE A COMPLETE LIST OF OBJECTS.  NOW WE NEED TO FIND ALL  THE USERNAMES AND PASSWORDS CURRENTLY SET FOR THOSE OBJECTS		--
--  FOR USERNAMES, WE CAN DO A "COMPARE" CHECK IMMEDIATELY ... FOR	 PASSWORDS, WE NEED TO ITERATE THROUGH LATER USING THE EXTENDED		--
--  STORED PROCEDURE, "xp_user_isvalid"	TO COMPARE THE ENCTYPED VERSION	OF THE PASSWORDS!												--
------------------------------------------------------------------------------------------------------------------------------------------
--  COMMCELL TABLE (DR USERNAME/PASSWORD) 	-- ER USERNAME/PW STORED IN APP_COMMCELL TABLE
											-- ALL OTHER USERNAME/PW STORED IN GXGLOBALPARAM
--
	INSERT @credsMatch
	SELECT DISTINCT creds.Id, Objs.Id, tableId, Props.id, Objs.commcellId, '', attrPwdName, 0, Props.userPassword, 1
		 FROM APP_CredProps AS Creds, APP_Commcell as Props, @extendedObjects as Objs
WHERE Creds.tableId = 10				-- 'APP_CREDS_COMMCELL_TABLE'
		   AND Props.id = Objs.commcellId
		   AND Props.userPassWord <> ''
------------------------------------------------------------------------------------------------------------------
--  ALERT "RUN" COMMANDS:
      INSERT @credsMatch
      SELECT DISTINCT creds.Id, Props.escalationLevel, tableId, Props.ntNotificationId,  Props.ntNotificationId, '', attrPwdName, 0, Props.RunAsUserPassword, 1
               FROM APP_CredProps AS Creds, NTnotificationAction as Props, @extendedObjects as Objs
WHERE Creds.tableId = 13                          -- 'APP_CREDS_NT_NOTIF_ACTION_TABLE'
                 AND Props.RunAsUserPassword <> ''
				 AND Objs.commcellId = 2
      INSERT @credsMatch
      SELECT DISTINCT creds.Id, Props.escalationLevel, tableId, Props.ntNotificationId, Props.ntNotificationId , '', attrUserName, 0, Props.RunAsUserLogin, 0
               FROM APP_CredProps AS Creds, NTnotificationAction as Props, @extendedObjects as Objs
WHERE Creds.tableId = 13                          -- 'APP_CREDS_NT_NOTIF_ACTION_TABLE'
                 AND Props.RunAsUserLogin <> ''
				 AND Objs.commcellId = 2
-------------------------------------------------------------------------------------------------------------------
	INSERT @credsMatch
	SELECT DISTINCT creds.Id, Objs.Id, tableId, Props.id, Objs.commcellId, '', attrUserName, 0, Props.userName, 0
		 FROM APP_CredProps AS Creds, APP_Commcell as Props, @extendedObjects as Objs
WHERE Creds.tableId = 10				-- 'APP_CREDS_COMMCELL_TABLE'
		   AND Props.id = Objs.commcellId
		   AND Props.userName <> ''
--
	INSERT @credsMatch
	SELECT DISTINCT creds.Id, Objs.Id, tableId, Props.id, Objs.commcellId, '', name, 0, value,	CASE WHEN (Props.name = Creds.attrPwdName) THEN 1 ELSE 0 END
		 FROM APP_CredProps AS Creds, GXGlobalParam as Props, @extendedObjects as Objs
		 WHERE (Props.name = Creds.attrPwdName OR Props.name = Creds.attrUserName)
AND Creds.tableId = 12				-- 'APP_CREDS_GLOBALPARAM_TABLE'
		   --AND Objs.commcellId = 2
		   AND Props.modified = 0
--
--
--	--------------------
--  SUBCLIENT_PROP TABLE
--	--------------------
	INSERT @credsMatch
	SELECT DISTINCT creds.Id, Objs.Id, tableId, Props.id, Props.componentNameId, ISNULL((SELECT TOP 1 attrVal FROM APP_SubClientProp WHERE componentNameId=Props.componentNameId AND Creds.attrDomainName=attrName),''),
		attrName, attrType, attrVal, CASE WHEN (Props.attrName = Creds.attrPwdName) THEN 1 ELSE 0 END
		 FROM APP_CredProps AS Creds, APP_SubClientProp as Props, @extendedObjects as Objs
WHERE Creds.tableId = 61				-- 'APP_CREDS_SUBCLIENTPROP_TABLE'
		   AND (Props.cs_attrName = Creds.cs_attrPwdName OR Props.cs_attrName = Creds.cs_attrUserName)
		   AND (Props.attrName = Creds.attrPwdName  OR props.attrName = Creds.attrUserName)
		   AND (Props.componentNameId = Objs.subClientId OR @isAllClients =1)
		   AND Props.modified = 0
--
--
--	--------------------
--  BACKUPSET_PROP TABLE
--	--------------------
	INSERT @credsMatch
	SELECT DISTINCT creds.Id, Objs.Id, tableId, Props.id, Props.componentNameId, ISNULL((SELECT TOP 1 attrVal FROM APP_BackupsetProp WHERE componentNameId=Props.componentNameId AND Creds.attrDomainName=attrName),''),
		attrName, attrType, attrVal, CASE WHEN (Props.attrName = Creds.attrPwdName) THEN 1 ELSE 0 END
		 FROM APP_CredProps AS Creds, APP_BackupsetProp as Props, @extendedObjects as Objs
		 WHERE (Props.attrName = Creds.attrPwdName  OR Props.attrName = Creds.attrUserName)
AND Creds.tableId = 51						--'APP_CREDS_BKUPSETPROP_TABLE'
		   AND ((Props.componentNameId = Objs.backupsetId AND Objs.subClientId = 0)  OR @isAllClients =1)
		   AND Props.modified = 0
--
--
--	-------------------
--  INSTANCE_PROP TABLE
--	-------------------
	INSERT @credsMatch
	SELECT DISTINCT creds.Id, Objs.Id, tableId, Props.id, Props.componentNameId, ISNULL((SELECT TOP 1 attrVal FROM APP_InstanceProp WHERE componentNameId=Props.componentNameId AND Creds.attrDomainName=attrName),''),
		attrName, attrType, attrVal,  CASE WHEN (Props.attrName = Creds.attrPwdName) THEN 1 ELSE 0 END
		 FROM APP_CredProps AS Creds, APP_InstanceProp as Props, @extendedObjects as Objs
		 WHERE (Props.attrName = Creds.attrPwdName OR Props.attrName = Creds.attrUserName)
AND Creds.tableId = 41							--'APP_CREDS_INSTANCEPROP_TABLE'
			AND ((Props.componentNameId = Objs.instanceId AND Objs.backupsetId=0 AND Objs.subClientId=0) OR @isAllClients =1)
		   AND Props.modified = 0
--
--
--	-------------------
--  IDA_PROP TABLE
--	-------------------
	INSERT @credsMatch
	SELECT DISTINCT creds.Id, Objs.Id, tableId, Props.id, Props.componentNameId, ISNULL((SELECT TOP 1 attrVal FROM APP_IDAProp WHERE componentNameId=Props.componentNameId AND Creds.attrDomainName=attrName),''),
		attrName, attrType, attrVal,  CASE WHEN (Props.attrName = Creds.attrPwdName) THEN 1 ELSE 0 END
		 FROM APP_CredProps AS Creds, APP_IDAProp as Props, @extendedObjects as Objs, app_idaName AS Ida
		 WHERE (Props.attrName = Creds.attrPwdName OR Props.attrName = Creds.attrUserName)
AND Creds.tableId = 31									--'APP_CREDS_IDAPROP_TABLE'
			AND ((Props.componentNameId = Ida.id AND Objs.backupsetId=0 AND Objs.subClientId=0
				AND Objs.instanceId=0 AND Objs.backupsetId=0 AND Objs.subClientId=0 ) OR @isAllClients =1)
			--AND Ida.clientId = Objs.clientId AND Ida.appTypeId = Objs.appTypeId
		   AND Props.modified = 0
--
--
--	-------------------
--  CLIENT_PROP TABLE
--	-------------------
	INSERT @credsMatch
	SELECT DISTINCT creds.Id, Objs.Id, tableId, Props.id, Props.componentNameId, '', attrName, attrType, attrVal,  CASE WHEN (Props.attrName = Creds.attrPwdName) THEN 1 ELSE 0 END
		 FROM APP_CredProps AS Creds, APP_ClientProp as Props, @extendedObjects as Objs
		 WHERE (Props.attrName = Creds.attrPwdName OR Props.attrName = Creds.attrUserName)
AND Creds.tableId = 21			-- 'APP_CREDS_CLIENTPROP_TABLE'
			AND ((Props.componentNameId = Objs.clientId AND Objs.appTypeId=0 AND Objs.instanceId=0
				AND Objs.backupsetId=0 AND Objs.subClientId=0) OR @isAllClients =1)
		   AND Props.modified = 0
--	-------------------
--  APP_COMPONENTPROP TABLE
--	-------------------
	INSERT @credsMatch
	SELECT DISTINCT creds.Id, Objs.Id, tableId, Props.id, Props.componentId, '', CAST(Props.propertyTypeId AS VARCHAR(128)), Props.dataType, Props.stringVal,  0
		 FROM APP_CredProps AS Creds, APP_ComponentProp as Props, @extendedObjects as Objs
		 WHERE Props.propertyTypeId = Creds.attrUserName
AND Creds.tableId = 71			-- 'APP_CREDS_COMPONENTPROP_TABLE'
			AND ((Props.componentId = Objs.clientGroupId AND Objs.clientId = 0 AND Objs.appTypeId=0 AND Objs.instanceId=0
				AND Objs.backupsetId=0 AND Objs.subClientId=0) OR @isAllClients = 1)
		   AND Props.modified = 0
		   AND Props.stringVal <> ''
AND Props.componentType = 8
	INSERT @credsMatch
	SELECT DISTINCT creds.Id, Objs.Id, tableId, Props.id, Props.componentId, '', CAST(Props.propertyTypeId AS VARCHAR(128)), Props.dataType, Props.stringVal,  1
		 FROM APP_CredProps AS Creds, APP_ComponentProp as Props, @extendedObjects as Objs
		 WHERE Props.propertyTypeId = Creds.attrPwdName
AND Creds.tableId = 71			-- 'APP_CREDS_COMPONENTPROP_TABLE'
			AND ((Props.componentId = Objs.clientGroupId AND Objs.clientId = 0 AND Objs.appTypeId=0 AND Objs.instanceId=0
				AND Objs.backupsetId=0 AND Objs.subClientId=0) OR @isAllClients = 1)
		   AND Props.modified = 0
		   AND Props.stringVal <> ''
AND Props.componentType = 8
--
--
--	-------------------
--  TM_SUBTASKOPTIONS TABLE
--	-------------------
	INSERT @credsMatch
	SELECT DISTINCT creds.Id, Objs.Id, tableId, Props.id, Props.subTaskId, '', CAST(optionId AS VARCHAR(128)), Props.type, Props.value,  CASE WHEN (CAST(Props.optionId AS VARCHAR(128)) = Creds.attrPwdName) THEN 1 ELSE 0 END
		 FROM APP_CredProps AS Creds, TM_SubTaskOptions as Props, @extendedObjects as Objs
		 WHERE (CAST(Props.optionId AS VARCHAR(128))= Creds.attrPwdName OR CAST(Props.optionId AS VARCHAR(128))= Creds.attrUserName)
AND Creds.tableId = 81									--'APP_CREDS_TASKOPTIONS_TABLE'
			AND ((Objs.taskId=0 AND Objs.type=2) OR
				EXISTS (SELECT ST.subTaskId FROM TM_SubTask ST WHERE ST.taskId=Objs.taskId )
				)
--
--
--	-------------------
--  IdxAccessPath TABLE
--	-------------------
	INSERT @credsMatch
	SELECT DISTINCT creds.Id, Objs.Id, tableId, Props.IdxAccessPathId, Props.IdxCacheId, '', attrPwdName, 0, Props.Password,  1
		FROM APP_CredProps AS Creds, IdxAccessPath as Props, @extendedObjects as Objs
WHERE Creds.tableId = 90									--'APP_CREDS_IDXACCESSPATH_TABLE'
		AND Props.Password <> ''
	INSERT @credsMatch
	SELECT DISTINCT creds.Id, Objs.Id, tableId, Props.IdxAccessPathId, Props.IdxCacheId, '', attrUserName, 0, Props.Username,  0
		FROM APP_CredProps AS Creds, IdxAccessPath as Props, @extendedObjects as Objs
WHERE Creds.tableId = 90									--'APP_CREDS_IDXACCESSPATH_TABLE'
		AND Props.Username <> ''
--
--
--	-------------------
--  MMDeviceController TABLE
--	-------------------
	INSERT @credsMatch
	SELECT DISTINCT creds.Id, Objs.Id, tableId, Props.DeviceControllerId, Props.SNRVolumeId, '', attrPwdName, 0, Props.UserPassword,  1
		FROM APP_CredProps AS Creds, MMDeviceController as Props, @extendedObjects as Objs
WHERE Creds.tableId = 91									--'APP_CREDS_MMDEVICECONTROLLER_TABLE'
		AND Props.UserPassword <> ''
	INSERT @credsMatch
	SELECT DISTINCT creds.Id, Objs.Id, tableId, Props.DeviceControllerId, Props.SNRVolumeId, '', attrUserName, 0, Props.UserName,  0
		FROM APP_CredProps AS Creds, MMDeviceController as Props, @extendedObjects as Objs
WHERE Creds.tableId = 91									--'APP_CREDS_MMDEVICECONTROLLER_TABLE'
		AND Props.UserName <> ''
--
--
--	-------------------
--  MMDRUInfo TABLE
--	-------------------
	INSERT @credsMatch
	SELECT DISTINCT creds.Id, Objs.Id, tableId, Props.DRUId, Props.DRUPortNumber, '', attrPwdName, 0, Props.DRUPassword,  1
		FROM APP_CredProps AS Creds, MMDRUInfo as Props, @extendedObjects as Objs
WHERE Creds.tableId = 92									--'APP_CREDS_MMDRUINFO_TABLE'
		AND Props.DRUPassword <> ''
	INSERT @credsMatch
	SELECT DISTINCT creds.Id, Objs.Id, tableId, Props.DRUId, Props.DRUPortNumber, '', attrUserName, 0, Props.DRUUserName,  0
		FROM APP_CredProps AS Creds, MMDRUInfo as Props, @extendedObjects as Objs
WHERE Creds.tableId = 92									--'APP_CREDS_MMDRUINFO_TABLE'
		AND Props.DRUUserName <> ''
--
--
--	-------------------
--  MMHost TABLE
--	-------------------
	INSERT @credsMatch
	SELECT DISTINCT creds.Id, Objs.Id, tableId, Props.ClientId, Props.ClientId, '', attrPwdName, 0, Props.IndexCachePassword,  1
		FROM APP_CredProps AS Creds, MMHost as Props, @extendedObjects as Objs
WHERE Creds.tableId = 93									--'APP_CREDS_MMHOST_TABLE'
		AND Props.IndexCachePassword <> ''
	INSERT @credsMatch
	SELECT DISTINCT creds.Id, Objs.Id, tableId, Props.ClientId, Props.ClientId, '', attrUserName, 0, Props.IndexCacheUser,  0
		FROM APP_CredProps AS Creds, MMHost as Props, @extendedObjects as Objs
WHERE Creds.tableId = 93									--'APP_CREDS_MMHOST_TABLE'
		AND Props.IndexCacheUser <> ''
--
--
--	-------------------
--  MMMountPath TABLE
--	-------------------
	INSERT @credsMatch
	SELECT DISTINCT creds.Id, Objs.Id, tableId, Props.MountPathId, Props.MediaSideId, '', attrPwdName, 0, Props.UserPassword,  1
		FROM APP_CredProps AS Creds, MMMountPath as Props, @extendedObjects as Objs
WHERE Creds.tableId = 94									--'APP_CREDS_MMMOUNTPATH_TABLE'
		AND Props.UserPassword <> ''
	INSERT @credsMatch
	SELECT DISTINCT creds.Id, Objs.Id, tableId, Props.MountPathId, Props.MediaSideId, '', attrUserName, 0, Props.UserName,  0
		FROM APP_CredProps AS Creds, MMMountPath as Props, @extendedObjects as Objs
WHERE Creds.tableId = 94									--'APP_CREDS_MMMOUNTPATH_TABLE'
		AND Props.UserName <> ''
--
--
--	-------------------
--  MMNDMPHostInfo TABLE
--	-------------------
	INSERT @credsMatch
	SELECT DISTINCT creds.Id, Objs.Id, tableId, Props.NDMPHostId, Props.ClientId, '', attrPwdName, 0, Props.Password,  1
		FROM APP_CredProps AS Creds, MMNDMPHostInfo as Props, @extendedObjects as Objs
WHERE Creds.tableId = 95									--'APP_CREDS_MMNDMPHOSTINFO_TABLE'
		AND Props.Password <> ''
	INSERT @credsMatch
	SELECT DISTINCT creds.Id, Objs.Id, tableId, Props.NDMPHostId, Props.ClientId, '', attrUserName, 0, Props.Login,  0
		FROM APP_CredProps AS Creds, MMNDMPHostInfo as Props, @extendedObjects as Objs
WHERE Creds.tableId = 95									--'APP_CREDS_MMNDMPHOSTINFO_TABLE'
		AND Props.Login <> ''
--
--
--	-------------------
--  MMSanSwitchProxy TABLE
--	-------------------
	INSERT @credsMatch
	SELECT DISTINCT creds.Id, Objs.Id, tableId, Props.SwitchId, Props.SwitchId, '', attrPwdName, 0, Props.SwitchPassword,  1
		FROM APP_CredProps AS Creds, MMSanSwitchProxy as Props, @extendedObjects as Objs
WHERE Creds.tableId = 96									--'APP_CREDS_MMSANSWITCHPROXY_TABLE'
		AND Props.SwitchPassword <> ''
	INSERT @credsMatch
	SELECT DISTINCT creds.Id, Objs.Id, tableId, Props.SwitchId, Props.SwitchId, '', attrUserName, 0, Props.SwitchLogin,  0
		FROM APP_CredProps AS Creds, MMSanSwitchProxy as Props, @extendedObjects as Objs
WHERE Creds.tableId = 96									--'APP_CREDS_MMSANSWITCHPROXY_TABLE'
		AND Props.SwitchLogin <> ''
--
--
--	-------------------
--  SMArray TABLE
--	-------------------
	INSERT @credsMatch
	SELECT DISTINCT creds.Id, Objs.Id, tableId, Props.Id, Props.ClientId, '', attrPwdName, 0, Props.LoginPassword,  1
		FROM APP_CredProps AS Creds, SMArray as Props, @extendedObjects as Objs
WHERE Creds.tableId = 97									--'APP_CREDS_SMARRAY_TABLE'
		AND Props.LoginPassword <> ''
	INSERT @credsMatch
	SELECT DISTINCT creds.Id, Objs.Id, tableId, Props.Id, Props.ClientId, '', attrUserName, 0, Props.LoginName,  0
		FROM APP_CredProps AS Creds, SMArray as Props, @extendedObjects as Objs
WHERE Creds.tableId = 97									--'APP_CREDS_SMARRAY_TABLE'
		AND Props.LoginName <> ''
--
--
--	-------------------
--  SMControlHost TABLE
--	-------------------
	INSERT @credsMatch
	SELECT DISTINCT creds.Id, Objs.Id, tableId, Props.ControlHostId, Props.SnapShotEngineId, '', attrPwdName, 0, Props.SMHostPassword,  1
		FROM APP_CredProps AS Creds, SMControlHost as Props, @extendedObjects as Objs
WHERE Creds.tableId = 98									--'APP_CREDS_SMCONTROLHOST_TABLE'
		AND Props.SMHostPassword <> ''
	INSERT @credsMatch
	SELECT DISTINCT creds.Id, Objs.Id, tableId, Props.ControlHostId, Props.SnapShotEngineId, '', attrUserName, 0, Props.SMHostUserName,  0
		FROM APP_CredProps AS Creds, SMControlHost as Props, @extendedObjects as Objs
WHERE Creds.tableId = 98									--'APP_CREDS_SMCONTROLHOST_TABLE'
		AND Props.SMHostUserName <> ''
	------------------------------------------------------------------------------------------------------------------
--  ALERT "Save to disk":
      INSERT @credsMatch
      SELECT DISTINCT creds.Id, Props.escalationLevel, tableId, Props.ntNotificationId,  Props.ntNotificationId, '', attrPwdName, 0, Props.password, 1
               FROM APP_CredProps AS Creds, NTMessageFormat as Props, @extendedObjects as Objs
WHERE Creds.tableId = 99                          -- 'APP_CREDS_NT_NOTIF_ACTION_TABLE'
                 AND Props.password <> ''
				 AND Objs.commcellId = 2
				 AND Props.messageType = 512 --NT_SAVE_ALERTNOTIF
      INSERT @credsMatch
      SELECT DISTINCT creds.Id, Props.escalationLevel, tableId, Props.ntNotificationId, Props.ntNotificationId , '', attrUserName, 0, Props.userName, 0
               FROM APP_CredProps AS Creds, NTMessageFormat as Props, @extendedObjects as Objs
WHERE Creds.tableId = 99                          -- 'APP_CREDS_NT_NOTIF_ACTION_TABLE'
                 AND Props.userName <> ''
				 AND Objs.commcellId = 2
				 AND Props.messageType = 512 --NT_SAVE_ALERTNOTIF
--
--
--	-------------------
--  UMDSProviders TABLE
--	-------------------
	INSERT @credsMatch
	SELECT DISTINCT creds.Id, Objs.Id, tableId, Props.id, Props.id, Props.domainName, '', 0, Props.password,  1
		FROM APP_CredProps AS Creds, UMDSProviders as Props, @extendedObjects as Objs
WHERE Creds.tableId = 100									--'UMDSProviders'
		AND Props.id >= 1 AND Props.serviceType = 2
	INSERT @credsMatch
	SELECT DISTINCT creds.Id, Objs.Id, tableId, Props.id, Props.id, Props.domainName, '', 0, Props.login,  0
		FROM APP_CredProps AS Creds, UMDSProviders as Props, @extendedObjects as Objs
WHERE Creds.tableId = 100									--'UMDSProviders'
		AND Props.id >= 1 AND Props.serviceType = 2
--
--
--	-------------------
--  APP_Credentials TABLE
--	-------------------
	INSERT @credsMatch
	SELECT DISTINCT creds.Id, Objs.Id, tableId, Props.credentialId, Props.credentialId, '', attrPwdName, 0, Props.password,  1
		FROM APP_CredProps AS Creds, APP_Credentials as Props, @extendedObjects as Objs
WHERE Creds.tableId = 101									--'APP_CREDS_CREDENTIAL_MANAGER_TABLE'
		AND Props.userName = @oldUserName
	INSERT @credsMatch
	SELECT DISTINCT creds.Id, Objs.Id, tableId, Props.credentialId, Props.credentialId, '', attrUserName, 0, Props.userName,  0
		FROM APP_CredProps AS Creds, APP_Credentials as Props, @extendedObjects as Objs
WHERE Creds.tableId = 101									--'APP_CREDS_CREDENTIAL_MANAGER_TABLE'
		AND Props.userName = @oldUserName
--
--
--
--
--	**********************************************************************************
--	*** 5. CHECK USER SECURITY 														**
--	***																				**
--	***  ALL THE CREDENTIALS WE MIGHT BE CHANGING ARE NOW IN TABLE @CREDSMATCH		**
--	***	 WE WILL NOW MAKE SURE WE HAVE THE CORRECT CREDENTIALS (ASSOCIATION AND		**
--	***  CAPABILITIES TO CHANGE THE PROPERTY.  FIRST FAILURE EXITS LOOP AND RETURNS	**
--	***  TO CALLER WITH APPROPRIATE SECURITY ERROR MESSAGE							**
--	**********************************************************************************
--
IF (@userCapsAtCommcell & CAST(POWER(2.0, 2 - 1) AS bigint)) <> 0
		SET @skipSecurityCheck = 1
	--IF @isPreview = 0	--No security check when doing preview
	IF @skipSecurityCheck = 0
	BEGIN
	DECLARE SecurityCheckCursor CURSOR STATIC FOR
			SELECT   [tableTypeId], [componentNameId], [isPassword]
			FROM @credsMatch
			WHERE [isPassword] = 0							-- ONLY NEED TO CHECK 1/2 OF THE LIST AS IT SHOULD BE USERNAME/PW PAIRS (2 ROWS)
			ORDER BY [tableTypeId], [componentNameId], [isPassword]
--
	OPEN SecurityCheckCursor
	FETCH NEXT FROM SecurityCheckCursor INTO  @tableTypeId, @componentNameId,  @isPassword
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF @lastTableTypeId = @tableTypeId AND @lastComponentNameId = @componentNameId  -- For multiples of the same componentNameId, do check
			GOTO SKIP_CREDS_CHECK														-- only once (for effeciency).
		SET @lastComponentNameId	= @componentNameId
		SET @lastTableTypeId		= @tableTypeId
IF      @tableTypeId = 10			BEGIN SET @secObjectType=  2018	SET @secCapability = 1 END -- 'APP_CREDS_COMMCELL_TABLE, COMM_CELL_ITEM, ADMIN MGMT'
ELSE IF @tableTypeId = 12		BEGIN SET @secObjectType=  2018	SET @secCapability = 1 END -- 'APP_CREDS_GLOBALPARAM_TABLE, COMM_CELL_ITEM. ADMIN MGMT'
ELSE IF @tableTypeId = 13	BEGIN SET @secObjectType=  2018	SET @secCapability = 1 set @componentNameId = 2 END -- 'APP_CREDS_NT_NOTIF_ACTION_TABLE, COMM_CELL_ITEM. ADMIN MGMT'
ELSE IF @tableTypeId = 101 BEGIN SET @secObjectType=  2018	SET @secCapability = 1 END -- 'APP_CREDS_CREDENTIAL_MANAGER_TABLE, COMM_CELL_ITEM. ADMIN MGMT'
ELSE IF @tableTypeId = 21		BEGIN SET @secObjectType=  2009	SET @secCapability = 2 END -- 'APP_CREDS_CLIENTPROP_TABLE, CLIENT_ITEM, AGENT MGMT'
ELSE IF @tableTypeId = 31			BEGIN SET @secObjectType = 2230	SET @secCapability = 2 END -- 'APP_CREDS_IDAPROP_TABLE, APP_TYPE_ITEM, AGENT MGMT'
ELSE IF @tableTypeId = 41		BEGIN SET @secObjectType = 2011	SET @secCapability = 2 END --'APP_CREDS_INSTANCEPROP_TABLE, INSTANCE_ITEM, AGENT MGMT'
ELSE IF @tableTypeId = 51		BEGIN SET @secObjectType = 2012	SET @secCapability = 2 END --'APP_CREDS_BKUPSETPROP_TABLE, BACKUP_SET_ITEM, AGENT MGMT'
ELSE IF @tableTypeId = 61	BEGIN SET @secObjectType = 2013	SET @secCapability = 2 END --'APP_CREDS_SUBCLIENTPROP_TABLE, SUB_CLIENT_ITEM, AGENT MGMT'
ELSE IF @tableTypeId = 81		BEGIN SET @secObjectType = 4300 SET @secCapability = 3 END --'APP_CREDS_TASKOPTIONS_TABLE, SCHEDULE_ITEM, EV_SCHEDULE_APPLICATION'
ELSE IF @tableTypeId = 90	BEGIN SET @secObjectType = 2048 SET @secCapability = 10 END --'APP_CREDS_IDXACCESSPATH_TABLE, MEDIA_AGENT_ITEM, EV_MANAGE_MEDIAAGENT'
ELSE IF @tableTypeId = 91	BEGIN SET @secObjectType = 2048 SET @secCapability = 10 END --'APP_CREDS_MMDEVICECONTROLLER_TABLE, MEDIA_AGENT_ITEM, EV_MANAGE_MEDIAAGENT'
ELSE IF @tableTypeId = 92		BEGIN SET @secObjectType = 2048 SET @secCapability = 10 END --'APP_CREDS_MMDRUINFO_TABLE, MEDIA_AGENT_ITEM, EV_MANAGE_MEDIAAGENT'
ELSE IF @tableTypeId = 93			BEGIN SET @secObjectType = 2048 SET @secCapability = 10 END --'APP_CREDS_MMHOST_TABLE, MEDIA_AGENT_ITEM, EV_MANAGE_MEDIAAGENT'
ELSE IF @tableTypeId = 94		BEGIN SET @secObjectType = 2048 SET @secCapability = 10 END --'APP_CREDS_MMMOUNTPATH_TABLE, MEDIA_AGENT_ITEM, EV_MANAGE_MEDIAAGENT'
ELSE IF @tableTypeId = 95	BEGIN SET @secObjectType = 2048 SET @secCapability = 10 END --'APP_CREDS_MMNDMPHOSTINFO_TABLE, MEDIA_AGENT_ITEM, EV_MANAGE_MEDIAAGENT'
ELSE IF @tableTypeId = 96	BEGIN SET @secObjectType = 2048 SET @secCapability = 10 END --'APP_CREDS_MMSANSWITCHPROXY_TABLE, MEDIA_AGENT_ITEM, EV_MANAGE_MEDIAAGENT'
ELSE IF @tableTypeId = 97			BEGIN SET @secObjectType = 2048 SET @secCapability = 10 END --'APP_CREDS_SMARRAY_TABLE, MEDIA_AGENT_ITEM, EV_MANAGE_MEDIAAGENT'
ELSE IF @tableTypeId = 98	BEGIN SET @secObjectType = 2048 SET @secCapability = 10 END --'APP_CREDS_SMCONTROLHOST_TABLE, MEDIA_AGENT_ITEM, EV_MANAGE_MEDIAAGENT'
ELSE IF @tableTypeId = 100			BEGIN SET @secObjectType = 2018 SET @secCapability = 1 SET @componentNameId = 2 END --'APP_CREDS_DOMAIN_TABLE, COMM_CELL_ITEM, ADMIN MGMT'
ELSE IF @tableTypeId = 99	BEGIN SET @secObjectType=  2018	SET @secCapability = 1 set @componentNameId = 2 END -- 'APP_CREDS_NT_NOTIF_ACTION_TABLE, COMM_CELL_ITEM. ADMIN MGMT'
ELSE IF @tableTypeId = 71	BEGIN SET @secObjectType = 2572 SET @secCapability = 2 END --'APP_CREDS_COMPONENTPROP_TABLE, SERVER_GROUP_NAME_ITEM  , AGENT MGMT'
		ELSE													BEGIN SET @secObjectType = 0    SET @secCapability = 1 END
IF @tableTypeId<>101
			EXEC br_NTPermCheck  @userID, @localeId, @secCapability, @secObjectType, @componentNameId, @errorCode OUTPUT, @errorString OUTPUT
		IF @errorCode <> 0
			GOTO ALL_DONE
SKIP_CREDS_CHECK:
			FETCH NEXT FROM SecurityCheckCursor INTO  @tableTypeId, @componentNameId,  @isPassword
	END
	CLOSE SecurityCheckCursor
	DEALLOCATE SecurityCheckCursor
	END --PREVIEW CHECK
	SET @lastComponentNameId  = 0
	SET @lastTableTypeId = 0
--	**********************************************************************************
--	*** 6. LOOP FOR ALL THE CREDENTIALS SAVED										**
--  **********************************************************************************
--	***	----------------------------------------------------------------------------**
--	*** 6a CHECK FOR USER/LOGIN MATCH TO "OLD" CREDENTIALS							**
--	***																				**
--	*** IF THE OLD LOGIN MATCHES, CHECK THE OLD PASSWORD.  IF BOTH MATCH, PROPS CAN	**
--	*** BE MODIFIED.  NOTE THAT WE ASSUME THAT WE ALLOW PASSWORD CHANGES W/O 		**
--	*** USERNAME CHANGES, BUT NOT THE OTHER WAY AROUND!								**
--	***	----------------------------------------------------------------------------**
--
	DECLARE @oldAttrPassword VARCHAR(1024)   -- Intentionally NOT nvarchar()!!
	BEGIN TRAN
	SET @tranStarted = 1
	DECLARE CredsMatchCursor CURSOR STATIC FOR
			SELECT [credPropsId], [extendedObjId], [tableTypeId], [tableId], [componentNameId], [attrDomainName], [attrVal], [isPassword]
			from @credsMatch
			WHERE [isPassWord] = 0						-- IF THE LOGINS MATCH, THEN BOTH TO CHECK THE PASSWORDS
			order by [tableTypeId], [tableId], [componentNameId], [isPassword]
	OPEN CredsMatchCursor
	FETCH NEXT FROM CredsMatchCursor INTO @credPropsId, @extendedObjId, @tableTypeId, @tableId, @componentNameId, @attrDomain, @attrVal, @isPassword
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF @attrDomain <> ''
			SET @attrVal = @attrDomain +'\' +@attrVal
--		-----------------------------------------------------------------------------------------------------------------
--		IF THIS IS A PASSWORD ITEM, WE NEED TO USE THE EXTENDED STORED PROCEDURE "xp_user_isvalid" TO DETERMINE IF THE
--		PASSWORDS ACTUALLY MATCH OR NOT, AS A "SIMPLE STRING COMPARE" WON'T WORK!
--		-----------------------------------------------------------------------------------------------------------------
		IF @attrVal <> @oldUserName
			GOTO SKIP_CREDS
if (@tableTypeId = 90)	--_APP_CREDS_IDXACCESSPATH_TABLE
		begin
			SET @oldAttrPassword = ISNULL((Select attrVal FROM @credsMatch WHERE credPropsId=@credPropsId AND extendedObjId=@extendedObjId
				AND tableTypeId=@tableTypeId AND componentNameId=@componentNameId AND tableId=@tableId AND isPassWord <> 0), '')
		end
		else
		begin
			SET @oldAttrPassword = ISNULL((Select attrVal FROM @credsMatch WHERE credPropsId=@credPropsId AND extendedObjId=@extendedObjId
				AND tableTypeId=@tableTypeId AND ((componentNameId=@componentNameId AND @componentNameId>0) OR (@componentNameId=0 AND tableId=@tableId)) AND isPassWord <> 0), '')
		end
		IF @oldAttrPassword = ''
			GOTO SKIP_CREDS
		SET @isPasswordType3 = 0
		IF @isSkipPasswordCheck = 0
		BEGIN
			--EXEC master..xp_user_isvalid @oldAttrPassword, @oldUserPasswordV2, @binValue OUTPUT     	-- DO CHECK FOR PASSWORD = TYPE 2
			EXEC isValidUserManaged @oldAttrPassword, @oldUserPassword, @isValidPswd OUTPUT, @errorWstring OUTPUT	-- DO CHECK FOR ALL PASSWORD TYPES
			IF @errorString <> ''
			BEGIN
				SET @errorCode = -1
				SET @errorWstring = N'[isValidUserManaged]: ' + @errorWstring
				GOTO ALL_DONE
			END
		END
		ELSE
		BEGIN
			set @isValidPswd = 1
		END
		--IF @isValidPswd = 0
		--	GOTO SKIP_CREDS
		--Input old password did not match with existing DB password
		--Now, check if input new password match with existing DB password, if yes then go to ALL_DONE, do not error out.
		IF @isValidPswd = 0
		BEGIN
			EXEC isValidUserManaged @oldAttrPassword, @newUserPassword, @isValidPswd OUTPUT, @errorWstring OUTPUT	-- DO CHECK FOR ALL PASSWORD TYPES
			IF @errorString <> ''
			BEGIN
				SET @errorCode = -1
				SET @errorWstring = N'[isValidUserManaged]:new password check error, ' + @errorWstring
				GOTO ALL_DONE
			END
			/*
			IF @isValidPswd = 1
			BEGIN
				SET @errorCode = 0
				SET @errorWstring = N'New password is already set.'
				GOTO ALL_DONE
			END
			ELSE
			BEGIN
				GOTO SKIP_CREDS
			END
			*/
		END
		SET @objectCount = @objectCount +1
--	***	----------------------------------------------------------------**
--	*** 6b WRITE NEW USERNAME/PASSWORDS TO DB							**
--	***	----------------------------------------------------------------**
		SET @isPIT = ISNULL((select isPIT from app_CredProps Where [id] = @credPropsId),0)
		IF @isPreview = 0
		BEGIN
		IF @isUserNameChange <>  0
		BEGIN
			DELETE @INSERT_PROP_RESULTS
			SET @attrName = (select attrUserName from app_CredProps Where [id] = @credPropsId)
			IF @attrDomain <> '' AND CHARINDEX('\', @newUserName) > 0
				SET @newAtrVal  = SUBSTRING(@newUserName, CHARINDEX('\', @newUserName)+1, LEN(@newUserName))
			ELSE
				SET @newAtrVal  = @newUserName
IF		@tableTypeId = 61			-- 'APP_CREDS_SUBCLIENTPROP_TABLE'
						INSERT  @INSERT_PROP_RESULTS	EXEC AppInsertSubClientProp	@componentNameId, @isPit, @nowTime, @attrName, 1, @newAtrVal
ELSE IF @tableTypeId = 51				-- 'APP_CREDS_BKUPSETPROP_TABLE'
						INSERT  @INSERT_PROP_RESULTS	EXEC AppInsertBkupSetProp	@componentNameId, @isPit, @nowTime, @attrName, 1, @newAtrVal
ELSE IF @tableTypeId = 41				-- 'APP_CREDS_INSTANCEPROP_TABLE'
						INSERT  @INSERT_PROP_RESULTS	EXEC AppInsertInstanceProp	@componentNameId, @isPit, @nowTime, @attrName, 1, @newAtrVal
ELSE IF @tableTypeId = 31					-- 'APP_CREDS_IDAPROP_TABLE'
						INSERT  @INSERT_PROP_RESULTS	EXEC  AppInsertIdaProp		 @componentNameId, @isPit, @nowTime, @attrName, 1, @newAtrVal
ELSE IF @tableTypeId = 21				-- 'APP_CREDS_CLIENTPROP_TABLE'
						INSERT  @INSERT_PROP_RESULTS	EXEC AppInsertClientProp @componentNameId, @isPit, @nowTime, @attrName, 1, @newAtrVal
ELSE IF @tableTypeId = 12				-- 'APP_CREDS_GLOBALPARAM_TABLE'
						INSERT  @INSERT_PROP_RESULTS	EXEC AppInsertGlobalParam  @isPit, @nowTime, @attrName, @newAtrVal
ELSE IF @tableTypeId = 10
						UPDATE APP_COMMCELL Set UserName = @newAtrVal WHERE id = @componentNameId
ELSE IF @tableTypeId = 71
UPDATE APP_ComponentProp Set stringVal = @newAtrVal WHERE componentId = @componentNameId AND propertyTypeId = @attrName AND componentType = 8
ELSE IF @tableTypeId = 81
			BEGIN
						UPDATE TM_SubTaskOptions SET value = @newAtrVal WHERE optionId = @attrName AND value = @oldUserName
						UPDATE TM_JobOptions SET value = @newAtrVal WHERE optionId = @attrName AND value = @oldUserName AND jobId = 0
			END
ELSE IF @tableTypeId = 13    --  'APP_CREDS_NT_NOTIF_ACTION_TABLE'
			BEGIN
				UPDATE NTnotificationAction SET runAsUserLogin = @newAtrVal WHERE NTNotificationId = @tableId AND escalationLevel = @extendedObjId
			END
ELSE IF @tableTypeId = 90    --  'APP_CREDS_IDXACCESSPATH_TABLE'
			BEGIN
				UPDATE IdxAccessPath SET Username = @newAtrVal WHERE IdxAccessPathId = @tableId
			END
ELSE IF @tableTypeId = 91    --  'APP_CREDS_MMDEVICECONTROLLER_TABLE'
			BEGIN
				UPDATE MMDeviceController SET UserName = @newAtrVal WHERE DeviceControllerId = @tableId AND SNRVolumeId = @componentNameId
			END
ELSE IF @tableTypeId = 92    --  'APP_CREDS_MMDRUINFO_TABLE'
			BEGIN
				UPDATE MMDRUInfo SET DRUUserName = @newAtrVal WHERE DRUId = @tableId AND DRUPortNumber = @componentNameId
			END
ELSE IF @tableTypeId = 93    --  'APP_CREDS_MMHOST_TABLE'
			BEGIN
				UPDATE MMHost SET IndexCacheUser = @newAtrVal WHERE ClientId = @tableId
			END
ELSE IF @tableTypeId = 94    --  'APP_CREDS_MMMOUNTPATH_TABLE'
			BEGIN
				UPDATE MMMountPath SET UserName = @newAtrVal WHERE MountPathId = @tableId AND MediaSideId = @componentNameId
			END
ELSE IF @tableTypeId = 95    --  'APP_CREDS_MMNDMPHOSTINFO_TABLE'
			BEGIN
				UPDATE MMNDMPHostInfo SET Login = @newAtrVal WHERE NDMPHostId = @tableId AND ClientId = @componentNameId
			END
ELSE IF @tableTypeId = 96    --  'APP_CREDS_MMSANSWITCHPROXY_TABLE'
			BEGIN
				UPDATE MMSanSwitchProxy SET SwitchLogin = @newAtrVal WHERE SwitchId = @tableId
			END
ELSE IF @tableTypeId = 97    --  'APP_CREDS_SMARRAY_TABLE'
			BEGIN
				UPDATE SMArray SET LoginName = @newAtrVal WHERE Id = @tableId AND ClientId = @componentNameId
			END
ELSE IF @tableTypeId = 98    --  'APP_CREDS_SMCONTROLHOST_TABLE'
			BEGIN
				UPDATE SMControlHost SET SMHostUserName = @newAtrVal WHERE ControlHostId = @tableId AND SnapShotEngineId = @componentNameId
			END
ELSE IF @tableTypeId = 99    --  'APP_CREDS_SAVETODISKALERT_TABLE'
			BEGIN
				UPDATE NTMessageFormat SET userName = @newAtrVal WHERE NTNotificationId = @tableId AND escalationLevel = @extendedObjId and messageType = 512 --NT_SAVE_ALERTNOTIF
			END
ELSE IF @tableTypeId = 100					-- 'APP_CREDS_DOMAIN_TABLE'
			BEGIN
				UPDATE UMDSProviders SET login = @umdsNewUserName WHERE id = @componentNameId AND domainName = @umdsDomainName AND serviceType = 2
			END
ELSE IF @tableTypeId = 101    --  'APP_CREDS_CREDENTIAL_MANAGER_TABLE'
			BEGIN
				UPDATE APP_Credentials SET userName = @newAtrVal WHERE credentialId = @tableId
			END
			SET @errorCode   = ISNULL((Select errorCode   from @INSERT_PROP_RESULTS), 0)
			SET @errorString = ISNULL((Select errorString from @INSERT_PROP_RESULTS), '')
			IF @errorCode <> 0				-- ANY ERROR IS AN ABORT!
				GOTO ALL_DONE
			IF @attrDomain <> '' AND CHARINDEX('\',@newUserName) > 0
			BEGIN
				DELETE @INSERT_PROP_RESULTS
				SET @attrName = (select attrDomainName from app_CredProps Where [id] = @credPropsId)
				SET @newAtrVal  = LEFT(@newUserName, CHARINDEX('\',@newUserName)-1)
IF		@tableTypeId = 61			-- 'APP_CREDS_SUBCLIENTPROP_TABLE'
							INSERT  @INSERT_PROP_RESULTS	EXEC AppInsertSubClientProp	@componentNameId, @isPit, @nowTime, @attrName, 1, @newAtrVal
ELSE IF @tableTypeId = 51				-- 'APP_CREDS_BKUPSETPROP_TABLE'
							INSERT  @INSERT_PROP_RESULTS	EXEC AppInsertBkupSetProp	@componentNameId, @isPit, @nowTime, @attrName, 1, @newAtrVal
ELSE IF @tableTypeId = 41				-- 'APP_CREDS_INSTANCEPROP_TABLE'
							INSERT  @INSERT_PROP_RESULTS	EXEC AppInsertInstanceProp	@componentNameId, @isPit, @nowTime, @attrName, 1, @newAtrVal
ELSE IF @tableTypeId = 31					-- 'APP_CREDS_IDAPROP_TABLE'
							INSERT  @INSERT_PROP_RESULTS	EXEC  AppInsertIdaProp		 @componentNameId, @isPit, @nowTime, @attrName, 1, @newAtrVal
ELSE IF @tableTypeId = 21				-- 'APP_CREDS_CLIENTPROP_TABLE'
							INSERT  @INSERT_PROP_RESULTS	EXEC AppInsertClientProp @componentNameId, @isPit, @nowTime, @attrName, 1, @newAtrVal
				SET @errorCode   = ISNULL((Select errorCode   from @INSERT_PROP_RESULTS), 0)
				SET @errorString = ISNULL((Select errorString from @INSERT_PROP_RESULTS), '')
				IF @errorCode <> 0				-- ANY ERROR IS AN ABORT!
					GOTO ALL_DONE
			END
		END
		IF @isPasswordChange <>  0					-- Technically, this check really isn't needed as getting here implies
		BEGIN										-- .. at LEAST the password changed (username not necessarily)
			DELETE @INSERT_PROP_RESULTS
			SET @attrName       = (select attrPwdName from app_CredProps Where [id] = @credPropsId)
			SET @encryptionType = (select encryptionType from app_CredProps Where [id] = @credPropsId)
			IF @encryptionType = 5
				SET @newAtrVal = @newUserPasswordV5
			ELSE
				SET @newAtrVal = @newUserPassword
IF		@tableTypeId = 61			-- 'APP_CREDS_SUBCLIENTPROP_TABLE'
						INSERT  @INSERT_PROP_RESULTS	EXEC AppInsertSubClientProp	@componentNameId, @isPit, @nowTime, @attrName, 1, @newAtrVal
ELSE IF @tableTypeId = 51				-- 'APP_CREDS_BKUPSETPROP_TABLE'
						INSERT  @INSERT_PROP_RESULTS	EXEC AppInsertBkupSetProp	@componentNameId, @isPit, @nowTime, @attrName, 1, @newAtrVal
ELSE IF @tableTypeId = 41				-- 'APP_CREDS_INSTANCEPROP_TABLE'
						INSERT  @INSERT_PROP_RESULTS	EXEC AppInsertInstanceProp	@componentNameId, @isPit, @nowTime, @attrName, 1, @newAtrVal
ELSE IF @tableTypeId = 31					-- 'APP_CREDS_IDAPROP_TABLE'
						INSERT  @INSERT_PROP_RESULTS	EXEC  AppInsertIdaProp		 @componentNameId, @isPit, @nowTime, @attrName, 1, @newAtrVal
ELSE IF @tableTypeId = 21				-- 'APP_CREDS_CLIENTPROP_TABLE'
						INSERT  @INSERT_PROP_RESULTS	EXEC AppInsertClientProp @componentNameId, @isPit, @nowTime, @attrName, 1, @newAtrVal
ELSE IF @tableTypeId = 12				-- 'APP_CREDS_GLOBALPARAM_TABLE'
						INSERT  @INSERT_PROP_RESULTS	EXEC AppInsertGlobalParam  @isPit, @nowTime, @attrName, @newAtrVal
ELSE IF @tableTypeId = 10
						UPDATE APP_COMMCELL Set UserPassword = @newAtrVal WHERE id = @componentNameId
ELSE IF @tableTypeId = 71
UPDATE APP_ComponentProp Set stringVal = @newAtrVal WHERE componentId = @componentNameId AND propertyTypeId = @attrName	AND componentType = 8
ELSE IF @tableTypeId = 81
			BEGIN
						UPDATE TM_SubTaskOptions SET value = @newAtrVal WHERE optionId = @attrName AND value = @oldAttrPassword
						UPDATE TM_JobOptions SET value = @newAtrVal WHERE optionId = @attrName AND value = @oldAttrPassword AND jobId = 0
			END
ELSE IF @tableTypeId = 13    --  'APP_CREDS_NT_NOTIF_ACTION_TABLE'
			BEGIN
				UPDATE NTnotificationAction SET runAsUserPassword = @newAtrVal WHERE NTNotificationId = @tableId AND escalationLevel = @extendedObjId
			END
ELSE IF @tableTypeId = 90    --  'APP_CREDS_IDXACCESSPATH_TABLE'
			BEGIN
				UPDATE IdxAccessPath SET Password = @newAtrVal WHERE IdxAccessPathId = @tableId
			END
ELSE IF @tableTypeId = 91    --  'APP_CREDS_MMDEVICECONTROLLER_TABLE'
			BEGIN
				UPDATE MMDeviceController SET UserPassword = @newAtrVal WHERE DeviceControllerId = @tableId AND SNRVolumeId = @componentNameId
			END
ELSE IF @tableTypeId = 92    --  'APP_CREDS_MMDRUINFO_TABLE'
			BEGIN
				UPDATE MMDRUInfo SET DRUPassword = @newAtrVal WHERE DRUId = @tableId AND DRUPortNumber = @componentNameId
			END
ELSE IF @tableTypeId = 93    --  'APP_CREDS_MMHOST_TABLE'
			BEGIN
				UPDATE MMHost SET IndexCachePassword = @newAtrVal WHERE ClientId = @tableId
			END
ELSE IF @tableTypeId = 94    --  'APP_CREDS_MMMOUNTPATH_TABLE'
			BEGIN
				UPDATE MMMountPath SET UserPassword = @newAtrVal WHERE MountPathId = @tableId AND MediaSideId = @componentNameId
			END
ELSE IF @tableTypeId = 95    --  'APP_CREDS_MMNDMPHOSTINFO_TABLE'
			BEGIN
				UPDATE MMNDMPHostInfo SET Password = @newAtrVal WHERE NDMPHostId = @tableId AND ClientId = @componentNameId
			END
ELSE IF @tableTypeId = 96    --  'APP_CREDS_MMSANSWITCHPROXY_TABLE'
			BEGIN
				UPDATE MMSanSwitchProxy SET SwitchPassword = @newAtrVal WHERE SwitchId = @tableId
			END
ELSE IF @tableTypeId = 97    --  'APP_CREDS_SMARRAY_TABLE'
			BEGIN
				UPDATE SMArray SET LoginPassword = @newAtrVal WHERE Id = @tableId AND ClientId = @componentNameId
			END
ELSE IF @tableTypeId = 98    --  'APP_CREDS_SMCONTROLHOST_TABLE'
			BEGIN
				UPDATE SMControlHost SET SMHostPassword = @newAtrVal WHERE ControlHostId = @tableId AND SnapShotEngineId = @componentNameId
			END
ELSE IF @tableTypeId = 99    --  'APP_CREDS_SAVETODISKALERT_TABLE'
			BEGIN
				UPDATE NTMessageFormat SET password = @newAtrVal WHERE NTNotificationId = @tableId AND escalationLevel = @extendedObjId and messageType = 512 --NT_SAVE_ALERTNOTIF
			END
ELSE IF @tableTypeId = 100					-- 'APP_CREDS_DOMAIN_TABLE'
			BEGIN
				UPDATE UMDSProviders SET password = @newAtrVal WHERE id = @componentNameId AND domainName = @umdsDomainName AND serviceType = 2
			END
ELSE IF @tableTypeId = 101    --  'APP_CREDS_CREDENTIAL_MANAGER_TABLE'
			BEGIN
				UPDATE APP_Credentials SET password = @newAtrVal WHERE credentialId = @tableId
			END
			SET @errorCode   = ISNULL((Select errorCode   from @INSERT_PROP_RESULTS), 0)
			SET @errorString = ISNULL((Select errorString from @INSERT_PROP_RESULTS), '')
			IF @errorCode <> 0				-- ANY ERROR IS AN ABORT!
				GOTO ALL_DONE
		END
		END	--PREVIEW CHECK
		ELSE
		BEGIN
				--INSERT  INTO @previewTable ([type],[clientGroupId],[clientGroupName],[clientId],[clientName],[appTypeId],[appTypeName],[instanceId],[instanceName],
				--[backupsetId],[backupSetName],[subClientId],[subClientName],[mediaAgentId],[mediaAgentName],[libraryId],[libraryName],[archGroupId],[archGroupName],
				--[vtContainerId],[vtContainerName],[vtPolicyId],[vtPolicyName],[vtShelfId],[vtShelfName],[taskId],[taskName],[subTaskId],[subTaskName])
			IF @isUserNameChange <>  0
			BEGIN
IF @tableTypeId = 61			-- 'APP_CREDS_SUBCLIENTPROP_TABLE'
					INSERT  INTO @previewTable ([type],[clientId],[clientName],[appTypeId],[appTypeName],[instanceId],[instanceName],
					[backupsetId],[backupSetName],[subClientId],[subClientName])
SELECT DISTINCT 7, CL.id, CL.name, IDA.type, IDA.displayName, INS.id, INS.name, BS.id, BS.name, APP.id, APP.subclientName
					FROM APP_Application APP
					JOIN APP_BackupSetName BS ON BS.id=APP.backupSet
					JOIN APP_InstanceName INS ON INS.id=APP.instance
					JOIN APP_iDAType IDA ON IDA.type=APP.appTypeId
					JOIN APP_Client CL ON CL.id=APP.clientId
					WHERE APP.id=@componentNameId
ELSE IF @tableTypeId = 51				-- 'APP_CREDS_BKUPSETPROP_TABLE'
					INSERT  INTO @previewTable ([type],[clientId],[clientName],[appTypeId],[appTypeName],[instanceId],[instanceName],
					[backupsetId],[backupSetName])
SELECT DISTINCT 6, CL.id, CL.name, IDA.type, IDA.displayName, INS.id, INS.name, BS.id, BS.name
					FROM APP_Application APP
					JOIN APP_BackupSetName BS ON BS.id=APP.backupSet
					JOIN APP_InstanceName INS ON INS.id=APP.instance
					JOIN APP_iDAType IDA ON IDA.type=APP.appTypeId
					JOIN APP_Client CL ON CL.id=APP.clientId
					WHERE APP.backupSet=@componentNameId
ELSE IF @tableTypeId = 41				-- 'APP_CREDS_INSTANCEPROP_TABLE'
					INSERT  INTO @previewTable ([type],[clientId],[clientName],[appTypeId],[appTypeName],[instanceId],[instanceName])
SELECT DISTINCT 5, CL.id, CL.name, IDA.type, IDA.displayName, INS.id, INS.name
					FROM APP_Application APP
					JOIN APP_InstanceName INS ON INS.id=APP.instance
					JOIN APP_iDAType IDA ON IDA.type=APP.appTypeId
					JOIN APP_Client CL ON CL.id=APP.clientId
					WHERE APP.instance=@componentNameId
ELSE IF @tableTypeId = 31					-- 'APP_CREDS_IDAPROP_TABLE'
					INSERT  INTO @previewTable ([type],[clientId],[clientName],[appTypeId],[appTypeName])
SELECT DISTINCT 4, CL.id, CL.name, IDAT.type, IDAT.displayName FROM APP_Application APP
					JOIN APP_iDAType IDAT ON IDAT.type=APP.appTypeId
					JOIN APP_Client CL ON CL.id=APP.clientId
					JOIN APP_IDAName IDA ON IDA.clientId=CL.id AND IDA.appTypeId=APP.appTypeId
					WHERE IDA.id=@componentNameId
ELSE IF @tableTypeId = 21				-- 'APP_CREDS_CLIENTPROP_TABLE'
					INSERT  INTO @previewTable ([type],[clientId],[clientName])
SELECT DISTINCT 3, CL.id, CL.name
					FROM APP_Application APP
					JOIN APP_Client CL ON CL.id=APP.clientId
					WHERE APP.clientId=@componentNameId
ELSE IF @tableTypeId = 12				-- 'APP_CREDS_GLOBALPARAM_TABLE'
					INSERT  INTO @previewTable ([type],[commCellId],[commCellName])
SELECT DISTINCT 1, C.id, C.aliasName
					FROM APP_CommCell C
					WHERE C.id=@componentNameId
ELSE IF @tableTypeId = 10
					INSERT  INTO @previewTable ([type],[commCellId],[commCellName])
SELECT DISTINCT 1, C.id, C.aliasName
					FROM APP_CommCell C
					WHERE C.id=@componentNameId
ELSE IF @tableTypeId = 71
					INSERT  INTO @previewTable ([type],[clientGroupId],[clientGroupName])
SELECT DISTINCT 28, G.id, G.name
					FROM APP_ComponentProp C
					JOIN APP_ClientGroup G ON G.id = C.componentId
					WHERE C.componentId=@componentNameId
AND componentType = 8
					AND C.modified = 0
ELSE IF @tableTypeId = 81
				BEGIN
					INSERT  INTO @previewTable ([type],[taskId],[taskName],[subTaskId],[subTaskName])
SELECT 68, T.taskId, T.taskName, S.subTaskId, S.subTaskName FROM TM_SubTaskOptions O
					JOIN TM_SubTask S ON S.subTaskId=O.subTaskId
					JOIN TM_Task T ON T.taskId=S.taskId
					WHERE value = @oldUserName AND S.subTaskId=@componentNameId
					AND (optionId IN (select attrUserName from app_CredProps Where [id] = @credPropsId))
				END
ELSE IF @tableTypeId = 13    --  'APP_CREDS_NT_NOTIF_ACTION_TABLE'
				BEGIN
					INSERT  INTO @previewTable ([type],[alertId],[alertName])
SELECT DISTINCT 64, R.id, R.notificationName + case when @extendedObjId=2 then '(Escalated)' else '' end
					FROM NTnotificationAction N
					JOIN NTnotificationRule R ON R.id=N.NTnotificationID
					WHERE N.NTNotificationId = @tableId AND escalationLevel = @extendedObjId
					--UPDATE NTnotificationAction SET runAsUserPassword = @newAtrVal WHERE NTNotificationId = @tableId AND escalationLevel = @componentNameId
				END
ELSE IF @tableTypeId = 90    --  'APP_CREDS_IDXACCESSPATH_TABLE'
				BEGIN
					--UPDATE IdxAccessPath SET Password = @newAtrVal WHERE IdxAccessPathId = @tableId
					INSERT  INTO @previewTable ([type],[clientId],[clientName])
SELECT DISTINCT 3, CL.id, CL.name
					FROM IdxAccessPath IAP
					JOIN APP_Client CL ON CL.id=IAP.ClientId
					WHERE IAP.IdxAccessPathId=@tableId
				END
ELSE IF @tableTypeId = 91    --  'APP_CREDS_MMDEVICECONTROLLER_TABLE'
				BEGIN
					--UPDATE MMDeviceController SET UserPassword = @newAtrVal WHERE DeviceControllerId = @tableId AND SNRVolumeId = @componentNameId
					INSERT  INTO @previewTable ([type],[clientId],[clientName],[libraryId],[libraryName], [mountPathId], [mountPathName])
SELECT DISTINCT 9, CL.id, CL.name, MP.LibraryId, ML.AliasName, MP.MountPathId, MC.Folder
					FROM MMDeviceController MC
					JOIN APP_Client CL ON CL.id=MC.ClientId
					JOIN MMMountPathToStorageDevice MS ON MS.DeviceId = MC.DeviceId
					JOIN MMMountPath MP ON MP.MountPathId = MS.MountPathId
					JOIN MMLibrary ML ON ML.LibraryId=MP.LibraryId
					WHERE MC.DeviceControllerId = @tableId AND MC.SNRVolumeId = @componentNameId
				END
ELSE IF @tableTypeId = 92    --  'APP_CREDS_MMDRUINFO_TABLE'
				BEGIN
					--UPDATE MMDRUInfo SET DRUPassword = @newAtrVal WHERE DRUId = @tableId AND DRUPortNumber = @componentNameId
					INSERT  INTO @previewTable ([type],[libraryId],[libraryName])
SELECT DISTINCT 9, MP.LibraryId, ML.AliasName
					FROM MMDRUInfo D
					JOIN MMDevice MD ON MD.DRUId=D.DRUId
					JOIN MMDeviceController MC ON MC.DeviceId=MD.DeviceId
					JOIN MMMountPathToStorageDevice MS ON MS.DeviceId = MC.DeviceId
					JOIN MMMountPath MP ON MP.MountPathId = MS.MountPathId
					JOIN MMLibrary ML ON ML.LibraryId=MP.LibraryId
					WHERE D.DRUId=@tableId AND D.DRUPortNumber = @componentNameId
				END
ELSE IF @tableTypeId = 93    --  'APP_CREDS_MMHOST_TABLE'
				BEGIN
					--UPDATE MMHost SET IndexCachePassword = @newAtrVal WHERE ClientId = @tableId
					INSERT  INTO @previewTable ([type],[clientId],[clientName])
SELECT DISTINCT 3, CL.id, CL.name
					FROM MMHost MH
					JOIN APP_Client CL ON CL.id=MH.ClientId
					WHERE MH.ClientId=@tableId
				END
ELSE IF @tableTypeId = 94    --  'APP_CREDS_MMMOUNTPATH_TABLE'
				BEGIN
					INSERT  INTO @previewTable ([type],[libraryId],[libraryName], [mountPathId], [mountPathName])
SELECT DISTINCT 52, ML.LibraryId, ML.AliasName, MP.MountPathId, MC.Folder
					FROM MMMountPath MP
					JOIN MMLibrary ML ON ML.LibraryId=MP.LibraryId
					JOIN MMMountPathToStorageDevice MS ON MS.MountPathId=MP.MountPathId
					JOIN MMDeviceController MC ON MC.DeviceId=MS.DeviceId
					WHERE MP.MountPathId=@tableId AND MP.MediaSideId = @componentNameId
				END
ELSE IF @tableTypeId = 95    --  'APP_CREDS_MMNDMPHOSTINFO_TABLE'
				BEGIN
					--UPDATE MMNDMPHostInfo SET Password = @newAtrVal WHERE NDMPHostId = @tableId AND ClientId = @componentNameId
					INSERT  INTO @previewTable ([type],[clientId],[clientName])--,[libraryId],[libraryName])
SELECT DISTINCT 9, CL.id, CL.name--, ML.LibraryId, ML.AliasName
					FROM MMNDMPHostInfo MH
					--JOIN MMLibraryHostInfo LH ON LH.NDMPHostId=MH.NDMPHostId
					--JOIN MMLibraryController LC ON LC.LibraryControllerId=LH.LibraryControllerId
					--JOIN MMLibrary ML ON ML.LibraryId=LC.LibraryId
					JOIN APP_Client CL ON CL.id=MH.ClientId
					WHERE MH.NDMPHostId = @tableId AND MH.ClientId = @componentNameId
				END
ELSE IF @tableTypeId = 96    --  'APP_CREDS_MMSANSWITCHPROXY_TABLE'
				BEGIN
					--UPDATE MMSanSwitchProxy SET SwitchPassword = @newAtrVal WHERE SwitchId = @tableId
					INSERT  INTO @previewTable ([type],[commCellId],[commCellName])
SELECT DISTINCT 1, C.id, C.aliasName
					FROM APP_CommCell C
					WHERE C.id=@componentNameId
				END
ELSE IF @tableTypeId = 97    --  'APP_CREDS_SMARRAY_TABLE'
				BEGIN
					--UPDATE SMArray SET LoginPassword = @newAtrVal WHERE Id = @tableId AND ClientId = @componentNameId
					INSERT  INTO @previewTable ([type],[clientId],[clientName])
SELECT DISTINCT 3, CL.id, CL.name
					FROM SMArray SA
					JOIN APP_Client CL ON CL.id=SA.ClientId
					WHERE SA.Id = @tableId AND SA.ClientId = @componentNameId
				END
ELSE IF @tableTypeId = 98    --  'APP_CREDS_SMCONTROLHOST_TABLE'
				BEGIN
					--UPDATE SMControlHost SET SMHostPassword = @newAtrVal WHERE ControlHostId = @tableId AND SnapShotEngineId = @componentNameId
					IF EXISTS(SELECT 1 FROM SMControlHost SC WHERE SC.ControlHostId = @tableId AND SC.SnapShotEngineId = @componentNameId AND SC.ClientId > 1)
						INSERT  INTO @previewTable ([type],[clientId],[clientName])
SELECT DISTINCT 3, CL.id, CL.name
						FROM SMControlHost SC
						JOIN APP_Client CL ON CL.id=SC.ClientId
						WHERE SC.ControlHostId = @tableId AND SC.SnapShotEngineId = @componentNameId
					ELSE
						INSERT  INTO @previewTable ([type],[commCellId],[commCellName])
SELECT DISTINCT 1, C.id, C.aliasName
						FROM APP_CommCell C
						WHERE C.id=2
				END
ELSE IF @tableTypeId = 99    --  'APP_CREDS_SAVETODISKALERT_TABLE'
				BEGIN
					INSERT  INTO @previewTable ([type],[alertId],[alertName])
SELECT DISTINCT 64, R.id, R.notificationName + case when @extendedObjId=2 then '(Escalated)' else '' end
					FROM NTMessageFormat N
					JOIN NTnotificationRule R ON R.id=N.NTnotificationID
					WHERE N.NTNotificationId = @tableId AND escalationLevel = @extendedObjId and N.messageType=512		--NT_SAVE_ALERTNOTIF
				END
ELSE IF @tableTypeId = 101    --  'APP_CREDS_CREDENTIAL_MANAGER_TABLE'
				BEGIN
					INSERT  INTO @previewTable ([type],[credentialId],[credentialName])
SELECT DISTINCT 174, APC.credentialId, APC.credentialName
					FROM APP_Credentials APC
					WHERE APC.credentialId = @tableId
				END
ELSE IF @tableTypeId = 100	-- 'APP_CREDS_SUBCLIENTPROP_TABLE'
					INSERT  INTO @previewTable ([type],[domainId], [domainName])
					SELECT DISTINCT 100, id, domainName
					FROM UMDSProviders
					WHERE id=@componentNameId
				SET @preUserRow = @@IDENTITY
			END
			IF @isPasswordChange <>  0
			BEGIN
IF @tableTypeId = 61			-- 'APP_CREDS_SUBCLIENTPROP_TABLE'
					INSERT  INTO @previewTable ([type],[clientId],[clientName],[appTypeId],[appTypeName],[instanceId],[instanceName],
					[backupsetId],[backupSetName],[subClientId],[subClientName])
SELECT DISTINCT 7, CL.id, CL.name, IDA.type, IDA.displayName, INS.id, INS.name, BS.id, BS.name, APP.id, APP.subclientName
					FROM APP_Application APP
					JOIN APP_BackupSetName BS ON BS.id=APP.backupSet
					JOIN APP_InstanceName INS ON INS.id=APP.instance
					JOIN APP_iDAType IDA ON IDA.type=APP.appTypeId
					JOIN APP_Client CL ON CL.id=APP.clientId
					WHERE APP.id=@componentNameId
ELSE IF @tableTypeId = 51				-- 'APP_CREDS_BKUPSETPROP_TABLE'
					INSERT  INTO @previewTable ([type],[clientId],[clientName],[appTypeId],[appTypeName],[instanceId],[instanceName],
					[backupsetId],[backupSetName])
SELECT DISTINCT 6, CL.id, CL.name, IDA.type, IDA.displayName, INS.id, INS.name, BS.id, BS.name
					FROM APP_Application APP
					JOIN APP_BackupSetName BS ON BS.id=APP.backupSet
					JOIN APP_InstanceName INS ON INS.id=APP.instance
					JOIN APP_iDAType IDA ON IDA.type=APP.appTypeId
					JOIN APP_Client CL ON CL.id=APP.clientId
					WHERE APP.backupSet=@componentNameId
ELSE IF @tableTypeId = 41				-- 'APP_CREDS_INSTANCEPROP_TABLE'
					INSERT  INTO @previewTable ([type],[clientId],[clientName],[appTypeId],[appTypeName],[instanceId],[instanceName])
SELECT DISTINCT 5, CL.id, CL.name, IDA.type, IDA.displayName, INS.id, INS.name
					FROM APP_Application APP
					JOIN APP_InstanceName INS ON INS.id=APP.instance
					JOIN APP_iDAType IDA ON IDA.type=APP.appTypeId
					JOIN APP_Client CL ON CL.id=APP.clientId
					WHERE APP.instance=@componentNameId
ELSE IF @tableTypeId = 31					-- 'APP_CREDS_IDAPROP_TABLE'
					INSERT  INTO @previewTable ([type],[clientId],[clientName],[appTypeId],[appTypeName])
SELECT DISTINCT 4, CL.id, CL.name, IDAT.type, IDAT.displayName FROM APP_Application APP
					JOIN APP_iDAType IDAT ON IDAT.type=APP.appTypeId
					JOIN APP_Client CL ON CL.id=APP.clientId
					JOIN APP_IDAName IDA ON IDA.clientId=CL.id AND IDA.appTypeId=APP.appTypeId
					WHERE IDA.id=@componentNameId
ELSE IF @tableTypeId = 21				-- 'APP_CREDS_CLIENTPROP_TABLE'
					INSERT  INTO @previewTable ([type],[clientId],[clientName])
SELECT DISTINCT 3, CL.id, CL.name
					FROM APP_Application APP
					JOIN APP_Client CL ON CL.id=APP.clientId
					WHERE APP.clientId=@componentNameId
ELSE IF @tableTypeId = 12				-- 'APP_CREDS_GLOBALPARAM_TABLE'
					INSERT  INTO @previewTable ([type],[commCellId],[commCellName])
SELECT DISTINCT 1, C.id, C.aliasName
					FROM APP_CommCell C
					WHERE C.id=@componentNameId
ELSE IF @tableTypeId = 10
					INSERT  INTO @previewTable ([type],[commCellId],[commCellName])
SELECT DISTINCT 1, C.id, C.aliasName
					FROM APP_CommCell C
					WHERE C.id=@componentNameId
ELSE IF @tableTypeId = 71
					INSERT  INTO @previewTable ([type],[clientGroupId],[clientGroupName])
SELECT DISTINCT 28, G.id, G.name
					FROM APP_ComponentProp C
					JOIN APP_ClientGroup G ON G.id = C.componentId
					WHERE C.componentId=@componentNameId
AND componentType = 8
					AND C.modified = 0
ELSE IF @tableTypeId = 81
				BEGIN
					INSERT  INTO @previewTable ([type],[taskId],[taskName],[subTaskId],[subTaskName])
SELECT 68, T.taskId, T.taskName, S.subTaskId, S.subTaskName FROM TM_SubTaskOptions O
					JOIN TM_SubTask S ON S.subTaskId=O.subTaskId
					JOIN TM_Task T ON T.taskId=S.taskId
					WHERE value = @oldAttrPassword AND S.subTaskId=@componentNameId
					AND (optionId IN (select attrPwdName from app_CredProps Where [id] = @credPropsId))
				END
ELSE IF @tableTypeId = 13    --  'APP_CREDS_NT_NOTIF_ACTION_TABLE'
				BEGIN
					INSERT  INTO @previewTable ([type],[alertId],[alertName])
SELECT DISTINCT 64, R.id, R.notificationName + case when @extendedObjId=2 then '(Escalated)' else '' end
					FROM NTnotificationAction N
					JOIN NTnotificationRule R ON R.id=N.NTnotificationID
					WHERE N.NTNotificationId = @tableId AND N.escalationLevel = @extendedObjId
					--UPDATE NTnotificationAction SET runAsUserPassword = @newAtrVal WHERE NTNotificationId = @tableId AND escalationLevel = @componentNameId
				END
ELSE IF @tableTypeId = 90    --  'APP_CREDS_IDXACCESSPATH_TABLE'
				BEGIN
					--UPDATE IdxAccessPath SET Password = @newAtrVal WHERE IdxAccessPathId = @tableId
					INSERT  INTO @previewTable ([type],[clientId],[clientName])
SELECT DISTINCT 3, CL.id, CL.name
					FROM IdxAccessPath IAP
					JOIN APP_Client CL ON CL.id=IAP.ClientId
					WHERE IAP.IdxAccessPathId=@tableId
				END
ELSE IF @tableTypeId = 91    --  'APP_CREDS_MMDEVICECONTROLLER_TABLE'
				BEGIN
					--UPDATE MMDeviceController SET UserPassword = @newAtrVal WHERE DeviceControllerId = @tableId AND SNRVolumeId = @componentNameId
					INSERT  INTO @previewTable ([type],[clientId],[clientName],[libraryId],[libraryName], [mountPathId], [mountPathName])
SELECT DISTINCT 9, CL.id, CL.name, MP.LibraryId, ML.AliasName, MP.MountPathId, MC.Folder
					FROM MMDeviceController MC
					JOIN APP_Client CL ON CL.id=MC.ClientId
					JOIN MMMountPathToStorageDevice MS ON MS.DeviceId = MC.DeviceId
					JOIN MMMountPath MP ON MP.MountPathId = MS.MountPathId
					JOIN MMLibrary ML ON ML.LibraryId=MP.LibraryId
					WHERE MC.DeviceControllerId = @tableId AND MC.SNRVolumeId = @componentNameId
				END
ELSE IF @tableTypeId = 92    --  'APP_CREDS_MMDRUINFO_TABLE'
				BEGIN
					--UPDATE MMDRUInfo SET DRUPassword = @newAtrVal WHERE DRUId = @tableId AND DRUPortNumber = @componentNameId
					INSERT  INTO @previewTable ([type],[libraryId],[libraryName])
SELECT DISTINCT 9, MP.LibraryId, ML.AliasName
					FROM MMDRUInfo D
					JOIN MMDevice MD ON MD.DRUId=D.DRUId
					JOIN MMDeviceController MC ON MC.DeviceId=MD.DeviceId
					JOIN MMMountPathToStorageDevice MS ON MS.DeviceId = MC.DeviceId
					JOIN MMMountPath MP ON MP.MountPathId = MS.MountPathId
					JOIN MMLibrary ML ON ML.LibraryId=MP.LibraryId
					WHERE D.DRUId=@tableId AND D.DRUPortNumber = @componentNameId
				END
ELSE IF @tableTypeId = 93    --  'APP_CREDS_MMHOST_TABLE'
				BEGIN
					--UPDATE MMHost SET IndexCachePassword = @newAtrVal WHERE ClientId = @tableId
					INSERT  INTO @previewTable ([type],[clientId],[clientName])
SELECT DISTINCT 3, CL.id, CL.name
					FROM MMHost MH
					JOIN APP_Client CL ON CL.id=MH.ClientId
					WHERE MH.ClientId=@tableId
				END
ELSE IF @tableTypeId = 94    --  'APP_CREDS_MMMOUNTPATH_TABLE'
				BEGIN
					--UPDATE MMMountPath SET UserPassword = @newAtrVal WHERE MountPathId = @tableId AND MediaSideId = @componentNameId
					INSERT  INTO @previewTable ([type],[libraryId],[libraryName], [mountPathId], [mountPathName])
SELECT DISTINCT 52, ML.LibraryId, ML.AliasName, MP.MountPathId, MC.Folder
					FROM MMMountPath MP
					JOIN MMLibrary ML ON ML.LibraryId=MP.LibraryId
					JOIN MMMountPathToStorageDevice MS ON MS.MountPathId=MP.MountPathId
					JOIN MMDeviceController MC ON MC.DeviceId=MS.DeviceId
					WHERE MP.MountPathId=@tableId AND MP.MediaSideId = @componentNameId
				END
ELSE IF @tableTypeId = 95    --  'APP_CREDS_MMNDMPHOSTINFO_TABLE'
				BEGIN
					--UPDATE MMNDMPHostInfo SET Password = @newAtrVal WHERE NDMPHostId = @tableId AND ClientId = @componentNameId
					INSERT  INTO @previewTable ([type],[clientId],[clientName])--,[libraryId],[libraryName])
SELECT DISTINCT 9, CL.id, CL.name--, ML.LibraryId, ML.AliasName
					FROM MMNDMPHostInfo MH
					--JOIN MMLibraryHostInfo LH ON LH.NDMPHostId=MH.NDMPHostId
					--JOIN MMLibraryController LC ON LC.LibraryControllerId=LH.LibraryControllerId
					--JOIN MMLibrary ML ON ML.LibraryId=LC.LibraryId
					JOIN APP_Client CL ON CL.id=MH.ClientId
					WHERE MH.NDMPHostId = @tableId AND MH.ClientId = @componentNameId
				END
ELSE IF @tableTypeId = 96    --  'APP_CREDS_MMSANSWITCHPROXY_TABLE'
				BEGIN
					--UPDATE MMSanSwitchProxy SET SwitchPassword = @newAtrVal WHERE SwitchId = @tableId
					INSERT  INTO @previewTable ([type],[commCellId],[commCellName])
SELECT DISTINCT 1, C.id, C.aliasName
					FROM APP_CommCell C
					WHERE C.id=@componentNameId
				END
ELSE IF @tableTypeId = 97    --  'APP_CREDS_SMARRAY_TABLE'
				BEGIN
					--UPDATE SMArray SET LoginPassword = @newAtrVal WHERE Id = @tableId AND ClientId = @componentNameId
					INSERT  INTO @previewTable ([type],[clientId],[clientName])
SELECT DISTINCT 3, CL.id, CL.name
					FROM SMArray SA
					JOIN APP_Client CL ON CL.id=SA.ClientId
					WHERE SA.Id = @tableId AND SA.ClientId = @componentNameId
				END
ELSE IF @tableTypeId = 98    --  'APP_CREDS_SMCONTROLHOST_TABLE'
				BEGIN
					--UPDATE SMControlHost SET SMHostPassword = @newAtrVal WHERE ControlHostId = @tableId AND SnapShotEngineId = @componentNameId
					IF EXISTS(SELECT 1 FROM SMControlHost SC WHERE SC.ControlHostId = @tableId AND SC.SnapShotEngineId = @componentNameId AND SC.ClientId > 1)
						INSERT  INTO @previewTable ([type],[clientId],[clientName])
SELECT DISTINCT 3, CL.id, CL.name
						FROM SMControlHost SC
						JOIN APP_Client CL ON CL.id=SC.ClientId
						WHERE SC.ControlHostId = @tableId AND SC.SnapShotEngineId = @componentNameId
					ELSE
						INSERT  INTO @previewTable ([type],[commCellId],[commCellName])
SELECT DISTINCT 1, C.id, C.aliasName
						FROM APP_CommCell C
						WHERE C.id=2
				END
ELSE IF @tableTypeId = 99    --  'APP_CREDS_SAVETODISKALERT_TABLE'
				BEGIN
					INSERT  INTO @previewTable ([type],[alertId],[alertName])
SELECT DISTINCT 64, R.id, R.notificationName + case when @extendedObjId=2 then '(Escalated)' else '' end
					FROM NTMessageFormat N
					JOIN NTnotificationRule R ON R.id=N.NTnotificationID
					WHERE N.NTNotificationId = @tableId AND escalationLevel = @extendedObjId and N.messageType=512 -- NT_SAVE_ALERTNOTIF
				END
ELSE IF @tableTypeId = 101    --  'APP_CREDS_CREDENTIAL_MANAGER_TABLE'
				BEGIN
					INSERT  INTO @previewTable ([type],[credentialId],[credentialName])
SELECT DISTINCT 174, APC.credentialId, APC.credentialName
					FROM APP_Credentials APC
					WHERE APC.credentialId = @tableId
				END
ELSE IF @tableTypeId = 100	-- 'APP_CREDS_SUBCLIENTPROP_TABLE'
					INSERT  INTO @previewTable ([type],[domainId], [domainName])
					SELECT DISTINCT 100, id, domainName
					FROM UMDSProviders
					WHERE id=@componentNameId
				SET @prePswdRow = @@IDENTITY
			END
		END --PREVIEW CHECK
IF @tableTypeId = 61			-- 'APP_CREDS_SUBCLIENTPROP_TABLE'
			SET @componentName = ISNULL((SELECT subclientName FROM APP_Application  WHERE id=@componentNameId), '')
IF @tableTypeId = 81			-- 'APP_CREDS_TASKOPTIONS_TABLE'
			SET @componentName = ISNULL((SELECT subTaskName FROM TM_SubTask  WHERE subTaskId=@componentNameId), '')
--	***	----------------------------------------------------------------**
--	*** 6c WRITE OUT TO GUI AUDIT TRAIL									**
--	***	----------------------------------------------------------------**
		IF @SKIP_AUDIT_TRAIL <> 0
			GOTO SKIP_CREDS
		SET @cvEntityType = ISNULL((Select type from @extendedObjects Where id = @extendedObjId), 0)
--		-----------------------------
		-- SET GUI AUDIT OPERATION --
--		-----------------------------
		IF ((@lastTableTypeId = @tableTypeId)
OR (@lastTableTypeId in (10, 12) 		-- 'APP_CREDS_COMMCELL_TABLE, APP_CREDS_GLOBALPARAM_TABLE'
AND @tableTypeId in (10, 12)))	-- Messy cause CS props can be in 2 different tables
		        AND @lastComponentNameId = @componentNameId
AND (@tableTypeId NOT in (99, 13)) -- Changes to regular and escalated alert notifications are not audited correctly. So avoiding this check for those table types
			GOTO OBJECT_ID_DEFINED
		SET @lastComponentNameId	= @componentNameId
		SET @lastTableTypeId		= @tableTypeId
SET @opMsgId = (342 | (CAST(POWER(2, 24) AS BIGINT) * 84))
		IF @isPreview = 0
		BEGIN
		EXEC EvGuiAuditSetOperation @opMsgId, @userId, @opEvMsgId OUTPUT, @opId OUTPUT
		SET @dataIsEvent = 0
--		------------------------------------------
--		-- CHECK IF A REASON WAS SUPPLIED		--
--		------------------------------------------
		if @reason <> ''
		BEGIN
SET @paramMsgId  = (842 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			SET @paramData   = @reason
			EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
		END
---
--		--------------------------------------
--		-- CHECK IF COMMCELL WAS DEFINED	--
--		---------------------------------------
		SET @objId = ISNULL((Select commcellId from @extendedObjects where id=@extendedObjId), 0)
		IF @objId <> 0
		BEGIN
SET @paramMsgId  = (201 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			SET @paramData   = ISNULL((Select aliasName from APP_Commcell where id = @objId), 'No Commcell Name')
			EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
		END
--		------------------------------------------
--		-- CHECK IF CLIENT GROUP WAS DEFINED	--
--		------------------------------------------
		SET @objId = ISNULL((Select clientGroupId from @extendedObjects where id=@extendedObjId), 0)
		IF @objId <> 0
		BEGIN
SET @paramMsgId  = (222 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			SET @paramData   = ISNULL((Select name from APP_ClientGroup where id = @objId), 'No ClientGroup Name')
			EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
		END
--		----------------------------------
--		-- CHECK IF CLIENT WAS DEFINED	--
--		----------------------------------
		IF @cvEntityType = 2				-- ALL CLIENTS, BETTER THAN USING @isAllClients so we can handle all MediaAgents, etc ...)
		BEGIN
IF 		@tableTypeId = 21		SET @objId= @componentNameId
ELSE IF @tableTypeId = 31			SET @objId = ISNULL((SELECT TOP 1 appTypeId from APP_IDAName  WHERE id = @componentNameId), 0)
ELSE IF @tableTypeId = 41		SET @objId = ISNULL((SELECT TOP 1 clientId from APP_Application WHERE instance = @componentNameId), 0)
ELSE IF @tableTypeId = 51		SET @objId = ISNULL((SELECT TOP 1 clientId from APP_Application WHERE backupset = @componentNameId), 0)
ELSE IF @tableTypeId = 61	SET @objId = ISNULL((SELECT TOP 1 clientId from APP_Application WHERE id = @componentNameId), 0)
			ELSE 													SET @objId = 0
		END
		ELSE
			SET @objId = ISNULL((Select clientId from @extendedObjects where id=@extendedObjId), 0)
		IF @objId <> 0
		BEGIN
SET @paramMsgId  = (202 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			SET @paramData   = ISNULL((Select name from app_client where id = @objId), 'No Client Name')
			EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
		END
--		----------------------------------
		-- CHECK IF APPTYPE WAS DEFINED --
--		----------------------------------
		IF @cvEntityType = 2
		BEGIN
IF @tableTypeId		 = 31			SET @objId = ISNULL((SELECT TOP 1 appTypeId from APP_IDAName  	WHERE id = @componentNameId), 0)
ELSE IF @tableTypeId = 41		SET @objId = ISNULL((SELECT TOP 1 appTypeId from APP_Application WHERE instance = @componentNameId), 0)
ELSE IF @tableTypeId = 51		SET @objId = ISNULL((SELECT TOP 1 appTypeId from APP_Application WHERE backupset = @componentNameId), 0)
ELSE IF @tableTypeId = 61	SET @objId = ISNULL((SELECT TOP 1 appTypeId from APP_Application WHERE id = @componentNameId), 0)
			ELSE 													SET @objId = 0
		END
		ELSE
			SET @objId = ISNULL((Select appTypeId from @extendedObjects where id=@extendedObjId), 0)
		IF @objId <> 0
		BEGIN
SET @paramMsgId  = (206 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			SET @paramData   = ISNULL((Select name from app_idaType where type = @objId), 'No Ida Name')    -- THIS IS WRONG, BUT FOR NOW ALLOW THIS "SIMPLE" LOOKUP
			EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
		END
--		----------------------------------
		-- CHECK IF INSTANCE WAS DEFINED --
--		----------------------------------
		IF @cvEntityType = 2
		BEGIN
IF @tableTypeId		 = 41		SET @objId = @componentNameId
ELSE IF @tableTypeId = 51		SET @objId = ISNULL((SELECT TOP 1 instance from APP_Application WHERE backupset = @componentNameId), 0)
ELSE IF @tableTypeId = 61	SET @objId = ISNULL((SELECT TOP 1 instance from APP_Application WHERE id = @componentNameId), 0)
			ELSE 													SET @objId = 0
		END
		ELSE
			SET @objId = ISNULL((Select instanceId from @extendedObjects where id=@extendedObjId), 0)
		IF @objId <> 0 AND @objId <> 1
		BEGIN
SET @paramMsgId  = (207 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			SET @paramData   = ISNULL((Select name from app_InstanceName where id = @objId), 'No Instance Name')
			EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
		END
--		-----------------------------------
		-- CHECK IF BACKUPSET WAS DEFINED --
--		----------------------------------
		IF @cvEntityType = 2
		BEGIN
IF @tableTypeId = 51			SET @objId = @componentNameId
ELSE IF @tableTypeId = 61	SET @objId = ISNULL((SELECT TOP 1 backupset from APP_Application WHERE id = @componentNameId), 0)
			ELSE 													SET @objId = 0
		END
		ELSE
			SET @objId = ISNULL((Select backupsetId from @extendedObjects where id=@extendedObjId), 0)
		IF @objId <> 0
		BEGIN
SET @paramMsgId  = (208 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			SET @paramData   = ISNULL((Select name from app_backupsetName where id = @objId), 'No Backupset Name')
			EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
		END
--		-----------------------------------
		-- CHECK IF SUBCLIENT WAS DEFINED --
--		----------------------------------
		IF @cvEntityType = 2
		BEGIN
IF @tableTypeId = 61	SET @objId = @componentNameId
			ELSE 											SET @objId = 0
		END
		ELSE
		SET @objId = ISNULL((Select subClientId from @extendedObjects where id=@extendedObjId), 0)
		IF @objId <> 0
		BEGIN
SET @paramMsgId  = (211 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			SET @paramData   = ISNULL((Select subClientName from app_application where id = @objId), 'No Subclient Name')
			EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
		END
--		--------------------------------------
		-- CHECK IF MEDIA AGENT WAS DEFINED --
--		--------------------------------------
		SET @objId = ISNULL((Select [mediaAgentId] from @extendedObjects where id= @extendedObjId), 0)
		IF @objId <> 0
		BEGIN
SET @paramMsgId  = (213 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			SET @paramData   = ISNULL((Select name from app_client where id = @objId), 'No Media Agent Name')
			EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
		END
--		----------------------------------
		-- CHECK IF LIBRARY WAS DEFINED --
--		----------------------------------
		SET @objId = ISNULL((Select [libraryId] from @extendedObjects where id= @extendedObjId), 0)
		IF @objId <> 0
		BEGIN
SET @paramMsgId  = (191 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			SET @paramData   = ISNULL((Select aliasName from MMLibrary where libraryId = @objId), 'No Library Name')
			EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
		END
if (@tableTypeId=99 OR @tableTypeId=13)
		begin
SET @paramMsgId  = (1207 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			SET @paramData   = ''
			SET @paramData   = (Select notificationName from NTNotificationRule where id = @tableId)
			if (@paramData is not null and len(@paramData)>0)
			begin
				EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
			end
			if (@extendedObjId=2)
			begin
SET @paramMsgId  = (211 | (CAST(POWER(2, 24) AS BIGINT) * 74))
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
			end
		end
		--TODOTODOTODO MORE TO DO ARCHGROUP, ETC ... SEE ExtendedObjects Table for more detail
		END --PREVIEW CHECK
OBJECT_ID_DEFINED:
--		--------------------------------------------------
--		-- ADD FINALLY IF PASSWORD AND USERNAME CHANGED	--
--		--------------------------------------------------
		IF @isUserNameChange <> 0
		BEGIN
			IF @isPreview = 0
			BEGIN
				SET @paramMsgId = (Select auditTrailUserNameMsg from APP_CredProps where id = @credPropsId)
				IF @paramMsgId = @GENERIC_USERNAME_MSG
				BEGIN
IF @tableTypeId = 100
						SET @paramData   =  @oldUserName
ELSE IF @tableTypeId = 71
						SET @paramData =
(SELECT CASE WHEN attrUserName = 1202 THEN
(SELECT TOP 1 Message FROM EvLocaleMsgs WHERE MessageID=(1232 | (CAST(POWER(2, 24) AS BIGINT) * 83)) and LocaleID=@localeId)
								ELSE attrUserName END
								from APP_CredProps where id = @credPropsId)
					ELSE
						SET @paramData   =  (Select attrUserName from APP_CredProps where id = @credPropsId)
					EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
				END
				SET @paramData   = @attrVal
				EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
				SET @paramData   = @newUserName
				EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
				 -- Add the schedule name as parameter for schedule option entries
if (@tableTypeId=81)
				begin
					SET @paramData   = @componentName
					EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
				end
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
			END
			ELSE
			BEGIN
				SET @paramMsgId = (Select previewUserNameMsg from APP_CredProps where id = @credPropsId)
				SET @outputText = (SELECT Message FROM EvLocaleMsgs WHERE MessageID=@paramMsgId and LocaleID=@localeId)
				IF @paramMsgId = @GENERIC_USERNAME_MSG
				BEGIN
					--IF @tableTypeId = APP_CREDS_TASKOPTIONS_TABLE
					--	SET @paramData   =  (SELECT xpath FROM TM_StaticTaskOption WHERE optionId in (Select CAST(attrPwdName AS BIGINT) from APP_CredProps where id = @credPropsId))
					--ELSE
IF @tableTypeId = 100
						SET @paramData   =  @oldUserName
ELSE IF @tableTypeId = 71
						SET @paramData =
(SELECT CASE WHEN attrUserName = 1202 THEN
(SELECT TOP 1 Message FROM EvLocaleMsgs WHERE MessageID=(1232 | (CAST(POWER(2, 24) AS BIGINT) * 83)) and LocaleID=@localeId)
								ELSE attrUserName END
								from APP_CredProps where id = @credPropsId)
					ELSE
						SET @paramData   =  (Select attrUserName from APP_CredProps where id = @credPropsId)
					SET @outputText = REPLACE(@outputText, '^1%s', @paramData)
					SET @outputText = REPLACE(@outputText, '^2%s', @attrVal)
					SET @outputText = REPLACE(@outputText, '^3%s', @newUserName)
				END
				ELSE
				BEGIN
					SET @outputText = REPLACE(@outputText, '^1%s', @attrVal)
					SET @outputText = REPLACE(@outputText, '^2%s', @newUserName)
					IF @componentName is not null
						SET @outputText = REPLACE(@outputText, '^3%s', @componentName)
				END
				UPDATE @previewTable SET changes = @outputText, changesId = @paramMsgId WHERE id = @preUserRow
			END
		END
		IF @isPasswordChange <> 0
		BEGIN
			IF @isPreview = 0
			BEGIN
				SET @paramMsgId = (Select auditTrailPassWordMsg from APP_CredProps where id = @credPropsId)
if (@tableTypeId<>81)
				begin
					IF @paramMsgId = @GENERIC_PASSWORD_MSG
					BEGIN
IF @tableTypeId = 100
						SET @paramData   =  @oldUserName
ELSE IF @tableTypeId = 71
--SET @paramData = (SELECT Message FROM EvLocaleMsgs WHERE MessageID=(1233 | (CAST(POWER(2, 24) AS BIGINT) * 83)) and LocaleID=@localeId)
						SET @paramData =
(SELECT CASE WHEN attrPwdName = 1203 THEN
(SELECT TOP 1 Message FROM EvLocaleMsgs WHERE MessageID=(1233 | (CAST(POWER(2, 24) AS BIGINT) * 83)) and LocaleID=@localeId)
								ELSE attrPwdName END
								from APP_CredProps where id = @credPropsId)
					ELSE
						SET @paramData   =  (Select attrPwdName from APP_CredProps where id = @credPropsId)
						EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
					END
					EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
				end
				else
				begin
					-- Add the schedule name to parameter list.
					SET @paramData   = @componentName
					EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
					EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
				end
			END
			ELSE
			BEGIN
				IF @isUserNameChange = 0
					SET @paramMsgId = (Select previewPassWordMsg from APP_CredProps where id = @credPropsId)
				ELSE
					SET @paramMsgId = @GENERIC_USERNAME_PASSWORD_PREVIEW
				SET @outputText = (SELECT Message FROM EvLocaleMsgs WHERE MessageID=@paramMsgId and LocaleID=@localeId)
				IF @paramMsgId = @GENERIC_PASSWORD_MSG
				BEGIN
					--IF @tableTypeId = APP_CREDS_TASKOPTIONS_TABLE
					--	SET @paramData   =  (SELECT xpath FROM TM_StaticTaskOption WHERE optionId in (Select CAST(attrPwdName AS BIGINT) from APP_CredProps where id = @credPropsId))
					--ELSE
IF @tableTypeId = 100
						SET @paramData   =  @oldUserName
ELSE IF @tableTypeId = 71
						SET @paramData =
(SELECT CASE WHEN attrPwdName = 1203 THEN
(SELECT TOP 1 Message FROM EvLocaleMsgs WHERE MessageID=(1233 | (CAST(POWER(2, 24) AS BIGINT) * 83)) and LocaleID=@localeId)
								ELSE attrPwdName END
								from APP_CredProps where id = @credPropsId)
					ELSE
						SET @paramData   =  (Select attrPwdName from APP_CredProps where id = @credPropsId)
					SET @outputText = REPLACE(@outputText, '^1%s', @paramData)
				END
IF @tableTypeId = 81
					SET @outputText = REPLACE(@outputText, '^1%s', @componentName)
				--IF @isUserNameChange = 0
				--	SET @outputText = @outputText + ' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, ALERT_TEMPLATE_USER, 0,2) + ' ' + @oldUserName
				IF @isUserNameChange = 0
					UPDATE @previewTable SET changes = @outputText, changesId = @paramMsgId WHERE id = @prePswdRow
				ELSE
				BEGIN
					UPDATE @previewTable SET changes = (changes+' '+@outputText) WHERE id = @preUserRow
					DELETE @previewTable WHERE id = @prePswdRow
				END
			END
		END
SKIP_CREDS:
		FETCH NEXT FROM CredsMatchCursor INTO @credPropsId, @extendedObjId, @tableTypeId, @tableId, @componentNameId, @attrDomain, @attrVal, @isPassword
		END
	CLOSE CredsMatchCursor
	DEALLOCATE CredsMatchCursor
--	FOR DEBUGGING ONLY  --------------------------------------------------------------------------------------------------------
/*
if @brAlertTrace = 0    --  IF NON-ZERO, THIS RETURNS MORE THAN THE ONE RESULT SET CALLER IS EXPECTING!
BEGIN
--	SELECT  	terseAuditTrail=@terseAuditTrail,  userId=@userId, localeId=@localeId
--	SELECT		oldUserName=@oldUserName, oldUserPassword=@oldUserPassword, newUserName=@newUserName, newUserPassword=@newUserPassword
	SELECT 		tbl='associations', * FROM @associations order by appTypeId
--	SELECT 		tbl='extendedObjects', * from @extendedObjects
	SELECT 		tbl='credsMatch', * from @credsMatch order by [tableTypeId], [componentNameId], [isPassword]
END
*/
--	******************************************************
--	*** 7.  CLEANUP AND RETURN RESULTS TO CALLER		**
--	******************************************************
	EXEC sp_xml_removedocument @idoc
	SET @idoc = 0				-- So we don't do it again!
--	SET @errorCode = 1				-- MAYBE GUI CAN DISPLAY STRING W/O THROWING AN ERROR?
	if (@objectCount > 0)
set @errorWstring = dbo.fn_EvFormatEventMsgText(0, @localeId, (1857 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0,2)
	else
	BEGIN
SET @errorCode = 100			--  'CV_DB_NODATA'
set @errorWstring = dbo.fn_EvFormatEventMsgText(0, @localeId, (1858 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0,2)
	END
END TRY
--=====================================================================
--==============  COME HERE IF THERE WAS A PROBLEM!     ===============
--=====================================================================
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
SET @errorCode	 = 0x0A0001             -- 'CV_APPMGR_GENERIC_ERROR'
	SET @errorString = 'Procedure['+@function +'], line '+ CONVERT(VARCHAR(20),ERROR_LINE()) + ' Error: [' + ERROR_MESSAGE() + ']'
	END CATCH
--===================================================
-- ====== THIS IS THE RESPONSE IF ALL WENT WELL =====
--===================================================
ALL_DONE:
--	CHECK AND CLOSE/DEALLOCATE ANY CURSORS WE USED THAT MIGHT STILL BE DANGLING FIRST:
	IF ( CURSOR_STATUS('global', 'descendCursor') >= 0   OR CURSOR_STATUS('local', 'descendCursor') >= 0 )  -- CLOSE CURSOR IF OPEN
		CLOSE descendCursor
	IF ( CURSOR_STATUS('global','descendCursor') = -1     OR CURSOR_STATUS('local','descendCursor') = -1 )
		DEALLOCATE descendCursor
	IF ( CURSOR_STATUS('global', 'SecurityCheckCursor') >= 0   OR CURSOR_STATUS('local', 'SecurityCheckCursor') >= 0 )  -- CLOSE CURSOR IF OPEN
		CLOSE SecurityCheckCursor
	IF ( CURSOR_STATUS('global','SecurityCheckCursor') = -1     OR CURSOR_STATUS('local','SecurityCheckCursor') = -1 )
		DEALLOCATE SecurityCheckCursor
	IF ( CURSOR_STATUS('global', 'CredsMatchCursor') >= 0   OR CURSOR_STATUS('local', 'CredsMatchCursor') >= 0 )  -- CLOSE CURSOR IF OPEN
		CLOSE CredsMatchCursor
	IF ( CURSOR_STATUS('global','CredsMatchCursor') = -1     OR CURSOR_STATUS('local','CredsMatchCursor') = -1 )
		DEALLOCATE CredsMatchCursor
	IF @iDoc <> 0
		EXEC sp_xml_removedocument @idoc
	IF @isPreview = 1 AND @errorCode = 0
	BEGIN
		SET @xmlout =	(SELECT  P.changes '@changes', (
			SELECT
CASE WHEN type=68 THEN
					(SELECT DISTINCT type '@_type_' ,
						E.subclientId '@subtaskId',
						E.subTaskName '@subtaskName',
						E.taskId '@taskId',
						E.taskName '@taskName'
					FOR
						XML PATH('subTask'), TYPE
					)
WHEN type=174 THEN
					(SELECT DISTINCT type '@_type_' ,
						E.credentialId '@credentialId',
						E.credentialName '@credentialName'
					FOR
						XML PATH('credEntity'), TYPE
					)
				ELSE
					(SELECT DISTINCT type '@_type_' ,
						E.commCellId '@commCellId',
						E.commCellName '@commCellName',
						E.clientGroupId '@clientGroupId' ,
						E.clientGroupName '@clientGroupName' ,
						E.clientId '@clientId' ,
						E.clientName '@clientName' ,
						E.apptypeId '@applicationId' ,
						E.appTypeName '@appName' ,
						E.instanceId '@instanceId',
						CASE CHARINDEX('', E.instanceName)
							WHEN 0 THEN	E.instanceName
							ELSE
								'|'+REPLACE(E.instanceName,
								'', '|#12!')
							END '@instanceName',
						E.backupsetId '@backupsetId',
						E.backupsetName '@backupsetName',
						E.subclientId '@subclientId',
						E.subclientName '@subclientName',
						E.alertId '@alertId',
						E.alertName '@alertName',
						E.libraryId '@libraryId',
						E.libraryName '@libraryName',
						E.mountPathId '@mountPathId',
						E.mountPathName '@mountPathName'
					FOR
						XML PATH('entity'), TYPE
					)
				END
				FROM @previewTable E WHERE E.changesId=P.changesId AND E.changes=P.changes
			FOR
				XML PATH('entities'), TYPE
		)
		FROM @previewTable AS P GROUP BY changes, changesId
		FOR XML PATH('credentialChanges'),
		ROOT('GuiServer_ModifyCredsResp'))
		IF @xmlout IS NULL
			SET @xmlout = '<GuiServer_ModifyCredsResp/>'
	END
	ELSE
	BEGIN
		IF @errorString <> ''
			SET @errorWstring = CONVERT(nvarchar(2048),@errorString)
		SET @xmlout =  (SELECT  1                    as TAG,
				NULL                 as Parent,
			@errorCode               as [App_GenericResp!1!errorCode],
			@errorWstring             as [App_GenericResp!1!errorMessage]
		FOR XML EXPLICIT)
	END
IF @tranStarted <> 0
BEGIN
IF  @errorCode in (0, 100)    -- 0, 'CV_DB_NODATA'
		COMMIT TRAN
	ELSE
		ROLLBACK TRAN
END
SELECT @xmlout
SET NOCOUNT OFF
GO
/*
DROP PROC AppCredPropsUpd
GO
DECLARE @rId as int = 242
DECLARE @xmlText as varchar(max) = (select message from TrackNotificationProcs where id = @rid)
--SELECT CONVERT(xml, @xmlText)
exec AppCredPropsUpd @xmlText
*/

IF EXISTS (select * from GxQscripts where name = 'AppCredPropsUpd')
	delete from GxQscripts where name = 'AppCredPropsUpd'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCredPropsUpd')
	delete from GXDBVersions where aliasname = 'AppCredPropsUpd'
GO

insert into GXDBVersions values(2, 'AppCredPropsUpd',  '00010067001200140000', 'AppCredPropsUpd', '00010067001200140000')
GO

