

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCreateSCPForEdgeDriveClient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCreateSCPForEdgeDriveClient.sp,v $ $Id: AppCreateSCPForEdgeDriveClient.sp,v 1.15.40.18 2020/04/17 00:39:26 skilaru Exp $";
--
--  +====================================================================================+
--  |   Procedure:  AppCreateSCPForEdgeDriveClient()
--  |
--  | Description:  SP for creating a new subclient policy for an Edge Drive Client
--  |
--  |       Input:  @clientId , @storagePolicyId , @userId
--  |      Output:  @errorCode , @errorString to indicate operation status
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  riyer  For Creation of Edge Drive client specific subclient policy
--  +====================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppCreateSCPForEdgeDriveClient')
BEGIN
	print '>>> Drop Stored Procedure: AppCreateSCPForEdgeDriveClient <<<'
	drop procedure AppCreateSCPForEdgeDriveClient
END
IF EXISTS (select * from GxQscripts where name='AppCreateSCPForEdgeDriveClient')
	delete from GxQscripts where name = 'AppCreateSCPForEdgeDriveClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCreateSCPForEdgeDriveClient')
	delete from GXDBVersions where aliasname = 'AppCreateSCPForEdgeDriveClient'
GO
print '... Creating Procedure: AppCreateSCPForEdgeDriveClient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCreateSCPForEdgeDriveClient
  @clientId INT, 
  @storagePolicyID INT, 
  @userId INT,
  @i_xml XML
AS
  DECLARE @errorCode INT
  DECLARE @errorString nvarchar(MAX)
DECLARE @nowTime  INT
DECLARE @subclientPolicyName  NVARCHAR(MAX)
DECLARE @subclientPolicyId INT
DECLARE @defaultsubclientId  INT
DECLARE @clientStatus INT = 0
DECLARE @systemDriveType INT = 0
DECLARE @versionsInDrive INT
DECLARE @gracePeriodForVersions INT
DECLARE @trashCanRetentionInDays INT
DECLARE @versionsInDrive_defaultValue INT
DECLARE @gracePeriodForVersions_defaultValue INT
DECLARE @trashCanRetentionInDays_defaultValue INT
SET @nowTime = dbo.GetUnixTime(GETUTCDATE())
DECLARE @cId int = @clientId
SET @clientId = NULL
SELECT @clientId=ID , @subclientPolicyName = name, @clientStatus = status
FROM APP_Client with(nolock) WHERE id = @cId AND id>0 AND status & 0x10000000 = 0x10000000
IF (@clientId IS NULL)
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Error. Given client is not valid'
	GOTO EXIT_SP
END
SET @systemDriveType = ISNULL((SELECT CAST(attrVal AS INT) FROM App_ClientProp WITH (NOLOCK) WHERE componentNameId = @clientId and attrName = 'System Drive Type' and modified = 0), 0)
---------------------------------------------------------------------------------
--Retention defaults
---------------------------------------------------------------------------------
--									EdgeDrive   ObjectStore  NFS_ObjectStore
--'Versions in Drive'                  10          10        1
--'Grace Period For Versions'          30          30        30
--'Trash Can Retention'                30          730       30
---------------------------------------------------------------------------------
IF @clientStatus & 0x40000000 = 0x40000000 -- object store variants
BEGIN
	IF @systemDriveType = 4 -- EdgeSystemDriveTypes_NFS_OBJECT_STORE-4
	BEGIN
		SET	@versionsInDrive_defaultValue = 1
		SET	@gracePeriodForVersions_defaultValue = 30
		SET @trashCanRetentionInDays_defaultValue = 30
	END
	ELSE
	BEGIN
		SET	@versionsInDrive_defaultValue = 10
		SET	@gracePeriodForVersions_defaultValue = 30
		SET @trashCanRetentionInDays_defaultValue = 730
	END
END
ELSE -- Edge drive
BEGIN
	SET	@versionsInDrive_defaultValue = 10
	SET	@gracePeriodForVersions_defaultValue = 30
	SET @trashCanRetentionInDays_defaultValue = 30
END
DECLARE @isIndefiniteRetention INT = ISNULL(@i_xml.value('(//App_EdgeSubclientPolicyProp/@isIndefiniteRetention)[1]', 'INT'),0)
IF @isIndefiniteRetention = 1
BEGIN
	SET @trashCanRetentionInDays = -1
END
ELSE
BEGIN
	SET @trashCanRetentionInDays = ISNULL(@i_xml.value('(//App_EdgeSubclientPolicyProp/@retentionInDays)[1]', 'INT'),@trashCanRetentionInDays_defaultValue)
END
DECLARE @enableRetentionRulesForVersions INT = ISNULL(@i_xml.value('(//App_EdgeSubclientPolicyProp/@enableRetentionRulesForVersions)[1]', 'INT'),1)
IF @enableRetentionRulesForVersions = 1
BEGIN
	SET @versionsInDrive = ISNULL(@i_xml.value('(//App_EdgeSubclientPolicyProp/@minNoOfVersions)[1]', 'INT'),@versionsInDrive_defaultValue)
	SET @gracePeriodForVersions = ISNULL(@i_xml.value('(//App_EdgeSubclientPolicyProp/@versionsRetentionInDays)[1]', 'INT'),@gracePeriodForVersions_defaultValue)
END
ELSE
BEGIN
	SET @versionsInDrive = 0
	SET @gracePeriodForVersions = 0
END
--Insert into APP_BackupSetName
IF @systemDriveType = 4 -- EdgeSystemDriveTypes_NFS_OBJECT_STORE-4
BEGIN
	SET @subclientPolicyName = @subclientPolicyName + ' - Hybrid File Store Policy'
END
ELSE
BEGIN
	SET @subclientPolicyName = @subclientPolicyName + ' - Edge Drive Policy'
END
IF EXISTS (SELECT 1 FROM APP_BackupSetName WITH (NOLOCK) WHERE name = @subclientPolicyName AND status & 0x0080 <> 0)
BEGIN
	SET @subclientPolicyName = @subclientPolicyName + '_' + CAST(@nowTime AS NVARCHAR(20))
END
BEGIN TRY
	DECLARE @subclientPolicyStatus INT = 0x10080 -- (CV_STATUS_POLICY_BSET | CV_STATUS_EDGE_POLICY_BSET)
IF @clientStatus & 0x40000000 = 0x40000000
SET @subclientPolicyStatus = @subclientPolicyStatus | 0x40000
	INSERT INTO APP_BackupSetName
		VALUES(@subclientPolicyName, @nowTime, @nowTime, @subclientPolicyStatus, 0, 0, 2, NEWID())
	SET @subclientPolicyId = SCOPE_IDENTITY()
	DECLARE @subclientPolicyIdaType NVARCHAR(MAX) = (SELECT
														CASE
															WHEN @systemDriveType = 4 THEN '3' -- (EdgeSystemDriveTypes_NFS_OBJECT_STORE-4) (SCP_UNIX-3)
															ELSE '2' -- (SCP_WINDOWS_ADVANCE-2))
														END
													 )
	INSERT INTO APP_BackupSetProp  (componentNameId, attrName, attrType, attrVal, created, modified, ccpId) VALUES
		(@subclientPolicyId, 'Associated subclient Policy Ida Type', 7, @subclientPolicyIdaType, @nowTime, 0, 0),
		(@subclientPolicyId, 'Subclient Policy Create UserId', 7, CAST(@userId AS NVARCHAR(10)), @nowTime, 0, 0),
		(@subclientPolicyId, 'Use Change Journal', 2, '0', @nowTime, 0, 0)
	--Insert into App_EdgeDriveAssociation
	INSERT INTO App_EdgeDriveAssociation (clientId ,entityType,entityId)
		VALUES(@clientId, 65, @subclientPolicyId)
	--Insert into APP_Application
	INSERT INTO APP_Application
		VALUES( 2 , 1030, 1, @subclientPolicyId, 0, @storagePolicyID, @storagePolicyID, @nowTime, @nowTime, 'default', 131080, 0, 0, 2, NEWID())
	-- Status 131080 = CV_STATUS_DEFAULT | CV_STATUS_EDGEDRIVE_SUB
	SET @defaultsubclientId = SCOPE_IDENTITY()
	--Insert into APP_SubclientProp
	INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId) VALUES
		(@defaultsubclientId, 'last data SP', 10, '1', @nowTime, 0,0),
		(@defaultsubclientId, 'last log SP', 10, '1', @nowTime, 0,0),
		(@defaultsubclientId, 'sys: pre post option', 10, '0', @nowTime, 0,0)	,
		(@defaultsubclientId, 'Use VSS for System State', 2, '0', @nowTime, 0,0),
		(@defaultsubclientId, 'prepost password', 1, '3cfe3eeb854e8aa64e0155bec019674d5', @nowTime, 0,0),
		(@defaultsubclientId, 'System State', 2, '0', @nowTime, 0,0),
		(@defaultsubclientId, 'System State on Full Backup Only', 2, '0', @nowTime, 0,0),
		(@defaultsubclientId, 'sys:nStreams', 7, '2', @nowTime, 0,0),
		(@defaultsubclientId, 'FLR Hash Block Size', 7, '0', @nowTime, 0,0)	,
		(@defaultsubclientId, 'FLR Hash Min File Size', 7, '0', @nowTime, 0,0),
		(@defaultsubclientId, 'Use VSS Enabled', 2, '0', @nowTime, 0,0)	,
		(@defaultsubclientId, 'Use VSS Options', 7, '0', @nowTime, 0,0),
		(@defaultsubclientId, 'Use Change Journal', 2, '0', @nowTime, 0,0),
		(@defaultsubclientId, 'sys:UseMultipleStreamsWithinDrive', 2, '1', @nowTime, 0,0),
(@defaultsubclientId, 'Versions in Drive', 7, CONVERT(NVARCHAR(MAX),@versionsInDrive), @nowTime, 0,0),
(@defaultsubclientId, 'Grace Period For Versions', 7, CONVERT(NVARCHAR(MAX),@gracePeriodForVersions), @nowTime, 0,0),
(@defaultsubclientId, 'Trash Can Retention', 7, CONVERT(NVARCHAR(MAX),@trashCanRetentionInDays), @nowTime, 0,0)
	IF @systemDriveType = 3 OR  @systemDriveType = 6-- Records Manager, eDiscovery
	BEGIN
		INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId) VALUES
			(@defaultsubclientId, 'Use Classic File Scan', 2, '1', @nowTime, 0,0),
			(@defaultsubclientId, 'Use DC for FS backups', 2, '0', @nowTime, 0,0)
	END
	ELSE
	BEGIN
		INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
		VALUES(@defaultsubclientId, 'Use DC for FS backups', 2, '1', @nowTime, 0,0)
	END
IF @clientStatus & 0x40000000 = 0x40000000
	BEGIN
		IF @systemDriveType = 3 -- Records Manager
		BEGIN
			INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
			SELECT @defaultsubclientId, attrName, attrType, attrVal, @nowTime, 0, 0
			FROM App_ClientProp WITH(NOLOCK)
			WHERE componentNameId = @clientId
			AND attrName IN ('UNCPath user name', 'UNCPath password')
			AND modified = 0
		END
	END
	INSERT INTO ArchPipeConfig (appNumber,compressWhere,numNWAgents,NWWriteSpeed)
		VALUES(@defaultsubclientId, 0, 2, 0)
	INSERT INTO APP_ScFilterFile(componentNameId, type, fileName, created, modified, ccpId) VALUES
		(@defaultsubclientId, 3, '**\.edgedrive.cache', @nowTime, 0, 0)	,
		(@defaultsubclientId, 3, '**\LostAndFound', @nowTime, 0, 0) ,
		(@defaultsubclientId, 3, '*.conflict*', @nowTime, 0, 0) ,
		(@defaultsubclientId, 3, '~*', @nowTime, 0, 0) ,
		(@defaultsubclientId, 3, '**\AppData', @nowTime, 0, 0),
		(@defaultsubclientId, 3, '*DS_Store*', @nowTime, 0, 0),
		(@defaultsubclientId, 3, '**\ntuser.dat*', @nowTime, 0, 0)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = ERROR_NUMBER()
	SET @errorString = ERROR_MESSAGE()
END CATCH
EXIT_SP:
SELECT @errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'AppCreateSCPForEdgeDriveClient')
	delete from GxQscripts where name = 'AppCreateSCPForEdgeDriveClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCreateSCPForEdgeDriveClient')
	delete from GXDBVersions where aliasname = 'AppCreateSCPForEdgeDriveClient'
GO

insert into GXDBVersions values(2, 'AppCreateSCPForEdgeDriveClient',  '00010015004000180000', 'AppCreateSCPForEdgeDriveClient', '00010015004000180000')
GO

