

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCreateOnDemandBackupSet.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCreateOnDemandBackupSet.sp,v $ $Id: AppCreateOnDemandBackupSet.sp,v 1.31.56.2 2018/03/27 08:13:52 jiechen Exp $";
-- =============================================
-- Author:		Sergio Bonilla
-- Create date: 09/04/2007
-- Description:	Creates an OnDemand BackupSet .
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppCreateOnDemandBackupSet <<<'

IF EXISTS (select * from sysobjects where name='AppCreateOnDemandBackupSet')
	drop procedure AppCreateOnDemandBackupSet
IF EXISTS (select * from GxQscripts where name='AppCreateOnDemandBackupSet')
	delete from GxQscripts where name = 'AppCreateOnDemandBackupSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCreateOnDemandBackupSet')
	delete from GXDBVersions where aliasname = 'AppCreateOnDemandBackupSet'
GO
print '... Creating Procedure: AppCreateOnDemandBackupSet'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCreateOnDemandBackupSet
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @xmlText XML
AS
  DECLARE @o_backupSetId INT
  DECLARE @o_subclientId INT
  DECLARE @o_errorString NVARCHAR(1024)
BEGIN
SET NOCOUNT ON
	DECLARE @i_clientId			INT
	DECLARE @i_appTypeId		INT
	DECLARE @i_commcellId		INT
	DECLARE @i_dataArchGrpId	INT
	DECLARE @i_logArchGrpId		INT
	DECLARE @instanceId			INT
	DECLARE @valid				INT
	DECLARE @backupSetId		INT
	DECLARE @subClientId		INT
	DECLARE @createTime			INT
	DECLARE @i_subClientName	NVARCHAR(1024)
	DECLARE @i_backupSetName	NVARCHAR(1024)
	DECLARE @i_webClientId		INT
	DECLARE @i_SILO_CopyId		INT
	DECLARE @i_userGUID 		VARCHAR(36)
	DECLARE @userId				INT
	SET @o_errorString = ''
	SET @o_backupSetId = 0
	SET @o_subclientId = 0
	--GET COMMCELL
	SET @i_commcellId = ISNULL(( SELECT ref.value('@commcellId', 'INT')
								FROM @xmlText . nodes('CVGui_CreateOnDemandBackupSetReq') R ( ref ) ), 2)
	--GET CLIENT ID
	SET @i_clientId = (SELECT clientId FROM APP_Commcell WHERE id = @i_commcellId)
	SET @i_clientId = ISNULL(( SELECT ref.value('@clientId', 'INT')
								FROM @xmlText . nodes('CVGui_CreateOnDemandBackupSetReq') R ( ref ) ), @i_clientId)
	--GET WEBSERVER CLIENT ID
	SET @i_webClientId = ISNULL(( SELECT ref.value('@webServerClientId', 'INT')
								FROM @xmlText . nodes('CVGui_CreateOnDemandBackupSetReq') R ( ref ) ), 0)
	--GET SILO COPY ID
	SET @i_SILO_CopyId = ISNULL(( SELECT ref.value('@siloCopyId', 'INT')
								FROM @xmlText . nodes('CVGui_CreateOnDemandBackupSetReq') R ( ref ) ), 0)
	SET @i_userGUID = ISNULL(( SELECT ref.value('@userGUID', 'VARCHAR(36)')
								FROM @xmlText . nodes('CVGui_CreateOnDemandBackupSetReq') R ( ref ) ), '')
	--GET APPTYPE ID, DEFAULT TO APPTYPE FROM COMMCELL
	SET @i_appTypeId = (SELECT TOP(1) appTypeId FROM app_application WHERE clientId = 2 AND
subclientStatus & 0x00004 = 0 AND subclientStatus & 0x00002 = 0 AND
appTypeId in (1, 11, 33,
34, 42, 43))
	SET @i_appTypeId = ISNULL(( SELECT ref.value('@appTypeId', 'INT')
								FROM @xmlText . nodes('CVGui_CreateOnDemandBackupSetReq') R ( ref ) ), @i_appTypeId)
	--USE DEFAULT INSTANCE
	SET @instanceId = ISNULL(( SELECT ref.value('@instanceId', 'INT')
								FROM @xmlText . nodes('CVGui_CreateOnDemandBackupSetReq') R ( ref ) ), 1)
	IF @i_appTypeId IS NULL AND @i_SILO_CopyId > 0
	BEGIN
		SET @o_backupSetId = -100
		SET @o_errorString = 'There is no File System iDataAgent installed for SILO BackupSet creation.'
		GOTO EXIT_PROC
	END
	--CANNOT CREATE BACKUPSET FOR SUBCLIENT POLICY
IF @i_appTypeId = 1030
	BEGIN
		SET @o_backupSetId = -1
		SET @o_errorString = 'Invalid appTypeId'
		GOTO EXIT_PROC
	END
	--MAKE SURE BACKUPSET NAME IS NOT EMPTY
	SET @i_backupSetName = ISNULL(( SELECT ref.value('@backupSetName', 'NVARCHAR(1024)')
								FROM @xmlText . nodes('CVGui_CreateOnDemandBackupSetReq') R ( ref ) ), '')
	IF @i_backupSetName = '' AND @i_SILO_CopyId = 0
	BEGIN
		SET @o_backupSetId = -2
		SET @o_errorString = 'Backup set name can not be empty'
		GOTO EXIT_PROC
	END
	--GET SUBCLIENT NAME. CHECK FOR ATTRIBUTE NOT SENT
	SET @i_subClientName = ISNULL(( SELECT ref.value('@subClientName', 'NVARCHAR(1024)')
								FROM @xmlText . nodes('CVGui_CreateOnDemandBackupSetReq') R ( ref ) ), 'default')
	--CHECK FOR EMPTY INPUT subClientName
	IF @i_subClientName = ''
		SET @i_subClientName = 'default'
	SET @createTime = dbo.getunixtime(GETUTCDATE())
	--VERIFY ARGUMENTS
	SET @valid = (SELECT COUNT(*) FROM APP_CommCell AS CC, APP_Client AS CL, APP_iDAType as AT, ArchGroup AS AG
					WHERE CC.id = @i_commcellId AND CL.id = @i_clientId AND AT.type = @i_appTypeId)
	IF @valid = 0
	BEGIN
		SET @o_backupSetId = -3
		SET @o_errorString = 'Invalid arguments'
		GOTO EXIT_PROC
	END
	--GET ARCHGROUP INFORMATION
	SET @i_dataArchGrpId = ISNULL(( SELECT ref.value('@dataArchGrpId', 'INT')
								FROM @xmlText . nodes('CVGui_CreateOnDemandBackupSetReq') R ( ref ) ), 0)
	SET @i_logArchGrpId = ISNULL(( SELECT ref.value('@logArchGrpId', 'INT')
								FROM @xmlText . nodes('CVGui_CreateOnDemandBackupSetReq') R ( ref ) ), @i_dataArchGrpId)
	IF @i_dataArchGrpId = 0 OR NOT EXISTS (SELECT * FROM ArchGroup WHERE id = @i_dataArchGrpId)
	BEGIN
		SET @o_backupSetId = -4
		SET @o_errorString = 'Invalid ArchGrp arguments'
		GOTO EXIT_PROC
	END
	IF @i_SILO_CopyId > 0 AND NOT EXISTS (SELECT * FROM ArchGroupCopy WHERE id = @i_SILO_CopyId)
	BEGIN
		SET @o_backupSetId = -4
		SET @o_errorString = 'Invalid ArchGrpCopy arguments for SILO'
		GOTO EXIT_PROC
	END
	IF @i_SILO_CopyId > 0
	BEGIN
		DECLARE @copyName NVARCHAR(256)
		DECLARE @spName NVARCHAR(256)
		SELECT @spName = name FROM ArchGroup WHERE id = @i_dataArchGrpId
		SELECT @copyName = name FROM ArchGroupCopy WHERE id = @i_SILO_CopyId
		SET @i_backupSetName = 'Silo_BackupSet_' + @spName + '_' + @copyName
	END
	IF EXISTS( SELECT name FROM APP_BackupSetName WHERE name = @i_backupSetName)
	BEGIN
		SET @o_backupSetId = -5
		SET @o_errorString = 'Backup set name already exists'
		GOTO EXIT_PROC
	END
	IF len(@i_userGUID) > 0
	BEGIN
		SET @userId = ISNULL((SELECT id FROM UMUsers WHERE userGuid = @i_userGUID), 0)
	END
BEGIN TRY
	BEGIN TRAN
	--FETCH INSTANCE INFORMATION
	SET @instanceId = (SELECT DISTINCT AP.instance FROM APP_Application AS AP, APP_InstanceName AS INST
		WHERE AP.clientId = @i_clientId AND AP.appTypeId = @i_appTypeId AND AP.instance = INST.id AND INST.id = @instanceId)
	--CREATE BACKUP SET
	INSERT INTO APP_BackupSetName (name, refTime, modified, status, origCCId, GUID)
				VALUES(@i_backupSetName, @createTime, @createTime, 0, 2, newid())
	SET @backupSetId = SCOPE_IDENTITY() --@@IDENTITY -> returns the inserted identity id from trigger insert operations
	--CREATE DEFAULT SUBCLIENT
	INSERT INTO APP_Application (clientId, appTypeId, instance, backupSet, dataArchGrpID, logArchGrpID, appNumber, refTime, modified, subclientName, subclientStatus, origCCId, GUID)
SELECT @i_clientId, @i_appTypeId, @instanceId, @backupSetId, @i_dataArchGrpId, @i_logArchGrpId, 0, @createTime, @createTime, @i_subClientName, 0x00008, 2, newid()
		FROM @xmlText . nodes('CVGui_CreateOnDemandBackupSetReq') R ( ref )
			--VALUES(@i_clientId, @i_appTypeId, @instanceId, @backupSetId, @i_dataArchGrpId, @i_logArchGrpId, 0, @createTime, @createTime, @i_subClientName, CV_STATUS_DEFAULT)
	SET @subClientId = SCOPE_IDENTITY() --@@IDENTITY -> returns the inserted identity id from trigger insert operations
	--ADD SUBCLIENT PROPERTIES
	INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
				VALUES(@subClientId, 'last data SP', 10, 1, @createTime, 0)
	INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
				VALUES(@subClientId, 'last log SP', 10, 1, @createTime, 0)
	INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
				VALUES(@subClientId, 'Single Instancing Option', 7, 0, @createTime, 0)
	INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
				VALUES(@subClientId, 'Encrypt: encryption', 10, 0, @createTime, 0)
	INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
				VALUES(@subClientId, 'prepost password', 1, 2, @createTime, 0)
	INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
				VALUES(@subClientId, 'sys:UseMultipleStreamsWithinDrive', 2, 0, @createTime, 0)
	INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
				VALUES(@subClientId, 'Full Failover to SP dataPaths', 2, 0, @createTime, 0)
	INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
				VALUES(@subClientId, 'Non-Full Failover to SP dataPaths', 2, 0, @createTime, 0)
	INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
				VALUES(@subClientId, 'sys: pre post option', 10, 0, @createTime, 0)
	INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
				VALUES(@subClientId, 'use global filters', 2, 0, @createTime, 0)
	--From 10.0, Use Shadow Copy is present under Use VSS Enabled (1) and Use VSS Options(1)
IF(SELECT releaseId FROM App_Client WHERE id = @i_clientId) < 15
		INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
					VALUES(@subClientId, 'Use Shadow Copy', 2, 0, @createTime, 0)
	ELSE
	BEGIN
		INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
				VALUES(@subClientId, 'Use VSS Enabled', 2, 0, @createTime, 0)
		INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
				VALUES(@subClientId, 'Use VSS Options', 7, 1, @createTime, 0)
	END
	INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
				VALUES(@subClientId, 'Use VSS for System State', 2, 1, @createTime, 0)
	INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
				VALUES(@subClientId, 'Use QSNAP', 2, 0, @createTime, 0)
	INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
				VALUES(@subClientId, 'UNCPath password', 1, 2, @createTime, 0)
	INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
				VALUES(@subClientId, 'sys:nStreams', 7, 1, @createTime, 0)
	INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
				VALUES(@subClientId, 'New Index Cycle', 10, 100, @createTime, 0)
	INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
				VALUES(@subClientId, 'last content change', 10, @createTime, @createTime, 0)
	--CREATE BACKUP SET PROPERTIES FOR:
	--ALL APPTYPES
	INSERT INTO APP_BackupSetProp (componentNameId, attrName, attrType, attrVal, created, modified)
				VALUES(@backupSetId, 'Use Change Journal', 2, 1, @createTime, 0)
	INSERT INTO APP_BackupSetProp (componentNameId, attrName, attrType, attrVal, created, modified)
				VALUES(@backupSetId, 'Use DC for FS backups', 2, 0, @createTime, 0)
	INSERT INTO APP_BackupSetProp (componentNameId, attrName, attrType, attrVal, created, modified)
				VALUES(@backupSetId, 'OnDemand Backupset', 2, 1, @createTime, 0)
	IF @i_SILO_CopyId > 0
	BEGIN
		INSERT INTO APP_BackupSetProp (componentNameId, attrName, attrType, attrVal, created, modified)
				VALUES(@backupSetId, 'SILO Copy ID', 10, @i_SILO_CopyId, @createTime, 0)
	INSERT INTO APP_SubClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
				VALUES(@subClientId, 'SILO Copy ID', 10, @i_SILO_CopyId, @createTime, 0)
	END
	--NON MIGRATOR/ARCHIVER APPTYPES
IF (@i_appTypeId != 58)
	BEGIN
		INSERT INTO APP_BackupSetProp (componentNameId, attrName, attrType, attrVal, created, modified)
					VALUES(@backupSetId, 'Pre 7.0 System State Archive Files Exist', 2, 0, @createTime, 0)
		INSERT INTO APP_BackupSetProp (componentNameId, attrName, attrType, attrVal, created, modified)
					VALUES(@backupSetId, 'My Backupset', 2, 0, @createTime, 0)
		INSERT INTO APP_BackupSetProp (componentNameId, attrName, attrType, attrVal, created, modified)
					VALUES(@backupSetId, 'Reset File Access Times', 2, 0, @createTime, 0)
	END
	IF @i_webClientId > 0
	BEGIN
		--LEGAL HOLD BACKUP SET PROPERTIES
		INSERT INTO APP_BackupSetProp (componentNameId, attrName, attrType, attrVal, created, modified)
				VALUES(@backupSetId, 'Prefered Web Server ClientId', 7, @i_webClientId, @createTime, 0)
	END
	--Associate newly created backupSet with user group
	exec dbo.sec_AssociateBackupSetWithGroup @userId, @backupSetId
	--ON SUCCESS RETURN BACKUPSET ID
	SET @o_backupSetId = @backupSetId
	SET @o_subclientId = @subClientId
	COMMIT TRAN
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	EXECUTE dbo.GetError @o_errorString OUTPUT , @o_backupSetId OUTPUT
	--CHANGE ERROR CODE TO NEGATIVE TO DISTINGUISH FROM ACTUAL BACKUP SET ID
	IF @o_backupSetId > 0
		SET @o_backupSetId = -1 * @o_backupSetId
	-- Rollback any active or uncommittable transactions before
	-- inserting information in the ErrorLog
	IF XACT_STATE() <> 0
	BEGIN
		ROLLBACK TRANSACTION;
	END
END CATCH
EXIT_PROC:
	SELECT @o_backupSetId AS backupSetId, @o_subclientId AS subclientId, @o_errorString AS errorString
END
GO


IF EXISTS (select * from GxQscripts where name = 'AppCreateOnDemandBackupSet')
	delete from GxQscripts where name = 'AppCreateOnDemandBackupSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCreateOnDemandBackupSet')
	delete from GXDBVersions where aliasname = 'AppCreateOnDemandBackupSet'
GO

insert into GXDBVersions values(2, 'AppCreateOnDemandBackupSet',  '00010031005600020000', 'AppCreateOnDemandBackupSet', '00010031005600020000')
GO

