

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCreateMobilePolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCreateMobilePolicy.sp,v $ $Id: AppCreateMobilePolicy.sp,v 1.1.2.5 2020/12/17 08:29:10 jswaminathan Exp $";
--	+===================================================================+
--	|  					  AppCreateMobilePolicy							|
--	+===================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppCreateMobilePolicy')
BEGIN
	print '>>> Drop Stored Procedure: AppCreateMobilePolicy <<<'
	drop procedure AppCreateMobilePolicy
END
IF EXISTS (select * from GxQscripts where name='AppCreateMobilePolicy')
	delete from GxQscripts where name = 'AppCreateMobilePolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCreateMobilePolicy')
	delete from GXDBVersions where aliasname = 'AppCreateMobilePolicy'
GO
print '... Creating Procedure: AppCreateMobilePolicy'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppCreateMobilePolicy
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @inUserId INT,
  @inLocaleId INT,
  @inXml XML
-----------------------------------------------------------
AS
  DECLARE @outXml XML
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			INT = dbo.GetUnixTime (GetUTCdate())
	DECLARE @tempPolicy TABLE(mobilePolicyId INT, mobilePolicyName NVARCHAR(MAX))
	BEGIN TRY
	IF OBJECT_ID('tempdb.dbo.#policyInfo') IS NOT NULL
	    DROP TABLE #policyInfo
	CREATE TABLE #policyInfo
	(
		policyId		INT,
policyName		NVARCHAR(255),
description		NVARCHAR(2048),
		disabled		INT,
		flag			INT
	)
	-- Read the XML
	INSERT INTO #policyInfo
	SELECT
			ISNULL((ref.value('@policyId', 'INT')), 0),
			ISNULL((ref.value('@policyName', 'NVARCHAR(255)')), 'default'),
			ISNULL((ref.value('@description', 'NVARCHAR(2048)')), ''),
			ISNULL(ref.value('@isDisabled', 'int'), 0),
			0
	FROM
	@inXml.nodes('/Api_CreateMobilePolicyReq/policy') doc(ref)
	BEGIN TRAN
	-- CHECK IF USER HAS ADD CAPABILITY
	DECLARE @userHasCapability INT = 0
	IF (@userHasCapability = 0)
	BEGIN
SET @errorCode = (462 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @errorString = (select message from EvLocaleMsgs WITH (NOLOCK) Where messageId = @errorCode AND [localeId] = @inLocaleId)
        SET @errorString = REPLACE(@errorString, '^1%s', (SELECT login FROM UMUsers WITH (NOLOCK) where id = @inUserId))
SET @errorString = REPLACE(@errorString, '^2%s', (select message from EvLocaleMsgs WITH (NOLOCK) Where messageId = (3129 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @inLocaleId))
        SET @errorString = REPLACE(@errorString, 'this ^3%s and ', '')
		GOTO ERROR
	END
	-- CHECK FOR DUPLICATE policy
	IF EXISTS (SELECT 1 FROM App_MobilePolicy CP WITH(NOLOCK) JOIN #policyInfo P ON P.policyName = CP.mobilePolicyName)
	BEGIN
SET @errorCode = (3126 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @errorString = dbo.fn_EvFormatEventMsgText(0, @inLocaleId, @errorCode, 0, 2)
		GOTO ERROR
	END
	UPDATE #policyInfo
SET flag |= 0x1
	WHERE disabled = 1
	MERGE App_MobilePolicy AS TARGET
	USING (SELECT policyId, policyName, description, flag FROM #policyInfo) AS
							SOURCE (policyId, policyName, description, flag)
		ON (TARGET.mobilePolicyId = SOURCE.policyId OR TARGET.mobilePolicyName = SOURCE.policyName)
	WHEN NOT MATCHED BY TARGET THEN
		INSERT(mobilePolicyName, description, flag, created, modified)
		VALUES(SOURCE.policyName, SOURCE.description, SOURCE.flag, @nowTime, 0)
	output inserted.mobilePolicyId, inserted.mobilePolicyName INTO @tempPolicy;
	-- Update new policyIds
	UPDATE #policyInfo
	SET policyId = T.mobilePolicyId
	FROM @tempPolicy T
	WHERE T.mobilePolicyName = #policyInfo.policyName
	-- ADD CREATOR OF THE ENTITY. RUN LOOP
	DECLARE @policyid INT = 0
	DECLARE @permissionsList NVARCHAR(MAX)
	DECLARE @propertyCursor CURSOR
	SET @propertyCursor = CURSOR FOR
						select mobilePolicyId from @tempPolicy WHERE mobilePolicyId > 0
	OPEN @propertyCursor
	FETCH NEXT FROM @propertyCursor INTO @policyid
	WHILE @@FETCH_STATUS = 0
	BEGIN
EXEC sec_setCreatorForEntity @inUserId, 0, @permissionsList, @errorCode OUTPUT, @errorString OUTPUT, 167, @policyId
		if (@errorCode<>0)
		BEGIN
			IF @errorString = ''
				set @errorString = 'Create Mobile Policy failed.'
			BREAK
		END
		FETCH NEXT FROM @propertyCursor INTO @policyId
	END
	CLOSE @propertyCursor;
	DEALLOCATE @propertyCursor;
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SELECT @errorCode = ERROR_NUMBER(), @errorString = ERROR_MESSAGE()
END CATCH
ERROR:
	IF @errorCode <> 0
	BEGIN
		IF XACT_STATE() <> 0
		BEGIN
			ROLLBACK TRAN
		END
		IF @errorString = ''
		BEGIN
SET @errorCode = (1287 | (CAST(POWER(2, 24) AS BIGINT) * 35)) --TODO
			SET @errorString = dbo.fn_EvFormatEventMsgText(0, @inLocaleId, @errorCode, 0, 2)
		END
	END
	ELSE
		COMMIT TRAN
ERROR_EXIT:
		SET @outXml = (SELECT
						(SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
							FOR XML PATH('error'), TYPE),
						(SELECT policyId AS '@policyId', policyName AS '@policyName'
							FROM #policyInfo
							FOR XML PATH('policies'),TYPE)
					FOR XML PATH('Api_MobilePolicyResp'), TYPE)
	IF OBJECT_ID('tempdb.dbo.#policyInfo') IS NOT NULL
	    DROP TABLE #policyInfo
	SELECT @outXml
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppCreateMobilePolicy')
	delete from GxQscripts where name = 'AppCreateMobilePolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCreateMobilePolicy')
	delete from GXDBVersions where aliasname = 'AppCreateMobilePolicy'
GO

insert into GXDBVersions values(2, 'AppCreateMobilePolicy',  '00010001000200050000', 'AppCreateMobilePolicy', '00010001000200050000')
GO

