

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCreateIndexTag.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCreateIndexTag.sp,v $ $Id: AppCreateIndexTag.sp,v 1.1.44.2 2018/03/22 01:40:17 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppCreateIndexTag <<<'

IF EXISTS (select * from sysobjects where name='AppCreateIndexTag')
	drop procedure AppCreateIndexTag
IF EXISTS (select * from GxQscripts where name='AppCreateIndexTag')
	delete from GxQscripts where name = 'AppCreateIndexTag'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCreateIndexTag')
	delete from GXDBVersions where aliasname = 'AppCreateIndexTag'
GO
print '... Creating Procedure: AppCreateIndexTag'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCreateIndexTag
  @i_userId INT=0,
  @i_xmlText XML,
  @o_xmlText XML	OUTPUT
AS
SET NOCOUNT ON
	DECLARE @o_errorCode		INT=0
	DECLARE @o_errorString		NVARCHAR(MAX)=N''
	DECLARE @i_tagID            VARCHAR(36)
	DECLARE @i_containerGuid	VARCHAR(36)
	DECLARE @i_tagValue         NVARCHAR(255)
	DECLARE @i_tagDesc          NVARCHAR(MAX)
	DECLARE @i_createdBy        NVARCHAR(255)
	DECLARE @i_operationType	INT
	DECLARE @i_tagAttribute		INT
	DECLARE @i_ownerUserId		INT
BEGIN TRY
BEGIN TRAN
	SET @i_tagID			= ISNULL(( SELECT ref.value('@idxTagGUID',		'VARCHAR(36)')	FROM @i_xmlText.nodes('App_IndexingTagReq/tag') R ( ref ) ), 0)
	SET @i_containerGuid	= ISNULL(( SELECT ref.value('@containerGuid',	'VARCHAR(36)')	FROM @i_xmlText.nodes('App_IndexingTagReq/tag') R ( ref ) ), '')
	SET @i_tagValue			= ISNULL(( SELECT ref.value('@tagValue',		'NVARCHAR(255)')FROM @i_xmlText.nodes('App_IndexingTagReq/tag') R ( ref ) ), '')
	SET @i_tagDesc			= ISNULL(( SELECT ref.value('@tagDesc',			'NVARCHAR(MAX)')FROM @i_xmlText.nodes('App_IndexingTagReq/tag') R ( ref ) ), '')
	SET @i_ownerUserId		= ISNULL(( SELECT ref.value('@ownerUserId',		'INT')			FROM @i_xmlText.nodes('App_IndexingTagReq/tag') R ( ref ) ), 0)
	SET @i_operationType	= ISNULL(( SELECT ref.value('@operationType',	'INT')			FROM @i_xmlText.nodes('App_IndexingTagReq/tag') R ( ref ) ), 0)
	SET @i_tagAttribute		= ISNULL(( SELECT ref.value('@tagAttribute',	'INT')			FROM @i_xmlText.nodes('App_IndexingTagReq/tag') R ( ref ) ), 0)
	IF ( @i_ownerUserId IS NULL OR @i_ownerUserId = 0 )
		SET @i_ownerUserId = @i_userId
    SET @i_createdBy = (SELECT login FROM UMUsers WHERE id = @i_userId)
	if (@i_operationType =1 ) --Add
		BEGIN
			IF (LEN(@i_containerGuid) = 0)
			BEGIN
				set @i_containerGuid = ISNULL((SELECT TOP(1) containerGuid FROM DM2Container WHERE containerName='Indexing Tags'), '')
				IF LEN(@i_containerGuid) = 0
				BEGIN
					SET @o_errorCode = 1
					SET @o_errorString = 'Default container not exists'
					GOTO EXIT_ERROR
				END
			END
			--CHECK FOR TAG ALREADY EXISTING
			IF EXISTS(SELECT * FROM DM2DocTags WHERE TagValue = @i_tagValue AND containerGuid = @i_containerGuid AND ownerUserId = @i_userId)
			BEGIN
				SET @o_errorCode = 7
				SET @o_errorString = 'Tag already exists'
				GOTO EXIT_ERROR
			END
			SET @i_tagID = NEWID()
			INSERT INTO DM2DocTags (TagID, TagValue, TagDesc, CreatedBy, Attribute, ownerUserId, containerGuid)
			VALUES (@i_tagID, @i_tagValue, @i_tagDesc, @i_createdBy, @i_tagAttribute, @i_userId, @i_containerGuid)
		END
	ELSE IF(@i_operationType =3 ) --Modify
		BEGIN
			IF @i_tagID = ''
			BEGIN
				SET @o_errorCode = 3
				SET @o_errorString = 'Missing tag id during modify operation'
				GOTO EXIT_ERROR
			END
			 --THIS ERROR SHOULD NOT HAPPEN
			IF (NOT EXISTS (SELECT * FROM DM2DocTags WHERE TagID = @i_tagID AND ownerUserId = @i_userId))
			BEGIN
				SET @o_errorCode = 3
				SET @o_errorString = 'Tag id not found duting modify operation'
				GOTO EXIT_ERROR
			END
			UPDATE DM2DocTags SET TagDesc = @i_tagDesc WHERE TagID = @i_tagID AND ownerUserId = @i_userId
		END
	ELSE
		BEGIN
			SET @o_errorCode = 9
			SET @o_errorString = 'Operation Type is missing'
		END
COMMIT TRAN
END TRY
---------------------------------------------
-- CHECK FOR ERRORS ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    -- Call procedure to print error information.
    -- Call procedure to get error information.
    EXECUTE dbo.GetError @o_errorString OUTPUT , @o_errorCode OUTPUT
    -- Rollback any active or uncommittable transactions before
    -- inserting information in the ErrorLog
    IF XACT_STATE() <> 0
    BEGIN
        ROLLBACK TRAN;
    END
END CATCH;
EXIT_ERROR:
BEGIN
	IF @o_errorCode <> 0
	BEGIN
		SET @o_xmlText  =
		(	SELECT
				(   SELECT @o_errorCode AS '@errorCode', @o_errorString AS '@errorMessage'
					FOR XML PATH('error'),TYPE
				)
			FOR XML PATH ('App_IndexingTagRes'), TYPE
		)
		ROLLBACK TRAN;
	END
	ELSE
	BEGIN
		SET @o_xmlText = (SELECT DISTINCT
            T.TagID '@idxTagGUID', T.TagValue '@tagValue'
            FROM DM2DocTags AS T WHERE @i_tagID = T.TagID
            FOR XML PATH('tag'), ROOT('App_IndexingTagRes'))
        IF @o_xmlText IS null
            SET @o_xmlText = '<App_IndexingTagRes/>'
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppCreateIndexTag')
	delete from GxQscripts where name = 'AppCreateIndexTag'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCreateIndexTag')
	delete from GXDBVersions where aliasname = 'AppCreateIndexTag'
GO

insert into GXDBVersions values(2, 'AppCreateIndexTag',  '00010001004400020000', 'AppCreateIndexTag', '00010001004400020000')
GO

