

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCreateFolderForCompany.sp] ---------- 

--  +==============================================================================+
--  |		 		 Name:  AppCreateFolderForCompany()
--  | Description:  This procedure will be used while creating a company. This will create default folder for a company
--  +==============================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCreateFolderForCompany.sp,v $ $Id: AppCreateFolderForCompany.sp,v 1.1.2.1 2020/07/01 14:22:21 snandhini Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppCreateFolderForCompany')
BEGIN
	print '>>> Drop Stored Procedure: AppCreateFolderForCompany <<<'
	drop procedure AppCreateFolderForCompany
END
IF EXISTS (select * from GxQscripts where name='AppCreateFolderForCompany')
	delete from GxQscripts where name = 'AppCreateFolderForCompany'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCreateFolderForCompany')
	delete from GXDBVersions where aliasname = 'AppCreateFolderForCompany'
GO
print '... Creating Procedure: AppCreateFolderForCompany'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCreateFolderForCompany
  @i_companyId INTEGER,
  @i_companyName NVARCHAR(255),
  @i_callerId INTEGER
AS
  DECLARE @errCode INTEGER=0
  DECLARE @errString NVARCHAR(MAX) = ''
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	IF @i_companyName IS NOT NULL AND @i_companyName <> '' AND @i_companyId <> 0 AND NOT EXISTS (SELECT 1 FROM APP_SmartFolder WHERE name = @i_companyName)
	BEGIN
DECLARE @companyGrpId NVARCHAR(64) = ISNULL((SELECT attrValInt FROM App_CompanyProp WHERE attrName='Associated Smart Client Group' AND componentNameId = @i_companyId AND modified=0 AND  cs_attrName = CHECKSUM('Associated Smart Client Group')),0)
DECLARE @tenantOperatorGroupId INT = (SELECT TOP 1 ID FROM UMGroups WHERE umdsproviderId = @i_companyId and groupFlags &  0x40000 > 0)
		DECLARE @folderId INT = 0
		DECLARE @nowTime INT = dbo.GetUNIXTime(GETUTCDATE())
		DECLARE @folderXml XML = '<App_SmartFolderEntityInfo isAutomatic="0">
									<folder _type_="127" smartFolderName="'+ @i_companyName + '" folderType="28" />
									<parentEntity _type_="27" />
								</App_SmartFolderEntityInfo>'
		INSERT INTO APP_SmartFolder(name, description, folderType, flag, status, rawXml, ruleQuery, ownerId, created, modified)
SELECT  @i_companyName, '', 28, 0, 0, @folderXml, '', @i_callerId, @nowTime,0
		SET @folderId = SCOPE_IDENTITY()
		INSERT INTO APP_SmartFolderAssoc(folderId, componentType, componentId, status, created, modified)
SELECT @folderId, 28,	@companyGrpId,	0,	@nowTime,	0
		INSERT INTO APP_CompanyProp (componentNameId, attrName, attrType, attrVal, created, modified)
SELECT @i_companyId, 'Associated Folder', 7, @folderId, @nowTime, 0
		INSERT INTO App_CompanyEntities(entityType, entityId, companyId, created)
SELECT 127, @folderId, @i_companyId, @nowTime
		INSERT INTO UMSecurityAssociations (isUser, userOrGroupId, entityType1, entityId1, permissionId, authorId, companyId, isCreator)
SELECT 1, @i_callerId, 127, @folderId, 107, @i_callerId, 0, 1
		UNION
SELECT 1, @i_callerId, 127, @folderId, 31, @i_callerId, 0, 1
		UNION
SELECT 0, @tenantOperatorGroupId, 127, @folderId, 31, @i_callerId, @i_companyId, 0
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @errCode = ERROR_NUMBER()
    set @errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
	select @errCode, @errString
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppCreateFolderForCompany')
	delete from GxQscripts where name = 'AppCreateFolderForCompany'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCreateFolderForCompany')
	delete from GXDBVersions where aliasname = 'AppCreateFolderForCompany'
GO

insert into GXDBVersions values(2, 'AppCreateFolderForCompany',  '00010001000200010000', 'AppCreateFolderForCompany', '00010001000200010000')
GO

