

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCreateEntityTag.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCreateEntityTag.sp,v $ $Id: AppCreateEntityTag.sp,v 1.1.2.3 2020/10/23 13:13:23 sthakkar Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppCreateEntityTag')
BEGIN
	print '>>> Drop Stored Procedure: AppCreateEntityTag <<<'
	drop procedure AppCreateEntityTag
END
IF EXISTS (select * from GxQscripts where name='AppCreateEntityTag')
	delete from GxQscripts where name = 'AppCreateEntityTag'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCreateEntityTag')
	delete from GXDBVersions where aliasname = 'AppCreateEntityTag'
GO
print '... Creating Procedure: AppCreateEntityTag'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCreateEntityTag
  @xmlInput XML, 
  @xmlResult XML OUTPUT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	DECLARE @userId INT
	DECLARE @localeId INT
	DECLARE @errorString NVARCHAR(MAX)
	DECLARE @errorCode INT
	DECLARE @companyid int = 0
	DECLARE @serviceType int = 0
	DECLARE @containerId nvarChar(255)
	DECLARE @entityType INT;
	DECLARE @tagsHaveError INT = 0;
	DECLARE @userName NVARCHAR(255);
	DECLARE @nowTime   integer
	SET     @nowTime  =   dbo.GetUnixTime (GetUTCdate());
	SET @localeId = ISNULL(@xmlInput.value('(//Api_EntityTagsReq/processinginstructioninfo/locale/@localeId)[1]', 'int') , 0)
	SET @userId = ISNULL(@xmlInput.value('(//Api_EntityTagsReq/processinginstructioninfo/user/@userId)[1]', 'int') , 0)
	--Check if correct user is logged in
	IF @userId = 0
	BEGIN
		SET @errorCode = 1
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (4671 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
		GOTO errorexit
	END
	SET @userName = (SELECT name FROM UMUSers WHERE id = @userId);
	SET @companyid = dbo.AppGetOrganizationForUser(@userId)
	IF @companyid <> 0
	BEGIN
		SET @serviceType = 5
	END
	-- creating table from ixml
	IF object_id('tempdb.dbo.#tempAppEntityTagsTable') IS NOT null DROP TABLE #tempAppEntityTagsTable
	CREATE TABLE #tempAppEntityTagsTable (entityId int, entityType int, tagName NVARCHAR(255), tagValue NVARCHAR(max),tagId int, hasError int);
	--inserting data to table
	INSERT into #tempAppEntityTagsTable
	SELECT  ref.value('@entityId', 'INT'),ref.value('@entityType','INT'), sref.value('@name','NVARCHAR(MAX)') ,sref.value('@value','NVARCHAR(MAX)'),NULL, 0 FROM  @xmlInput.nodes('Api_EntityTagsReq/entityTag') R ( ref )
	OUTER APPLY R.ref.nodes('tag') S (sref)
	--removing duplicates by entityId, entityType, tagId
	;WITH cte AS (
		SELECT
			entityId,
			entityType,
			tagName,
			ROW_NUMBER() OVER (
				PARTITION BY
					entityId,
					entityType,
					tagName
				ORDER BY
					entityId,
					entityType,
					tagName
			) row_num
		 FROM #tempAppEntityTagsTable
	)
	DELETE FROM cte
	WHERE row_num > 1;
	update #tempAppEntityTagsTable set hasError = 1 where entityId IS NULL OR entityId = 0 OR  entityType IS NULL OR entityType = 0 or tagName IS NULL or tagName = ''
	IF @@ROWCOUNT > 0
		SET @tagsHaveError = 1
	IF EXISTS (SELECT hasError from #tempAppEntityTagsTable where hasError = 0)
	BEGIN
		 SET @entityType = (SELECT TOP 1 entityType from #tempAppEntityTagsTable where entityType IS NOT NULL);
		 --creating table to check if user has permission on entities or not
		IF object_id('tempdb.dbo.#entityPermissionsTable') IS NOT NULL
			DROP TABLE  #entityPermissionsTable
		CREATE TABLE #entityPermissionsTable (entityId int, entityType int ,hasPermissions int  );
		INSERT INTO #entityPermissionsTable
		SELECT DISTINCT a.entityId, a.entityType, 0  FROM #tempAppEntityTagsTable a where a.hasError = 0
IF OBJECT_ID('tempdb.dbo.#getPermissionsOnEntities_InputTable') IS NOT NULL DROP TABLE #getPermissionsOnEntities_InputTable CREATE TABLE #getPermissionsOnEntities_InputTable ( entityId1 INT, entityId2 INT DEFAULT 0, entityId3 INT DEFAULT 0, entityId4 INT DEFAULT 0, entityId5 INT DEFAULT 0 ) IF OBJECT_ID('tempdb.dbo.#getPermissionsOnEntities_OutputTable') IS NOT NULL DROP TABLE #getPermissionsOnEntities_OutputTable CREATE TABLE #getPermissionsOnEntities_OutputTable ( entityId1 INT, entityId2 INT, entityId3 INT, entityId4 INT, entityId5 INT, permissionsString VARCHAR(512), isChildRow BIT DEFAULT 0	        )
		INSERT INTO #getPermissionsOnEntities_InputTable (entityId1, entityId2, entityId3, entityId4, entityId5)
				SELECT entityId, 0, 0, 0,0 FROM #entityPermissionsTable
		EXEC sec_getPermissionsOnEntities @userId, @entityType
		--updating has permissions based on stored proc
		update #entityPermissionsTable
set hasPermissions = CAST(SUBSTRING((SELECT permissionsString from #getPermissionsOnEntities_OutputTable where entityId1 = #entityPermissionsTable.entityId),27,1) AS INT)
		-- Update #temapAppEntityTagsTable column hasError if   5. user does not have tag management permission on given entityID and entityType
		update #tempAppEntityTagsTable
			set hasError = 2
			FROM #tempAppEntityTagsTable a INNER JOIN #entityPermissionsTable b ON   a.entityId = b.entityId AND a.entityType = b.entityType
			WHERE  b.hasPermissions = 0
		IF @@ROWCOUNT <> 0
			SET @tagsHaveError = 1
		--Fetch container id to know where to add tags
		IF EXISTS (SELECT hasError from #tempAppEntityTagsTable where hasError = 0)
		BEGIN
			SET @containerId = (
				SELECT TOP 1  A.containerId FROM DM2Container a
				JOIN UMSecurityAssociations b ON a.containerId = b.entityId1 AND a.containerType = b.entityType1
				LEFT JOIN UMUsers c ON b.userOrGroupId = c.id AND b.isUser = 1
				LEFT JOIN UMGroups d ON d.id = b.userOrGroupId AND b.isUser = 0
				LEFT JOIN umdsproviders e ON e.id = d.umdsProviderId  AND b.isUser = 0
				LEFT JOIN UMDSProviders f ON c.umDSproviderId = f.id AND b.isUser = 1
				WHERE containerType = 9504 AND attribute & 1 = 1 AND (f.serviceType = @serviceType OR e.serviceType = @serviceType) AND ((@companyid > 0 AND f.id = @companyid) OR @companyid = 0)
			)
			IF @containerId IS NULL
			BEGIN
DECLARE @containerName NVARCHAR(255) = (SELECT message FROM EvLocaleMsgs WHERE messageId = (4669 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
				IF @companyId > 0
				BEGIN
					DECLARE @companyName NVARCHAR(100)
					SET @companyName = (SELECT hostName FROM  UMDSProviders WHERE id = @companyId)
					SET @containerName = @containerName + '-' + @companyName
				END
				DECLARE @i_xmlText XML =
				'<DM2ContentIndexing_ContainerOperationReq entityType="9504" operationType="1" fromSite="4">
					<container containerType="9504" containerName= "' + CONVERT(NVARCHAR(255),@containerName) + '" comment="' + CONVERT(NVARCHAR(255),@containerName) + '" attribute="1">
					</container>
				</DM2ContentIndexing_ContainerOperationReq>'
				EXEC  DM2PerformContainerOperation 1,0,@i_xmlText
				SET @containerId= (SELECT containerId FROM DM2Container WHERE containerType=9504 AND containerName = @containerName)
			END
			DECLARE @containerGuid nvarchar(255) = (SELECT containerGuid FROM DM2Container WHERE containerId = @containerId);
			--Insert new Tags to DM2DocTags in the default container
			INSERT INTO DM2DocTags (TagID, containerGuid, TagValue,TagDesc, ownerUserId,CreatedBy,Attribute)
			SELECT DISTINCT newId(), @containerGuid, q.tagName, '', @userId, @userName, 1   FROM
					(SELECT DISTINCT tagName FROM #tempAppEntityTagsTable b LEFT JOIN DM2DocTags d ON b.tagName = d.TagValue AND d.containerGuid = @containerGuid
					WHERE d.TagValue IS NULL AND b.hasError = 0) q
			-- update #tempAppEntityTagsTable with tagIds
			UPDATE #tempAppEntityTagsTable
				SET tagId = (SELECT distinct id FROM (SELECT id,TagName from DM2DocTags d INNER JOIN #tempAppEntityTagsTable t
							ON d.TagValue = t.tagName
							WHERE d.containerGuid = @containerGuid AND t.hasError = 0  ) s WHERE s.tagName = #tempAppEntityTagsTable.tagName and #tempAppEntityTagsTable.hasError = 0 )
			-- insert into App_entityTags
			INSERT INTO App_EntityTags (entity_type, entity_id, entity_tag_id, entity_tag_value, created)
			SELECT DISTINCT entityType,entityId, tagId, tagvalue,@nowTime FROM #tempAppEntityTagsTable  TAT
				WHERE
					NOT EXISTS (SELECT entity_type, entity_id, entity_tag_id FROM App_EntityTags AET WHERE AET.entity_id = TAT.entityId AND AET.entity_type = TAT.entityType AND AET.entity_tag_id = TAT.tagId ) AND TAT.hasError = 0
		END
	END
	--Setting error code and error message
	IF @tagsHaveError = 1
	BEGIN
		SET @errorCode = 1
		IF EXISTS (select hasError from #tempAppEntityTagsTable where hasError = 1)
		BEGIN
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (4670 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
		END
		IF EXISTS (select hasError from #tempAppEntityTagsTable where hasError = 2)
		BEGIN
			DECLARE @errorPermissions NVARCHAR(1000)
SET @errorPermissions = (SELECT message FROM EvLocaleMsgs WHERE messageId = (4672 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
			SET @errorString = @errorString + @errorPermissions
		END
	END
	ELSE
	BEGIN
		SET @errorCode = 0
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (4674 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode = ERROR_NUMBER()
    SET @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	GOTO errorexit
END CATCH
errorexit:
IF object_id('tempdb.dbo.#entityPermissionsTable') IS NOT null DROP TABLE #entityPermissionsTable
IF object_id('tempdb.dbo.#getPermissionsOnEntities_InputTable') IS NOT null DROP TABLE #getPermissionsOnEntities_InputTable
IF object_id('tempdb.dbo.#getPermissionsOnEntities_OutputTable') IS NOT null DROP TABLE #getPermissionsOnEntities_OutputTable
IF object_id('tempdb.dbo.#tempAppEntityTagsTable') IS NOT null DROP TABLE #tempAppEntityTagsTable
SET @xmlResult = (SELECT
(
    	SELECT @errorCode AS '@errorCode',
           	@errorString AS '@errorMessage'
	FOR XML PATH('error'), TYPE
)
FOR XML PATH('Api_EntityTagsResp'))
GO

IF EXISTS (select * from GxQscripts where name = 'AppCreateEntityTag')
	delete from GxQscripts where name = 'AppCreateEntityTag'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCreateEntityTag')
	delete from GXDBVersions where aliasname = 'AppCreateEntityTag'
GO

insert into GXDBVersions values(2, 'AppCreateEntityTag',  '00010001000200030000', 'AppCreateEntityTag', '00010001000200030000')
GO

