

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCreateCustomDomains.sp] ---------- 

--  +========================================================================+
--  | Name:  AppCreateCustomDomains
--  | Description: Takes an XML with user info and domain info
--  | creates user if the user does not exist in DB
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppCreateCustomDomains')
BEGIN
	print '>>> Drop Stored Procedure: AppCreateCustomDomains <<<'
	drop procedure AppCreateCustomDomains
END
IF EXISTS (select * from GxQscripts where name='AppCreateCustomDomains')
	delete from GxQscripts where name = 'AppCreateCustomDomains'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCreateCustomDomains')
	delete from GXDBVersions where aliasname = 'AppCreateCustomDomains'
GO
print '... Creating Procedure: AppCreateCustomDomains'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppCreateCustomDomains
  @userId INTEGER,     
  @localeId INTEGER,
  @createUsers INTEGER,
  @inXML XML OUTPUT
AS
BEGIN TRY
-- Step 1 - Get list of users in the XML and get distinct domains from the request
-- Step 2 - Remove all users for which domain exist (this can be based on flag whether code also want us to create any missing user)
-- Step 2.a   - Get List of domain that need to be created and also client id which sent this domain info
-- Step 3 - Execute get custom domain info for that client
-- Step 4 - Keep that domain info in variable. If user was part of AD user group, then we will refer actual domain while if it wasn't , then we will create new custom domain as per company setting
-- Step 5 - For the fetched domain, create that new provider by properly setting owner company
-- Step 6 - Now if we did request for user creation , then code to create user will kick in.
-- Step 6.a   - We will try to keep much code as common as possible because then we can remove our logic from C++ layer for user creation in activation
DECLARE @infoTbl TABLE (clientId INT, ownerAlias NVARCHAR(1024), isADUser INT, email NVARCHAR(1024) DEFAULT '', upn NVARCHAR(1024) DEFAULT '', uguid nvarchar(64), uSID nvarchar(128), useUPN INT DEFAULT(0), domainAlias NVARCHAR(1024), customDomain  NVARCHAR(1024), providerId INT DEFAULT (-1), ownerCompany INT DEFAULT (-1), ownerUserId INT DEFAULT (-1),userGroupName  NVARCHAR(1024), userGroupId INT DEFAULT(0), isDomainExist INT DEFAULT (0), isUserExist INT DEFAULT(0))
DECLARE @createOnlyDomainAndUserGroups INT = (SELECT CASE WHEN @createUsers=1 THEN 0 ELSE 1 END )
DECLARE @errorCode   integer=0
DECLARE @errorStr   nvarchar(MAX)
DECLARE @providerId INT = 0
DECLARE @ownerCompany INT = 0   -- Default Owner Company is 0
DECLARE @ownerUserId INT = 0   -- Default userId is 1
DECLARE @description NVARCHAR(MAX)=N''
DECLARE @defaultUserGroupName NVARCHAR(256)
DECLARE @domainname NVARCHAR(256)
DECLARE  @ownerCompanyId	INT
DECLARE  @userGroupName	    NVARCHAR(255)
DECLARE  @errorString       VARCHAR(MAX)
DECLARE @customDomainUserGroupId INT = 0 -- This need to be hanled in infotable and also update that value
DECLARE @domainCreateTbl Table (providerId INT PRIMARY KEY, customDomainName NVARCHAR(1024), defaultUserGroupId INT)
DECLARE @allowDomainCreationForLocalUser INT  = ISNULL((SELECT 1 FROM GxGlobalParam WITH(NOLOCK) WHERE name='Allow Custom Domain Creation for Local Users' AND value='1'), 0)
-- Step 1 - Get list of users in the XML and get distinct domains from the request
-- We don't want to create domain for local users via CVD. We will only do that for AD domains
-- for local users, domain creation will be taken care by Activation(if required)
INSERT INTO @infoTbl (clientId , ownerAlias , isADUser , email , upn , uguid , uSID, useUPN)
SELECT cl.value('@clientId', 'INT'), ow.value('@val', 'NVARCHAR(1024)'), 0,'','','','',0
	FROM    @inXML.nodes('App_SetClientOwnerReq/clientOwners') R(ref)
	CROSS APPLY ref.nodes('./client') C(cl)
	CROSS APPLY ref.nodes('./ownerName') O(ow)
	WHERE (@allowDomainCreationForLocalUser = 1) AND
		(ow.value('@val', 'NVARCHAR(1024)') NOT IN (SELECT orig.value('@loginAlias', 'NVARCHAR(1024)') FROM @inXML.nodes('App_SetClientOwnerReq/clientOwners/ownerNameADUserInfo') O(orig)))
UNION
SELECT cl.value('@clientId', 'INT') , ad.value('@loginAlias', 'NVARCHAR(1024)'), 1, ad.value('@email', 'NVARCHAR(1024)'), ad.value('@userPrincipalName', 'NVARCHAR(1024)'), ad.value('@uGUID', 'NVARCHAR(1024)'), ad.value('@uSID', 'NVARCHAR(1024)'), 0
	FROM    @inXML.nodes('App_SetClientOwnerReq/clientOwners') R(ref)
	CROSS APPLY ref.nodes('./client') C(cl)
	CROSS APPLY ref.nodes('./ownerNameADUserInfo') A(ad)
-- Step 2 -  Get List of domains in request and mark all domain which already exist
UPDATE TT
	SET TT.domainAlias = substring(ownerAlias, 1, charindex('\', ownerAlias, 1)-1),
	TT.isDomainExist =
							( SELECT CASE WHEN UD.id IS NOT NULL THEN 1
								ELSE 0
								END),
	TT.providerId =
							( SELECT CASE WHEN UD.id IS NOT NULL THEN UD.id
								ELSE 0
								END)
FROM @infoTbl TT
LEFT OUTER JOIN UMDSProviders UD
	ON UD.domainName=substring(TT.ownerAlias, 1, charindex('\', TT.ownerAlias, 1)-1)
-- Only execute below code if there is atleast 1 missing domain
IF EXISTS(SELECT 1 FROM @infoTbl WHERE isDomainExist=0)
BEGIN
	-- Step 3 - Execute get custom domain info for that client
	DECLARE @clientCompanyTBL TABLE (ownerCompanyId INT  PRIMARY KEY, ownerUserID INT, customDomainName NVARCHAR(1024), userGroupName NVARCHAR(1024))
	-- Run on clients for which we don't have domain exist
	-- Loop is commented as we are not sure in what case this code is called for multiple clients.
	-- If required, we can simply uncomment this code to include processing for all client
	DECLARE @i_clientId INT = (SELECT min(clientId) FROM @infoTbl WHERE isDomainExist=0 )
	--DECLARE @i_clientId INT = (SELECT min(clientId) FROM @infoTbl WHERE isDomainExist=0 )
	--WHILE @i_clientId  IS NOT NULL
	--BEGIN
		-- Delete any previous Data
		-- DELETE @clientCompanyTBL
		-- Set values here , so that in case we start loop, we don't keep reading old values
		SET @ownerCompanyId		= -1
		SET @ownerUserID		= -1
		SET @domainName			= ''
		SET @userGroupName	    = ''
		SET @errorString		= ''
		-- Get Custom Domain Info for this client
		------------------------------------------------------------------------------------------------------
--- CODE BELOW HERE IS FROM AppGetCustomDomainInfo.spb  ----------
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
DECLARE @scgID INT = 0
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	SET @errorCode = 0
    SET @errorString = ''
SET @domainName = (SELECT TOP 1 value FROM APP_AdvanceSettings WHERE keyName = 'sLaptopUserDomain' AND enabled = 1 AND deleted = 0 AND entityType = 3 AND entityId = @i_clientId)
SET @userGroupName = (SELECT TOP 1 value FROM APP_AdvanceSettings WHERE keyName = 'DefaultUserGroupName' AND enabled = 1 AND deleted = 0 AND entityType = 3 AND entityId = @i_clientId)
	-- If we are checking owner company directly from installation property companyid, then we have to make sure that owner company is not 0.
	-- Because it might be the case that commcell Admin installed some laptop for some user but later on gave some company user access to it.
	-- In that case, out fallback approach to SCG first and company later will be success. In any case, we will figure out owner company to be 0
	SELECT @ownerCompanyId=CAST(AC.attrval AS INT) FROM APP_ClientProp AC
							INNER JOIN UMDSProviders UD
ON CAST(UD.id AS NVARCHAR(64))=AC.attrval AND UD.serviceType = 5
WHERE attrname='Installation Company ID' AND componentNameId=@i_clientId
	-- If for some reason, we don't find valid installation company id or if its 0, then check via Auth code
	IF ((@ownerCompanyId IS NULL) OR (@ownerCompanyId = 0))
	BEGIN
		SELECT @ownerCompanyId=ACOP.componentNameId
			FROM APP_ClientProp ACLP
			INNER JOIN APP_CompanyProp  ACOP
				ON ACOP.attrval=ACLP.attrval
WHERE ACLP.attrname='Authorization Code' AND ACLP.componentNameId=@i_clientId AND ACLP.modified=0 AND
ACOP.attrname='Authorization Code' AND ACOP.modified=0 AND ACOP.cs_attrName=checksum('Authorization Code')
	END
	-- If we reach here and have valid companyid , then get the relevant SCG ID
	IF ((@ownerCompanyId >= 0))
	BEGIN
SET @scgID = ISNULL((SELECT attrValInt FROM APP_CompanyProp WHERE attrName='Associated Smart Client Group' AND componentnameid = @ownerCompanyId AND modified=0 AND cs_attrName=checksum('Associated Smart Client Group')),0)
	END
	IF @scgID = 0
	BEGIN
SET @scgID = ISNULL((SELECT TOP 1 entityId FROM APP_AdvanceSettings WHERE keyName = 'sLaptopUserDomain' AND enabled = 1 AND deleted = 0 AND entityType = 28 AND cast(value AS NVARCHAR(1024)) = @domainName),0)
	END
    -- If we are not able to fetch owner company via SCG setting, then we will check if this client is part of some Company SCG. If yes, then that company is owner for that new provider
    IF @scgID = 0
    BEGIN
        SET @scgID = ISNULL((SELECT TOP 1 ACG.id FROM APP_ClientGroup ACG
	                                INNER JOIN APP_ClientGroupAssoc ACGA
		                                ON ACGA.clientGroupId=ACG.id AND ACGA.clientId=@i_clientId
                                    INNER JOIN APP_CompanyProp ACP
ON ACP.attrName='Associated Smart Client Group' AND attrValInt = ACG.id  AND ACP.cs_attrName=checksum('Associated Smart Client Group')
WHERE ACG.flag & 0x1000 <> 0),0)
		-- If we got SCG id by directly looking up client to SCG association, then we won't have owner company set at thig moment
		-- In that case, fetch it now.
SET @ownerCompanyId = ISNULL((SELECT TOP 1 componentNameId FROM APP_CompanyProp WHERE attrname = 'Associated Smart Client Group' AND attrValInt = @scgID AND modified=0 AND cs_attrName=checksum('Associated Smart Client Group')),0)
    END
    IF ((@domainName IS NULL OR LEN(@domainName) <=0) OR (@userGroupName IS NULL OR LEN(@userGroupName) <=0))
    BEGIN
SET @domainName = (SELECT TOP 1 value FROM APP_AdvanceSettings WHERE keyName = 'sLaptopUserDomain' AND enabled = 1 AND deleted = 0 AND entityType = 28 AND entityId = @scgID)
SET @userGroupName = (SELECT TOP 1 value FROM APP_AdvanceSettings WHERE keyName = 'DefaultUserGroupName' AND enabled = 1 AND deleted = 0 AND entityType = 28 AND entityId = @scgID)
    END
    -- Default Value
    SET @ownerUserID = 1
    IF @ownerCompanyId > 0
    BEGIN
        -- If we get valid company id, then we will get tenant admin id too.
        SET @ownerUserID = (SELECT TOP 1 UU.id FROM UMUsers UU
			                    INNER JOIN UMUserGroup UUG
			                    ON UUG.userId=UU.id
			                    INNER JOIN UMGroups UG
ON UG.id=UUG.groupId AND UG.groupFlags&0x10000<> 0 and UG.umdsProviderId=@ownerCompanyId)
    END
	ELSE IF @ownerCompanyId = 0
	BEGIN
		-- We got company id as 0. As per this case, we won't have domainName and userGroupName populated
		-- Lets check GxGlobalParam for the same key
		-- For company id 0, there is no way user could set this
SET @domainName = (SELECT TOP 1 value FROM GxGlobalParam WHERE name = 'sCustomDomain')
SET @userGroupName = (SELECT TOP 1 value FROM GxGlobalParam WHERE name = 'sCustomUserGroupName')
	END
	-- If we have an user group with format - CompanyName\Tenant Users, then we should only return the relevant user group name wihtout domain name.
	DECLARE @pos INT = 0
	IF (LEN(@userGroupName) > 0)
	BEGIN
		SET @pos=CHARINDEX('\',@userGroupName,1)
		IF @pos <> 0
		BEGIN
			SET @userGroupName= RIGHT(@userGroupName,LEN(@userGroupName)-@pos)
		END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode	 = ERROR_NUMBER()
	SET @errorString  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
--- CODE Till HERE IS FROM AppGetCustomDomainInfo.spb  ----------
		------------------------------------------------------------------------------------------------------
		-- If for some reason, we get any error, then stop this
		IF (@errorCode <> 0)
		BEGIN
			SET @errorStr = @errorString
			GOTO PROC_EXIT
		END
		INSERT INTO @clientCompanyTBL
		SELECT @ownerCompanyId, @ownerUserID, @domainName, @userGroupName
		-- Finally update our primary table for which domain info is missing
		-- For users which  sent AD user info, for them domain name remain same
		-- For users which sent no domain name, we will use domain name returned by AppGetCustomDomainInfo
		UPDATE IT
		SET IT.customDomain= (SELECT CASE WHEN isADUser<>1 THEN CCT.customDomainName ELSE IT.domainAlias END),
			IT.ownerCompany=CCT.ownerCompanyId,
			IT.ownerUserId=CCT.ownerUserID,
			IT.userGroupName = CCT.userGroupName
			FROM @infoTbl IT
		INNER JOIN @clientCompanyTBL CCT
			ON IT.clientId=@i_clientId AND IT.isDomainExist=0
		-- Get Next client
		--SET @i_clientId = (SELECT min(clientId) FROM @infoTbl WHERE clientId>@i_clientId AND isDomainExist=0 )
	--END
	-- Step 4 - Keep that domain info in variable. If user was part of AD user group, then we will refer actual domain while if it wasn't , then we will create new custom domain as per company setting
	IF @description=''
	BEGIN
		SET @description = 'Entity created by system at ' + CAST(GETUTCDATE() AS NVARCHAR(64))
	END
	-- Step 5 - In the cusros for eachfetched domain, create that new provider by properly setting owner company and creating required user groups
	-- We have cursor, as in a single request we get both AD users and local users as part of request. Although domain creation for local user is behind additional setting but it is still there
	-- to honor both cases, we have to create cursor
	DECLARE ProviderInfoCursor CURSOR
	FOR
	SELECT customDomain,ownerCompany,ownerUserId,userGroupName FROM @infoTbl
	where isDomainExist=0
	GROUP BY customDomain,ownerCompany,ownerUserId,userGroupName
	OPEN ProviderInfoCursor
		FETCH FROM ProviderInfoCursor INTO @domainName, @ownerCompany,@ownerUserId,@defaultUserGroupName
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF @defaultUserGroupName IS NULL
		BEGIN
			SET @defaultUserGroupName = ''
		END
		SET @providerId=0
		IF LEN(@domainName) > 0
		BEGIN
			-------------------------------------------------------------------------------------------------------------------------------------------
--- CODE BELOW HERE IS FROM AppCreateCustomDomain.spb  ----------
-- give few parameters (customDomain,ownerCompany,ownerUserId,userGroupName), this code can create domain
-- identify if the owner is in hostname\username format, and convert to domainName\username
SET @providerId = ISNULL((SELECT id FROM UMDSProviders WITH (READUNCOMMITTED) WHERE domainName = @domainName ),0)
IF @providerId = 0
BEGIN
	-- Create a dummy domain
	DECLARE @desc NVARCHAR(128) = 'Entity created by system at ' + CAST(GETUTCDATE() AS NVARCHAR(64))
	INSERT UMDSProviders (domainName, hostName, description, login, password, trustedHostUser, trustedHostPW, flags, enabled, serviceType,
							modified, dnsRoot, dnsRootStatus, useSecureLdap, origCCId, GUID, port, resourceId, checkTime,ownerCompany,ownerId )
VALUES(@domainName, @domainName, @desc,'', '', '', '', CAST(0x0004 AS INT), 1, 12,
							0,'','',0, default, default, 0, 0,86400,@ownerCompany,@ownerUserId)
	SET @providerId = ISNULL((SELECT id FROM UMDSProviders WITH (READUNCOMMITTED) WHERE hostname = @domainName ),0)
	DECLARE @errString			nvarchar(1024)
	DECLARE @errCode INT
DECLARE @TenantAdminGroupId int = ISNULL((SELECT id FROM umgroups WITH (NOLOCK) WHERE umdsProviderId=@ownerCompany AND groupFlags &  0x10000 = 0x10000),0)
DECLARE @userManagementRoleId int = ISNULL((SELECT id FROM UMRoles WITH (NOLOCK) WHERE (name = 'UserManagement_Owner') AND (flags & 128 <> 0)), 1)
EXEC sec_setCreatorForEntity @ownerUserId, @userManagementRoleId, '', @errCode OUTPUT, @errString OUTPUT, 61, @providerId, 0, 0, 0, 0, 0, 0, 0, 0, @TenantAdminGroupId
	-- Logic
	-- If you have valid company id - where you have actual parent company, then keep working the same logic
	-- If user have specified some different user group name, then we will also create that one.
	-- Newly created user will be added to that group
END
--- CODE Till HERE IS FROM AppCreateCustomDomain.spb  ----------
			-------------------------------------------------------------------------------------------------------------------------------------------
			--IF @providerId <> 0
			--BEGIN
			--	INSERT INTO @domainCreateTbl (providerId , customDomainName , defaultUserGroupId)
			--	SELECT @providerId,@domainName,@customDomainUserGroupId
			--END
		END
		FETCH FROM ProviderInfoCursor INTO @domainName, @ownerCompany,@ownerUserId,@defaultUserGroupName
	END
	CLOSE ProviderInfoCursor
	DEALLOCATE ProviderInfoCursor
	-- Update our main table to signify that domains have been created
	--UPDATE TT
	--	SET TT.providerId = DCT.providerId,
	--	TT.userGroupId = DCT.defaultUserGroupId,
	--	TT.isDomainExist=1
	--FROM @infoTbl TT
	--LEFT OUTER JOIN @domainCreateTbl DCT
	--	ON DCT.customDomainName=TT.customDomain AND TT.isDomainExist=0
	-- If Request wants us to create users too, then we can come up with common spb here
	--IF(@createOnlyDomainAndUserGroups = 0)
	--BEGIN
	--END
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode	 = ERROR_NUMBER()
	SET @errorStr  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
PROC_EXIT:
IF (@errorStr = '' OR @errorStr IS NULL) AND @errorCode = 0
	SET @errorStr = 'Success'
	SET @inXML = (SELECT @errorCode '@errorCode', @errorStr '@errorMessage' FOR XML PATH('Api_GenericResp'))
GO

IF EXISTS (select * from GxQscripts where name = 'AppCreateCustomDomains')
	delete from GxQscripts where name = 'AppCreateCustomDomains'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCreateCustomDomains')
	delete from GXDBVersions where aliasname = 'AppCreateCustomDomains'
GO

insert into GXDBVersions values(2, 'AppCreateCustomDomains',  '00000000000000000000', 'AppCreateCustomDomains', '00000000000000000000')
GO

