

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCreateCredentialAssocForEntity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2017  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCreateCredentialAssocForEntity.sp,v $ $Id: AppCreateCredentialAssocForEntity.sp,v 1.1.2.1 2018/06/26 05:47:12 aselvanayagam Exp $";
--
--  +========================================================================+
--  |   Procedure:  AppCreateCredentialAssocForEntity
--  |
--  | Description:  Creates an association between credential and caller entity
--  |
--  |       Input:  Entity Id, Entity Type, Credential Id, Flag to indicate an updation is requires
--  |
--  |      Output:  Credential assoc ID if a valid credential ID was passed
--  |
--  |      Notes:	None at this time
--  |
--  |   Revisions  Author			Description
--  |   ---------  -------			---------------------------------------------
--  |   1.1        aselvanayagam 	Stored procedure to create a credential association and update the creating entity with the association
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppCreateCredentialAssocForEntity <<<'

IF EXISTS (select * from sysobjects where name='AppCreateCredentialAssocForEntity')
	drop procedure AppCreateCredentialAssocForEntity
IF EXISTS (select * from GxQscripts where name='AppCreateCredentialAssocForEntity')
	delete from GxQscripts where name = 'AppCreateCredentialAssocForEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCreateCredentialAssocForEntity')
	delete from GXDBVersions where aliasname = 'AppCreateCredentialAssocForEntity'
GO
print '... Creating Procedure: AppCreateCredentialAssocForEntity'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure AppCreateCredentialAssocForEntity
  @i_entityId integer,
  @i_entityType integer,
  @i_credentialId integer,
  @i_updateEntity integer = 0
AS
  DECLARE @o_credentialAssocId integer
SET NOCOUNT ON
BEGIN
	IF EXISTS (SELECT 1 FROM APP_Credentials WHERE credentialId = @i_credentialId)
		BEGIN
			INSERT INTO APP_CredentialAssoc (credentialId, entityType, entityId)
			VALUES(@i_credentialId, @i_entityType, @i_entityId)
			SET @o_credentialAssocId = SCOPE_IDENTITY()
			-- Update the caller entity's table with the credential association Id
			-- Every time support for credential association is added to a new table / entity type
			-- the corresponding table can be updated here with the newly created association's Id
			IF @i_updateEntity > 0
				BEGIN
IF @i_entityType = 186
					BEGIN
						UPDATE MMDeviceController SET CredentialAssocId = @o_credentialAssocId WHERE DeviceControllerId = @i_entityId
					END
				END
			SELECT @o_credentialAssocId;
		END
	ELSE
		BEGIN
			SELECT -1;
		END
END
SET NOCOUNT OFF;
GO

IF EXISTS (select * from GxQscripts where name = 'AppCreateCredentialAssocForEntity')
	delete from GxQscripts where name = 'AppCreateCredentialAssocForEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCreateCredentialAssocForEntity')
	delete from GXDBVersions where aliasname = 'AppCreateCredentialAssocForEntity'
GO

insert into GXDBVersions values(2, 'AppCreateCredentialAssocForEntity',  '00010001000200010000', 'AppCreateCredentialAssocForEntity', '00010001000200010000')
GO

