

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCreateCompanySetPlans.sp] ---------- 

--  +==============================================================================+
--  |		 		 Name:  AppGetCreateCompanyEmailSetting
--  | Description:  This procedure will be used while creating a company. This will get email related settings
--  +==============================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCreateCompanySetPlans.sp,v $ $Id: AppCreateCompanySetPlans.sp,v 1.1.2.2 2020/06/16 16:58:53 jswaminathan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppCreateCompanySetPlans')
BEGIN
	print '>>> Drop Stored Procedure: AppCreateCompanySetPlans <<<'
	drop procedure AppCreateCompanySetPlans
END
IF EXISTS (select * from GxQscripts where name='AppCreateCompanySetPlans')
	delete from GxQscripts where name = 'AppCreateCompanySetPlans'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCreateCompanySetPlans')
	delete from GXDBVersions where aliasname = 'AppCreateCompanySetPlans'
GO
print '... Creating Procedure: AppCreateCompanySetPlans'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCreateCompanySetPlans
  @companyId INTEGER,
  @userId INTEGER,
  @i_companyProperties XML,
  @tenantAdminGroupId INT,
  @tenantOperatorGroupId INT,
  @localeId INTEGER,
  @companyClientGroupId INT OUTPUT,
  @errCode int OUTPUT,
  @errString NVARCHAR(MAX) OUTPUT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @errCode =0
SET @errString  =''
DECLARE @quotasize INT = 100
DECLARE @nowTime INT = dbo.GetUnixTime(GETUTCDATE())
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF @i_companyProperties.exist('Api_OrganizationInfo/planDetails') = 0
BEGIN
    GOTO SCRIPT_EXIT
END
-- To remove when checkin:
--declare @_stTime datetime2(7) = sysdatetime()
DECLARE @tempPlansToAdd TABLE (planId INT PRIMARY KEY)
INSERT INTO @tempPlansToAdd
SELECT t.ref3.value('@planId', 'INT')
FROM @i_companyProperties.nodes('Api_OrganizationInfo') R ( ref )
            OUTER APPLY ref.nodes('planDetails') S(ref2)
			OUTER APPLY ref2.nodes('plan') t(ref3)
DECLARE @tenantAdminRoleId int = ISNULL((SELECT id FROM UMRoles WHERE (flags & 256 <> 0)), 1)
		-- Add more check here
	-- company can get a plan which is owned by Commcell or actual company
	DECLARE @planNotAllowed NVARCHAR(MAX)
	declare @planNotAllowedCount INT  = 0
--SELECT @planNotAllowed = COALESCE(@planNotAllowed + ' ,', '') + AP.name, @planNotAllowedCount=@planNotAllowedCount + 1 FROM  @tempPlansToAdd TP
SELECT @planNotAllowed = COALESCE(@planNotAllowed + ' ,', '') + AP.name, @planNotAllowedCount=SUM(COUNT(AP.name))  OVER() FROM  @tempPlansToAdd TP
INNER JOIN APP_Plan AP
	ON AP.id=TP.planId
WHERE dbo.AppGetOrganizationForUser(AP.ownerId) NOT IN (0 /*Commcell company Id*/, @companyId)
GROUP BY AP.name
IF @planNotAllowed IS NOT NULL
BEGIN
	IF @planNotAllowedCount = 1
	BEGIN
		--Error Setting plan. Plan(s) '^1%s' is/are owned by another company.
SET @errCode = (3931 | (CAST(POWER(2, 24) AS BIGINT) * 35))
	END
	ELSE
	BEGIN
		--Error Setting plan. Plans '^1%s' are owned by another companies.
SET @errCode = (3932 | (CAST(POWER(2, 24) AS BIGINT) * 35))
	END
	SET @errString =  (SELECT message FROM EvLocaleMsgs WHERE messageId = @errCode AND localeId = @localeId)
	SET @errString = REPLACE(@errString, '^1%s', @planNotAllowed)
    GOTO SCRIPT_EXIT
END
-- Security associations for tenant admin and tenant operator user groups.
-- Associate the plan with View and Use plan permissions.
-- Give them Create... permissions on Commcell.
--declare @_stTime1 datetime2(7) = sysdatetime()
BEGIN
	DECLARE @planSubscriptionRoleId INT
SELECT @planSubscriptionRoleId = id FROM UMRoles (NOLOCK) WHERE	flags & (64) <> 0	AND name = 'Plan Subscription Role'
	IF OBJECT_ID('tempdb.dbo.#SecurityAssociations_CreateCompanySetPlans') IS NOT NULL
		DROP TABLE #SecurityAssociations_CreateCompanySetPlans
	CREATE TABLE #SecurityAssociations_CreateCompanySetPlans
	(
		isuser INT,
		userOrGroupId INT,
		roleId INT,
		permissionId INT,
		entityType INT,
		entityId INT
	)
	CREATE CLUSTERED INDEX SecurityAssociationsIdx1_CreateCompanySetPlans ON #SecurityAssociations_CreateCompanySetPlans (isUser, userOrGroupId);;
	INSERT INTO #SecurityAssociations_CreateCompanySetPlans (isUser, userOrgroupId, roleId, permissionId, entityType, entityId)
SELECT 0, @tenantAdminGroupId, 0, 31, 158, planId
		FROM @tempPlansToAdd
	UNION ALL
SELECT 0, @tenantAdminGroupId, 0, 159, 158, planId
		FROM @tempPlansToAdd
	UNION ALL
SELECT 0, @tenantAdminGroupId, @planSubscriptionRoleId, 0, 158, planId
		FROM @tempPlansToAdd
	UNION ALL -- Associate tenant operator also with the same permissions as above.
SELECT 0, @tenantOperatorGroupId, 0, 31, 158, planId
		FROM @tempPlansToAdd
	UNION ALL
SELECT 0, @tenantOperatorGroupId, 0, 159, 158, planId
		FROM @tempPlansToAdd
	UNION ALL
SELECT 0, @tenantOperatorGroupId, @planSubscriptionRoleId, 0, 158, planId
		FROM @tempPlansToAdd
	INSERT INTO UMSecurityAssociations (isUser, userOrgroupId, roleId, permissionId, entityType1, entityId1, authorId, companyId)
		SELECT Tbl.isUser, Tbl.userOrGroupId, Tbl.roleId, Tbl.permissionId, Tbl.entityType, Tbl.entityId, @userId, @companyId
		FROM #SecurityAssociations_CreateCompanySetPlans Tbl
			LEFT JOIN UMSecurityAssociations Sec (NOLOCK)
				ON Tbl.isUser = Sec.isUser AND Tbl.userOrgroupId = Sec.userOrGroupId
				AND Tbl.roleId = Sec.roleId AND Tbl.permissionId = Sec.permissionId
				AND Tbl.entityType = Sec.entityType1 AND Tbl.entityId = Sec.entityId1
		WHERE
			Sec.isUser IS NULL
END
--print 'Time taken for security region in AppCreateCompanySetPlans:[' + cast(datediff(ms,@_stTime1,sysdatetime()) as varchar(10)) + ']'
	DECLARE @setDefaultPlan INT = ISNULL((SELECT 1 FROM	GXGlobalParam WITH(NOLOCK) WHERE name=N'Set Default Plan Automatically' AND value=N'1' AND modified=0),0)
--Domain and sub domain information, Plan information.
--The plans will be save as default plans for the company. We will only set Server, Laptop, FS and DB plan as default plan if the user has given one of them.
DECLARE @tempSetTable table(componentId int, propertyAttrName nvarchar(255), stringVal NVARCHAR(max), attrType INT)
	INSERT INTO @tempSetTable (componentId, propertyAttrName, stringVal, attrType)
SELECT distinct @companyId , CA.propertyTypId, CA.Value, CA.attrtype
FROM @i_companyProperties.nodes('Api_OrganizationInfo') R ( ref )
             	OUTER APPLY ref.nodes('organizationProperties') S(ref2)
			OUTER APPLY ref2.nodes('additionalDomains') T(ref3)
			OUTER APPLY ref.nodes('planDetails') U(ref4)
			  	OUTER APPLY ref4.nodes('plan') v(ref5)
CROSS APPLY (
SELECT case u.ref4.value('@subtype','NVARCHAR(MAX)')
WHEN 33554437 THEN 'Default Server Plan'
WHEN 33554439 THEN 'Default Laptop Plan'
WHEN 50331655 THEN 'Default File System Plan'
WHEN 33579013  THEN 'Default DB Plan'
END AS propertyTypId, v.ref5.value('@planId','NVARCHAR(MAX)') AS Value, 7 AS attrType
FROM app_plan WHERE id = v.ref5.value('@planId','NVARCHAR(MAX)') AND ((flag & 0x00004) = 0) AND ((flag & 0x40000000) = 0) AND @setDefaultPlan=1
		) CA
WHERE ca.Value is not null AND CA.propertyTypId IS NOT NULL
--check for duplicate plan subtypes and remove them from the temp table. we will only save one plan as default company plan for a given subtype of a plan.
;WITH CTE
    AS
    (
        SELECT ROW_NUMBER() OVER ( PARTITION BY componentId,  propertyAttrName ORDER BY propertyAttrName DESC ) AS 'RowNumber'
FROM @tempSetTable T WHERE propertyAttrName IN ('Default Server Plan','Default Laptop Plan','Default File System Plan','Default DB Plan')
    )
    DELETE FROM cte
WHERE  RowNumber <> 1;
INSERT INTO App_CompanyProp (componentNameId,  attrName, attrType, attrVal, created, modified)
SELECT @companyId, propertyAttrName, attrType, stringVal, @nowTime, 0
FROM @tempSetTable
SCRIPT_EXIT:
SET NOCOUNT OFF
--print 'Time taken for AppCreateCompanySetPlans:[' + cast(datediff(ms,@_stTime,sysdatetime()) as varchar(10)) + ']'
GO

IF EXISTS (select * from GxQscripts where name = 'AppCreateCompanySetPlans')
	delete from GxQscripts where name = 'AppCreateCompanySetPlans'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCreateCompanySetPlans')
	delete from GXDBVersions where aliasname = 'AppCreateCompanySetPlans'
GO

insert into GXDBVersions values(2, 'AppCreateCompanySetPlans',  '00010001000200020000', 'AppCreateCompanySetPlans', '00010001000200020000')
GO

