

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCreateCompanySetInitialProperties.sp] ---------- 

--  +==============================================================================+
--  |		 		 Name:  AppGetCreateCompanyEmailSetting
--  | Description:  This procedure will be used while creating a company. This will get email related settings
--  +==============================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCreateCompanySetInitialProperties.sp,v $ $Id: AppCreateCompanySetInitialProperties.sp,v 1.1.2.6.4.2 2021/03/05 00:45:17 nshah Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppCreateCompanySetInitialProperties')
BEGIN
	print '>>> Drop Stored Procedure: AppCreateCompanySetInitialProperties <<<'
	drop procedure AppCreateCompanySetInitialProperties
END
IF EXISTS (select * from GxQscripts where name='AppCreateCompanySetInitialProperties')
	delete from GxQscripts where name = 'AppCreateCompanySetInitialProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCreateCompanySetInitialProperties')
	delete from GXDBVersions where aliasname = 'AppCreateCompanySetInitialProperties'
GO
print '... Creating Procedure: AppCreateCompanySetInitialProperties'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppCreateCompanySetInitialProperties
  @i_userId INTEGER,
  @i_localeId INTEGER,
  @i_companyId INTEGER,
  @companyName NVARCHAR(4000),
  @companyClientGroupId INT,
  @companyTenantAdminGroupId INT,
  @companyTenantOperatorGroupId INT,
  @companyTenantAdminUserId INT,
  @i_companyProperties XML,
  @i_isCompanyWithoutTenantAdmin INT
AS
  DECLARE @errorCode int
  DECLARE @errorString NVARCHAR(1024) 
-- To remove when checkin:
--declare @_stTime datetime2(7) = sysdatetime()
 SET @errorCode =0
  SET @errorString =''
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @nowTime  INT = dbo.GetUnixTime(GETUTCDATE())
	DECLARE @webconsoleClients  table(clientId int)
	 DECLARE @authCodeEnabled INT = 0
    SET @authCodeEnabled = ISNULL((select ref.value('@enableAuthCodeGen','INT') from @i_companyProperties.nodes('Api_OrganizationInfo/organizationProperties') R (ref)),0)
	-- During Company creation enable TFA if its enabled at Commcell Level.
	DECLARE @tfaCommcell INT = ISNULL((select Convert(int, value) from GxGlobalParam WITH (NOLOCK) where Name = 'EnableTwoFactorAuthentication'), 0)
	DECLARE @enableTFA INT = 0
    SET @enableTFA = ISNULL((select ref.value('@enableTwoFactorAuthentication','INT') from @i_companyProperties.nodes('Api_OrganizationInfo/organizationProperties') R (ref)),
							(CASE WHEN @tfaCommcell = 1 THEN 1 ELSE 0 END))
	DECLARE @vOrgName NVARCHAR(256) = (SELECT ref.value('@vOrgName','NVARCHAR(256)') from @i_companyProperties.nodes('Api_OrganizationInfo/organizationProperties') R (ref))
	DECLARE @vOrgGUID NVARCHAR(128) = (SELECT ref.value('@vOrgGuid','NVARCHAR(128)') from @i_companyProperties.nodes('Api_OrganizationInfo/organizationProperties') R (ref))
	DECLARE @salesforceCustomerId NVARCHAR(256) = (SELECT ref.value('@salesforceCustomerId','NVARCHAR(256)') from @i_companyProperties.nodes('Api_OrganizationInfo/organizationProperties') R (ref))
	DECLARE @contractId NVARCHAR(256) = (SELECT ref.value('@contractId','NVARCHAR(256)') from @i_companyProperties.nodes('Api_OrganizationInfo/organizationProperties') R (ref))
	DECLARE @quotaVMCount INT = (SELECT ref.value('@quotaVMCount','INT') from @i_companyProperties.nodes('Api_OrganizationInfo/organizationProperties') R (ref))
	DECLARE @quotaUserCount INT = (SELECT ref.value('@quotaUserCount','INT') from @i_companyProperties.nodes('Api_OrganizationInfo/organizationProperties') R (ref))
	DECLARE @enableAutoDiscovery INT = ISNULL((select ref.value('@enableAutoDiscovery','INT') from @i_companyProperties.nodes('Api_OrganizationInfo/organizationProperties') R (ref)),0)
	DECLARE @enableEDiscoveryForLaptopRequest INT = (select ref.value('@enableEDiscoveryForLaptop','INT') from @i_companyProperties.nodes('Api_OrganizationInfo/organizationProperties') R (ref))
	DECLARE @enableEDiscoveryForO365Request INT = (select ref.value('@enableEDiscoveryForO365','INT') from @i_companyProperties.nodes('Api_OrganizationInfo/organizationProperties') R (ref))
	IF object_id('tempdb.dbo.#OrgPropTbl') IS NOT null DROP TABLE #OrgPropTbl
	CREATE TABLE #OrgPropTbl
    (   componentNameId     integer,
        attrName            varchar(256),
        attrType            integer,
        attrVal             nvarchar(MAX) NOT NuLl,
        created             INT,
        modified            INT
	)
	--Insert Creation Time for the company in app_companyprop table
	INSERT into #OrgPropTbl(componentNameId, attrName, attrType, attrVal, created, modified) values
	(@i_companyId, 'Creation Time', 7, @nowTime, @nowTime, 0),
	(@i_companyId, 'Enable Auth Code Generation', 7, @authCodeEnabled, @nowTime, 0),
	(@i_companyId, 'API Quota Limit', 7, 0, @nowTime, 0),
	(@i_companyId, 'API Quota Time Frame', 7, 0, @nowTime, 0),
	(@i_companyId, 'EnableTwoFactorAuthentication', 7, @enableTFA, @nowTime, 0)
	-- Set salesforceCustomerId, contractId, quotaVMCount & quotaUserCount if set in the request
IF (@salesforceCustomerId IS NOT NULL)
	BEGIN
		INSERT into #OrgPropTbl(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@i_companyId,  'Salesforce Customer Id', 1, @salesforceCustomerId, @nowTime, 0)
	END
IF (@contractId IS NOT NULL)
	BEGIN
		INSERT into #OrgPropTbl(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@i_companyId, 'Contract Id', 1, @contractId, @nowTime, 0)
	END
IF (@quotaVMCount IS NOT NULL)
	BEGIN
		INSERT into #OrgPropTbl(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@i_companyId, 'License Usage VM Count', 7, @quotaVMCount, @nowTime, 0)
	END
IF (@quotaUserCount IS NOT NULL)
	BEGIN
		INSERT into #OrgPropTbl(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@i_companyId, 'License Usage User Count', 7, @quotaUserCount, @nowTime, 0)
	END
	-- Set VorgName and Vorg GUID if set in the request
IF (@vOrgName IS NOT NULL)
	BEGIN
		INSERT into #OrgPropTbl(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@i_companyId, 'vOrg Name', 1, @vOrgName, @nowTime, 0)
	END
IF (@vOrgGUID IS NOT NULL)
	BEGIN
		INSERT into #OrgPropTbl(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@i_companyId,  'vOrg Guid', 1, @vOrgGUID, @nowTime, 0)
	END
	--------------------------------- START - Ediscovery Code----------------------------------------------------------------
	-- Call code to setup Ediscovery for Company before processing company properties
	-- SP takes care of handling empty input
	-- No need to call below SP as this is company creation. No client exist at this time for this company
	-- Keeping below code which will need to be uncommented in case we support passing client id as part of company creation
	-- EXEC dbo.AppSetEDiscoveryForCompany @i_companyId, '', @i_companyProperties , @errorCode OUTPUT, @errorString OUTPUT
	--Setup actual DB values
	IF (@enableEDiscoveryForLaptopRequest IS NOT NULL)
	BEGIN
		INSERT into #OrgPropTbl(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@i_companyId,  'Enable eDiscovery for Laptop', 7, @enableEDiscoveryForLaptopRequest, @nowTime, 0)
	END
	IF (@enableEDiscoveryForO365Request IS NOT NULL)
	BEGIN
		INSERT into #OrgPropTbl(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@i_companyId,  'Enable eDiscovery for O365', 7, @enableEDiscoveryForO365Request, @nowTime, 0)
	END
	--------------------------------- START - Ediscovery Code----------------------------------------------------------------
	-- If enableAutoDiscovery is set when creating company, we need to add the following additional setting to corresponding client group of the company
	IF @enableAutoDiscovery <> 0
	BEGIN
		DECLARE @tmpRecordTable TABLE (id INT)
		INSERT INTO APP_AdvanceSettings (entityId, keyName, type, relativePath, value, enabled, deleted, entityType, sourceId, sourceEntityType)
		OUTPUT Inserted.id INTO @tmpRecordTable
VALUES (@companyClientGroupId, 'nEnableAutoDetectApp', 'INTEGER', 'iDataAgent', '2', 1, 0, 28, 0, 0)
		INSERT INTO APP_AdvanceSettingsEx(keyId, details, hidden)
		SELECT TOP 1 id, '', 1 FROM @tmpRecordTable
	END
	DECLARE @setDefaultPlan INT = ISNULL((SELECT 1 FROM	GXGlobalParam WITH(NOLOCK) WHERE name=N'Set Default Plan Automatically' AND value=N'1'),0)
	--Domain and sub domain information, Plan information.
	--The plans will be save as default plans for the company. We will only set Server, Laptop, FS and DB plan as default plan if the user has given one of them.
	DECLARE @tempSetTable table(componentId int, propertyAttrName nvarchar(255), stringVal NVARCHAR(max), attrType INT)
		INSERT INTO @tempSetTable (componentId, propertyAttrName, stringVal, attrType)
    SELECT distinct @i_companyId , CA.propertyTypId, CA.Value, CA.attrtype
    FROM @i_companyProperties.nodes('Api_OrganizationInfo') R ( ref )
             	 OUTER APPLY ref.nodes('organizationProperties') S(ref2)
			 OUTER APPLY ref2.nodes('additionalDomains') T(ref3)
	CROSS APPLY (
SELECT 'Primary Domain'  AS propertyTypId,  S.ref2.value('@primaryDomain','NVARCHAR(MAX)') AS Value, 1 AS attrType WHERE  S.ref2.value('@primaryDomain','NVARCHAR(MAX)') <> '' UNION ALL
SELECT 'Sub Domain' AS propertyTypId,  T.ref3.value('@val','NVARCHAR(MAX)') AS Value, 1 AS attrType
		  ) CA
	WHERE ca.Value is not null AND CA.propertyTypId IS NOT NULL
	--Check for duplicate domain or sub domain name
	DECLARE @DomainTbl TABLE (
                                DomainName NVARCHAR(MAX)
                             )
	INSERT INTO @DomainTbl
	SELECT S.Data from
	(SELECT attrVal FROM App_CompanyProp where attrName  in ('Sub Domain', 'Primary Domain') AND componentNameId<>@i_companyId) C
		CROSS APPLY dbo.SplitString(C.attrVal, ',') S
	IF EXISTS (SELECT 1 from  @DomainTbl WHERE DomainName IN (SELECT stringVal FROM @tempSetTable))
	BEGIN
SET @errorCode = (3213 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3213 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @i_localeId)
		GOTO EXIT_ERROR
	END
	DECLARE @SubDomainStr nvarchar(max)
	SET  @SubDomainStr=(SELECT STUFF(( SELECT ',' + stringVal
		FROM @tempSetTable where propertyAttrName='Sub Domain'
              FOR
                XML PATH('')
              ), 1, 1, '') AS domainList)
	--delete the rows for sub domain and now add the comma seperated strings for sub domains
	DELETE @tempSetTable where propertyAttrName='Sub Domain'
	IF(@SubDomainStr is not null)
	BEGIN
		INSERT INTO @tempSetTable
SELECT distinct @i_companyId ,'Sub Domain', @SubDomainStr,1
	END
	INSERT INTO #OrgPropTbl (componentNameId,  attrName, attrType, attrVal, created, modified)
	SELECT @i_companyId, propertyAttrName, attrType, stringVal, @nowTime, 0
	FROM @tempSetTable
IF EXISTS (SELECT 1 FROM @tempSetTable where propertyAttrName in ('Primary Domain' , 'Sub Domain'))
	BEGIN
		INSERT INTO @webconsoleClients
		SELECT c.id
			FROM app_client c
INNER JOIN simInstalledPackages sim ON c.id = sim.ClientId AND sim.simPackageID IN (726,1135)
		LEFT JOIN App_VMToPMMAp vm ON vm.PMClientId=c.id WHERE VMClientId is null
		UNION
		SELECT vm.VMClientId
		FROM app_client c
		INNER JOIN App_VMToPMMAp vm ON c.id=PMClientId
INNER JOIN simInstalledPackages sim ON c.id = sim.ClientId AND sim.simPackageID IN (726,1135)
			INSERT INTO APP_AdvanceSettings (entityId, keyName, type, relativePath, value, enabled, deleted, entityType, sourceId, sourceEntityType)
			SELECT C.clientId, stringVal,'STRING', 'WebConsole\Customization',cast( @i_companyId as nvarchar), 1,0,3,0,0
			FROM @tempSetTable T , @webconsoleClients C
WHERE propertyAttrName in ('Primary Domain' ,  'Sub Domain')
			AND  NOT EXISTS (SELECT 1 FROM APP_AdvanceSettings A WHERE C.clientId = A.entityId AND A.keyName=T.stringVal AND type='STRING' AND A.relativePath='WebConsole\Customization')
			--now mark the keys hidden
			INSERT INTO APP_AdvanceSettingsEx(keyId  , details, hidden)
			SELECT id, '', 1 from APP_AdvanceSettings WHERE relativePath='WebConsole\Customization' AND value LIKE CAST(@i_companyId AS NVARCHAR(MAX))
            INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
            SELECT clientId, 6 /*WORK_TOKEN_REGISTRY*/, '', @nowTime, 0, 0, 0, -1
            FROM @webconsoleClients
	END
Declare @emailDomains TABLE (emailDomain nvarchar(512))
INSERT INTO @emailDomains select distinct ref.value('@val','nvarchar(255)') from @i_companyProperties.nodes('Api_OrganizationInfo/organization/emailDomainNames') R (ref)
INSERT INTO UMDSProviderProp (componentNameId,attrName,attrType,attrVal,created,modified) select  @i_companyId,'Email Domain','1',emailDomain,@nowTime,0 from @emailDomains where emailDomain <> ''
--now insert the properties computed
INSERT INTO APP_companyprop(componentNameId, attrName, attrType, attrVal, created, modified)
SELECT componentNameId, attrName, attrType, attrVal, created, modified FROM #OrgPropTbl
EXEC [dbo].[AppCreateCompanySetPlans]  @i_companyId, @i_userId, @i_companyProperties, @companyTenantAdminGroupId, @companyTenantOperatorGroupId, @i_localeId, @companyClientGroupId, @errorCode OUTPUT, @errorString OUTPUT
IF(@errorCode >0)
BEGIN
	GOTO EXIT_ERROR
END
DECLARE @dontCreateOrganizationAlerts INT = 0
SELECT @dontCreateOrganizationAlerts = value FROM GXGlobalParam (NOLOCK) WHERE name='disableDefaultOrganizationAlerts' AND Modified = 0
-- If key is not there to disable/not create default organization alerts, then create default organization alerts
IF @dontCreateOrganizationAlerts = 0
BEGIN
    EXEC NTCreateDefaultAlertsForOrganization @companyTenantAdminGroupId, @companyTenantAdminUserId, @companyClientGroupId, @errorCode OUTPUT, @errorString OUTPUT
END
EXIT_ERROR:
	SELECT @errorCode, @errorString
SET NOCOUNT OFF
--print 'Time taken for AppCreateCompanySetInitialProperties:[' + cast(datediff(ms,@_stTime,sysdatetime()) as varchar(10)) + ']'
GO

IF EXISTS (select * from GxQscripts where name = 'AppCreateCompanySetInitialProperties')
	delete from GxQscripts where name = 'AppCreateCompanySetInitialProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCreateCompanySetInitialProperties')
	delete from GXDBVersions where aliasname = 'AppCreateCompanySetInitialProperties'
GO

insert into GXDBVersions values(2, 'AppCreateCompanySetInitialProperties',  'v1.1.2.6.4.2', 'AppCreateCompanySetInitialProperties', 'v1.1.2.6.4.2')
GO

