

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCreateCompanyEmailSettings.sp] ---------- 

--  +==============================================================================+
--  |		 		 Name:  AppGetCreateCompanyEmailSetting
--  | Description:  This procedure will be used while creating a company. This will get email related settings
--  +==============================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCreateCompanyEmailSettings.sp,v $ $Id: AppCreateCompanyEmailSettings.sp,v 1.1.2.7 2020/04/30 22:28:15 nshah Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppCreateCompanyEmailSettings')
BEGIN
	print '>>> Drop Stored Procedure: AppCreateCompanyEmailSettings <<<'
	drop procedure AppCreateCompanyEmailSettings
END
IF EXISTS (select * from GxQscripts where name='AppCreateCompanyEmailSettings')
	delete from GxQscripts where name = 'AppCreateCompanyEmailSettings'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCreateCompanyEmailSettings')
	delete from GXDBVersions where aliasname = 'AppCreateCompanyEmailSettings'
GO
print '... Creating Procedure: AppCreateCompanyEmailSettings'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCreateCompanyEmailSettings
  @i_tenantAdminUserId INTEGER,
  @i_companyName NVARCHAR(255),
  @i_templateId INT,
  @i_pwd NVARCHAR(400),
  @i_localeId INT
AS
  DECLARE @CompanyCreateEmailSettings XML
  DECLARE @CompanyCreationEmailTo NVARCHAR(MAX)
  DECLARE @CompanyCreationEmailCC NVARCHAR(MAX)
  DECLARE @CompanyCreateEmailBody NVARCHAR(MAX)
  DECLARE @CompanyCreateEmailSub NVARCHAR(MAX)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @WebConsoleURL NVARCHAR(MAX)
DECLARE @adminEmail NVARCHAR(510)
DECLARE @adminName NVARCHAR(510)
DECLARE @adminConsoleURL NVARCHAR(MAX)
DECLARE @downloadCenterURL NVARCHAR(MAX)
DECLARE @templateTypeId int
DECLARE @email nvarchar(255)
DECLARE @name nvarchar(255)
DECLARE @sessionid VARCHAR(255)
DECLARE @qsdkSessionId  VARCHAR(255)
DECLARE @passwordLink NVARCHAR(max) = ''
DECLARE @sessionTable TABLE (errorCode       int, guidOut         VARCHAR(255))
--This stored procedure will return both the types of email setting, to support the backward compatibility(<sp12) we will use  @CompanyCreationEmailTo, @CompanyCreationEmailCC,@CompanyCreateEmailBody,@CompanyCreateEmailSub variables and
--for email template @CompanyCreateEmailSettings variable will be used. Populating both here to avoid making duplicate DB queries for the properties.
DECLARE @strEmailTemplate   NVARCHAR(MAX) = '<!doctype html><html>  <head/>  <body> <div style="width: 600px;padding: 0;margin: 0 auto;text-align: center;text-align:-moz-center;
   text-align:-webkit-center;border:0;">  <table border="0" cellpadding="0" cellspacing="0" bgcolor="#ffffff" width="600" style="color: #666;background: #ffffff;width: 600px;border:0;">
    <tbody>  <tr>  <td width="100%" valign="middle" bgcolor="#ffffff" style="color: #666666;background: #ffffff;vertical-align: middle;font-family: Helvetica, Arial,
	 sans-serif;font-size: 1.5em;line-height: 1.25em;text-align: left;padding: 0;margin:0;">  <p style="font-family: Helvetica, Arial, sans-serif;font-size: 1.5em;
	  margin: 0;padding:0;text-transform: uppercase;font-weight: bold;">commvault</p>  <hr width="100%" noshade="noshade" size="1" color="#666666" style="height: 1px;" /> </td> </tr>  <tr>
	   <td>&nbsp;</td> </tr>  <tr> <td width="100%" valign="middle" bgcolor="#ffffff" style="color: #666666;background: #ffffff;vertical-align: middle;font-size: 1em;line-height: 1.2em;
	   text-align: left;font-family: Helvetica, Arial, sans-serif;">$MESSAGE_CONTENT
       </td> </tr> </tbody>  </table></div></body></html>'
 SET @strEmailTemplate = ISNULL((SELECT CAST(value AS NVARCHAR(MAX)) FROM GXGlobalParam(NOLOCK) WHERE name = 'InviteEmailMessageTemplate' AND modified = 0), @strEmailTemplate)
SELECT @adminEmail=email, @adminName=name FROM umusers WHERE flags & 0x040  <> 0--0x040
SELECT @templateTypeId=typeId from App_EmailTemplateType where name='ADD_COMPANY'
SELECT @email=email, @name=name FROM umusers WHERE id=@i_tenantAdminUserId
SET @sessionid = CAST(NEWID() AS VARCHAR(255))
DECLARE @timeoutInMins int = ISNULL((SELECT CAST(value as int) from GXGlobalParam WITH (NOLOCK) WHERE name = 'ChangePasswordLinkExpirationTimeInMinutes'), 4320)--72 hours
DECLARE @timeoutInHoursMins nvarchar(50)=''
SET @timeoutInHoursMins = (SELECT dbo.AppGetTimeOutFormatedString(@timeoutInMins, @i_localeId))
INSERT INTO @sessionTable
EXEC QSDK_CreateSession @sessionid,@i_tenantAdminUserId, '',16, @timeoutInMins-- EC_API
SET @qsdkSessionId = (SELECT guidOut FROM @sessionTable)
DECLARE @encryptedSessionId nvarchar(max)
EXEC dbo.pswEncryptionManaged @qsdkSessionId , @encryptedSessionId OUTPUT
IF object_id('tempdb.dbo.#tempGXGlobalParamObjects') IS NOT Null DROP TABLE #tempGXGlobalParamObjects
CREATE TABLE #tempGXGlobalParamObjects(name nvarchar(max), val nvarchar(max))
INSERT INTO #tempGXGlobalParamObjects
SELECT name, value from GXGlobalParam where name in ('WebConsoleURL', 'CompanyCreationEmailTo','CompanyCreationEmailCC','CompanyCreateEmailBody', 'CompanyCreateEmailSub') and modified=0
SELECT @WebConsoleURL=val FROM #tempGXGlobalParamObjects WHERE name='WebConsoleURL'
SELECT @CompanyCreationEmailTo=val FROM #tempGXGlobalParamObjects WHERE name='CompanyCreationEmailTo'
SELECT @CompanyCreationEmailCC=val FROM #tempGXGlobalParamObjects WHERE name='CompanyCreationEmailCC'
SELECT @CompanyCreateEmailBody=val FROM #tempGXGlobalParamObjects WHERE name='CompanyCreateEmailBody'
SET @adminConsoleURL = (SELECT SUBSTRING(@webConsoleURL,1,(CHARINDEX('/webconsole',@webConsoleURL)-1))+'/adminconsole')
SET @webConsoleURL = (SELECT SUBSTRING(@webConsoleURL, 1, (CHARINDEX('/webconsole', @webConsoleURL) - 1)) + '/webconsole')
SET @downloadCenterURL = @WebConsoleURL + '/downloadcenter/dc.do';
SET @passwordLink = @webConsoleURL + '/login/resetPassword.jsp?app=1&tk=' + @encryptedSessionId;
SELECT @CompanyCreateEmailSettings = (
SELECT @templateTypeId as '@templateTypeId', (SELECT @i_templateId AS '@emailTemplateId'  FOR XML PATH('template'),type)
, (SELECT 'RECIPIENT_NAME' as '@name', @name as '@value' for xml path('tokenValues'), type)
, (SELECT 'TENANT_COMPANY_NAME' as '@name', @i_companyName as '@value' for xml path('tokenValues'), type)
, (SELECT 'CHANGE_PASSWORD_LINK' as '@name', @passwordLink as '@value' for xml path('tokenValues'), type)
, (SELECT 'DOWNLOADCENTER_URL' as '@name', @downloadCenterURL as '@value' for xml path('tokenValues'), type)
, (SELECT 'USERNAME' as '@name', @email as '@value' for xml path('tokenValues'), type)
, (SELECT 'ADMINISTRATOR_EMAIL' as '@name', @adminEmail as '@value' for xml path('tokenValues'), type)
, (SELECT 'ADMINISTRATOR_NAME' as '@name', @adminName as '@value' for xml path('tokenValues'), type)
, (SELECT 'ADMINCONSOLE_URL' as '@name', @adminConsoleURL as '@value' for xml path('tokenValues'), type)
, (SELECT 'CHANGE_PASSWORD_LINK_EXPIRATION' as '@name', @timeoutInHoursMins as '@value' for xml path('tokenValues'), type)
,(SELECT @email as '@val' for xml path('toEmails'), type)
FOR XML PATH('Api_SendEmailTemplateMailRequest'))
--need for backward compatibility
DECLARE @existingDecrptPwd NVARCHAR(400)
EXEC miscProc2 @I_pwd,@existingDecrptPwd  OUTPUT
if(@CompanyCreateEmailBody is null)
BEGIN
SET @CompanyCreateEmailBody = (SELECT Message FROM EvLocaleMsgs WHERE MessageID=(3211 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and LocaleID=@i_localeId)
    SET @CompanyCreateEmailBody = REPLACE(@CompanyCreateEmailBody,  '[^1%s]', @name)
	SET @CompanyCreateEmailBody = REPLACE(@CompanyCreateEmailBody,  '[^2%s]', @i_companyName)
	SET @CompanyCreateEmailBody = REPLACE(@CompanyCreateEmailBody,  '[^3%s]', '<a style="color: #00a3d4; font-family: Verdana, Helvetica, sans-serif;" href="{@LINK}">Admin Console</a>')
	SET @CompanyCreateEmailBody = REPLACE(@CompanyCreateEmailBody,  '{@LINK}', @adminConsoleURL)
	SET @CompanyCreateEmailBody = REPLACE(@CompanyCreateEmailBody,  '[^4%s]', @email)
	SET @CompanyCreateEmailBody = REPLACE(@CompanyCreateEmailBody,  '[^5%s]', @existingDecrptPwd)
	SET @CompanyCreateEmailBody = REPLACE(@CompanyCreateEmailBody,  '[^6%s]', @adminEmail)
	SET @CompanyCreateEmailBody = REPLACE(@strEmailTemplate,  '$MESSAGE_CONTENT', @CompanyCreateEmailBody)
END
ELSE
BEGIN
    SET @CompanyCreateEmailBody = REPLACE(@CompanyCreateEmailBody,  '$NAME', @name)
	SET @CompanyCreateEmailBody = REPLACE(@CompanyCreateEmailBody,  '$COMPANY_NAME', @i_companyName)
	SET @CompanyCreateEmailBody = REPLACE(@CompanyCreateEmailBody,  '$URL', '<a style="color: #00a3d4; font-family: Verdana, Helvetica, sans-serif;" href="{@LINK}">Admin Console</a>')
	SET @CompanyCreateEmailBody = REPLACE(@CompanyCreateEmailBody,  '{@LINK}', @adminConsoleURL)
	SET @CompanyCreateEmailBody = REPLACE(@CompanyCreateEmailBody,  '$EMAIL', @email)
	SET @CompanyCreateEmailBody = REPLACE(@CompanyCreateEmailBody,  '$PASSWORD', @existingDecrptPwd)
	SET @CompanyCreateEmailBody = REPLACE(@CompanyCreateEmailBody,  '$ADMIN_EMAIL', @adminEmail)
END
SELECT @CompanyCreateEmailSub=val FROM #tempGXGlobalParamObjects WHERE name='CompanyCreateEmailSub'
IF(@CompanyCreateEmailSub is null)
BEGIN
SET @CompanyCreateEmailSub = (SELECT Message FROM EvLocaleMsgs WHERE MessageID=(3212 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and LocaleID=@i_localeId)
	SET @CompanyCreateEmailSub = REPLACE(@CompanyCreateEmailSub,  '[^1%s]', @i_companyName)
END
ELSE
BEGIN
	SET @CompanyCreateEmailSub = REPLACE(@CompanyCreateEmailSub,  '$COMPANY_NAME', @i_companyName)
END
SELECT  @CompanyCreateEmailSettings,@CompanyCreationEmailTo, @CompanyCreationEmailCC,@CompanyCreateEmailBody,@CompanyCreateEmailSub
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppCreateCompanyEmailSettings')
	delete from GxQscripts where name = 'AppCreateCompanyEmailSettings'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCreateCompanyEmailSettings')
	delete from GXDBVersions where aliasname = 'AppCreateCompanyEmailSettings'
GO

insert into GXDBVersions values(2, 'AppCreateCompanyEmailSettings',  '00010001000200070000', 'AppCreateCompanyEmailSettings', '00010001000200070000')
GO

