

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCreateCompanyClientGroup.sp] ---------- 

--  +==============================================================================+
--  | Name:  AppCreateCompanyClientGroup
--  | Description:  This procedure will be used while creating a company.
--	|				It's used to create company client group.
--	| Inputs: Logged in user Id, companyId, companyName and domainName, Tenant Admin group Id
--	|		  localeId
--	| Outputs: Company client group Id, error code and error string.
--  +==============================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCreateCompanyClientGroup.sp,v $ $Id: AppCreateCompanyClientGroup.sp,v 1.1.2.2.20.1 2021/05/17 23:37:04 nshah Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppCreateCompanyClientGroup')
BEGIN
	print '>>> Drop Stored Procedure: AppCreateCompanyClientGroup <<<'
	drop procedure AppCreateCompanyClientGroup
END
IF EXISTS (select * from GxQscripts where name='AppCreateCompanyClientGroup')
	delete from GxQscripts where name = 'AppCreateCompanyClientGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCreateCompanyClientGroup')
	delete from GXDBVersions where aliasname = 'AppCreateCompanyClientGroup'
GO
print '... Creating Procedure: AppCreateCompanyClientGroup'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppCreateCompanyClientGroup
  @userId INT,
  @companyId INT,
  @companyName NVARCHAR(4000),
  @domainName NVARCHAR(255),
  @tenantAdminGroupId int,
  @localeId INTEGER,
  @companyClientGroupId INT OUTPUT,
  @errCode int OUTPUT,
  @errString NVARCHAR(max) OUTPUT
AS
-- To remove when checkin:
--declare @_stTime datetime2(7) = sysdatetime()
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @nowTime INTEGER  =  dbo.GetUnixTime (GetUTCdate())
DECLARE @clientGroupName NVARCHAR(512)	= @companyName
DECLARE @clientGroupFlag INT =  0x1000  |  1073741824
DECLARE @scgRuleId int  =0
DECLARE @errorTable TABLE
(
    errorCode INT,
    errorString VARCHAR(MAX)
)
EXEC AppGetUniqueEntityName 28, @clientGroupName, @userId, @clientGroupName OUTPUT
DECLARE @scgDesc NVARCHAR(MAX) =  N'Clients belonging to ' + @companyName
INSERT INTO [APP_ClientGroup]
			([name]
			,[description]
			,[flag]
			,[status]
			,[userId]
			,[refTime]
			,[modified]
			,[fwPorts]
			,[origCCId]
			,[GUID])
		VALUES
			(@clientGroupName
			,@scgDesc
			,@clientGroupFlag
			,0
			,@userId
			,@nowTime
			,@nowTime
			,''
			,2
			,NEWID())
SET @companyClientGroupId  = SCOPE_IDENTITY()
DECLARE @companyCGQuery NVARCHAR(MAX)
DECLARE @companyRuleXml VARCHAR(MAX)
--SCG_PKID_CLIENT_PROP=2=prodID / SCG_PKID_USER_CLIENT_OWNER=11=prodId
-- SCG_PKID_COMPANY_INSTALLED_CLIENT_ASSOCIATIONS - 55
-- SCG_PKID_COMPANY_CLIENT_ASSOCIATIONS - 44
SET @companyRuleXml = '<scgRule op="1"><rules><rule op="0"><rules><rule filterID="100" propID="44" propType="4" secValue="' + @domainName + '" value="' + cast( @companyId as nvarchar(255)) + '"/></rules></rule></rules><rules><rule op="0"><rules><rule filterID="100" propID="55" propType="4" secValue="' + @domainName + '" value="' + cast( @companyId as nvarchar(255)) + '"/></rules></rule></rules></scgRule>'
DECLARE @scgExitCode INT = 0
DECLARE @scgExitMsg VARCHAR(1024) = ''
--for better performance of create company api not using this procedure
--EXEC APPSCGV2GenerateQueryParams @companyRuleXml, @scgExitCode OUTPUT, @scgExitMsg OUTPUT, @companyCGQuery OUTPUT
DECLARE @nCompanyId nvarchar(10) =cast (@companyId as nvarchar(10))
SET @companyCGQuery =
'DECLARE @inClientId INT = 0/*GetAllClients*/;  DECLARE @inSCGId INT = 0/*SCGProcessing*/;
 (  SELECT clientId FROM dbo.scgV2CompanyClientAssociations(''='',' + @nCompanyId + ' , @inClientId, @inSCGId )  )
 UNION  (  SELECT clientId FROM dbo.scgV2CompanyClientInstallAssociations(''='',' +  @nCompanyId + ' , @inClientId, @inSCGId )  ) '
IF (@scgExitCode <> 0)
BEGIN
	SET @errCode = @scgExitCode
	SET @errString = @scgExitMsg
	GOTO EXIT_ERROR
END
INSERT INTO APP_SCGRULE (scgId, ruleXml, ruleQuery, ownerId, created, modified)
				values
					(@companyClientGroupId,
					@companyRuleXml,
					@companyCGQuery,
					1,
					0,
					'0')
SET @scgRuleId  = SCOPE_IDENTITY()
UPDATE APP_SCGScope set entityId=2, entityType=1 where scgRuleId=@scgRuleId--DEFAULT_COMMCELL_ID
INSERT into App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@companyId, 'Associated Smart Client Group', 7, @companyClientGroupId, @nowTime, 0)
-- All security handling will be done later.
EXIT_ERROR:
--print 'Time taken for AppCreateCompanyClientGroup:[' + cast(datediff(ms,@_stTime,sysdatetime()) as varchar(10)) + ']'
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppCreateCompanyClientGroup')
	delete from GxQscripts where name = 'AppCreateCompanyClientGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCreateCompanyClientGroup')
	delete from GXDBVersions where aliasname = 'AppCreateCompanyClientGroup'
GO

insert into GXDBVersions values(2, 'AppCreateCompanyClientGroup',  'v1.1.2.2.20.1', 'AppCreateCompanyClientGroup', 'v1.1.2.2.20.1')
GO

