

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCreateCompanyAudit.sp] ---------- 

--  +==============================================================================+
--  | Name:  AppCreateCompanyClientGroup
--  | Description:  This procedure will be used while creating a company.
--	|				It's used to create company client group.
--	| Inputs: Logged in user Id, companyId, companyName and domainName, Tenant Admin group Id
--	|		  localeId
--	| Outputs: Company client group Id, error code and error string.
--  +==============================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCreateCompanyAudit.sp,v $ $Id: AppCreateCompanyAudit.sp,v 1.1.2.3 2020/12/21 15:57:16 nshah Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppCreateCompanyAudit')
BEGIN
	print '>>> Drop Stored Procedure: AppCreateCompanyAudit <<<'
	drop procedure AppCreateCompanyAudit
END
IF EXISTS (select * from GxQscripts where name='AppCreateCompanyAudit')
	delete from GxQscripts where name = 'AppCreateCompanyAudit'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCreateCompanyAudit')
	delete from GXDBVersions where aliasname = 'AppCreateCompanyAudit'
GO
print '... Creating Procedure: AppCreateCompanyAudit'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppCreateCompanyAudit
  @userId INT,
  @localeId INTEGER,
  @companyId INT,
  @tenantAdminGroupId INT,
  @tenantAdminId INT,
  @i_isCompanyWithoutTenantAdmin INT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @planLst NVARCHAR(MAX)
DECLARE @siteName NVARCHAR(MAX)
DECLARE @emailDomainName NVARCHAR(MAX)
DECLARE @domainName  NVARCHAR(MAX) =''
DECLARE @companyName  NVARCHAR(MAX) =''
DECLARE @tenantAdminEmail  NVARCHAR(MAX) =''
IF OBJECT_ID('tempdb.dbo.#getPlans') IS NOT NULL
    DROP TABLE #getPlans
CREATE TABLE #getPlans
(
    planName nvarchar(max)
)
INSERT INTO #getPlans
SELECT   distinct p.name FROM
UMSecurityAssociations u
INNER JOIN App_Plan p ON p.id=entityId1
WHERE userOrGroupId=@tenantAdminGroupId AND isUser=0 AND entityType1=158
SELECT   @planLst = COALESCE(@planLst+', ' ,'') + planName
FROM #getPlans
SELECT @siteName=attrval FROM App_CompanyProp WHERE componentNameId=@companyId AND  modified=0 AND attrName='Primary Domain' AND cs_attrName=CHECKSUM('Primary Domain')
SELECT @emailDomainName=attrVal FROM UMDSProviderProp WHERE componentNameId=@companyId AND modified=0 AND attrName='Email Domain'
SELECT @domainName=domainName, @companyName=hostName FROM UMDSProviders WHERE id=@companyId
SELECT @tenantAdminEmail=email FROM umusers WHERE id=@tenantAdminId
--SELECT @planLst
--SELECT @siteName
--SELECT @emailDomainName
--SELECT @domainName
--SELECT @companyName
DECLARE @opMsgId            INTEGER
DECLARE @opEvMsgId          INTEGER
DECLARE @opId               INTEGER
DECLARE @paramMsgId         INTEGER
DECLARE @paramData          NVARCHAR(1024)
DECLARE @dataIsEvent        INTEGER = 0
SET @opMsgId = (680 | (CAST(POWER(2, 24) AS BIGINT) * 84))
EXEC EvGuiAuditSetOperation @opMsgId, @userId, @opEvMsgId OUTPUT, @opId OUTPUT
SET @paramMsgId = (1655 | (CAST(POWER(2, 24) AS BIGINT) * 85))
    EXEC EvGuiAuditSetParamData @opId, @companyName, 0
    EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
SET @paramMsgId = (1801 | (CAST(POWER(2, 24) AS BIGINT) * 85))
    EXEC EvGuiAuditSetParamData @opId, @domainName, 0
    EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
IF(@i_isCompanyWithoutTenantAdmin=0)
BEGIN
SET @paramMsgId = (1805 | (CAST(POWER(2, 24) AS BIGINT) * 85))
	EXEC EvGuiAuditSetParamData @opId, @tenantAdminEmail, 0
	EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
END
IF @planLst IS NOT NULL
BEGIN
SET @paramMsgId = (1803 | (CAST(POWER(2, 24) AS BIGINT) * 85))
    EXEC EvGuiAuditSetParamData @opId, @planLst, 0
    EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
END
IF @siteName IS NOT NULL
BEGIN
SET @paramMsgId = (1804 | (CAST(POWER(2, 24) AS BIGINT) * 85))
    EXEC EvGuiAuditSetParamData @opId, @siteName, 0
    EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
END
IF @emailDomainName IS NOT NULL
BEGIN
SET @paramMsgId = (1802 | (CAST(POWER(2, 24) AS BIGINT) * 85))
    EXEC EvGuiAuditSetParamData @opId, @emailDomainName, 0
    EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppCreateCompanyAudit')
	delete from GxQscripts where name = 'AppCreateCompanyAudit'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCreateCompanyAudit')
	delete from GXDBVersions where aliasname = 'AppCreateCompanyAudit'
GO

insert into GXDBVersions values(2, 'AppCreateCompanyAudit',  '00010001000200030000', 'AppCreateCompanyAudit', '00010001000200030000')
GO

