

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCreateCompany.sp] ---------- 

--  +==============================================================================+
--  |		 		 Name:  AppGetCreateCompanyEmailSetting
--  | Description:  This procedure will be used while creating a company. This will get email related settings
--  +==============================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCreateCompany.sp,v $ $Id: AppCreateCompany.sp,v 1.1.2.10.4.1 2021/02/11 22:13:36 nshah Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppCreateCompany')
BEGIN
	print '>>> Drop Stored Procedure: AppCreateCompany <<<'
	drop procedure AppCreateCompany
END
IF EXISTS (select * from GxQscripts where name='AppCreateCompany')
	delete from GxQscripts where name = 'AppCreateCompany'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCreateCompany')
	delete from GXDBVersions where aliasname = 'AppCreateCompany'
GO
print '... Creating Procedure: AppCreateCompany'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppCreateCompany
  @i_XMLReqest XML,
  @password NVARCHAR(max),
  @userSalt nvarchar(MAX),
  @i_isCompanyReplicatedFromIDPCommcell INT,
  @i_isCompanyWithoutTenantAdmin INT
AS
  DECLARE @errorCode INT	
  DECLARE @errorString NVARCHAR(MAX)
  DECLARE @companyId INT
  DECLARE @companyGuid NVARCHAR(50)
  DECLARE @companyClientGroupId INT
  DECLARE @tenantAdminId INT
  DECLARE @tenantAdminGroupId INT
  DECLARE @tenantUserGroupId INT
  DECLARE @tenantOperatorGroupId INT
-- To remove when checkin:
--declare @_stTime datetime2(7) = sysdatetime()
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @errorCode =0
SET @errorString =''
SET @companyId =-1
SET @companyGuid  = ''
SET @companyClientGroupId  = 0
SET @tenantAdminId = 1
SET @tenantAdminGroupId  = 0
SET @tenantUserGroupId  = 0
SET @tenantOperatorGroupId = 0
 DECLARE @hostName NVARCHAR(4000)
 DECLARE @domainName NVARCHAR(255)
 DECLARE @serviceType INT = 5
 DECLARE @email NVARCHAR(max)
 DECLARE @fullName NVARCHAR(max)
 DECLARE @pswdHistoryCount INT = 0
 DECLARE @localeId INT = 0
 DECLARE @userId INT = 0
 DECLARE @nowTime INT = dbo.GetUnixTime(GETUTCDATE())
-- <?xml version="1.0" encoding="UTF-8"?><Api_CreateOrganizationRequest sendEmail="1">
--    <organizationInfo>
--        <organization connectName="NewCompanyWithPlan">
--            <shortName domainName="NewCompanyWithPlan"/>
--            <emailDomainNames val="commvault.com"/>
--        </organization>
--        <planDetails type="2" subtype="33554437" description="Server plan" numUsers="0" numDevices="0" planStatusFlag="0" restrictions="1" rpoInMinutes="1440" numAssocEntities="19" numCopies="1" isElastic="0" numCompanies="1">
--            <plan planId="1" planName="Server plan" planType="2" planSubtype="33554437" planSummary="RPOHours:24,NumberOfCopies:1,AssociatedEntitiesCount:19"/>
--        </planDetails>
--        <organizationProperties primaryDomain="NewCompanyWithPlan.testlab.commvault.com" enableAutoDiscovery="0">
--            <primaryContacts fullName="Nipa B shah" email="nshah@commvault.com"/>
--        </organizationProperties>
--    </organizationInfo>
--</Api_CreateOrganizationRequest>
--collect the input
 SET @localeId = ISNULL(@i_XmlReqest.value('(//Api_CreateOrganizationRequest/processinginstructioninfo/locale/@localeId)[1]', 'int') , 0)
 SET @userId = ISNULL(@i_XmlReqest.value('(//Api_CreateOrganizationRequest/processinginstructioninfo/user/@userId)[1]', 'int') , 0)
 SET @hostName = ISNULL(@i_XmlReqest.value('(//Api_CreateOrganizationRequest/organizationInfo/organization/@connectName)[1]', 'NVARCHAR(4000)') , '')
 SET @domainName = ISNULL(@i_XmlReqest.value('(//Api_CreateOrganizationRequest/organizationInfo/organization/shortName/@domainName)[1]', 'NVARCHAR(255)') , '')
 SET @email = ISNULL(@i_XmlReqest.value('(//Api_CreateOrganizationRequest/organizationInfo/organizationProperties/primaryContacts/@email)[1]', 'NVARCHAR(max)') , '')
 SET @fullName = ISNULL(@i_XmlReqest.value('(//Api_CreateOrganizationRequest/organizationInfo/organizationProperties/primaryContacts/@fullName)[1]', 'NVARCHAR(max)') , '')
DECLARE @tenantAdminRoleId int = ISNULL((SELECT id FROM UMRoles WHERE (flags & 256 <> 0)), 1)
 --SELECT @localeId,@userId, @hostName, @domainName, @email, @fullName
 --verify that user doesn't exists
  DECLARE @tenantAdminLogin nvarchar(255) = ''
IF(@i_isCompanyWithoutTenantAdmin =0)
BEGIN
	IF CHARINDEX('@', @email) > 0
		SET @tenantAdminLogin = @domainName + '\' +  LEFT(@email, (CHARINDEX('@', @email) - 1))
	ELSE
		SET @tenantAdminLogin = @domainName + '\' + @email
	IF(EXISTS(SELECT Id FROM UMUsers WHERE login = @tenantAdminLogin))
	BEGIN
SET @errorCode = (1061 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (1061 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
    	SET @errorString = REPLACE(@errorString, '^1%s',@tenantAdminLogin)
    	GOTO EXIT_ERROR
	END
END
DECLARE @flags INT = 0,  @enabled INT = 1, @useSecureLdap INT = 0, @dnsRootStatus INT = 0, @port INT = 0, @resourceId INT= 0
DECLARE @hasRights AS INT = 0
DECLARE @permissionId INT =255  -- Check Create Company when creating a new company.
EXEC sec_userHasCapability @userId,0,@hasRights OUTPUT,0,0,@permissionId
IF(@hasRights = 0)
BEGIN
SET @errorCode = (2408 | (CAST(POWER(2, 24) AS BIGINT) * 35))
	SET @errorString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = @errorCode AND [localeId] = 0)
	SET @errorString = REPLACE(@errorString, '^1%s', ISNULL((SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers WITH(NOLOCK) WHERE id = @userId),@userId))
	SET @errorString = REPLACE(@errorString, '^2%s', dbo.sec_getLocalizedPermission(@permissionId, 0))
SET @errorString = REPLACE(@errorString, '^3%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (468 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = 0))
	 GOTO EXIT_ERROR
END
IF	EXISTS (SELECT TOP 1 1 FROM UMDSProviders (NOLOCK) WHERE hostName = @hostName AND flags & 0x0002 = 0)
BEGIN
SET @errorCode = (3443 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3443 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
	GOTO EXIT_ERROR
END
IF EXISTS(SELECT 1 FROM UMDSProviders WITH(NOLOCK) WHERE domainName = @domainName)
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Domain ' + @domainName + ' already exists'
GOTO EXIT_ERROR
END
DECLARE @providerIdOfInitiator INT = dbo.AppGetOrganizationForUser(@userId)
-- origCCId for multiCommcell
DECLARE @commCellId INT = ISNULL(@i_XmlReqest.value('(//Api_CreateOrganizationRequest/organizationInfo/organization/commcell/@commCellId)[1]', 'int') ,2)
INSERT UMDSProviders (domainName, hostName, description, login, password, trustedHostUser, trustedHostPW, flags, enabled, serviceType,
			modified, dnsRoot, dnsRootStatus, useSecureLdap, origCCId, GUID, port, resourceId, ownerId , ownerCompany)
VALUES(@domainName, @hostName, @hostName, NULL, NULL, '', '', @flags, @enabled, @serviceType,
			0,NULL,@dnsRootStatus,@useSecureLdap, @commCellId, default, @port, @resourceId, @userId, @providerIdOfInitiator)
SET @companyId = SCOPE_IDENTITY()
INSERT INTO UMDSProviderProp (componentNameId,attrName,attrType,attrVal,created, modified)
VALUES(@companyId,'Password History Count',1,@pswdHistoryCount,dbo.GetUnixTime(GETUTCDATE()),0)
EXEC sec_setCreatorForEntity @userId, @tenantAdminRoleId, '', @errorCode OUTPUT, @errorString OUTPUT, 61, @companyId
--select '@companyId', @companyId
-----2. CREATE TENANT ADMIN GROUP
DECLARE @tenantAdminGroupName varchar(20) = 'Tenant Admin' --'Tenant Admin'
INSERT INTO UMGroups (groupFlags, allCapabilities, allAssociations, selfAssociation, name, description, origCCId, GUID, umdsproviderId, email, lastCredSetTime)
VALUES (1 | 0x10000, 0, 0, 1, @tenantAdminGroupName, '', 2, NEWID() , @companyId, '', 0)
SET @tenantAdminGroupId	= SCOPE_IDENTITY()
--SELECT '@tenantAdminGroupId', @tenantAdminGroupId
--tenant admin group properties
 INSERT INTO UMGroupsProp  ([componentNameId] ,[attrName] ,[attrType] ,[attrVal] ,[created] ,[modified]) VALUES
(@tenantAdminGroupId,'Quota size',7,100,@nowTime,0),
(@tenantAdminGroupId,'Enforce quota',7,0,@nowTime,0),
(@tenantAdminGroupId,'Edge Drive Quota Size',7,0,@nowTime,0),
(@tenantAdminGroupId,'Enforce Edge Drive Quota',7,0,@nowTime,0)
----Put it into All Tenant Admin User groups.
DECLARE @allTenantAdmingroupId INT = 0
SELECT @allTenantAdmingroupId = id
FROM UMGroups (NOLOCK)
WHERE ((groupFlags & CAST(0x0040 AS INT)) <> 0)
IF @allTenantAdmingroupId <> 0
BEGIN
	INSERT INTO UMDSGroupMaps (umGroupId, umdsGroupId, flag)
		VALUES (@allTenantAdmingroupId, @tenantAdminGroupId, 0)
END
----3. Create Tenant admin
IF(@i_isCompanyWithoutTenantAdmin =0)
BEGIN
	INSERT INTO [UMUsers]([name],[description],[login],[password],[email],[datePasswordSet],[dateExpires],[policy],[enabled],[flags],[modified],[pVer],[Pager],[lastLogInTime],[credSetTime],[umDSproviderId],[userGuid],[origUserGuid],[origCCId],[salt])
	VALUES (@fullName, '', @tenantAdminLogin, @password, @email, @nowTime, 0, 0, 1, 0x001, 0, 50, NULL, 0, 0, @companyId, NEWID(), '', 2, @userSalt)
	SET  @tenantAdminId  = SCOPE_IDENTITY()
	--SELECT '@tenantAdminId', @tenantAdminId
	UPDATE UMDSProviders SET ownerId=@tenantAdminId WHERE id = @companyId
	INSERT INTO [dbo].[UMUsersProp] ([componentNameId] ,[attrName] ,[attrType] ,[attrVal] ,[created] ,[modified]) VALUES
	(@tenantAdminId,'Company Name', 1, @hostName, @nowTime, 0),
(@tenantAdminId,'UMDS user inherits quota', 7, '1', @nowTime, 0),
(@tenantAdminId,'Enforce quota', 7, '0', @nowTime, 0),
(@tenantAdminId,'UMDS User Inherits Edge Drive Quota', 7, '1', @nowTime, 0),
(@tenantAdminId,'Enforce Edge Drive Quota', 7, '0', @nowTime, 0),
(@tenantAdminId,'Edge Drive Quota Size', 7, '100', @nowTime, 0),
(@tenantAdminId,'API Quota Limit', 7, '0', @nowTime, 0),
(@tenantAdminId,'API Quota Time Frame', 7, '0', @nowTime, 0),
	(@tenantAdminId,'Primary Contact', 7, '1', @nowTime, 0)
	--ReComputeQuota ??
	IF @i_isCompanyReplicatedFromIDPCommcell = 0
	BEGIN
		INSERT INTO [dbo].[UMUsersProp] ([componentNameId] ,[attrName] ,[attrType] ,[attrVal] ,[created] ,[modified]) VALUES
		(@tenantAdminId,'Invitation sent', 7, '1', @nowTime, 0),
(@tenantAdminId,'Enforce Password Change', 7, '1', @nowTime, 0)
	END
	INSERT INTO UMUserGroup (userId, groupId, flag)
	SELECT @tenantAdminId, @tenantAdminGroupId, 0
END
-----4. CREATE TENANT USER GROUP
DECLARE @tenantUserGroupName varchar(20) = 'Tenant Users'
INSERT INTO UMGroups (groupFlags, allCapabilities, allAssociations, selfAssociation, name, description, origCCId, GUID, umdsproviderId, email, lastCredSetTime)
VALUES (1 | 1073741824, 0, 0, 1, @tenantUserGroupName, '', 2, NEWID() , @companyId, '', 0)
SET @tenantUserGroupId	= SCOPE_IDENTITY()
--tenant user group properties
 INSERT INTO UMGroupsProp  ([componentNameId] ,[attrName] ,[attrType] ,[attrVal] ,[created] ,[modified]) VALUES
(@tenantUserGroupId,'Quota size',7,100,@nowTime,0),--'Quota size'
(@tenantUserGroupId,'Enforce quota',7,0,@nowTime,0),
(@tenantUserGroupId,'Edge Drive Quota Size',7,0,@nowTime,0),
(@tenantUserGroupId,'Enforce Edge Drive Quota',7,0,@nowTime,0)
----Put it into All Tenant User User groups.
DECLARE @allTenantUsergroupId INT = 0
SELECT @allTenantUsergroupId = id
FROM UMGroups (NOLOCK)
WHERE ((groupFlags & CAST(0x0080 AS INT)) <> 0)
IF @allTenantUsergroupId <> 0
BEGIN
	INSERT INTO UMDSGroupMaps (umGroupId, umdsGroupId, flag)
		VALUES (@allTenantUsergroupId, @tenantUserGroupId, 0)
END
--SELECT '@tenantUserGroupId', @tenantUserGroupId
-----5. CREATE TENANT OPERATOR GROUP
DECLARE @tenantOperatorGroupName varchar(20) = 'Tenant Operator'
DECLARE @tenantOperatorGroupFlag INT = CAST(0x40000 AS INT) | CAST(0x0001 AS INT) | CAST(0x0010 AS INT)
INSERT INTO UMGroups (groupFlags, allCapabilities, allAssociations, selfAssociation, name, description, origCCId, GUID, umdsproviderId, email, lastCredSetTime)
	VALUES (@tenantOperatorGroupFlag, 0, 0, 1, @tenantOperatorGroupName, '', 2, NEWID() , @companyId, '', 0)
SET @tenantOperatorGroupId	= SCOPE_IDENTITY()
--tenant operator group properties
 INSERT INTO UMGroupsProp  ([componentNameId] ,[attrName] ,[attrType] ,[attrVal] ,[created] ,[modified]) VALUES
(@tenantOperatorGroupId,'Quota size',7,100,@nowTime,0),--'Quota size'
(@tenantOperatorGroupId,'Enforce quota',7,0,@nowTime,0),
(@tenantOperatorGroupId,'Edge Drive Quota Size',7,100,@nowTime,0),
(@tenantOperatorGroupId,'Enforce Edge Drive Quota',7,0,@nowTime,0)
----API Quota Limit??
----API Quota Time Frame??
----DisableTwoFactorAuthentication??
--SELECT '@tenantOperatorGroupId', @tenantOperatorGroupId
------6. Client group
EXEC  [dbo].[AppCreateCompanyClientGroup]  @userId, @companyId,  @hostName,  @domainName,  @tenantAdminGroupId,  @localeId,  @companyClientGroupId OUTPUT, @errorCode OUTPUT, @errorString OUTPUT
IF(@errorCode >0)
BEGIN
	GOTO EXIT_ERROR
END
------7. Security and Operator associations.
-- To remove when checkin:
--declare @_stTime1 datetime2(7) = sysdatetime()
BEGIN
	DECLARE @tenantOperatorRoleID INT = 0
	DECLARE @creatorUserCompanyId INT = 0
	DECLARE @tenantAdminGroupIdOfCreator INT = 0
	DECLARE @clientGroupOwnerRoleName VARCHAR(1024) = ''
	DECLARE @clientGroupOwnerRoleId INT = 0
	DECLARE @mspRoleId INT = 0
	-- This is a temp table with all security associations. We will insert at last checking If exists.
	IF OBJECT_ID('tempdb.dbo.#SecurityAssociations_CreateCompany') IS NOT NULL
		DROP TABLE #SecurityAssociations_CreateCompany
	CREATE TABLE #SecurityAssociations_CreateCompany
	(
		isuser INT,
		userOrGroupId INT,
		roleId INT,
		permissionId INT,
		entityType INT,
		entityId INT,
		isCreator INT DEFAULT 0,
		companyId INT DEFAULT 0
	)
	CREATE CLUSTERED INDEX SecurityAssociationsIdx1_CreateCompanySetPlans ON #SecurityAssociations_CreateCompany (isUser, userOrGroupId, roleId, permissionId, entityType, entityId, isCreator);;
	-- a. Tenant Admin user group (Copied from AppSetCompanyTenantAdminGroupPermission.sp. Plans alone not handled in here, will be handled in later SP).
	BEGIN
			INSERT INTO #SecurityAssociations_CreateCompany (isUser, userOrgroupId, roleId, permissionId, entityType, entityId, companyId)
VALUES (0, @tenantAdminGroupId, @tenantAdminRoleId, 0, 61, @companyId, @companyId)						-- Tenant admin role on the company
	END
	-- b. Tenant Operator user group. (Copied from AppSetCompanyInitialProperties.sp, AppSetCompanyTenantOperatorRole.sp, sec_setCommvaultUserAsResellerForCompany.sp)
	-- This section contains operator and reseller configurations as well.
	BEGIN
		-- Unlike tenant admin role, tenant operator role can be specified in input (old - style) or global.
		SET @tenantOperatorRoleID = ISNULL(@i_XmlReqest.value('(Api_CreateOrganizationRequest/organizationInfo/organizationProperties/operatorRole/@roleId)[1]', 'INT'), 0)
		IF @tenantOperatorRoleID = 0			-- global tenant operator role.
		BEGIN
SELECT @tenantOperatorRoleID = id FROM UMRoles (NOLOCK) WHERE flags & 512 <> 0
		END
		-- In old-style, we used to save this as property in company properties table. Do the same for backward compatibility.
		-- It will be used when some customer tries old-style REST API, where in he specifies only operator user / group and
		-- we pick up the role from this table.
		INSERT INTO APP_CompanyProp (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (@companyId, 'Operator Role', 7, CAST(@tenantOperatorRoleID AS VARCHAR(32)), @nowTime, 0)
		-- If there is explicit operators configured, set them. Call stored proc in that case. It does not happen via GUI or a common thing.
		IF (@i_XmlReqest.exist('Api_CreateOrganizationRequest/organizationInfo/organizationProperties/operators/user') = 1)
			OR (@i_XmlReqest.exist('Api_CreateOrganizationRequest/organizationInfo/organizationProperties/operators/userGroup') = 1)
		BEGIN
			DECLARE @operatorsXML XML
			SET @operatorsXML = (SELECT
									(SELECT 2 AS '@operatorsOperationType',
										(SELECT @i_XmlReqest.query('Api_CreateOrganizationRequest/organizationInfo/organizationProperties/operators')
										FOR XML PATH (''), TYPE)
									FOR XML PATH('organizationProperties'), TYPE)
								FOR XML PATH ('Api_OrganizationInfo'))
			EXEC sec_setCommvaultUserAsResellerForCompany @userId, @localeId, @operatorsXML, @companyId, @errorCode OUTPUT, @errorString OUTPUT
		END
		-- From SP22, do NOT give any default Security associations for Tenant Operator group on the company. Neither add an entry in UMOperators as well.
		SET @creatorUserCompanyId = dbo.AppGetOrganizationForUser (@userId)
		IF @creatorUserCompanyId > 0
		BEGIN
			SELECT @tenantAdminGroupIdOfCreator = id
			FROM UMGroups (NOLOCK)
			WHERE
				umdsProviderId = @creatorUserCompanyId
				AND groupFlags & 65536 /*(GF_GROUP_TENANT_ADMIN)*/ <> 0
			INSERT INTO UMOperators (companyId, roleId, isUser, userOrGroupId, flags)
				VALUES (@companyId, @tenantOperatorRoleID, 0, @tenantAdminGroupIdOfCreator, 0)
			INSERT INTO #SecurityAssociations_CreateCompany (isUser, userOrgroupId, roleId, permissionId, entityType, entityId, companyId)
VALUES (0, @tenantAdminGroupIdOfCreator, @tenantOperatorRoleId, 0, 61, @companyId, @creatorUserCompanyId)
		END
		ELSE
		BEGIN
			INSERT INTO UMOperators (companyId, roleId, isUser, userOrGroupId, flags)
				VALUES (@companyId, @tenantOperatorRoleID, 1, @userId, 0)
			INSERT INTO #SecurityAssociations_CreateCompany (isUser, userOrgroupId, roleId, permissionId, entityType, entityId, companyId)
VALUES (1, @userId, @tenantOperatorRoleId, 0, 61, @companyId, 0)
		END
	END
	-- c. Company client group (Copied from AppACCreateOrganizationDefaultEntities.sp and AppSetCompanyGroupPermission.sp)
	BEGIN
SELECT @mspRoleId = id FROM UMRoles (NOLOCK) WHERE flags & 16 <> 0
		INSERT INTO #SecurityAssociations_CreateCompany (isUser, userOrgroupId, roleId, permissionId, entityType, entityId, isCreator, companyId)
VALUES (0, @tenantAdminGroupId, @tenantAdminRoleId, 0, 28, @companyClientGroupId, 0, @companyId),
(1, @userId, @mspRoleId, 0, 28, @companyClientGroupId, 1, 0)
		-- Company client group owner role.
		IF NOT EXISTS (SELECT 1 FROM GXGlobalParam (NOLOCK) WHERE name = 'skipAutoSettingOwnerPermission' AND value = '1' AND modified = 0)
		BEGIN
			-- All fresh installs have the above key set, so we will not be hitting here.
			-- If this key is not there (like existing setups, upgraded ones, etc.) then we have to set an Owner role on the company client group.
			-- This logic is copied from Set Security Associations SP. (and internal SPs - Populate Owners Table, Create Role).
SET @clientGroupOwnerRoleName = 'SystemCreatedRole_' + CAST (28 AS NVARCHAR(MAX)) + '_' + CAST (@companyClientGroupId AS NVARCHAR(MAX)) + '_' + CAST(@nowTime AS NVARCHAR(MAX))
			INSERT INTO UMRoles (commcellId, name, description, disabled, isPrivate, flags, ownerId, created, modified, GUID, xmlProperties, capabilitiesBitMask, permissionsString)
VALUES (2, @clientGroupOwnerRoleName, 'System created owner role for entity', 0, 1, 4, 1, @nowTime, 0, NEWID(), '', 0, '')
			SELECT @clientGroupOwnerRoleId = id FROM UMRoles (NOLOCK) WHERE name = @clientGroupOwnerRoleName
			INSERT INTO UMRolesPermissions (roleId, hierarchyLevel, categoryId, permissionId, excludeCategory, excludePermission)
VALUES (@clientGroupOwnerRoleId, 121, 102, 0, 0, 0)
			INSERT INTO UMRolesWithPermissionsExpanded (roleId, categoryId, permissionId)
SELECT @clientGroupOwnerRoleId, 102, id
				FROM UMPermissions (NOLOCK)
				WHERE
categoryId = 102
			INSERT INTO UMOwnerRoles (entityType, entityId, roleId, permissionId, authorId)
VALUES (28, @companyClientGroupId, @clientGroupOwnerRoleId, 0, @userId)
		END
	END
	-- d. Now we got all the security associations in temp table. Let's insert them.
	BEGIN
		INSERT INTO UMSecurityAssociations (isUser, userOrgroupId, roleId, permissionId, entityType1, entityId1, authorId, isCreator, companyId)
			SELECT Tbl.isUser, Tbl.userOrGroupId, Tbl.roleId, Tbl.permissionId, Tbl.entityType, Tbl.entityId, @userId, Tbl.isCreator, Tbl.companyId
			FROM #SecurityAssociations_CreateCompany Tbl
				LEFT JOIN UMSecurityAssociations Sec (NOLOCK)
					ON Tbl.isUser = Sec.isUser AND Tbl.userOrgroupId = Sec.userOrGroupId
					AND Tbl.roleId = Sec.roleId AND Tbl.permissionId = Sec.permissionId
					AND Tbl.entityType = Sec.entityType1 AND Tbl.entityId = Sec.entityId1
					AND Tbl.isCreator = Sec.isCreator
			WHERE
				Sec.isUser IS NULL
	END
	-- e. Tag these entities with the company. This is a new piece of code.
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#EntitiesToTagWithCompany') IS NOT NULL
			DROP TABLE #EntitiesToTagWithCompany
		CREATE TABLE #EntitiesToTagWithCompany
		(
			entityId INT,
			entityType INT,
			UNIQUE CLUSTERED (entityType, entityId)
		);;
		INSERT INTO #EntitiesToTagWithCompany (entityType, entityId)
VALUES (15, @tenantAdminGroupId),
(15, @tenantOperatorGroupId),
(15, @tenantUserGroupId),
(28, @companyClientGroupId)
		IF(@i_isCompanyWithoutTenantAdmin =0)
		BEGIN
			INSERT INTO #EntitiesToTagWithCompany (entityType, entityId)
VALUES (13, @tenantAdminId)
		END
		EXEC sec_setCompanyIdForEntity 0, 0, @companyId		-- This sp requires well known external temp table Entities To Tag With Company.
	END
END
--print 'Time taken for security region in AppCreateCompany:[' + cast(datediff(ms,@_stTime1,sysdatetime()) as varchar(10)) + ']'
--select '@companyClientGroupId', @companyClientGroupId
--Before we end
If(@i_isCompanyWithoutTenantAdmin =1)
BEGIN
	DECLARE @createAsUserID int =0
		EXEC sec_getCreateAsUserId 0,0 , @createAsUserID OUTPUT,0,0,@tenantAdminGroupId
		IF @createAsUserID > 0
		BEGIN
			SET @tenantAdminId = @createAsUserID
		END
END
EXIT_ERROR:
IF(@errorCode=0)
BEGIN
	SELECT @companyGuid=GUID FROM UMDSProviders WHERE ID = @companyId
END
SELECT  @errorCode as 'errorCode', @errorString as 'errorString', @companyId as 'companyId', @companyGuid as 'companyGuid', @companyClientGroupId as 'companyClientGroupId',  @tenantAdminId as 'tenantAdminId', @tenantAdminGroupId as 'tenantAdminGroupId', @tenantUserGroupId as 'tenantUserGroupId', @tenantOperatorGroupId AS 'tenantOperatorGroupId'
SET NOCOUNT OFF
--print 'Time taken for AppCreateCompany:[' + cast(datediff(ms,@_stTime,sysdatetime()) as varchar(10)) + ']'
GO

IF EXISTS (select * from GxQscripts where name = 'AppCreateCompany')
	delete from GxQscripts where name = 'AppCreateCompany'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCreateCompany')
	delete from GXDBVersions where aliasname = 'AppCreateCompany'
GO

insert into GXDBVersions values(2, 'AppCreateCompany',  'v1.1.2.10.4.1', 'AppCreateCompany', 'v1.1.2.10.4.1')
GO

