

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCreateCLRFunctions.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCreateCLRFunctions.sp,v $ $Id: AppCreateCLRFunctions.sp,v 1.33.34.21 2020/06/13 05:01:33 abilbrey Exp $";
--  +===============================================================================+
--  | Stored Proc:  AppCreateCLRFunctions()
--  |
--  | Description:  Create CLR functions and stored procedures
--  +===============================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppCreateCLRFunctions')
BEGIN
	print '>>> Drop Stored Procedure: AppCreateCLRFunctions <<<'
	drop procedure AppCreateCLRFunctions
END
IF EXISTS (select * from GxQscripts where name='AppCreateCLRFunctions')
	delete from GxQscripts where name = 'AppCreateCLRFunctions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCreateCLRFunctions')
	delete from GXDBVersions where aliasname = 'AppCreateCLRFunctions'
GO
print '... Creating Procedure: AppCreateCLRFunctions'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCreateCLRFunctions
  @i_FullDLLPath NVARCHAR(MAX)
AS
  DECLARE @o_retVal INTEGER;
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	DECLARE @windows TINYINT = 1
	DECLARE @linux TINYINT = 2
	DECLARE @osType TINYINT = 0
	DECLARE @nl VARCHAR(4) = ''
	DECLARE @versionSQL NVARCHAR(MAX)
	SET @versionSQL = @@VERSION
	SET @osType = IIF((@versionSQL LIKE '%Linux%'), @linux, @windows)
	SET @nl = IIF((@osType = @windows), (CHAR(13) + CHAR(10)), CHAR(10))		-- CRLF(Windows), LF(Linux newline)
	-- Get SQL Release to determine how to query the local SQL Server
	DECLARE @versionNumber VARCHAR(128) = CAST(SERVERPROPERTY('ProductVersion') AS VARCHAR(128))
	DECLARE @releaseNumber VARCHAR(128) = LEFT(@versionNumber, CHARINDEX('.', @versionNumber) - 1)
	DECLARE @sqlQuery 		NVARCHAR(MAX)
	SET @sqlQuery = '
		USE MASTER;
		IF EXISTS (SELECT name FROM syslogins WHERE name = ''CVDBCLRLogin'')
			DROP LOGIN CVDBCLRLogin;
		IF EXISTS (SELECT name FROM sys.asymmetric_keys WHERE name = ''CVDBCLRKey'')
			DROP ASYMMETRIC KEY CVDBCLRKey;
		IF EXISTS ( SELECT name FROM sysusers WHERE name LIKE ''CVManagedLoggerLogin'' and sid = ( SELECT sid FROM syslogins WHERE name LIKE ''CVManagedLoggerLogin'' ) )
			DROP USER CVManagedLoggerLogin;
		IF EXISTS (SELECT name FROM syslogins WHERE name = ''CVManagedLoggerLogin'')
			DROP LOGIN CVManagedLoggerLogin;
		IF EXISTS (SELECT name FROM sys.asymmetric_keys WHERE name = ''CVManagedLoggerKey'')
			DROP ASYMMETRIC KEY CVManagedLoggerKey;
	'
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF	@o_retVal <> 0 GOTO CX_EXIT
	-- Changes to stop RECONFIGURE the SQL Server during each DbUpgrade over the life time of the server
	IF EXISTS(SELECT 1 FROM master.sys.configurations WITH(NOLOCK) WHERE name = 'show advanced options' AND CAST(value_in_use AS INT) = 0)
	BEGIN
		SET @sqlQuery = 'USE MASTER;
				EXEC sp_configure ''show advanced options'', 1;
				RECONFIGURE;
		'
		EXECUTE sp_executeSql @sqlQuery
		SET @o_retVal = @@ERROR
		IF	@o_retVal <> 0 GOTO CX_EXIT
	END
	IF EXISTS(SELECT 1 FROM master.sys.configurations WITH(NOLOCK) WHERE name = 'clr enabled' AND CAST(value_in_use AS INT) = 0)
	BEGIN
		SET @sqlQuery = 'USE MASTER;
				EXEC sp_configure ''clr enabled'' , 1;
				RECONFIGURE;
		'
		EXECUTE sp_executeSql @sqlQuery
		SET @o_retVal = @@ERROR
		IF	@o_retVal <> 0 GOTO CX_EXIT
	END
	IF (@releaseNumber >= 14)	-- SQL Server 2017+
	BEGIN
		IF EXISTS(SELECT 1 FROM master.sys.configurations WITH(NOLOCK) WHERE name = 'clr strict security' AND CAST(value_in_use AS INT) = 1)
		BEGIN
			SET @sqlQuery = 'USE MASTER;
					EXEC sp_configure ''clr strict security'' , 0;
					RECONFIGURE;
			'
			EXECUTE sp_executeSql @sqlQuery
			SET @o_retVal = @@ERROR
			IF	@o_retVal <> 0 GOTO CX_EXIT
		END
	END
	-- SP21 Note: New CLR functions are being written to replace the OLE Usage and support Linux and should be able to disable this in the near future for Windows SQL 2017+
	-- In the CV Security Hardening documentation it is stated that 'Ole Automation Procedures' can be disabled but the Commserv Database has SPs using it?
	-- Adding OLE only for Windows Unsafe methods and only if the Commserv database is being created
	-- NCVS Search: sp_OACreate
	-- Note Linux does NOT support 'Ole Automation Procedures'
	IF (@osType = @windows)
	BEGIN
		IF (DB_NAME() = 'Commserv') AND EXISTS(SELECT 1 FROM master.sys.configurations WITH(NOLOCK) WHERE name = 'Ole Automation Procedures' AND CAST(value_in_use AS INT) = 0)
		BEGIN
			SET @sqlQuery = 'USE MASTER;
					EXEC sp_configure ''Ole Automation Procedures'', 1;
					RECONFIGURE;
			'
			EXECUTE sp_executeSql @sqlQuery
			SET @o_retVal = @@ERROR
			IF	@o_retVal <> 0 GOTO CX_EXIT
		END
	END
	SET @sqlQuery =  ''
	DECLARE @objcur CURSOR
	DECLARE @object_id INT
	DECLARE @type char(2)
	SET @objcur=CURSOR FOR
		(SELECT object_id,TYPE FROM sys.objects WHERE object_id in(
	SELECT object_id FROM sys.assembly_modules
    WHERE assembly_id in (SELECT assembly_id FROM sys.assemblies WHERE name IN ('dbCLR','timezoneclr'))))
	OPEN @objcur
	FETCH NEXT FROM @objcur INTO @object_id,@type
	SET @sqlQuery = ''
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF @type = 'P' OR @type = 'PC'
			SET @sqlQuery += 'DROP PROCEDURE ' +  OBJECT_NAME(@object_id) + '; ' + @nl
		ELSE IF @type = 'FS'
			SET @sqlQuery += 'DROP FUNCTION ' +  OBJECT_NAME(@object_id) + '; ' + @nl
		ELSE IF @type = 'AF'
			SET @sqlQuery += 'DROP AGGREGATE ' +  OBJECT_NAME(@object_id) + '; ' + @nl
		FETCH NEXT FROM @objcur INTO @object_id,@type
	END
	CLOSE @objcur
	DEALLOCATE @objcur
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF	@o_retVal <> 0 GOTO CX_EXIT
	SET @sqlQuery = '
		IF EXISTS (SELECT name FROM sys.assemblies asms WHERE asms.name = N''dbCLR'')
			DROP ASSEMBLY [dbCLR];
	'
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF	@o_retVal <> 0 GOTO CX_EXIT
    SET @sqlQuery = '
		IF EXISTS (SELECT name FROM sys.assemblies asms WHERE asms.name = N''CVManagedLogger'')
			DROP ASSEMBLY [CVManagedLogger];
	'
    EXECUTE sp_executeSql @sqlQuery
    SET @o_retVal = @@ERROR
    IF  @o_retVal <> 0 GOTO CX_EXIT
	DECLARE @index INT = CHARINDEX('\',  REVERSE(@i_FullDLLPath) )
	SET @sqlQuery = 'USE MASTER; ' + @nl
	SET @sqlQuery += 'CREATE ASYMMETRIC KEY CVDBCLRKey FROM EXECUTABLE FILE = ''' + @i_FullDLLPath + '''; ' + @nl
	SET @sqlQuery += 'CREATE LOGIN CVDBCLRLogin FROM ASYMMETRIC KEY CVDBCLRKey; ' + @nl
	SET @sqlQuery += 'GRANT UNSAFE ASSEMBLY TO CVDBCLRLogin; ' + @nl
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF  @o_retVal <> 0 GOTO CX_EXIT
	SET @sqlQuery = 'CREATE ASSEMBLY dbCLR FROM N''' + @i_FullDLLPath + ''' WITH PERMISSION_SET = UNSAFE; ' + @nl
	EXECUTE sp_executeSql @sqlQuery
	SET @o_retVal = @@ERROR
	IF	@o_retVal <> 0 GOTO CX_EXIT
	-- Register/Add new CLR functions in the below sp file.
	-- The following sp file contains all CLR related SP's,functions,aggregates which are general for Windows and Linux platforms and windows specifics as well.
	EXEC DbclrInstall_3_CommservProc
CX_EXIT:
	SELECT @o_retVal
	RETURN @o_retVal
GO

IF EXISTS (select * from GxQscripts where name = 'AppCreateCLRFunctions')
	delete from GxQscripts where name = 'AppCreateCLRFunctions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCreateCLRFunctions')
	delete from GXDBVersions where aliasname = 'AppCreateCLRFunctions'
GO

insert into GXDBVersions values(2, 'AppCreateCLRFunctions',  '00010033003400210000', 'AppCreateCLRFunctions', '00010033003400210000')
GO

