

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppConfigureUserSID.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- =======================================================================
-- Create date: 21/12/2017
-- Description: Configure User SID into Umusersprop
-- =======================================================================
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppConfigureUserSID <<<'

IF EXISTS (select * from sysobjects where name='AppConfigureUserSID')
	drop procedure AppConfigureUserSID
IF EXISTS (select * from GxQscripts where name='AppConfigureUserSID')
	delete from GxQscripts where name = 'AppConfigureUserSID'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppConfigureUserSID')
	delete from GXDBVersions where aliasname = 'AppConfigureUserSID'
GO
print '... Creating Procedure: AppConfigureUserSID'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppConfigureUserSID
  @userId INT, 
  @ADSIDInfo NVARCHAR(MAX) 
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @output INT = 1
--sample entry:<App_ADSIDInfo uSID="S-1-5-21-3393418607-3554941549-4209072599-1105"><gSIDs val="S-1-5-21-3393418607-3554941549-4209072599-1110"/><gSIDs val="S-1-5-21-3393418607-3554941549-4209072599-1119"/><gSIDs val="S-1-5-21-3393418607-3554941549-4209072599-3119"/></App_ADSIDInfo>
--XML entry should either be saved without header (or) should be saved in UTF-16.
-- output 0 denotes success- inserted/updated successfully
--we are always going to insert/update the SID. The AD user's groups can change between logins. And updating the entry would be simpler than iterating gSIDs and cherry picking its difference.
IF NOT EXISTS (SELECT 1 FROM UMUsersProp with (nolock) WHERE attrName = 'User SID' AND componentNameId = @userId AND modified=0)
BEGIN
	INSERT INTO UMUsersProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (@userId, 'User SID', 1, @ADSIDInfo, dbo.GetUnixTime(GETUTCDATE()), 0)
	SET @output = 0
END
ELSE
BEGIN
UPDATE UMUsersProp SET attrVal = @ADSIDInfo WHERE attrName = 'User SID' AND componentNameId = @userId AND modified=0
	SET @output = 0
END
SET NOCOUNT OFF
SELECT 	@output as errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'AppConfigureUserSID')
	delete from GxQscripts where name = 'AppConfigureUserSID'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppConfigureUserSID')
	delete from GXDBVersions where aliasname = 'AppConfigureUserSID'
GO

insert into GXDBVersions values(2, 'AppConfigureUserSID',  '00000000000000000000', 'AppConfigureUserSID', '00000000000000000000')
GO

