

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppConfigureInvitedUser.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppConfigureInvitedUser.sp,v $ $Id: AppConfigureInvitedUser.sp,v 1.2.32.7 2017/07/18 19:27:48 nshah Exp $";
/*
Input is list of emails:
<App_InviteUsers>
	<users val="abc@commvault.com" />
	<users val="abc.xyz@gmail.com" />
</App_InviteUsers>
1. Get string after '@', in this case it would be commvault.com and gamil.com
2. Append '.' it becomes .commvault.com and .gmail.com
3. Identify rows of UMDSProviders where last part of hostName matches above string.
	Example hostName is 'gp.cv.commvault.com' so .commvault.com matches but .gmail.com do not match.
4. The id and domainName(commvault-nj) of above matching row are used to enter a row in UMUsers(it means register). These users are AD users. login column of UMUsers would be domainName\alias name. Example: commvault-nj\abc
5. Identify Ids of registered AD and Non AD users.
6. Associate Users identified in #5 to Laptop users Group.
7. Return two list of users in following format. First list is of Registerd (AD and Non AD users). Second list is of Non Registered Non AD Users. C++ will send emails accordingly to these list.
	<App_InviteUsers>
	  <users val="abc@commvault.com" />
	  <users val="abc.xyz@gmail.com" />
	</App_InviteUsers>
*/
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppConfigureInvitedUser <<<'

IF EXISTS (select * from sysobjects where name='AppConfigureInvitedUser')
	drop procedure AppConfigureInvitedUser
IF EXISTS (select * from GxQscripts where name='AppConfigureInvitedUser')
	delete from GxQscripts where name = 'AppConfigureInvitedUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppConfigureInvitedUser')
	delete from GXDBVersions where aliasname = 'AppConfigureInvitedUser'
GO
print '... Creating Procedure: AppConfigureInvitedUser'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppConfigureInvitedUser
  @initiatorUserId INT,
  @inUsers XML
AS
  DECLARE @errorCode INT = 0
  DECLARE @errorString VARCHAR(MAX) = 'Success'
  DECLARE @downloadPackageList VARCHAR(MAX) = ''
  DECLARE @registerAndDownloadPackageList VARCHAR(MAX) = ''
DECLARE @InviteUserTBL TABLE (userEmail VARCHAR(MAX), providerID INT, loginName VARCHAR(MAX), aliasName VARCHAR(MAX), userId INT)
DECLARE @providerIdOfInitiator INT = ISNULL( (SELECT umDSproviderId FROM UMUsers WHERE id = @initiatorUserId), 0)
DECLARE @ownerCompany INT = (SELECT ownerCompany FROM UMDSProviders WHERE id = @providerIdOfInitiator)
IF @ownerCompany != 0
	SET @ownerCompany = (SELECT id FROM UMDSProviders WHERE id = @ownerCompany)
ELSE
	SET @ownerCompany = @providerIdOfInitiator
DECLARE @laptopGrpId INT = ISNULL((SELECT id FROM UMGroups WHERE name = 'Tenant Users' AND umdsProviderId = @ownerCompany), 0)
BEGIN TRY
	INSERT INTO @InviteUserTBL(userEmail)
	SELECT userEmail.Node.value('@val', 'VARCHAR(MAX)')
	FROM @inUsers.nodes('//App_InviteUsers/users') userEmail(Node)
	MERGE @InviteUserTBL AS T
	USING UMDSProviders AS S
	ON (S.hostName LIKE (SELECT '%.' + RIGHT(T.userEmail, LEN(T.userEmail) - CHARINDEX('@', T.userEmail) )) )
	WHEN MATCHED
		THEN UPDATE SET T.providerID = S.id, T.loginName = S.domainName + '\' + LEFT(T.userEmail, (CHARINDEX('@', T.userEmail) - 1)), T.aliasName = LEFT(T.userEmail, (CHARINDEX('@', T.userEmail) - 1));
	SET @downloadPackageList = (SELECT
									(SELECT userEmail AS '@val'
										FROM @InviteUserTBL where providerID <> ''
									FOR XML PATH('users'), TYPE),  --Get AD User list
									(SELECT userEmail AS '@val'
										FROM @InviteUserTBL
										INNER JOIN UMUsers ON userEmail = email AND providerID IS NULL
									FOR XML PATH('users'), TYPE) --Get list of Non AD Users those are already registered
									FOR XML PATH(''), ROOT('App_InviteUsers') )
	SET @registerAndDownloadPackageList = (SELECT
											(SELECT	A.userEmail AS '@val'
												FROM @InviteUserTBL A
												LEFT OUTER JOIN   UMUsers B
												ON A.userEmail = B.email
												WHERE B.email IS NULL
												AND providerID IS NULL
											FOR XML PATH('users'), TYPE) --Get list of Non AD Users those are not registered
											FOR XML PATH(''), ROOT('App_InviteUsers') )
	--insert AD users
	MERGE UMUsers AS T
	USING (select DISTINCT userEmail, providerId, loginName, aliasName, userId from @InviteUserTBL) AS S
	ON (S.loginName = T.login)
	WHEN NOT MATCHED BY TARGET AND S.providerID <> ''
		THEN
			INSERT ([name]
								,[description]
								,[login]
								,[password]
								,[email]
								,[datePasswordSet]
								,[dateExpires]
								,[policy]
								,[enabled]
								,[flags]
								,[modified]
								,[pVer]
								,[Pager]
								,[lastLogInTime]
								,[credSetTime]
								,[umDSproviderId]
								,[userGuid]
								,[origUserGuid])
			VALUES(				S.aliasName, --name
								S.aliasName, -- description
								S.loginName, -- login
								'2ALXqLLXNLLX0LLXcLLXxLL',-- password
								S.userEmail,--email
								0,--datePWDset
								0,--dateExpires
								0,--policy
								1,--enabled
								1,--flags
								0,--modified
								0,--pVer
								0,--Pager
								0,--lastLogInTime
								0,--credSetTime
								S.providerID,--umDSproviderId
								'',--userGUID
								''--origUserGuid
								);
	--insert regular user
	MERGE UMUsers AS T
	USING @InviteUserTBL AS S--(select DISTINCT userEmail, providerId, loginName, aliasName, userId from @InviteUserTBL) AS S
	ON (S.userEmail = T.email)
	WHEN NOT MATCHED BY TARGET AND S.providerID is null
		THEN
			INSERT ([name]
								,[description]
								,[login]
								,[password]
								,[email]
								,[datePasswordSet]
								,[dateExpires]
								,[policy]
								,[enabled]
								,[flags]
								,[modified]
								,[pVer]
								,[Pager]
								,[lastLogInTime]
								,[credSetTime]
								,[umDSproviderId]
								,[userGuid]
								,[origUserGuid])
			VALUES(				LEFT(S.userEmail, (CHARINDEX('@', S.userEmail) - 1)), --name
								LEFT(S.userEmail, (CHARINDEX('@', S.userEmail) - 1)), -- description
								LEFT(S.userEmail, (CHARINDEX('@', S.userEmail) - 1)), -- login
								(select dbo.EncodeSecretCLR(SUBSTRING(CONVERT(varchar(40), NEWID()),0,9) )),-- password
								S.userEmail,--email
								0,--datePWDset
								0,--dateExpires
								0,--policy
								1,--enabled
								1,--flags
								0,--modified
								0,--pVer
								0,--Pager
								0,--lastLogInTime
								0,--credSetTime
								@ownerCompany,--umDSproviderId
								'',--userGUID
								''--origUserGuid
								);
	--Identify userid of ADUsers
	MERGE @InviteUserTBL T
	USING UMusers S
	ON (T.loginName = S.login)
	WHEN MATCHED
		THEN UPDATE SET T.userId = S.id;
	--Identify userid of Registred Non AD Users
	MERGE @InviteUserTBL T
	USING UMusers S
	ON (T.userEmail = S.email AND T.providerID IS NULL)
	WHEN MATCHED
		THEN UPDATE SET T.userId = S.id;
	--Associate AD user and registered Non AD users to Laptop users group
	IF( @laptopGrpId != 0 )
	BEGIN
		MERGE UMUserGroup AS T
		USING @InviteUserTBL AS S
		ON (T.userId = S.userId AND T.groupId = @laptopGrpId)
		WHEN NOT MATCHED BY TARGET AND S.userId != 0
			THEN INSERT ([userId], [groupId], [flag])
			VALUES(S.userId, @laptopGrpId, 0);
	END
MERGE UMUSERSPROP P
USING (select U.Id, U.UMDSPROVIDERID From UMUSERS U JOIN @InviteUserTBL T on U.email = T.userEmail) S
ON (S.Id = P.componentNameId and P.attrName = 'Enforce Password Change')
WHEN NOT MATCHED and ((SELECT ServiceType FROM UMDSPROVIDERS WHERE ID = S.UMDSPROVIDERID) != 2 AND (SELECT ServiceType FROM UMDSPROVIDERS WHERE ID = S.UMDSPROVIDERID) != 3 ) --Neither AD not Domino
	THEN INSERT
		(
			componentNameId,
			attrName,
			attrType,
			attrVal,
			created,
			modified
		)
	VALUES
		(
			S.Id,
			'Enforce Password Change',
			7,
			'1',
			dbo.GetUnixTime (GetUTCdate()),
			0
		);
	MERGE UMUsersProp AS U
		USING @InviteUserTBL AS S
		ON (U.componentNameId = S.userId AND U.ATTRNAME = 'Invitation sent' AND U.modified=0 and attrVal=1)
		WHEN MATCHED
		THEN
			UPDATE  SET U.created =  dbo.GetUnixTime (GetUTCdate())
		WHEN NOT MATCHED BY TARGET AND S.userId != 0
			THEN INSERT ([componentNameId], [attrName],[attrType], [attrVal], [created], [modified])
			VALUES(S.userId, 'Invitation sent',7, 1,  dbo.GetUnixTime (GetUTCdate()), 0);
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode    = ERROR_NUMBER()
    SET @errorString  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
SELECT @errorCode, @errorString, @downloadPackageList, @registerAndDownloadPackageList
GO

IF EXISTS (select * from GxQscripts where name = 'AppConfigureInvitedUser')
	delete from GxQscripts where name = 'AppConfigureInvitedUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppConfigureInvitedUser')
	delete from GXDBVersions where aliasname = 'AppConfigureInvitedUser'
GO

insert into GXDBVersions values(2, 'AppConfigureInvitedUser',  '00010002003200070000', 'AppConfigureInvitedUser', '00010002003200070000')
GO

