

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppConfigureEdgeDriveAudit.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppConfigureEdgeDriveAudit.sp,v $ $Id: AppConfigureEdgeDriveAudit.sp,v 1.1.2.11 2019/04/23 15:17:05 nramalingam Exp $";
--
--  +================================================================================================+
--  |   Procedure:  AppConfigureEdgeDriveAudit()
--  |
--  | Description:  SP for configuring audit for edge drive client
--  |
--  |       Input:  ConfigureEdgeDriveAuditRequest XML containing edgeClient id
--  |
--  |      Output:  ConfigureEdgeDriveAuditResponse containing isConfigured, CloudProperties,webserver associated, push workqueue indicator, errorCode, errorString to determine status of the operation
--  |      Return:  errorCode
--  |
--  |   Revisions  Author           Description
--  |   ---------  nramalingam  	To Configure audit for edge drive client
--  |   ---------    				From V11SP12 each edge client will have its own monitoring policy.
--  |   ---------    				This stored by is called after the client is created.
--  +================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppConfigureEdgeDriveAudit')
BEGIN
	print '>>> Drop Stored Procedure: AppConfigureEdgeDriveAudit <<<'
	drop procedure AppConfigureEdgeDriveAudit
END
IF EXISTS (select * from GxQscripts where name='AppConfigureEdgeDriveAudit')
	delete from GxQscripts where name = 'AppConfigureEdgeDriveAudit'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppConfigureEdgeDriveAudit')
	delete from GXDBVersions where aliasname = 'AppConfigureEdgeDriveAudit'
GO
print '... Creating Procedure: AppConfigureEdgeDriveAudit'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppConfigureEdgeDriveAudit
  @i_xml XML	
AS
DECLARE @monitoringPolicyId  int = 0
DECLARE @monitoringPolicyStatus int
DECLARE @isEdgeAuditConfigured int = 0
DECLARE @cloudId int = 0
DECLARE @cloudName  nvarchar(510)
DECLARE @edgeClientId int = 0
DECLARE @webserverId int = 0
DECLARE @rowCount int
DECLARE @pushWQToken int = 0
DECLARE @curUtcDateTime BIGINT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @error XML
DECLARE @errorCode int = 0
BEGIN TRY
	BEGIN TRANSACTION
	SET @edgeClientId = (SELECT  ref.value('@clientId', 'int') FROM    @i_xml.nodes('Api_ConfigureEdgeDriveAuditRequest/edgeClient') R ( ref ))
	IF (@edgeClientId IS NULL OR @edgeClientId = 0 )
    BEGIN
		RAISERROR ('Edge Client Id is mandatory to create monitoring policy for edge client.', 16, 1 )
		--is validation for edge drive system type and audit enabled on client needed ?
	END
	-- gets the index servers webserver associated associated with the edge client.
    SET @webserverId = (SELECT TOP 1 webserverId FROM AppEdgeDriveWebserverAssociation where edgeClientId = @edgeClientId)
	IF (@webserverId IS NULL OR @webserverId = 0 )
    BEGIN
		RAISERROR ('Webserver not found for edge client.', 16, 1 )
	END
	SELECT TOP 1 @monitoringPolicyId = MP.monitorPolicyId, @monitoringPolicyStatus = MP.status from App_EdgeDriveAssociation EDA  WITH (NOLOCK)
	INNER JOIN APP_MonitoringPolicy MP WITH (NOLOCK)  ON  MP.monitorPolicyId = EDA.entityId
	LEFT OUTER JOIN APP_MonitoringPolicyProp MPP WITH (NOLOCK)  ON  MP.monitorPolicyId = MPP.monitorPolicyId AND MPP.attrName = 'IsBasePolicy' AND MPP.attrVal = '1'
	WHERE EDA.clientId = @edgeClientId and EDA.entityType=90 /**LM_MONITORING_POLICY_ENTITY**/ AND MPP.monitorPolicyId IS NULL --filter out base policy if any
    IF (@monitoringPolicyId = 0 )
    BEGIN
		DECLARE @primaryTemplateId INT
		DECLARE @primaryTemplateName NVARCHAR(510)
		DECLARE @edgeAudittemplateId INT
		DECLARE @commcellId INT = 2
		DECLARE @ownerId INT = ISNULL((SELECT TOP(1) id FROM UMUsers(nolock) WHERE (flags & 0x40 = 0x40)), 1)
		SET @primaryTemplateName = 'Simple Text Template'
		-- 'Simple Text Template' is a system template and we will have only one with its name.
		SET @primaryTemplateId = (SELECT TOP 1 templateId FROM APP_Template  WITH (NOLOCK) WHERE templateName = @primaryTemplateName AND status = 0)
		IF @primaryTemplateId IS NULL
		BEGIN
			RAISERROR ('Simple Text Template is not available', 16, 1 )
		END
		-- 'EdgeAudit' is a disovery system template and we will have only one template for that monitoring type.
		SET @edgeAudittemplateId = (SELECT TOP 1 templateId FROM APP_Template  WITH (NOLOCK) WHERE templateForMonitoringType = 13 /**enum MonitoringType EDGEAUDIT**/ AND status = 4 /**TemplateStatus DISCOVER**/)
		IF @edgeAudittemplateId IS NULL
		BEGIN
			RAISERROR (N'Edge Audit template is not available', 16, 1 )
		END
		DECLARE @monitoringPolicyName  nvarchar(510) = (SELECT TOP 1 Name +' - Edge Audit Policy' FROM App_Client (nolock) WHERE id = @edgeClientId)
		INSERT INTO APP_MonitoringPolicy values (@commcellId,@monitoringPolicyName ,@curUtcDateTime,@curUtcDateTime,'System created policy for EdgeAudit',1)
		SET @monitoringPolicyId = SCOPE_IDENTITY()
		INSERT INTO App_MonitorTemplateAssoc VALUES (@monitoringPolicyId,@commcellId,@primaryTemplateId),
													(@monitoringPolicyId,@commcellId,@edgeAudittemplateId)
		INSERT INTO APP_MonitoringPolicyProp VALUES (@monitoringPolicyId,@commcellId,'age ci data after days',7,'1095',@curUtcDateTime,@curUtcDateTime),
													(@monitoringPolicyId,@commcellId,'capture as attachment',2,'0',@curUtcDateTime,@curUtcDateTime),
													(@monitoringPolicyId,@commcellId,'capture as ftp',2,'0',@curUtcDateTime,@curUtcDateTime),
													(@monitoringPolicyId,@commcellId,'Capture entire file',2,'0',@curUtcDateTime,@curUtcDateTime),
													(@monitoringPolicyId,@commcellId,'Capture lines before match',2,'0',@curUtcDateTime,@curUtcDateTime),
													(@monitoringPolicyId,@commcellId,'Capture lines after match',2,'0',@curUtcDateTime,@curUtcDateTime),
													(@monitoringPolicyId,@commcellId,'Capture log file header',2,'0',@curUtcDateTime,@curUtcDateTime),
													(@monitoringPolicyId,@commcellId,'Continuous monitoring',2,'1',@curUtcDateTime,@curUtcDateTime),
													(@monitoringPolicyId,@commcellId,'Creater User Id',7,@ownerId,@curUtcDateTime,@curUtcDateTime),
													(@monitoringPolicyId,@commcellId,'Do not monitor entries older than days',7,'7',@curUtcDateTime,@curUtcDateTime),
													(@monitoringPolicyId,@commcellId,'Do not monitor old data',2,'0',@curUtcDateTime,@curUtcDateTime),
													(@monitoringPolicyId,@commcellId,'Do not monitor older entries enabler',2,'0',@curUtcDateTime,@curUtcDateTime),
													(@monitoringPolicyId,@commcellId,'Enable CI',2,'1',@curUtcDateTime,@curUtcDateTime),
													(@monitoringPolicyId,@commcellId,'enable ci data ageing',2,'1',@curUtcDateTime,@curUtcDateTime),
													(@monitoringPolicyId,@commcellId,'enable geo loc detection',2,'0',@curUtcDateTime,@curUtcDateTime)
		INSERT INTO APP_MonitoringPolicyProp VALUES (@monitoringPolicyId,@commcellId,'extraction options',1,'',@curUtcDateTime,@curUtcDateTime),
													(@monitoringPolicyId,@commcellId,'Global Monitoring Internet Gateway',7,'0',@curUtcDateTime,@curUtcDateTime),
													(@monitoringPolicyId,@commcellId,'Global Monitoring Proxy Client Id',7,'0',@curUtcDateTime,@curUtcDateTime),
													(@monitoringPolicyId,@commcellId,'Global Monitoring User Id',7,'0',@curUtcDateTime,@curUtcDateTime),
													(@monitoringPolicyId,@commcellId,'Global Monitoring User Name',1,'',@curUtcDateTime,@curUtcDateTime),
													(@monitoringPolicyId,@commcellId,'Global Monitoring Web Service URL',1,'',@curUtcDateTime,@curUtcDateTime),
													(@monitoringPolicyId,@commcellId,'Global Policy Id',7, '0' ,@curUtcDateTime,@curUtcDateTime),
													(@monitoringPolicyId,@commcellId,'Global Policy Name',1,'',@curUtcDateTime,@curUtcDateTime),
													(@monitoringPolicyId,@commcellId,'index all lines',2,'1',@curUtcDateTime,@curUtcDateTime),
													(@monitoringPolicyId,@commcellId,'is NetApp Filler Content',7,'0',@curUtcDateTime,@curUtcDateTime),
													(@monitoringPolicyId,@commcellId,'Monitoring Type',7,'13'/**MonitoringType EDGEAUDIT**/,@curUtcDateTime,@curUtcDateTime),
													(@monitoringPolicyId,@commcellId,'Search in subfolders',2,'0',@curUtcDateTime,@curUtcDateTime),
													(@monitoringPolicyId,@commcellId,'size_1491350400',7,'1315',@curUtcDateTime,@curUtcDateTime),
													(@monitoringPolicyId,@commcellId,'size_1491782400',7,'4217',@curUtcDateTime,@curUtcDateTime),
													(@monitoringPolicyId,@commcellId,'size_1492041600',7,'1324',@curUtcDateTime,@curUtcDateTime),
													(@monitoringPolicyId,@commcellId,'SubClient Id',7,'0',@curUtcDateTime,@curUtcDateTime),
													(@monitoringPolicyId,@commcellId,'Delete File',2,'1',@curUtcDateTime,@curUtcDateTime),
													(@monitoringPolicyId,@commcellId,'Factor',7,'2',@curUtcDateTime,@curUtcDateTime)
		INSERT INTO APP_MonitoringPolicyProp VALUES (@monitoringPolicyId,@commcellId,'Content',1,'%LOG_DIR%EdgeDrive\'+@monitoringPolicyName,@curUtcDateTime,@curUtcDateTime)
		-- Associate edge client to newly created policy
		INSERT INTO App_EdgeDriveAssociation(clientId, entityType, entityId)
		SELECT @edgeClientId,90/**LM_MONITORING_POLICY_ENTITY**/,@monitoringPolicyId
    END
	IF NOT EXISTS(SELECT 1 FROM APP_MonitorAssocEntity WITH (NOLOCK)  WHERE monitorPolicyId = @monitoringPolicyId and clientId = @webserverId)
    BEGIN
		INSERT INTO APP_MonitorAssocEntity
		SELECT @monitoringPolicyId,@commcellId,3 /*CLIENT_ENTITY*/ ,@curUtcDateTime,0,/**index Webserver ID **/@webserverId,0
		SET @pushWQToken = 1	-- push workqueue to the new client
    END
	SELECT @isEdgeAuditConfigured = 1 from  APP_MonitoringPolicyProp WITH (NOLOCK) WHERE monitorPolicyId = @monitoringPolicyId and attrname ='Cloud ID' and (attrval is not null AND attrval  <> '' AND attrval <>'0' AND @monitoringPolicyStatus = 0)
	IF(@isEdgeAuditConfigured = 0)
	BEGIN
		SELECT TOP 1 @cloudId = C.cloudId , @cloudName = C.name FROM DM2Cloud C WITH (NOLOCK)
		INNER JOIN DM2SearchServerCoreInfo CR WITH (NOLOCK) ON C.CloudId = CR.CloudId
		WHERE CR.ClientId = @webserverId AND CR.Enabled = 1 AND CR.cloudType IN (1, 5)  --1 =legacy cloud & 5 =multimode cloud
		--if LogMonitoring(LM) role is assocaited to indexserver, update cloudid, cloudname and enable policy.
		--if LM role is not associated, then the server wall call API to add role,update cloudid, cloudname and enable policy.
		IF EXISTS(SELECT 1 from DM2CloudCoreRole WITH (NOLOCK) WHERE CloudId = @cloudId AND roleid = 3) -- AnalyticsEngineType_Log_Monitoring
		BEGIN
			-- Associate policy to the Analytics Engine
            --set cloud id
            UPDATE APP_MonitoringPolicyProp SET attrVal = @cloudId,   modified = @curUtcDateTime WHERE monitorPolicyId = @monitoringPolicyId and attrName = 'Cloud Id'
            SET @rowCount = @@ROWCOUNT
            IF(@rowCount = 0)
            BEGIN
                INSERT INTO APP_MonitoringPolicyProp VALUES (@monitoringPolicyId,@commcellId,'Cloud Id',7,@cloudId,@curUtcDateTime,@curUtcDateTime)
            END
            --set cloud name
            UPDATE APP_MonitoringPolicyProp SET attrVal = @cloudName, modified = @curUtcDateTime WHERE monitorPolicyId = @monitoringPolicyId and attrName = 'Cloud Name'
            SET @rowCount = @@ROWCOUNT
            IF(@rowCount = 0)
            BEGIN
                INSERT INTO APP_MonitoringPolicyProp VALUES (@monitoringPolicyId,@commcellId,'Cloud Name',1,@cloudName,@curUtcDateTime,@curUtcDateTime)
            END
            --Enabling EdgeAudit policy
            UPDATE APP_MonitoringPolicy SET STATUS = 0 WHERE monitorPolicyId = @monitoringPolicyId
            SET @isEdgeAuditConfigured = 1
        END
		SET @pushWQToken = 1	-- push workqueue as the policy is not enabled yet.
	END
	IF @errorCode=0
		COMMIT TRANSACTION
	ELSE
	    ROLLBACK TRANSACTION
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
            SET @error = ( SELECT
                            ERROR_NUMBER() '@errorCode',
                            'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE() '@errorMessage'
                           FOR XML PATH('error'), TYPE
                         )
			ROLLBACK TRANSACTION
END  CATCH
SELECT	@isEdgeAuditConfigured AS '@isConfigured',
		@monitoringPolicyId AS '@monitoringPolicyId',
		@cloudId      AS '@cloudId',
        @cloudName    AS '@cloudName',
        @pushWQToken  AS '@pushWorkQueue',
		@webserverId  AS '@associatedWebServerId',
		@error FOR XML PATH('Api_ConfigureEdgeDriveAuditResponse'),TYPE

IF EXISTS (select * from GxQscripts where name = 'AppConfigureEdgeDriveAudit')
	delete from GxQscripts where name = 'AppConfigureEdgeDriveAudit'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppConfigureEdgeDriveAudit')
	delete from GXDBVersions where aliasname = 'AppConfigureEdgeDriveAudit'
GO

insert into GXDBVersions values(2, 'AppConfigureEdgeDriveAudit',  '00010001000200110000', 'AppConfigureEdgeDriveAudit', '00010001000200110000')
GO

