

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppConfigureAnalyticsJobAlertMonitoringPolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- 	+-----------------------------------------------------------------------+
--	| 		PROCEDURE: "AppConfigureAnalyticsJobAlertMonitoringPolicy"                                   |
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppConfigureAnalyticsJobAlertMonitoringPolicy <<<'

IF EXISTS (select * from sysobjects where name='AppConfigureAnalyticsJobAlertMonitoringPolicy')
	drop procedure AppConfigureAnalyticsJobAlertMonitoringPolicy
IF EXISTS (select * from GxQscripts where name='AppConfigureAnalyticsJobAlertMonitoringPolicy')
	delete from GxQscripts where name = 'AppConfigureAnalyticsJobAlertMonitoringPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppConfigureAnalyticsJobAlertMonitoringPolicy')
	delete from GXDBVersions where aliasname = 'AppConfigureAnalyticsJobAlertMonitoringPolicy'
GO
print '... Creating Procedure: AppConfigureAnalyticsJobAlertMonitoringPolicy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure AppConfigureAnalyticsJobAlertMonitoringPolicy
  @dummy integer
AS
SET NOCOUNT ON
DECLARE @now INT = dbo.getunixTime(GETDATE())
DECLARE @monitorPolicyName NVARCHAR(MAX) = N'System Created - Analytics Job Alert'
DECLARE @cloudId INT = 0
DECLARE @cloudName NVARCHAR(MAX) = N''
DECLARE @LMCloudInfo TABLE ( serverName NVARCHAR(MAX), clientId INT, clientName NVARCHAR(MAX), cloudId INT,
							hostName NVARCHAR(MAX), baePort INT, ver NVARCHAR(MAX), engineName NVARCHAR(MAX), cloudType INT, indexServerClientId INT, internalCloudName NVARCHAR(MAX))
INSERT @LMCloudInfo
EXEC DM2GetAllAnalyticsEngine 'Log Monitoring'
-- If Log Monitoring role is configured then only proceed for policy operation
IF EXISTS ( SELECT 1 FROM @LMCloudInfo )
BEGIN
    DELETE @LMCloudInfo
	-- Sync the policy for associate clients and Index server and will send work request.
	IF EXISTS ( SELECT 1
				FROM APP_MonitoringPolicy A WITH(NOLOCK) , APP_MonitoringPolicyProp B WITH(NOLOCK)
				WHERE A.monitorPolicyId = B.monitorPolicyId
				AND A.status <> 3
				AND B.attrName = N'Monitoring SubType'
				AND B.attrVal = 1)
	BEGIN
		DECLARE @monPolicyId INT = (SELECT A.monitorPolicyId
									FROM APP_MonitoringPolicy A WITH(NOLOCK) , APP_MonitoringPolicyProp B WITH(NOLOCK)
									WHERE A.monitorPolicyId = B.monitorPolicyId
									AND A.status <> 3
									AND B.attrName = N'Monitoring SubType'
									AND B.attrVal = 1)	-- Data Cube alert policy.
		IF @monPolicyId > 0
		BEGIN
			IF NOT EXISTS ( SELECT 1
							FROM APP_MonitoringPolicyProp WITH(NOLOCK)
							WHERE monitorPolicyId = @monPolicyId
							AND attrName = N'Cloud Id'
							AND CONVERT(INT,attrVal) > 0)
			BEGIN
				INSERT @LMCloudInfo
				EXEC DM2GetAllAnalyticsEngine 'Log Monitoring'
				IF EXISTS(SELECT 1 FROM @LMCloudInfo)
				BEGIN
					SELECT TOP(1) @cloudId = cloudId , @cloudName = engineName
					FROM @LMCloudInfo
				END
				UPDATE APP_MonitoringPolicyProp
				SET attrVal = @cloudId
				WHERE monitorPolicyId = @monPolicyId
					AND attrName = N'Cloud Id'
				UPDATE APP_MonitoringPolicyProp
				SET attrVal = @cloudName
				WHERE monitorPolicyId = @monPolicyId
				AND attrName = N'Cloud Name'
			END
			DECLARE @assocOldClientId TABLE( clientId INT)
			INSERT @assocOldClientId
			SELECT clientid
			FROM APP_MonitorAssocEntity WITH(NOLOCK)
			WHERE monitorPolicyId = @monPolicyId
			-- We will associate only client which have data analytics enabled.
			DELETE @LMCloudInfo
			INSERT @LMCloudInfo
			EXEC DM2GetAllAnalyticsEngine 'Data Analytics'
			DECLARE @assocNewCLientId TABLE(clientId INT)
			INSERT @assocNewCLientId
			SELECT clientId FROM @LMCloudInfo
			DELETE A
			FROM APP_MonitorAssocEntity A
				LEFT OUTER JOIN  @assocNewCLientId B
					ON A.monitorPolicyId = @monPolicyId
					AND A.clientId = B.clientId
			WHERE A.monitorPolicyId = @monPolicyId  AND B.clientId IS NULL
			INSERT APP_MonitorAssocEntity
			SELECT @monPolicyId,2,3 ,@now,0,B.clientId ,0
			FROM @assocNewCLientId B
				LEFT OUTER JOIN APP_MonitorAssocEntity A WITH(NOLOCK)
					ON A.monitorPolicyId = @monPolicyId
					AND A.clientId = B.clientId
			WHERE  A.clientId IS NULL
			IF NOT EXISTS ( SELECT 1 FROM APP_MonitorAssocEntity A WITH(NOLOCK) WHERE monitorPolicyId = @monPolicyId)
			BEGIN
			   -- then just disable the policy .
			   UPDATE APP_MonitoringPolicy
			   SET status = 1
			   WHERE monitorPolicyId = @monPolicyId
			END
			ELSE
			BEGIN
         -- enable the policy.
			   UPDATE APP_MonitoringPolicy
			   SET status = 0
			   WHERE monitorPolicyId = @monPolicyId
			END
		--populate work queue request clients
			DECLARE @workClientRequest TABLE(clientid INT)
			INSERT @workClientRequest
			SELECT *
			FROM @assocOldClientId
			UNION
			SELECT *
			FROM @assocNewCLientId
			DECLARE @editSyncReq  NVARCHAR(MAX) = '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><TMMsg_MonitoringPolicyChangeReq monitoringPolicyId="' + CONVERT(NVARCHAR(MAX),@monPolicyId) + '" operationType="1"/>'
			DECLARE @returnSyncCode TABLE (errorCode INT, errorMessage NVARCHAR(MAX))
			DECLARE clientIdList CURSOR FOR SELECT clientId FROM @workClientRequest
			OPEN clientIdList
			DECLARE @clts INT
			FETCH NEXT FROM clientIdList INTO @clts
			WHILE @@FETCH_STATUS = 0
			BEGIN
				INSERT @returnSyncCode
				EXEC AppWorkQueueSubmitRequest 8/*WORK_TOKEN_LOGMONITORING*/, 0, 0, @clts, 0, @editSyncReq
				FETCH NEXT FROM clientIdList INTO @clts
			END
			CLOSE clientIdList
			DEALLOCATE clientIdList
		END
	END
	ELSE   -- we will create a new policy
	BEGIN
		DELETE @LMCloudInfo
		INSERT @LMCloudInfo
		EXEC DM2GetAllAnalyticsEngine 'Data Analytics'
		IF EXISTS(SELECT 1 FROM @LMCloudInfo)  -- will only create policy when there is Data Analytics role is congfigured
		BEGIN
		   DELETE @LMCloudInfo
		   INSERT @LMCloudInfo
		   EXEC DM2GetAllAnalyticsEngine 'Log Monitoring'
			SELECT TOP(1) @cloudId = cloudId , @cloudName = engineName FROM @LMCloudInfo
			DECLARE @oem NVARCHAR(510)
			SET @oem = (SELECT OEM.OEMName
						FROM simOEM OEM WITH(NOLOCK)
						WHERE OEM.OEMid = (	SELECT TOP(1) CONVERT(INT, GX.value)
											FROM GXGlobalParam GX
											WHERE GX.name = N'MiniBrandid'))
			DECLARE @primarytemplateName NVARCHAR(MAX) = ISNULL(@oem, N'Commvault') + N' DataCube Log'
			DECLARE @primarytemplateId INT = (	SELECT templateId
												FROM APP_template WITH(NOLOCK)
												WHERE templateName = @primarytemplateName
												AND status NOT IN ( 3,4))
			DECLARE @templatexml NVARCHAR(MAX) = N'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><LogMonitoring_TemplateXML isFixedWidth="0" templateForMonitoringType="0"><columns aliasName="Job Status" convertInUTC="0" decimalPlaces="2" defaultOpType="0" format="" index="0" isFacet="1" isIndexed="1" isStored="1" isTokenized="0" primaryDataType="1" primaryTypeFormat="21" solrFieldName="status" useThousandSeparator="0"><column _type_="87" columnId="1238" columnName="status"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/><supportedOpTypes val="2"/><supportedOpTypes val="3"/><dataExtractionOption/></columns><columns aliasName="Data Source Id" convertInUTC="0" decimalPlaces="2" defaultOpType="0" format="" index="1" isFacet="1" isIndexed="1" isStored="1" isTokenized="0" primaryDataType="0" primaryTypeFormat="0" solrFieldName="datasource" useThousandSeparator="0"><column _type_="87" columnId="1239" columnName="datasource"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/><supportedOpTypes val="2"/><supportedOpTypes val="3"/><dataExtractionOption/></columns><columns aliasName="Data Source Name" convertInUTC="0" decimalPlaces="2" defaultOpType="0" format="" index="2" isFacet="1" isIndexed="1" isStored="1" isTokenized="0" primaryDataType="1" primaryTypeFormat="21" solrFieldName="name" useThousandSeparator="0"><column _type_="87" columnId="1240" columnName="name"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/><supportedOpTypes val="2"/><supportedOpTypes val="3"/><dataExtractionOption/></columns><columns aliasName="Type" convertInUTC="0" decimalPlaces="2" defaultOpType="0" format="" index="3" isFacet="1" isIndexed="1" isStored="1" isTokenized="0" primaryDataType="1" primaryTypeFormat="21" solrFieldName="type" useThousandSeparator="0"><column _type_="87" columnId="1241" columnName="type"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/><supportedOpTypes val="4"/><supportedOpTypes val="5"/><supportedOpTypes val="6"/><supportedOpTypes val="7"/><supportedOpTypes val="8"/><dataExtractionOption/></columns><columns aliasName="Total" convertInUTC="0" decimalPlaces="2" defaultOpType="0" index="4" isFacet="1" isIndexed="1" isStored="1" isTokenized="0" primaryDataType="0" primaryTypeFormat="0" solrFieldName="total" useThousandSeparator="0"><column _type_="87" columnId="1242" columnName="total"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/><supportedOpTypes val="4"/><supportedOpTypes val="5"/><supportedOpTypes val="6"/><supportedOpTypes val="7"/><supportedOpTypes val="8"/><dataExtractionOption/></columns><columns aliasName="Success" convertInUTC="0" decimalPlaces="2" defaultOpType="0" format="" index="5" isFacet="1" isIndexed="1" isStored="1" isTokenized="0" primaryDataType="0" primaryTypeFormat="0" solrFieldName="success" useThousandSeparator="0"><column _type_="87" columnId="1243" columnName="success"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/><supportedOpTypes val="2"/><supportedOpTypes val="3"/><dataExtractionOption/></columns><columns aliasName="Failed" convertInUTC="0" decimalPlaces="2" defaultOpType="0" format="" index="6" isFacet="1" isIndexed="1" isStored="1" isTokenized="0" primaryDataType="0" primaryTypeFormat="0" solrFieldName="failed" useThousandSeparator="0"><column _type_="87" columnId="1244" columnName="failed"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/><supportedOpTypes val="2"/><supportedOpTypes val="3"/><dataExtractionOption/></columns><columns aliasName="Error Code" convertInUTC="0" decimalPlaces="2" defaultOpType="0" index="7" isFacet="1" isIndexed="1" isStored="1" isTokenized="0" primaryDataType="0" primaryTypeFormat="0" solrFieldName="code" useThousandSeparator="0"><column _type_="87" columnId="1245" columnName="code"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/><supportedOpTypes val="4"/><supportedOpTypes val="5"/><supportedOpTypes val="6"/><supportedOpTypes val="7"/><supportedOpTypes val="8"/><dataExtractionOption/></columns><columns aliasName="Message" convertInUTC="0" decimalPlaces="2" defaultOpType="0" format="" index="8" isFacet="1" isIndexed="1" isStored="1" isTokenized="0" primaryDataType="1" primaryTypeFormat="22" solrFieldName="message_Count" useThousandSeparator="0"><column _type_="87" columnId="1246" columnName="message Count"/><supportedOpTypes val="0"/><supportedOpTypes val="1"/><supportedOpTypes val="2"/><supportedOpTypes val="3"/><dataExtractionOption/></columns><primaryTemplate _type_="86" templateId="' + CONVERT(NVARCHAR(MAX), @primarytemplateId)  + N'" templateName="'+ @primarytemplateName+ N'" /></LogMonitoring_TemplateXML>'
			DECLARE @secondaryTemplateName NVARCHAR(MAX) = N'Analytics Job Alert'
			IF NOT EXISTS ( SELECT 1
							FROM APP_template WITH(NOLOCK)
							WHERE templateName = @secondaryTemplateName
							AND status = 4 )
			BEGIN
				INSERT APP_Template (commcellId, templateName, templateXML, templateDescription, created, modified, templateForMonitoringType, status)
				SELECT 2, @secondaryTemplateName, @templatexml, N'Template used for indexing Analytics job alert data.', @now, 0, 12 /*DATACUBE_ALERT*/, 4
			END
			DECLARE @secondaryTemplateId INT = (SELECT templateId
												FROM APP_Template WITH(NOLOCK)
												WHERE templateName = @secondaryTemplateName
												AND status = 4)
			INSERT APP_MonitoringPolicy (commcellId, MonitorPolicyName, created, modified, description, status)
			SELECT 2, @monitorPolicyName, @now, @now, N'System created policy for analytics job alert', 0
			DECLARE @monPolId INT =(SELECT monitorPolicyId
									FROM APP_MonitoringPolicy WITH(NOLOCK)
									WHERE MonitorPolicyName = @monitorPolicyName
									AND status <> 3)
			INSERT APP_MonitorTemplateAssoc ( monitorPolicyId, commcellId, templateId)
			SELECT @monPolId, 2 , @primarytemplateId
			INSERT APP_MonitorTemplateAssoc ( monitorPolicyId, commcellId, templateId)
			SELECT @monPolId, 2 , @secondaryTemplateId
			INSERT APP_MonitoringPolicyProp
			(monitorPolicyId, commcellId, attrName, attrType, attrVal, created, modified)VALUES
			(@monPolId,	2,	N'age ci data after days',					7,	N'3',	@now,	@now),
			(@monPolId,	2,	N'capture as attachment',					2,	N'0',	@now,	@now),
			(@monPolId,	2,	N'capture as ftp',							2,	N'0',	@now,	@now),
			(@monPolId,	2,	N'Capture entire file',						2,	N'0',	@now,	@now),
			(@monPolId,	2,	N'Capture Entire folder',					2,	N'0',	@now,	@now),
			(@monPolId,	2,	N'Capture lines after match',				2,	N'0',	@now,	@now),
			(@monPolId,	2,	N'Capture lines before match',				2,	N'0',	@now,	@now),
			(@monPolId,	2,	N'Capture log file header',					2,	N'0',	@now,	@now),
			(@monPolId,	2,	N'Cloud Policy Id',							7,	N'0',	@now,	@now),
			(@monPolId,	2,	N'Continuous monitoring',					2,	N'1',	@now,	@now),
			(@monPolId,	2,	N'Creater User Id',							7,	N'1',	@now,	@now),
			(@monPolId,	2,	N'Discover Event',							2,	N'0',	@now,	@now),
			(@monPolId,	2,	N'Do not monitor entries older than days',	7,	N'7',	@now,	@now),
			(@monPolId,	2,	N'Do not monitor old data',					2,	N'0',	@now,	@now),
			(@monPolId,	2,	N'Do not monitor older entries enabler',	2,	N'0',	@now,	@now),
			(@monPolId,	2,	N'Enable CI',								2,	N'1',	@now,	@now),
			(@monPolId,	2,	N'enable ci data ageing',					2,	N'1',	@now,	@now),
			(@monPolId,	2,	N'enable geo loc detection',				2,	N'0',	@now,	@now),
			(@monPolId,	2,	N'Global Monitoring Internet Gateway',		7,	N'0',	@now,	@now),
			(@monPolId,	2,	N'Global Monitoring Proxy Client Id',		7,	N'0',	@now,	@now),
			(@monPolId,	2,	N'Global Monitoring User Id',				7,	N'0',	@now,	@now),
			(@monPolId,	2,	N'Global Policy Id',						7,	N'0',	@now,	@now),
			(@monPolId,	2,	N'index all lines',							2,	N'0',	@now,	@now),
			(@monPolId,	2,	N'is NetApp Filler Content',				7,	N'0',	@now,	@now),
			(@monPolId,	2,	N'lm task id',								7,	N'70',	@now,	@now),
			(@monPolId,	2,	N'Monitoring Type',							7,	N'0',	@now,	@now),
			(@monPolId,	2,	N'Number of line after match',				7,	N'5',	@now,	@now),
			(@monPolId,	2,	N'Number of lines before match',			7,	N'1',	@now,	@now),
			(@monPolId,	2,	N'Policy Expiry Time',						7,	N'0',	@now,	@now),
			(@monPolId,	2,	N'Search in subfolders',					2,	N'0',	@now,	@now),
			(@monPolId,	2,	N'Store captured data',						2,	N'0',	@now,	@now),
			(@monPolId,	2,	N'SubClient Id',							7,	N'0',	@now,	@now),
			(@monPolId,	2,	N'Global Monitoring User Name',				1,	N'',	@now,	@now),
			(@monPolId,	2,	N'Global Monitoring Web Service URL',		1,	N'',	@now,	@now),
			(@monPolId,	2,	N'Except these',							1,	N'',	@now,	@now),
			(@monPolId,	2,	N'Exclude these',							1,	N'',	@now,	@now),
			(@monPolId,	2,	N'extraction options',						1,	N'',	@now,	@now),
			(@monPolId,	2,	N'Global Policy Name',						1,	N'',	@now,	@now),
			(@monPolId,	2,	N'user name for unc path',					1,	N'',	@now,	@now),
			(@monPolId,	2,	N'Content',									1,	N'%LOG_DIR%DataCube.log%LOG_DIR%DataCube_*',	@now,	@now),
			(@monPolId,	2,	N'Monitoring SubType',						7,	N'1',	@now,	@now)
			INSERT APP_MonitoringPolicyProp
			(monitorPolicyId, commcellId, attrName, attrType, attrVal, created, modified)
			VALUES
			(@monPolId,	2,	N'Cloud Id',								7,	CONVERT(NVARCHAR(MAX),@cloudId),	@now,	@now),
			(@monPolId,	2,	N'Cloud Name',								1,	@cloudName,	@now,	@now)
			INSERT APP_Criteria (commcellId, monitorPolicyId, templateId, criteriaXML, severity, created)
			VALUES(2, @monPolId,@primarytemplateId,N'<?xml version=''1.0'' encoding=''UTF-8''?><LogMonitoring_ConditionsList criteriaName="(INFO  \(Thread-\d+\) \[   \] com\.commvault\.app\.business\.crawl\.CrawlStatus Job information with status matches any column)" opBetweenConditions="0"><conditionForMatchAnyColumn matchWholeWord="0" isCaseSensitive="0" value2="" value1="INFO  \(Thread-\d+\) \[   \] com\.commvault\.app\.business\.crawl\.CrawlStatus Job information with status" isInclusive="0" isregex="1"><column columnName="" /></conditionForMatchAnyColumn></LogMonitoring_ConditionsList>', 0 , @now)
			DECLARE @assocClientId TABLE(clientid INT)
			-- We will associate only those clients which have data analytics enabled.
			DELETE @LMCloudInfo
			INSERT @LMCloudInfo
			EXEC DM2GetAllAnalyticsEngine 'Data Analytics'
			INSERT @assocClientId
			SELECT DISTINCT clientId
			FROM @LMCloudInfo
			INSERT INTO APP_MonitorAssocEntity
			SELECT @monPolId,2,3 ,@now,0,clientId ,0
			FROM @assocClientId
			DECLARE @editReq  NVARCHAR(MAX) = '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><TMMsg_MonitoringPolicyChangeReq monitoringPolicyId="' + CONVERT(NVARCHAR(MAX),@monPolId) + '" operationType="1"/>'
			DECLARE @returnCode TABLE (errorCode INT, errorMessage NVARCHAR(MAX))
			DECLARE clientIdList CURSOR FOR SELECT clientId FROM @assocClientId
			OPEN clientIdList
			DECLARE @clt INT
			FETCH NEXT FROM clientIdList INTO @clt
			WHILE @@FETCH_STATUS = 0
			BEGIN
				INSERT @returnCode
				EXEC AppWorkQueueSubmitRequest 8/*WORK_TOKEN_LOGMONITORING*/, 0, 0, @clt, 0, @editReq
				FETCH NEXT FROM clientIdList INTO @clt
			END
			CLOSE clientIdList
			DEALLOCATE clientIdList
		END
	END
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppConfigureAnalyticsJobAlertMonitoringPolicy')
	delete from GxQscripts where name = 'AppConfigureAnalyticsJobAlertMonitoringPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppConfigureAnalyticsJobAlertMonitoringPolicy')
	delete from GXDBVersions where aliasname = 'AppConfigureAnalyticsJobAlertMonitoringPolicy'
GO

insert into GXDBVersions values(2, 'AppConfigureAnalyticsJobAlertMonitoringPolicy',  '00000000000000000000', 'AppConfigureAnalyticsJobAlertMonitoringPolicy', '00000000000000000000')
GO

