

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppConfigureAdminDLOInvitedUser.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppConfigureAdminDLOInvitedUser.sp,v $ $Id: AppConfigureAdminDLOInvitedUser.sp,v 1.1.2.12 2017/12/27 18:19:55 evolohov Exp $";
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppConfigureAdminDLOInvitedUser <<<'

IF EXISTS (select * from sysobjects where name='AppConfigureAdminDLOInvitedUser')
	drop procedure AppConfigureAdminDLOInvitedUser
IF EXISTS (select * from GxQscripts where name='AppConfigureAdminDLOInvitedUser')
	delete from GxQscripts where name = 'AppConfigureAdminDLOInvitedUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppConfigureAdminDLOInvitedUser')
	delete from GXDBVersions where aliasname = 'AppConfigureAdminDLOInvitedUser'
GO
print '... Creating Procedure: AppConfigureAdminDLOInvitedUser'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppConfigureAdminDLOInvitedUser
  @initiatorUserId INT,
  @inUsers XML
AS
  DECLARE @errorCode INT = 0
  DECLARE @errorString VARCHAR(MAX) = 'Success'
  DECLARE @downloadPackageList VARCHAR(MAX) = ''
  DECLARE @registerAndDownloadPackageList VARCHAR(MAX) = ''
  DECLARE @updatePlanUsersResponse VARCHAR(max) = ''
  DECLARE @registerAndDownloadSystemGeneratedPackageList VARCHAR(MAX) = ''
DECLARE @InviteUserTBL TABLE (sendInvite NVARCHAR(MAX),userEmail NVARCHAR(MAX), providerID INT, loginName NVARCHAR(MAX), userId INT DEFAULT 0,name NVARCHAR(255) DEFAULT '', description NVARCHAR(MAX) DEFAULT '', userGuid  NVARCHAR(256)  DEFAULT '', isSystemGenerated int default 0)
DECLARE @providerIdOfInitiator INT = ISNULL( (SELECT umDSproviderId FROM UMUsers WHERE id = @initiatorUserId), 0)
DECLARE @ownerCompany INT = (SELECT ownerCompany FROM UMDSProviders WHERE id = @providerIdOfInitiator)
IF @ownerCompany != 0
	SET @ownerCompany = (SELECT id FROM UMDSProviders WHERE id = @ownerCompany)
ELSE
	SET @ownerCompany = @providerIdOfInitiator
DECLARE @ownerCompanyName nvarchar(255)
SET @ownerCompanyName = (SELECT domainName FROM UMDSProviders WHERE id = @ownerCompany)
BEGIN TRY
----------------Users Begin---------------------------------------------------------
	INSERT INTO @InviteUserTBL(sendInvite,userEmail,loginName,providerID, userId, name, description, userGuid)
	SELECT R.ref.value('@sendInvite', 'VARCHAR(MAX)'), R.ref.value('@email','VARCHAR(MAX)'),S.usr.value('@userName','VARCHAR(MAX)'),ISNULL(T.prv.value('@providerId','INT'),0),ISNULL(S.usr.value('@userId','INT'),0),'','',S.usr.value('@userGUID','NVARCHAR(MAX)')
	FROM @inUsers.nodes('Api_UpdatePlanUsers/users') R(ref)
		OUTER APPLY ref.nodes('user') S(usr)
		OUTER APPLY ref.nodes('provider') T(prv)
	--Check for external group information. --here idleTime is used to populate
	INSERT INTO @InviteUserTBL(sendInvite,userEmail,loginName,providerID, userId, name,description, userGuid )
	SELECT R.ref.value('@idleTime', 'INT'), R.ref.value('@email','NVARCHAR(MAX)'),S.usr.value('@userName','NVARCHAR(MAX)'),T.prv.value('@providerId','INT'),ISNULL(S.usr.value('@userId','INT'),0),R.ref.value('@fullName','NVARCHAR(MAX)'), R.ref.value('@description','NVARCHAR(MAX)'),S.usr.value('@userGUID','NVARCHAR(MAX)')
	FROM @inUsers.nodes('App_UpdateUserPropertiesRequest/users') R(ref)
		OUTER APPLY ref.nodes('userEntity') S(usr)
		OUTER APPLY ref.nodes('provider') T(prv)
	delete @InviteUserTBL where sendInvite is null and userEmail is null  and providerID =0 and loginName is null and userId=0--need to come up with better idea
	--populate the information about existing users
	MERGE @InviteUserTBL T
	USING UMusers S
	ON (T.userId = S.id)
    WHEN MATCHED
		THEN UPDATE SET T.userEmail = S.email, T.loginName=S.login, T.providerId=S.umdsproviderId;
	-- Identify existing userid of ADUsers
	MERGE @InviteUserTBL T
	USING UMusers S
	ON (T.providerId > 0 AND T.loginName = S.login)
	WHEN MATCHED
		THEN UPDATE SET T.userId = S.id;
	--for external group and local group users we only got emails. populate information about users by using emails
	MERGE @InviteUserTBL AS T
	USING UMUsers AS S
	ON (T.userId<=0 AND T.userEmail = S.email and flags <> 0 and len(T.userEmail)>0)
	WHEN MATCHED
		THEN UPDATE SET T.userId = S.id, T.loginName=S.login, T.providerId=S.umdsproviderId;
	--update login name for the users getting created by organization user
	if(@ownerCompany>0)--create user under owner company
			update @InviteUserTBL set loginName=@ownerCompanyName+'\'+LEFT(userEmail, (CHARINDEX('@', userEmail) - 1))
			where userId<=0 and (providerID=0 or providerID is null)
	UPDATE T
		SET T.isSystemGenerated = 1
		FROM @InviteUserTBL AS T
		INNER JOIN UMUsersProp prop on userId=0 OR (componentNameId=userId and attrName ='System Generated user' and attrVal='1' and modified=0)
	--insert AD users
	MERGE UMUsers AS T
	USING (select DISTINCT userEmail, providerId, loginName, userId, name, description, userguid from @InviteUserTBL WHERE userId <= 0) AS S
	ON (S.loginName = T.login)
	WHEN NOT MATCHED BY TARGET AND S.providerId <> 0 AND S.userEmail IS NOT NULL
		THEN
			INSERT ([name]
								,[description]
								,[login]
								,[password]
								,[email]
								,[datePasswordSet]
								,[dateExpires]
								,[policy]
								,[enabled]
								,[flags]
								,[modified]
								,[pVer]
								,[Pager]
								,[lastLogInTime]
								,[credSetTime]
								,[umDSproviderId]
								,[userGuid]
								,[origUserGuid])
			VALUES(				S.name, --name
								S.description, -- description
								S.loginName, -- login
								'2ALXqLLXNLLX0LLXcLLXxLL',-- password
								S.userEmail,--email
								0,--datePWDset
								0,--dateExpires
								0,--policy
								1,--enabled
								1,--flags
								0,--modified
								0,--pVer
								0,--Pager
								0,--lastLogInTime
								0,--credSetTime
								S.providerID,--umDSproviderId
								S.userGUID,--userGUID
								''--origUserGuid
								);
	--insert regular user
	MERGE UMUsers AS T
	USING @InviteUserTBL AS S--(select DISTINCT userEmail, providerId, loginName, aliasName, userId from @InviteUserTBL) AS S
	ON (S.userEmail = T.email and t.flags<>0)
	WHEN NOT MATCHED BY TARGET AND (S.providerID is null or S.providerID=0) AND S.userId <= 0  AND S.userEmail IS NOT NULL
		THEN
			INSERT ([name]
								,[description]
								,[login]
								,[password]
								,[email]
								,[datePasswordSet]
								,[dateExpires]
								,[policy]
								,[enabled]
								,[flags]
								,[modified]
								,[pVer]
								,[Pager]
								,[lastLogInTime]
								,[credSetTime]
								,[umDSproviderId]
								,[userGuid]
								,[origUserGuid])
			VALUES(				LEFT(S.userEmail, (CHARINDEX('@', S.userEmail) - 1)), --name
								LEFT(S.userEmail, (CHARINDEX('@', S.userEmail) - 1)), -- description
								S.loginName, -- login
								(select dbo.EncodeSecretCLR(SUBSTRING(CONVERT(varchar(40), NEWID()),0,9) )),-- password
								S.userEmail,--email
								0,--datePWDset
								0,--dateExpires
								0,--policy
								1,--enabled
								1,--flags
								0,--modified
								0,--pVer
								0,--Pager
								0,--lastLogInTime
								0,--credSetTime
								@ownerCompany,--umDSproviderId
								NEWID(),--userGUID
								''--origUserGuid
								);
		--Identify userid of ADUsers
	MERGE @InviteUserTBL T
	USING UMusers S
	ON (T.loginName = S.login)
	WHEN MATCHED
		THEN UPDATE SET T.userId = S.id;
	--Identify userid of Registred Non AD Users
	MERGE @InviteUserTBL T
	USING UMusers S
	ON (T.userEmail = S.email AND T.providerID IS NULL)
	WHEN MATCHED
		THEN UPDATE SET T.userId = S.id;
	--set System generated flag
	MERGE UMUsersProp P
	USING (select U.Id, U.umdsProviderID From UMUsers U JOIN @InviteUserTBL T on U.id = T.userId and T.isSystemGenerated = 1) S
	ON (S.Id = P.componentNameId and P.attrName = 'System Generated user')
	WHEN NOT MATCHED
	--and ((SELECT ServiceType FROM UMDSProviders WHERE id = S.umdsProviderId) != 2
	--AND (SELECT ServiceType FROM UMDSProviders WHERE id = S.umdsProviderId) != 3 ) --Neither AD not Domino
	THEN INSERT
		(
			componentNameId,
			attrName,
			attrType,
			attrVal,
			created,
			modified
		)
	VALUES
		(
			S.Id,
			'System Generated user',
			7,
			'1',
			dbo.GetUnixTime (GetUTCdate()),
			0
		);
	-- Set for password change
	MERGE UMUsersProp P
	USING (select U.Id, U.umdsProviderID From UMUsers U JOIN @InviteUserTBL T on U.id = T.userId WHERE U.lastLogInTime = 0) S
	ON (S.Id = P.componentNameId and P.attrName = 'Enforce Password Change')
	WHEN NOT MATCHED and ((SELECT ServiceType FROM UMDSProviders WHERE id = S.umdsProviderId) != 2 AND (SELECT ServiceType FROM UMDSProviders WHERE id = S.umdsProviderId) != 3 ) --Neither AD not Domino
	THEN INSERT
		(
			componentNameId,
			attrName,
			attrType,
			attrVal,
			created,
			modified
		)
	VALUES
		(
			S.Id,
			'Enforce Password Change',
			7,
			'1',
			dbo.GetUnixTime (GetUTCdate()),
			0
		);
-- Set for invite sent
	MERGE UMUsersProp AS U
		USING (select userId from @InviteUserTBL where sendInvite = '1') AS S
		ON (U.componentNameId = S.userId AND U.ATTRNAME = 'Invitation sent' AND U.modified=0 and attrVal=1)
		WHEN MATCHED
		THEN
			UPDATE  SET U.created =  dbo.GetUnixTime (GetUTCdate())
		WHEN NOT MATCHED BY TARGET AND S.userId != 0
			THEN INSERT ([componentNameId], [attrName],[attrType], [attrVal], [created], [modified])
			VALUES(S.userId, 'Invitation sent',7, 1,  dbo.GetUnixTime (GetUTCdate()), 0);
----------------Users End---------------------------------------------------------
----------------External Groups Begin---------------------------------------------------------
	DECLARE @InviteExternalUserTBL TABLE (sendInvite VARCHAR(MAX), ExternalGroupName VARCHAR(MAX), ExternalGroupId int, ProviderName varchar(max), providerID INT)
	INSERT INTO @InviteExternalUserTBL(sendInvite, ExternalGroupName, ExternalGroupId, ProviderName, providerID)
	SELECT extGroup.ref.value('@sendInvite', 'VARCHAR(MAX)'),  S.usr.value('@externalGroupName', 'VARCHAR(MAX)'), ISNULL(S.usr.value('@groupId', 'int'),0), S.usr.value('@providerDomainName', 'VARCHAR(MAX)'), ISNULL(S.usr.value('@providerId', 'int'),0)
	FROM @inUsers.nodes('Api_UpdatePlanUsers/users') extGroup (ref)
		CROSS APPLY ref.nodes('externalUserGroup') S(usr)
-- Set the providerId in the input
	MERGE @InviteExternalUserTBL T
    USING UMDSProviders S
    ON (T.providerName = S.domainName)
    WHEN MATCHED
        THEN UPDATE SET T.providerId = S.id;
-- Set group id
	MERGE @InviteExternalUserTBL T
    USING UMGroups UG
    ON (T.externalGroupName = UG.name AND UG.umdsproviderId = T.providerId AND T.ExternalGroupId <= 0 )
    WHEN MATCHED
        THEN UPDATE SET T.ExternalGroupId = UG.id;
-- Insert the AD groups in the table
	MERGE UMGROUPS AS T
	USING @InviteExternalUserTBL AS S --(select DISTINCT userEmail, providerId, loginName, aliasName, userId FROM @InviteUserTBL) AS S
	ON ((T.id = S.externalGroupId) OR (S.ExternalGroupName = T.NAME AND S.providerId =T.umdsProviderId))
	WHEN MATCHED AND groupFlags = 0
	THEN
UPDATE SET groupFlags = (groupFlags | 0x0001) & ~ CAST(0x0020 AS INT) -- If ad group is deleted and you are re-associating it to plan, then enable existing group.
	WHEN NOT MATCHED BY TARGET
	THEN
	INSERT  ([groupFlags]
           ,[allCapabilities]
           ,[allAssociations]
           ,[selfAssociation]
           ,[name]
           ,[description]
           ,[origCCId]
           ,[GUID]
           ,[umdsProviderId]
           ,[email]
           ,[lastCredSetTime])
     VALUES
           (1
           ,0
           ,0
           ,1
           ,S.ExternalGroupName
           ,''
           ,2
           ,NEWID()
           ,S.providerId
           ,''
           ,0);
	MERGE UMDSGROUPS AS T
	USING (select U.id, temp.ExternalGroupName, temp.providerId FROM UMGROUPS U JOIN @InviteExternalUserTBL temp ON U.NAME = temp.ExternalGroupName AND u.umdsProviderId = temp.providerID) S
	ON (S.ExternalGroupName = T.NAME AND S.providerId = T.umdsProviderId)
	WHEN NOT MATCHED BY TARGET
	THEN
	INSERT  ([id]
           ,[umdsProviderId]
           ,[enabled]
           ,[name]
           ,[description]
           ,[email]
           ,[lastCredSetTime]
           ,[oldId])
     VALUES(
           S.id
           ,S.providerId
           ,1
           ,S.ExternalGroupName
           ,''
           ,''
           ,0
           ,0);
--Identify id of AD group
    MERGE @InviteExternalUserTBL T
    USING UMGroups S
    ON (T.ExternalGroupName = S.name AND T.providerID = S.umdsProviderId)
    WHEN MATCHED
        THEN UPDATE SET T.ExternalGroupId = S.id;
----------------External Groups End---------------------------------------------------------
----------------Local Groups Begin---------------------------------------------------------
	DECLARE @InviteLocalGroupTBL TABLE (sendInvite VARCHAR(MAX), localGroupName VARCHAR(MAX), localGroupId INT)
		INSERT INTO @InviteLocalGroupTBL(sendInvite, localGroupName, localGroupId)
	SELECT extGroup.ref.value('@sendInvite', 'VARCHAR(MAX)'),  S.usr.value('@userGroupName', 'VARCHAR(MAX)'),  S.usr.value('@userGroupId', 'int ')
	FROM @inUsers.nodes('Api_UpdatePlanUsers/users') extGroup (ref)
		CROSS APPLY ref.nodes('userGroup') S(usr)
-- Set the providerId in the input
	MERGE @InviteLocalGroupTBL T
    USING UMGroups S
    ON (T.localGroupName = S.name AND S.umdsProviderId = @ownerCompany)
    WHEN MATCHED
        THEN UPDATE SET T.localGroupId = S.id;
----------------Local Groups End---------------------------------------------------------
-- Set invite flag for localgroups
	MERGE UMGroupsProp AS G
		USING (select localGroupId from @InviteLocalGroupTBL where sendInvite = '1') AS S
		ON (G.componentNameId = S.localGroupId AND G.ATTRNAME = 'Invitation sent' AND G.modified=0 and attrVal=1)
		WHEN MATCHED
		THEN
			UPDATE  SET G.created =  dbo.GetUnixTime (GetUTCdate())
		WHEN NOT MATCHED BY TARGET AND S.localGroupId != 0
			THEN INSERT ([componentNameId], [attrName],[attrType], [attrVal], [created], [modified])
			VALUES(S.localGroupId, 'Invitation sent',7, 1,  dbo.GetUnixTime (GetUTCdate()), 0);
-- Set invite flag for external group
	MERGE UMGroupsProp AS G
		USING (select ExternalGroupId from @InviteExternalUserTBL where sendInvite = '1') AS S
		ON (G.componentNameId = S.ExternalGroupId AND G.ATTRNAME = 'Invitation sent' AND G.modified=0 and attrVal=1)
		WHEN MATCHED
		THEN
			UPDATE  SET G.created =  dbo.GetUnixTime (GetUTCdate())
		WHEN NOT MATCHED BY TARGET AND S.ExternalGroupId != 0
			THEN INSERT ([componentNameId], [attrName],[attrType], [attrVal], [created], [modified])
			VALUES(S.ExternalGroupId, 'Invitation sent',7, 1,  dbo.GetUnixTime (GetUTCdate()), 0);
--send download email only to local users/Organization users who has logged in OR a is AD user
		SET @downloadPackageList = (SELECT
					(select userEmail AS '@val' FROM @InviteUserTBL I
					INNER JOIN UMUsers u on u.id=I.userId
					inner join UMDSProviders p on p.id=u.umDSproviderId
					where sendInvite=1 and ((u.umDSproviderId>0 and p.serviceType=2 ) or ((u.umDSproviderId=0 or  p.servicetype=5)and u.credSetTime<>0))
					FOR XML PATH('users'), TYPE)
					FOR XML PATH(''), ROOT('App_InviteUsers'))
	--This is to diffirentiate if the user was created by system. We want to only send password to system created users.
	SET @registerAndDownloadSystemGeneratedPackageList = (SELECT
									(SELECT userEmail AS '@val'
										FROM @InviteUserTBL I
										INNER JOIN UMUsers u on u.id=I.userId
										INNER JOIN UMDSProviders P ON P.id = u.umDSproviderId
										 where sendInvite=1 and isSystemGenerated = 1 and ((u.umDSproviderId=0 or  p.servicetype=5)and u.credSetTime=0)
									FOR XML PATH('users'), TYPE)
									FOR XML PATH(''), ROOT('App_InviteUsers'))
	--send register emails to new local users, new organization users
	SET @registerAndDownloadPackageList = (SELECT
									(SELECT userEmail AS '@val'
										FROM @InviteUserTBL I
										INNER JOIN UMUsers u on u.id=I.userId
										INNER JOIN UMDSProviders P ON P.id = u.umDSproviderId
										 where sendInvite=1 and   isSystemGenerated = 0 and ((u.umDSproviderId=0 or  p.servicetype=5)and u.credSetTime=0)
									FOR XML PATH('users'), TYPE)
									FOR XML PATH(''), ROOT('App_InviteUsers'))
SET @updatePlanUsersResponse =
									--(SELECT
									--(SELECT(SELECT loginName AS '@userName', userId AS '@userId'  FOR XML PATH('user'), type)  FROM @InviteUserTBL FOR XML PATH('users'),TYPE)
									--,(SELECT(SELECT ExternalGroupName AS '@externalGroupName', ExternalGroupId AS '@groupId', providerID AS '@providerId', ProviderName AS '@providerDomainName' FOR XML PATH('externalUserGroup'), type)
									--FROM @InviteExternalUserTBL
									--FOR XML PATH('users'),TYPE)
								 --   FOR XML PATH('') , ROOT('Api_UpdatePlanUsers'))
								 (SELECT(SELECT sendInvite AS '@sendInvite',(SELECT loginName AS '@userName', userId AS '@userId'  FOR XML PATH('user'), type) FROM @InviteUserTBL FOR XML PATH('users'),TYPE)
										,(SELECT sendInvite AS '@sendInvite',(SELECT ExternalGroupName AS '@externalGroupName', ExternalGroupId AS '@groupId', providerID AS '@providerId', ProviderName AS '@providerDomainName' FOR XML PATH('externalUserGroup'), type) FROM @InviteExternalUserTBL FOR XML PATH('users'),TYPE)
										,(SELECT sendInvite AS '@sendInvite',(SELECT localGroupName AS '@userGroupName', localGroupId AS '@userGroupId' FOR XML PATH('userGroup'), type) FROM @InviteLocalGroupTBL FOR XML PATH('users'),TYPE)
								  FOR XML PATH('') , ROOT('Api_UpdatePlanUsers')
								 )
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode    = ERROR_NUMBER()
    SET @errorString  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
SELECT @errorCode, @errorString, @downloadPackageList, @registerAndDownloadPackageList, @updatePlanUsersResponse, @registerAndDownloadSystemGeneratedPackageList
GO

IF EXISTS (select * from GxQscripts where name = 'AppConfigureAdminDLOInvitedUser')
	delete from GxQscripts where name = 'AppConfigureAdminDLOInvitedUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppConfigureAdminDLOInvitedUser')
	delete from GXDBVersions where aliasname = 'AppConfigureAdminDLOInvitedUser'
GO

insert into GXDBVersions values(2, 'AppConfigureAdminDLOInvitedUser',  '00010001000200120000', 'AppConfigureAdminDLOInvitedUser', '00010001000200120000')
GO

