

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppConfigurationPolicySet.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppConfigurationPolicySet.sp,v $ $Id: AppConfigurationPolicySet.sp,v 1.1.4.32 2020/03/27 22:16:45 saurabhagrawal Exp $";
--	+===================================================================+
--	|  					  AppConfigurationPolicySet						|
--	|		Procedure for create/update a Agent policy table			|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppConfigurationPolicySet')
BEGIN
	print '>>> Drop Stored Procedure: AppConfigurationPolicySet <<<'
	drop procedure AppConfigurationPolicySet
END
IF EXISTS (select * from GxQscripts where name='AppConfigurationPolicySet')
	delete from GxQscripts where name = 'AppConfigurationPolicySet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppConfigurationPolicySet')
	delete from GXDBVersions where aliasname = 'AppConfigurationPolicySet'
GO
print '... Creating Procedure: AppConfigurationPolicySet'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppConfigurationPolicySet
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML
-----------------------------------------------------------
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
BEGIN
	DECLARE	@o_xmlString		XML
	DECLARE @hasPermission		INT = 0
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowUtcTime			DATETIME = GETUTCDATE()
	DECLARE @nowUtcUnix			INT = DATEDIFF(second, '01/01/1970', @nowUtcTime)
	DECLARE @nowTimeUnix		INT = DATEDIFF(second, '01/01/1970', GETDATE())
DECLARE @policyIds			TABLE (policyId INT, policyName NVARCHAR(1024))
	 -- READ THE XML
	DECLARE @policyId			INT = ISNULL (( SELECT ref.value('@policyId', 'INT')
                                                    FROM @i_xmlString.nodes ('Ida_SetConfigurationPolicyReq/policy/policyEntity') R(ref)), 0)
	DECLARE @policyName			NVARCHAR(MAX) = ISNULL (( SELECT ref.value('@policyName', 'NVARCHAR(1024)')
                                                    FROM @i_xmlString.nodes ('Ida_SetConfigurationPolicyReq/policy/policyEntity') R(ref)), '')
	DECLARE @policyType			INT = ISNULL (( SELECT ref.value('@policyType', 'INT')
                                                    FROM @i_xmlString.nodes ('Ida_SetConfigurationPolicyReq/policy') R(ref)), 0)
	DECLARE @appTypeId			INT = ISNULL (( SELECT ref.value('@appTypeId', 'INT')
                                                    FROM @i_xmlString.nodes ('Ida_SetConfigurationPolicyReq/policy/agentType') R(ref)), 0)
	DECLARE @CAPolicyInstType	INT = ISNULL ((SELECT ref.value('@cloudAppsPolicyInstanceType','INT')
													FROM @i_xmlString.nodes ('Ida_SetConfigurationPolicyReq/policy/detail/cloudAppPolicy') R(ref)), 0)
	DECLARE @userId				INT = 0
	DECLARE @localeId			INT = 0
	-- Variables
	DECLARE @currentTime		INT = dbo.getunixtime(getutcdate())
	-- Inputs for AppModifyIndexServerForCI.sp (Content Indexing Policy)
	Declare @inputXmlForIndexChange XML
	Declare @idxSrvrClientId 	INT = 0
	Declare @engineType 		INT = 0
	Declare @isPrimary			INT = 0
	Declare @opType				INT = 0
	Declare @entityType 		INT = 0
	Declare @skipIfPrimaryExistsForEngine INT = 0
	Declare @updateIfSrvrExistsForEngine INT = 0
	DECLARE @policyAttrName		NVARCHAR(MAX) = ''
	DECLARE @SCName NVARCHAR(MAX) = ''
	DECLARE @opMsgId            INT
	DECLARE @auditID INT
	DECLARE @opEvMsgId          INT
	SET @userId = ISNULL((SELECT  ref.value('@userId', 'int')
			FROM    @i_xmlString.nodes('Ida_SetConfigurationPolicyReq/processinginstructioninfo/user') R ( ref )), @userId)
	SET @localeId = ISNULL((SELECT  ref.value('@localeId', 'int') AS Agent
			FROM    @i_xmlString.nodes('Ida_SetConfigurationPolicyReq/processinginstructioninfo/locale') R ( ref )), @localeId)
	IF object_id('tempdb.dbo.#configPolicy_InfoTable') is not null
		DROP TABLE #configPolicy_InfoTable
	CREATE TABLE #configPolicy_InfoTable (policyId INT, policyName NVARCHAR(1024), policyType INT, detailType INT, appTypeId INT, policyDetails XML, flags INT)
	--GUI Audit temp table
    IF (object_id('tempdb.dbo.#PolicySubclients') IS NOT NULL) DROP TABLE #PolicySubclients
    CREATE TABLE #PolicySubclients (subclientID INT, subclientName VARCHAR(MAX))
	IF  @policyName = ''
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Missing policy name'
		GOTO ERROR_EXIT
	END
	IF @policyType = 1	-- Exchange policies
	BEGIN
		INSERT #configPolicy_InfoTable(policyId, policyName, policyType, detailType, appTypeId, policyDetails, flags)
		SELECT ISNULL((ref.value('policyEntity[1]/@policyId', 'INT')), 0),
		ISNULL((ref.value('policyEntity[1]/@policyName', 'NVARCHAR(MAX)')), ''),
		ref.value('@policyType', 'INT'),
		dt.value('emailPolicy[1]/@emailPolicyType', 'INT'),
		ISNULL(ref.value('agentType[1]/@appTypeId', 'INT'), 0),
		dt.query('*'),
		ISNULL(ref.value('@flags', 'INT'),0)
		FROM @i_xmlString.nodes ('Ida_SetConfigurationPolicyReq/policy') R(ref)
		CROSS APPLY ref.nodes('./detail') D(dt)
		IF EXISTS(SELECT 1 FROM #configPolicy_InfoTable WHERE detailType IN(1/*Archive*/, 4/*Journal*/))
		BEGIN
			DECLARE @ciPreviewPath TABLE(policyId INT, newUser nvarchar(1024), newPassword nvarchar(1024), policyDetails XML, oldUser nvarchar(1024), oldPassword nvarchar(1024), detailType INT)
			INSERT INTO @ciPreviewPath(policyId, newUser, newPassword, policyDetails, oldUser, oldPassword, detailType)
			SELECT
			A.policyId,
			A.policyDetails.value('(/emailPolicy/archivePolicy/contentIndexProps/previewPathDir/userAccount/@userName)[1]', 'nvarchar(1024)'),
			A.policyDetails.value('(/emailPolicy/archivePolicy/contentIndexProps/previewPathDir/userAccount/@password)[1]', 'nvarchar(1024)'),
			A.policyDetails,
			B.policyDetails.value('(/emailPolicy/archivePolicy/contentIndexProps/previewPathDir/userAccount/@userName)[1]', 'nvarchar(1024)'),
			B.policyDetails.value('(/emailPolicy/archivePolicy/contentIndexProps/previewPathDir/userAccount/@password)[1]', 'nvarchar(1024)'),
			A.detailType
			FROM #configPolicy_InfoTable A, APP_ConfigurationPolicyDetails B
			WHERE A.policyId > 0 AND A.detailType = 1/*Archive*/ AND A.policyId = B.componentNameId AND B.modified = 0
			INSERT INTO @ciPreviewPath(policyId, newUser, newPassword, policyDetails, oldUser, oldPassword, detailType)
			SELECT
			A.policyId,
			A.policyDetails.value('(/emailPolicy/journalPolicy/contentIndexProps/previewPathDir/userAccount/@userName)[1]', 'nvarchar(1024)'),
			A.policyDetails.value('(/emailPolicy/journalPolicy/contentIndexProps/previewPathDir/userAccount/@password)[1]', 'nvarchar(1024)'),
			A.policyDetails,
			B.policyDetails.value('(/emailPolicy/journalPolicy/contentIndexProps/previewPathDir/userAccount/@userName)[1]', 'nvarchar(1024)'),
			B.policyDetails.value('(/emailPolicy/journalPolicy/contentIndexProps/previewPathDir/userAccount/@password)[1]', 'nvarchar(1024)'),
			A.detailType
			FROM #configPolicy_InfoTable A, APP_ConfigurationPolicyDetails B
			WHERE A.policyId > 0 AND A.detailType = 4/*Journal*/ AND A.policyId = B.componentNameId AND B.modified = 0
			DELETE FROM @ciPreviewPath
			WHERE newUser != oldUser OR newPassword IS NOT NULL OR oldPassword IS NULL
			-- Update the password from the DB.
			UPDATE A
			SET policyDetails.modify('insert attribute password {sql:column("B.oldPassword") }
			into (/emailPolicy/archivePolicy/contentIndexProps/previewPathDir/userAccount)[1]')
			FROM #configPolicy_InfoTable A, @ciPreviewPath B
			WHERE A.policyId = B.policyId AND A.detailType = 1/*Archive*/
			UPDATE A
			SET policyDetails.modify('insert attribute password {sql:column("B.oldPassword") }
			into (/emailPolicy/journalPolicy/contentIndexProps/previewPathDir/userAccount)[1]')
			FROM #configPolicy_InfoTable A, @ciPreviewPath B
			WHERE A.policyId = B.policyId AND A.detailType = 4/*Journal*/
		END
	END
	ELSE IF @policyType = 2 -- File policies
	BEGIN
		INSERT #configPolicy_InfoTable(policyId, policyName, policyType, detailType, appTypeId, policyDetails, flags)
		SELECT ISNULL((ref.value('policyEntity[1]/@policyId', 'INT')), 0),
		ISNULL((ref.value('policyEntity[1]/@policyName', 'NVARCHAR(MAX)')), ''),
		ref.value('@policyType', 'INT'),
		dt.value('filePolicy[1]/@filePolicyType', 'INT'),
		ISNULL(ref.value('agentType[1]/@appTypeId', 'INT'), 0),
		dt.query('*'),
		ref.value('@flags', 'INT')
		FROM @i_xmlString.nodes ('Ida_SetConfigurationPolicyReq/policy') R(ref)
		CROSS APPLY ref.nodes('./detail') D(dt)
	END
	ELSE IF @policyType = 3 -- Entity Extraction policies
	BEGIN
		INSERT #configPolicy_InfoTable(policyId, policyName, policyType, detailType, appTypeId, policyDetails, flags)
		SELECT ISNULL((ref.value('policyEntity[1]/@policyId', 'INT')), 0),
		ISNULL((ref.value('policyEntity[1]/@policyName', 'NVARCHAR(MAX)')), ''),
		ref.value('@policyType', 'INT'),
		dt.value('eePolicy[1]/@extractionPolicyType', 'INT'),
		ISNULL(ref.value('agentType[1]/@appTypeId', 'INT'), 0),
		dt.query('*'),
		ref.value('@flags', 'INT')
		FROM @i_xmlString.nodes ('Ida_SetConfigurationPolicyReq/policy') R(ref)
		CROSS APPLY ref.nodes('./detail') D(dt)
	END
	ELSE IF @policyType = 5 -- Content indexing policies
	BEGIN
		INSERT #configPolicy_InfoTable(policyId, policyName, policyType, detailType, appTypeId, policyDetails, flags)
		SELECT ISNULL((ref.value('policyEntity[1]/@policyId', 'INT')), 0),
		ISNULL((ref.value('policyEntity[1]/@policyName', 'NVARCHAR(MAX)')), ''),
		ref.value('@policyType', 'INT'),
		dt.value('ciPolicy[1]/@ciPolicyType', 'INT'),
		ISNULL(ref.value('agentType[1]/@appTypeId', 'INT'), 0),
		dt.query('*'),
		ISNULL(ref.value('@flags', 'INT'),0)
		FROM @i_xmlString.nodes ('Ida_SetConfigurationPolicyReq/policy') R(ref)
		CROSS APPLY ref.nodes('./detail') D(dt)
	END
	ELSE IF @policyType = 6  OR @policyType = 7-- Office365 Policies
	BEGIN
		INSERT #configPolicy_InfoTable(policyId, policyName, policyType, detailType, appTypeId, policyDetails, flags)
		SELECT ISNULL((ref.value('policyEntity[1]/@policyId', 'INT')), 0),
		ISNULL((ref.value('policyEntity[1]/@policyName', 'NVARCHAR(MAX)')), ''),
		ref.value('@policyType', 'INT'),
		dt.value('cloudAppPolicy[1]/@cloudAppPolicyType', 'INT'),
		ISNULL(ref.value('agentType[1]/@appTypeId', 'INT'), 0),
		dt.query('*'),
		ISNULL(ref.value('@flags', 'INT'),0)
		FROM @i_xmlString.nodes ('Ida_SetConfigurationPolicyReq/policy') R(ref)
		CROSS APPLY ref.nodes('./detail') D(dt)
	END
--
	--CHECK FOR EXISTING POLICY WHILE ADDING A NEW ONE
	IF EXISTS(
		SELECT 1 FROM APP_ConfigurationPolicy CP
		JOIN APP_ConfigurationPolicyDetails CD ON CD.componentNameId = CP.policyId
		JOIN #configPolicy_InfoTable CI ON CI.policyName = CP.policyName
		WHERE CI.policyType = CP.policyType
		AND CI.detailType = CD.detailType
		AND CI.policyId <> CP.policyId
	)
	BEGIN
SET @errorCode = (2831 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @errorString = dbo.fn_EvFormatEventMsgText(0, @localeId, @errorCode, 0, 2)
		GOTO ERROR_EXIT
	END
	IF @policyId <> 0 OR @policyName <> ''
	BEGIN
		SELECT @policyId = T.policyId, @policyName = T.policyName
		FROM
		(
			SELECT policyId, policyName
			FROM APP_ConfigurationPolicy (NOLOCK)
			WHERE policyId = @policyId
			AND policyType = @policyType
			AND appTypeId = @appTypeId
			UNION
			SELECT policyId, policyName
			FROM APP_ConfigurationPolicy (NOLOCK)
			WHERE policyName = @policyName
			AND policyType = @policyType
			AND appTypeId = @appTypeId
		) T
	END
	BEGIN TRAN
		MERGE APP_ConfigurationPolicy AS CP
		USING
		(
			SELECT policyId, policyName, policyType, appTypeId, flags
			FROM #configPolicy_InfoTable
		) AS IT ON IT.policyId = CP.policyId AND IT.policyType = CP.policyType AND IT.appTypeId = CP.appTypeId
		WHEN MATCHED THEN
			UPDATE SET
			CP.policyName = IT.policyName,
			CP.modified = @nowUtcUnix
		WHEN NOT MATCHED THEN
			INSERT (policyName, policyType, appTypeId, flags, status, created, modified, ownerId)
			VALUES(IT.policyName, IT.policyType, IT.appTypeId, IT.flags, 0, @nowUtcUnix, 0, @userId)
		OUTPUT INSERTED.policyId, INSERTED.policyName INTO @policyIds;
		--Check Error
			set @errorCode = @@error
			IF(@errorCode <> 0)
				GOTO ERROR
		UPDATE APP_ConfigurationPolicyDetails
		SET modified = @nowUtcUnix
		FROM
		(
			SELECT policyId, detailType
			FROM #configPolicy_InfoTable
		) CP
		WHERE CP.policyId = APP_ConfigurationPolicyDetails.componentNameId
		AND CP.detailType = APP_ConfigurationPolicyDetails.detailType
		UPDATE #configPolicy_InfoTable
		SET policyId = PL.policyId
		FROM
		(
			SELECT * FROM @policyIds
		) PL
		WHERE PL.policyName = #configPolicy_InfoTable.policyName
		MERGE APP_ConfigurationPolicyDetails AS CD
		USING
		(
			SELECT policyId, detailType, policyDetails
			FROM #configPolicy_InfoTable
		) AS IT ON IT.policyId = CD.componentNameId AND IT.detailType = CD.detailType AND CD.modified = 0
		WHEN NOT MATCHED THEN
			INSERT (componentNameId, detailType, policyDetails, created, modified)
			VALUES(IT.policyId, IT.detailType, IT.policyDetails, @nowUtcUnix, 0);
		--Check Error
			set @errorCode = @@error
			IF(@errorCode <> 0)
				GOTO ERROR
		IF @policyId = 0
		BEGIN
			SET @policyId = ISNULL((SELECT TOP 1 policyId FROM APP_ConfigurationPolicy WHERE policyName = @policyName AND policyType = @policyType), 0)
		END
		IF @policyId <> 0 and @policyType = 2 -- File policies
		BEGIN
			DECLARE @subclientsAssoc TABLE (subclientId INT)
			INSERT INTO @subclientsAssoc
			SELECT ISNULL (Assoc.Id.value('@subclientId', 'INT'), 0)
			FROM @i_xmlString.nodes ('Ida_SetConfigurationPolicyReq/policy[1]/associations') Assoc(Id)
			DECLARE @subclientsDisassoc TABLE (subclientId INT)
			INSERT INTO @subclientsDisassoc
			SELECT ISNULL (Disassoc.Id.value('@subclientId', 'INT'), 0)
			FROM @i_xmlString.nodes ('Ida_SetConfigurationPolicyReq/policy[1]/disassociations') Disassoc(Id)
			IF EXISTS(SELECT 1 FROM #configPolicy_InfoTable WHERE detailType IN(3)) -- Retention file policy
			BEGIN
				SET @policyAttrName = 'Fs Retention Policy ID'
				-- Update modified time for existing 'FS Retention Policy ID' property and make new entry with new attrVal
				UPDATE APP_SubclientProp SET modified = @currentTime
				FROM (SELECT subclientId as Id
				FROM  @subclientsAssoc) as Assoc
				WHERE componentNameId = Assoc.Id
				AND attrName = @policyAttrName
				AND modified = 0
				INSERT APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
				SELECT Assoc.subclientId,
				@policyAttrName,
				10,
				CAST(@policyId As NVARCHAR(MAX)),
				@currentTime,
				0
				FROM @subclientsAssoc Assoc
			END
			ELSE IF EXISTS(SELECT 1 FROM #configPolicy_InfoTable WHERE detailType IN(5)) -- Content indexing file policy
			BEGIN
				SET @policyAttrName = 'Content Indexing Policy ID'
				DECLARE @enableCIAttrName NVARCHAR(MAX) = 'Enable Content Indexing'
				INSERT #PolicySubclients(subclientID, subclientName)
				SELECT APP.id, APP.subclientName
				FROM APP_Application APP
				INNER JOIN APP_SubClientProp SCProp
				ON APP.id = SCProp.componentNameId
				WHERE SCProp.attrName = @policyAttrName
				AND SCProp.attrVal = CAST(@policyId As NVARCHAR(MAX))
				AND SCProp.modified = 0
				-- For Association
				-- Update modified time for existing "Enable Content Indexing" property.
				UPDATE APP_SubclientProp SET modified = @currentTime
				FROM (SELECT subclientId as Id
				FROM  @subclientsAssoc) as Assoc
				WHERE componentNameId = Assoc.Id
				AND attrName = @enableCIAttrName
				AND modified = 0
				-- Disassociate this subclient from any other associations- Ex: subclient can have association to policy id 0.
				UPDATE APP_SubClientProp SET modified = @currentTime
				WHERE attrName = @policyAttrName
				AND modified = 0
				AND componentNameId IN (SELECT Assoc.subclientId
						FROM @subclientsAssoc Assoc
						INNER JOIN APP_SubClientProp SCProp
						ON Assoc.subclientId = SCProp.componentNameId
						WHERE SCProp.attrName = @policyAttrName
						AND SCProp.attrVal <> CAST(@policyId As NVARCHAR(MAX))
						AND SCProp.modified = 0)
				-- Include "Content Indexing Policy ID" property set to policy id in subclient property table.
				INSERT APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
				SELECT Assoc.subclientId,
				@policyAttrName,
				10,
				CAST(@policyId As NVARCHAR(MAX)),
				@currentTime,
				0
				FROM @subclientsAssoc Assoc
				WHERE Assoc.subclientId NOT IN (SELECT subclientID FROM #PolicySubclients)
				-- Include "Enable Content Indexing" property and set to true in subclient property table.
				INSERT APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
				SELECT Assoc.subclientId,
				@enableCIAttrName,
				2,
				1,
				@currentTime,
				0
				FROM @subclientsAssoc Assoc
				--GUI Audit
SET @opMsgId=(541 | (CAST(POWER(2, 24) AS BIGINT) * 85))
                EXEC EvGuiAuditSetOperation @opMsgId, @userId, @opEvMsgId OUTPUT, @auditID OUTPUT
SET @opMsgId=(1721 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				EXEC EvGuiAuditSetParamData @auditID, @policyName, @userId
				EXEC EvGuiAuditSetParameter @auditID, @opMsgId, @userId
SET @opMsgId=(1722 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				EXEC EvGuiAuditSetParameter @auditID, @opMsgId, @userId
				declare cur cursor local for
				SELECT APP.subclientName
				FROM APP_Application APP
				INNER JOIN APP_SubClientProp SCProp
				ON APP.id = SCProp.componentNameId
				WHERE SCProp.attrName = @policyAttrName
				AND SCProp.attrVal = CAST(@policyId As NVARCHAR(MAX))
				AND SCProp.modified = 0
				AND SCProp.componentNameId NOT IN (SELECT subclientID FROM #PolicySubclients)
				open cur
				fetch next from cur into @SCName
				WHILE @@FETCH_STATUS = 0
				BEGIN
SET @opMsgId=(211 | (CAST(POWER(2, 24) AS BIGINT) * 85))
					EXEC EvGuiAuditSetParamData @auditID, @SCName, @userId
					EXEC EvGuiAuditSetParameter @auditID, @opMsgId, @userId
					fetch next from cur into @SCName
				END
				close cur
				deallocate cur
				-- Update the index server client ID
				IF @policyType <> 4 -- for all CI policies except VM policy
				BEGIN
					SET @idxSrvrClientId = ISNULL(@i_xmlString.value('(Ida_SetConfigurationPolicyReq/policy/detail/filePolicy/contentIndexingPolicy/@searchEngineId)[1]' , 'INT'), 0)
					IF @idxSrvrClientId > 0
					BEGIN
						SET @engineType = 2
						SET @isPrimary = 0
						SET @opType = 1 --  ADD
						SET @entityType = 7 -- SUBCLIENT_ENTITY
						SET @skipIfPrimaryExistsForEngine = 1
						SET @updateIfSrvrExistsForEngine = 1
						-- Create the input XML for AppModifyIndexServerForCI.sp
						SET @inputXmlForIndexChange =
						(
							SELECT
							(SELECT @idxSrvrClientId '@idxServerClientId', @isPrimary '@isPrimary',
							@engineType '@engineType', @opType '@opType', @entityType '@entityType',
							@skipIfPrimaryExistsForEngine '@skipIfPrimaryExistsForEngine',
							@updateIfSrvrExistsForEngine '@updateIfSrvrExistsForEngine',
							(SELECT subclientId '@val'
							FROM @subclientsAssoc
							FOR XML PATH('entityIdList'), TYPE)
							FOR XML PATH('modifyIndexServerReq'), TYPE)
							FOR XML PATH('Indexing_ModifyIndexServerForCIReq')
						)
						EXEC AppModifyIndexServerForCI @inputXmlForIndexChange
					END
				END
				-- For Disassociation
				-- Update modified time for existing "Content Indexing Policy ID" or "Enable Content Indexing" property
				UPDATE APP_SubclientProp SET modified = @currentTime
				FROM (SELECT subclientId as Id
				FROM  @subclientsDisassoc) as Disassoc
				WHERE componentNameId = Disassoc.Id
				AND (attrName = @policyAttrName OR attrName = @enableCIAttrName)
				AND modified = 0
				-- Include "Enable Content Indexing" property and set to false in subclient property table
				INSERT APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
				SELECT Disassoc.subclientId,
				@enableCIAttrName,
				2,
				0,
				@currentTime,
				0
				FROM @subclientsDisassoc Disassoc
SET @opMsgId=(1723 | (CAST(POWER(2, 24) AS BIGINT) * 85))
				EXEC EvGuiAuditSetParameter @auditID, @opMsgId, @userId
				declare cur1 cursor local for
				SELECT APP.subclientName
				FROM APP_Application APP
				INNER JOIN APP_SubClientProp SCProp
				ON APP.id = SCProp.componentNameId
				WHERE SCProp.modified <> 0
				AND CAST(SCProp.attrVal as INT) <> 0
				AND SCProp.attrName = @policyAttrName
				AND SCProp.componentNameId IN (SELECT subclientID FROM #PolicySubclients)
				open cur1
				fetch next from cur1 into @SCName
				WHILE @@FETCH_STATUS = 0
				BEGIN
SET @opMsgId=(211 | (CAST(POWER(2, 24) AS BIGINT) * 85))
					EXEC EvGuiAuditSetParamData @auditID, @SCName, @userId
					EXEC EvGuiAuditSetParameter @auditID, @opMsgId, @userId
					fetch next from cur1 into @SCName
				END
				close cur1
				deallocate cur1
				IF @policyType <> 4 -- for all CI policies except VM policy
				BEGIN
					SET @idxSrvrClientId = ISNULL(@i_xmlString.value('(Ida_SetConfigurationPolicyReq/policy/detail/filePolicy/contentIndexingPolicy/@searchEngineId)[1]' , 'INT'), 0)
					IF @idxSrvrClientId > 0
					BEGIN
						SET @engineType = 2
						SET @isPrimary = 0
						SET @opType = 3 --  DELETE
						SET @entityType = 7 -- SUBCLIENT_ENTITY
						SET @skipIfPrimaryExistsForEngine = 1
						SET @updateIfSrvrExistsForEngine = 1
						-- Create the input XML for AppModifyIndexServerForCI.sp
						SET @inputXmlForIndexChange =
						(
							SELECT
							(SELECT @idxSrvrClientId '@idxServerClientId', @isPrimary '@isPrimary',
							@engineType '@engineType', @opType '@opType', @entityType '@entityType',
							@skipIfPrimaryExistsForEngine '@skipIfPrimaryExistsForEngine',
							@updateIfSrvrExistsForEngine '@updateIfSrvrExistsForEngine',
							(SELECT subclientId '@val'
							FROM @subclientsDisassoc
							FOR XML PATH('entityIdList'), TYPE)
							FOR XML PATH('modifyIndexServerReq'), TYPE)
							FOR XML PATH('Indexing_ModifyIndexServerForCIReq')
						)
						EXEC AppModifyIndexServerForCI @inputXmlForIndexChange
					END
				END
			END
		END
ERROR:
	IF @errorCode <> 0
		ROLLBACK TRAN
	ELSE
		COMMIT TRAN
ERROR_EXIT:
	IF object_id('tempdb.dbo.#configPolicy_InfoTable') is not null
		DROP TABLE #configPolicy_InfoTable
	IF object_id('tempdb.dbo.#PolicySubclients') is not null
		DROP TABLE #PolicySubclients
    SET @o_xmlString =
    (
		SELECT
			(SELECT --CP.policyType '@policyType',
				(
					SELECT policyId 'policyEntity/@policyId', policyName 'policyEntity/@policyName'
					FROM @policyIds
					FOR XML PATH('policy'), type
				),
				(SELECT @errorCode '@errorCode',
						@errorString '@errorMessage'
				FOR XML PATH ('resp'), TYPE
				)
			FOR XML PATH(''), ROOT('Ida_ConfigurationPolicyResp')
			)
    )
	SELECT @o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppConfigurationPolicySet')
	delete from GxQscripts where name = 'AppConfigurationPolicySet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppConfigurationPolicySet')
	delete from GXDBVersions where aliasname = 'AppConfigurationPolicySet'
GO

insert into GXDBVersions values(2, 'AppConfigurationPolicySet',  '00010001000400320000', 'AppConfigurationPolicySet', '00010001000400320000')
GO

