

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppConfigurationPolicyGet.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  				AppConfigurationPolicyGet							|
--	|		 Procedure to get Agent policy information					|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppConfigurationPolicyGet')
BEGIN
	print '>>> Drop Stored Procedure: AppConfigurationPolicyGet <<<'
	drop procedure AppConfigurationPolicyGet
END
IF EXISTS (select * from GxQscripts where name='AppConfigurationPolicyGet')
	delete from GxQscripts where name = 'AppConfigurationPolicyGet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppConfigurationPolicyGet')
	delete from GXDBVersions where aliasname = 'AppConfigurationPolicyGet'
GO
print '... Creating Procedure: AppConfigurationPolicyGet'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppConfigurationPolicyGet
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML OUTPUT
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE	@o_xmlString			XML
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			INT = dbo.GetUnixTime (GetUTCdate())
	 -- READ THE XML
	DECLARE @policyId			INT = 0
	DECLARE @policyName			NVARCHAR(MAX) = ''
	DECLARE @inPropertyLevel	INT	= 10 -- ListPropertyLevels_BasicProperties
	DECLARE @policyType			INT = 0
	DECLARE @flags				INT = 0
	DECLARE @emailPolicyType	INT = 0
	DECLARE @filePolicyType	INT = 0
	DECLARE @eePolicyType	INT = 0
	DECLARE @ciPolicyType	INT = 0
	DECLARE @isRequestFromGUI	INT = 0
	DECLARE @vmPolicyType 		INT = 0
	DECLARE @CloudPolicyType 		INT = 0
	DECLARE @skipSelectStatement	INT	= ISNULL((SELECT  ref.value('@value', 'int')
			FROM    @i_xmlString.nodes('Ida_GetConfigurationPolicyReq/processinginstructioninfo/attributes') R ( ref ) WHERE ref.value('@name', 'NVARCHAR(1024)') = 'skipSelectStatment'), 0)
	SET @isRequestFromGUI = ISNULL((SELECT  ref.value('@userId', 'int')
			FROM    @i_xmlString.nodes('Ida_GetConfigurationPolicyReq/processinginstructioninfo/user') R ( ref )), @isRequestFromGUI)
	SELECT	@policyId = ISNULL(ref.value('policy[1]/policyEntity[1]/@policyId', 'INT'), 0),
			@policyName = ISNULL(ref.value('policy[1]/policyEntity[1]/@policyName', 'NVARCHAR(MAX)'), ''),
			@inPropertyLevel = ISNULL(ref.value('@propertyLevel', 'INT'), 0),
			@policyType = ISNULL(ref.value('policy[1]/@policyType', 'INT'), 0),
			@flags = ISNULL(ref.value('policy[1]/@flags', 'INT'), 0),
			@emailPolicyType = ISNULL(ref.value('policy[1]/detail[1]/emailPolicy[1]/@emailPolicyType', 'INT'), 0),
			@filePolicyType = ISNULL(ref.value('policy[1]/detail[1]/filePolicy[1]/@filePolicyType', 'INT'), 0),
			@eePolicyType = ISNULL(ref.value('policy[1]/detail[1]/eePolicy[1]/@extractionPolicyType', 'INT'), 0),
			@ciPolicyType = ISNULL(ref.value('policy[1]/detail[1]/ciPolicy[1]/@ciPolicyType', 'INT'), 0),
			@vmPolicyType = ISNULL(ref.value('policy[1]/detail[1]/vmPolicy[1]/@vmPolicyType', 'INT'), 0),
			@CloudPolicyType = ISNULL(ref.value('policy[1]/detail[1]/cloudAppPolicy[1]/@cloudAppPolicyType', 'INT'), 0)
		FROM @i_xmlString.nodes ('Ida_GetConfigurationPolicyReq') R(ref)
--
	IF @inPropertyLevel = 30 -- ListPropertyLevels_AllProperties
	BEGIN
	-- FORM THE XML RESPONSE
		SET @o_xmlString =
				(
					SELECT CP.policyType '@policyType', CP.flags '@flags',
					CP.appTypeId 'agentType/@appTypeId',
					CP.policyId 'policyEntity/@policyId', CP.policyName 'policyEntity/@policyName',
					CD.policyDetails 'detail'
					FROM APP_ConfigurationPolicy CP (NOLOCK)
					JOIN APP_ConfigurationPolicyDetails CD (NOLOCK) ON CD.componentNameId = CP.policyId
					AND CD.modified = 0
					AND
					(
						CD.detailType = @emailPolicyType OR @emailPolicyType = 0
					)
					WHERE
					(
						policyId = @policyId OR @policyId = 0
					)
					AND
					(
						policyType = @policyType OR @policyType = 0
					)
					FOR XML PATH('policies'),
					ROOT('Ida_GetConfigurationPolicyResp')
				)
		IF @isRequestFromGUI > 0
		BEGIN
			set @o_xmlString.modify('delete /Ida_GetConfigurationPolicyResp/policies/detail/emailPolicy/archivePolicy/contentIndexProps/previewPathDir/userAccount/@password')
			set @o_xmlString.modify('delete /Ida_GetConfigurationPolicyResp/policies/detail/emailPolicy/journalPolicy/contentIndexProps/previewPathDir/userAccount/@password')
		END
	END
	ELSE IF @inPropertyLevel = 10 -- ListPropertyLevels_BasicProperties
	BEGIN
	-- FORM THE XML RESPONSE
		IF @policyType = 1	-- Exchange policies
		BEGIN
			SET @o_xmlString =
					(
						SELECT CP.policyType '@policyType', CP.flags '@flags',
						(
							SELECT CD.detailType 'emailPolicy/@emailPolicyType'
							FOR XML PATH('detail'), type
						),
						CP.appTypeId 'agentType/@appTypeId',
						CP.policyId 'policyEntity/@policyId', CP.policyName 'policyEntity/@policyName'
						FROM APP_ConfigurationPolicy CP (NOLOCK)
						JOIN APP_ConfigurationPolicyDetails CD (NOLOCK) ON CD.componentNameId = CP.policyId
						AND CD.modified = 0
						AND
						(
							CD.detailType = @emailPolicyType OR @emailPolicyType = 0
						)
						WHERE
						(
							policyId = @policyId OR @policyId = 0
						)
						AND
						(
							policyType = @policyType OR @policyType = 0
						)
						FOR XML PATH('policies'),
						ROOT('Ida_GetConfigurationPolicyResp')
					)
		END
		ELSE IF @policyType = 2 -- File policies
		BEGIN
			SET @o_xmlString =
					(
						SELECT CP.policyType '@policyType', CP.flags '@flags',
						(
							SELECT CD.detailType 'filePolicy/@filePolicyType'
							FOR XML PATH('detail'), type
						),
						CP.appTypeId 'agentType/@appTypeId',
						CP.policyId 'policyEntity/@policyId', CP.policyName 'policyEntity/@policyName'
						FROM APP_ConfigurationPolicy CP (NOLOCK)
						JOIN APP_ConfigurationPolicyDetails CD (NOLOCK) ON CD.componentNameId = CP.policyId
						AND CD.modified = 0
						AND
						(
							CD.detailType = @filePolicyType OR @filePolicyType = 0
						)
						WHERE
						(
							policyId = @policyId OR @policyId = 0
						)
						AND
						(
							policyType = @policyType OR @policyType = 0
						)
						FOR XML PATH('policies'),
						ROOT('Ida_GetConfigurationPolicyResp')
					)
		END
		ELSE IF @policyType = 3 -- Entity Extraction Policy
		BEGIN
			SET @o_xmlString =
					(
						SELECT CP.policyType '@policyType', CP.flags '@flags',
						(
							SELECT CD.detailType 'eePolicy/@extractionPolicyType'
							FOR XML PATH('detail'), type
						),
						CP.appTypeId 'agentType/@appTypeId',
						CP.policyId 'policyEntity/@policyId', CP.policyName 'policyEntity/@policyName'
						FROM APP_ConfigurationPolicy CP (NOLOCK)
						JOIN APP_ConfigurationPolicyDetails CD (NOLOCK) ON CD.componentNameId = CP.policyId
						AND CD.modified = 0
						AND
						(
							CD.detailType = @eePolicyType OR @eePolicyType = 0
						)
						WHERE
						(
							policyId = @policyId OR @policyId = 0
						)
						AND
						(
							policyType = @policyType OR @policyType = 0
						)
						FOR XML PATH('policies'),
						ROOT('Ida_GetConfigurationPolicyResp')
					)
		END
		ELSE IF @policyType = 5 -- Content Indexing policy
		BEGIN
			SET @o_xmlString =
					(
						SELECT CP.policyType '@policyType', CP.flags '@flags',
						(
							SELECT CD.detailType 'ciPolicy/@ciPolicyType'
							FOR XML PATH('detail'), type
						),
						CP.appTypeId 'agentType/@appTypeId',
						CP.policyId 'policyEntity/@policyId', CP.policyName 'policyEntity/@policyName'
						FROM APP_ConfigurationPolicy CP (NOLOCK)
						JOIN APP_ConfigurationPolicyDetails CD (NOLOCK) ON CD.componentNameId = CP.policyId
						AND CD.modified = 0
						AND
						(
							CD.detailType = @ciPolicyType OR @ciPolicyType = 0
						)
						WHERE
						(
							policyId = @policyId OR @policyId = 0
						)
						AND
						(
							policyType = @policyType OR @policyType = 0
						)
						FOR XML PATH('policies'),
						ROOT('Ida_GetConfigurationPolicyResp')
					)
		END
		ELSE IF @policyType = 6 OR @policyType = 7-- Office 365 Policies
		BEGIN
			SET @o_xmlString =
					(
						SELECT CP.policyType '@policyType', CP.flags '@flags',
						(
							SELECT CD.detailType 'cloudAppPolicy/@cloudAppPolicyType'
							FOR XML PATH('detail'), type
						),
						CP.appTypeId 'agentType/@appTypeId',
						CP.policyId 'policyEntity/@policyId', CP.policyName 'policyEntity/@policyName'
						FROM APP_ConfigurationPolicy CP (NOLOCK)
						JOIN APP_ConfigurationPolicyDetails CD (NOLOCK) ON CD.componentNameId = CP.policyId
						AND CD.modified = 0
						AND
						(
							CD.detailType = @CloudPolicyType OR @CloudPolicyType = 0
						)
						WHERE
						(
							policyId = @policyId OR @policyId = 0
						)
						AND
						(
							policyType = @policyType OR @policyType = 0
						)
						FOR XML PATH('policies'),
						ROOT('Ida_GetConfigurationPolicyResp')
					)
		END
	END
	ELSE IF @inPropertyLevel = 1 -- ListPropertyLevels_ListOnly
	BEGIN
	-- FORM THE XML RESPONSE
		SET @o_xmlString =
				(
					SELECT CP.policyType '@policyType', CP.flags '@flags',
					CP.appTypeId 'agentType/@appTypeId',
					CP.policyId 'policyEntity/@policyId', CP.policyName 'policyEntity/@policyName'
					FROM APP_ConfigurationPolicy CP (NOLOCK)
					JOIN APP_ConfigurationPolicyDetails CD (NOLOCK) ON CD.componentNameId = CP.policyId
					AND CD.modified = 0
					AND
					(
						CD.detailType = @emailPolicyType OR @emailPolicyType = 0
					)
					WHERE
					(
						policyType = @policyType OR @policyType = 0
					)
					FOR XML PATH('policies'),
					ROOT('Ida_GetConfigurationPolicyResp')
				)
	END
ERROR_EXIT:
	IF @errorCode <> 0
		SET @o_xmlString = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
							FOR XML PATH('Ida_GenericResp'), TYPE)
	IF @o_xmlString IS NULL
		SET @o_xmlString = '<Ida_GetConfigurationPolicyResp/>'
	IF @skipSelectStatement = 0
	BEGIN
		SELECT @o_xmlString
	END
	ELSE
	BEGIN
		SET @i_xmlString=@o_xmlString
	END
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppConfigurationPolicyGet')
	delete from GxQscripts where name = 'AppConfigurationPolicyGet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppConfigurationPolicyGet')
	delete from GXDBVersions where aliasname = 'AppConfigurationPolicyGet'
GO

insert into GXDBVersions values(2, 'AppConfigurationPolicyGet',  '00000000000000000000', 'AppConfigurationPolicyGet', '00000000000000000000')
GO

