

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppConfigurationPolicyDelete.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  				AppConfigurationPolicyDelete						|
--	|			Procedure for deleting a Agent Policy					|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppConfigurationPolicyDelete')
BEGIN
	print '>>> Drop Stored Procedure: AppConfigurationPolicyDelete <<<'
	drop procedure AppConfigurationPolicyDelete
END
IF EXISTS (select * from GxQscripts where name='AppConfigurationPolicyDelete')
	delete from GxQscripts where name = 'AppConfigurationPolicyDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppConfigurationPolicyDelete')
	delete from GXDBVersions where aliasname = 'AppConfigurationPolicyDelete'
GO
print '... Creating Procedure: AppConfigurationPolicyDelete'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppConfigurationPolicyDelete
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE	@o_xmlString		XML
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			INT = dbo.GetUnixTime (GETDATE())
	DECLARE @policyType			INT = 0
	DECLARE @detailType			INT = 0
	DECLARE @userId				INT = 0
	DECLARE @localeId			INT = 0
	DECLARE @policyAttrName		NVARCHAR(MAX) = ''
	/*Enum values from Ida_ConfigurationPolicyType message */
	DECLARE @EMAIL_POLICY_TYPE INT = 1
	DECLARE @FILE_POLICY_TYPE INT = 2
	DECLARE @EXTRACTION_POLICY_TYPE INT =3
	DECLARE @VIRTUAL_MACHINE_POLICY_TYPE INT = 4
	DECLARE @CONTENT_INDEX_POLICY_TYPE INT = 5
	DECLARE @CLOUD_APPS_POLICY_TYPE INT =6
	DECLARE @OFFICE_365_SP_POLICY_TYPE INT =7
	-- Inputs for AppModifyIndexServerForCI.sp (Content Indexing Policy)
	Declare @inputXmlForIndexChange XML
	Declare @policyXml			XML
	Declare @idxSrvrClientId 	INT = 0
	Declare @engineType 		INT = 0
	Declare @isPrimary			INT = 0
	Declare @opType				INT = 0
	Declare @entityType 		INT = 0
	Declare @skipIfPrimaryExistsForEngine INT = 0
	Declare @updateIfSrvrExistsForEngine INT = 0
	-- READ THE XML
	SET @userId = ISNULL((SELECT  ref.value('@userId', 'int')
			FROM    @i_xmlString.nodes('Ida_DeleteConfigurationPolicyReq/processinginstructioninfo/user') R ( ref )), @userId)
	SET @localeId = ISNULL((SELECT  ref.value('@localeId', 'int') AS Agent
			FROM    @i_xmlString.nodes('Ida_DeleteConfigurationPolicyReq/processinginstructioninfo/locale') R ( ref )), @localeId)
	DECLARE @policyId			INT = ISNULL (( SELECT ref.value('@policyId', 'INT')
													FROM @i_xmlString.nodes ('Ida_DeleteConfigurationPolicyReq/policyEntity') R(ref)), 0)
	DECLARE @policyName			NVARCHAR(MAX) = ISNULL (( SELECT ref.value('@policyName', 'NVARCHAR(MAX)')
													FROM @i_xmlString.nodes ('Ida_DeleteConfigurationPolicyReq/policyEntity') R(ref)), '')
	IF @policyId = 0
	BEGIN
		SET @policyId = (SELECT policyId FROM APP_ConfigurationPolicy WHERE policyName = @policyName)
	END
	IF @policyId = 0
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error : Invalid policy id in delete request.'
		GOTO ERROR_EXIT
	END
	SELECT @policyType=CP.policyType, @detailType=CD.detailType FROM APP_ConfigurationPolicy CP (NOLOCK)
	JOIN APP_ConfigurationPolicyDetails CD (NOLOCK) ON CD.componentNameId = CP.policyId
	WHERE CP.policyId = @policyId
	IF EXISTS(
				SELECT 1 FROM APP_EmailConfigPolicies P (READUNCOMMITTED)
				INNER JOIN APP_EmailConfigPolicyAssoc E (READUNCOMMITTED) ON P.componentNameId = E.assocId
				WHERE policyId = @policyId AND policyType = @detailType AND P.modified = 0 AND E.modified = 0
			 )
	BEGIN
SET @errorCode = (2832 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @errorString = dbo.fn_EvFormatEventMsgText(0, @localeId, @errorCode, 0, 2)
		GOTO ERROR_EXIT
	END
	--Check if Office365 policies associated to a plan
	IF EXISTS( SELECT PolicyId FROM APP_ConfigurationPolicy (NOLOCK) WHERE policyId = @policyId
AND (flags & 536870912 = 536870912)
				 AND policyType IN (@EMAIL_POLICY_TYPE, @CLOUD_APPS_POLICY_TYPE , @OFFICE_365_SP_POLICY_TYPE))
	BEGIN
SET @errorCode = (3578 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @errorString = dbo.fn_EvFormatEventMsgText(0, @localeId, @errorCode, 0, 2)
		GOTO ERROR_EXIT
	END
	IF @policyType = 2 and @detailType = 5 -- Content Indexing File Policy
	BEGIN
		SET @policyXml = ISNULL((SELECT Details.policyDetails from App_ConfigurationPolicyDetails Details
							WHERE Details.componentNameId = @policyId and modified = 0), '')
		SET @idxSrvrClientId = ISNULL(@policyXml.value('(/filePolicy/contentIndexingPolicy/@searchEngineId)[1]' , 'INT'), 0)
		IF @idxSrvrClientId > 0
		BEGIN
			SET @engineType = 2
			SET @isPrimary = 0
			SET @opType = 3 --  Delete
			SET @entityType = 7 -- SUBCLIENT_ENTITY
			SET @skipIfPrimaryExistsForEngine = 1
			SET @updateIfSrvrExistsForEngine = 1
		END
	END
	BEGIN TRAN
		DELETE APP_ConfigurationPolicy
		WHERE policyId = @policyId
		SELECT @errorCode = @@ERROR
		IF @errorCode <> 0 GOTO ERROR
		IF (@policyType = 2) and @detailType = 5 -- Content indexing file policy for FS
		BEGIN
			Declare @SubclientIds table (Id int)
			SET @policyAttrName = 'Content Indexing Policy ID'
			INSERT INTO @SubclientIds
			SELECT componentNameId FROM APP_SubClientProp
			WHERE attrName = @policyAttrName
			and attrVal = CAST(@policyId AS NVARCHAR(15))
			and modified = 0
			-- Update the modified time for the "Enable Content Indexing" property.
			UPDATE SubclientProp1 set modified = dbo.getunixtime(getutcdate())
			FROM APP_SubClientProp SubclientProp1 RIGHT OUTER JOIN @SubclientIds subclientIdList
			ON SubclientProp1.componentNameId = subclientIdList.Id
			WHERE SubclientProp1.attrName = 'Enable Content Indexing'
			and SubclientProp1.modified = 0
			-- Insert new row for "Enable Content Indexing" Property with attrVal = 0 and modified = 0
			INSERT APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			SELECT subclientIdList.Id, 'Enable Content Indexing', 2, 0, dbo.getunixtime(getutcdate()), 0
			FROM @SubclientIds subclientIdList
			-- Update the modified time for @policyAttrName property.
			UPDATE APP_SubClientProp set modified = dbo.getunixtime(getutcdate())
			WHERE attrName = @policyAttrName
			and  attrVal = CAST(@policyId AS NVARCHAR(15))
			and modified = 0
			-- Insert new row for @policyAttrName and set the attrVal = 0 and modified = 0
			INSERT APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
			SELECT subclientIdList.Id, @policyAttrName, 2, 0, dbo.getunixtime(getutcdate()), 0
			FROM @SubclientIds subclientIdList
			-- Create the input XML for AppModifyIndexServerForCI.sp
			SET @inputXmlForIndexChange =
			(
				SELECT
				(SELECT @idxSrvrClientId '@idxServerClientId', @isPrimary '@isPrimary',
				@engineType '@engineType', @opType '@opType', @entityType '@entityType',
				@skipIfPrimaryExistsForEngine '@skipIfPrimaryExistsForEngine',
				@updateIfSrvrExistsForEngine '@updateIfSrvrExistsForEngine',
				(SELECT Id '@val'
				FROM @SubclientIds
				FOR XML PATH('entityIdList'), TYPE)
				FOR XML PATH('modifyIndexServerReq'), TYPE)
				FOR XML PATH('Indexing_ModifyIndexServerForCIReq')
			)
			EXEC AppModifyIndexServerForCI @inputXmlForIndexChange
			--Deleting the associated schedules
			UPDATE T SET T.DELETED = 1 FROM TM_Task T
			INNER JOIN TM_SubTask ST ON T.taskId = ST.taskId
INNER JOIN TM_SubTaskOptions STO ON STO.subTaskId = ST.subTaskId AND optionId = 78814566 AND value = CAST(@policyId AS VARCHAR(10))
			EXEC TM_maintenance
		END
ERROR:
	IF @errorCode <> 0
		ROLLBACK TRAN
	ELSE
		COMMIT TRAN
ERROR_EXIT:
	SET @o_xmlString = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
						FOR XML PATH('Ida_GenericResp'), TYPE)
	SELECT @o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppConfigurationPolicyDelete')
	delete from GxQscripts where name = 'AppConfigurationPolicyDelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppConfigurationPolicyDelete')
	delete from GXDBVersions where aliasname = 'AppConfigurationPolicyDelete'
GO

insert into GXDBVersions values(2, 'AppConfigurationPolicyDelete',  '00000000000000000000', 'AppConfigurationPolicyDelete', '00000000000000000000')
GO

