

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppConfDeconf.sp] ---------- 

--#include <Db/dbsizes.h>
--#include <Db/dbrdbms.h>
--#include <AppMgr/AppTypeDefs.h>
--#include <AppMgr/derivedBackupSets.h>
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppConfDeconf.sp,v $ $Id: AppConfDeconf.sp,v 1.8.60.2.62.1 2021/01/28 19:19:05 snair Exp $";
--
--  +==========================================================================+
--  | Stored Precedure: AppConfDeconf()
--	|
--	|   Input: ClientId, AppType, Instance  -- These are expected to be hierarchial
--	|			i.e., if you specify instance <> 0, then appTypeId and clientId must also
--	|			be non-zero.  Zero otherwise means "all at this level".  Currently only
--	|		    newState =1 (configure) and newState =2 (deconfigure) are supported. Other
--	|			input means error.
--	|
--	|	return: SP return code = 0 means success, !0 - failure. In addition, two variables
--	|	  		passed in as OUTPUT variables will also contain return code (0=success) and infostring
--	|
--	|	Notes:	No Transaction Processing done here. Proc should be wrapped in transaction by calling
--	|			process and commit w/@retCode = 0 and rollback w/@retCode <> 0
--	|
--  |   Revisions  Author     Description
--  |   ---------  -------    ---------------------------------------------
--  |   1.0        stuk      Initial Edit
--	|   1.1		   stuk		 Annotate
--  |   1.2        stuk      Annotate more
--  |   1.3		   stuk	     'Platform Deleted 4', MA and CS deConfigure aware
--  +==========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppConfDeconf')
BEGIN
	print '>>> Drop Stored Procedure: AppConfDeconf <<<'
	drop procedure AppConfDeconf
END
IF EXISTS (select * from GxQscripts where name='AppConfDeconf')
	delete from GxQscripts where name = 'AppConfDeconf'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppConfDeconf')
	delete from GXDBVersions where aliasname = 'AppConfDeconf'
GO
print '... Creating Procedure: AppConfDeconf'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppConfDeconf
  @i_clientId integer,
  @i_appTypeId integer,
  @i_instance integer,
  @i_newState integer,					
  @retCode integer			OUTPUT,
  @infoString varchar(1024)	OUTPUT
AS
set nocount on
--@i_newState  1 = Config, 2 = Deconfig
if (@i_appTypeId + @i_instance) = 0  -- This was a client level config/deconfig
SET @infoString =  ''				-- BE OPTIMISTIC
SET @retCode    =  0
DECLARE @nowTime   			integer
DECLARE @describeString		nvarchar(512)
SET	@nowTime     =   dbo.GetUnixTime (GetUTCdate())
DECLARE @CV_STATUS_UNINSTALLED	AS	integer = 2			-- Convenience, from "AppMgrDefines.h"
DECLARE @CV_STATUS_DELETED		AS	integer	= 4
DECLARE @PLATFORM_DELETED_ID		AS  integer = 0		    -- Id of clientProp row that contains the "PlatformDeleted 4' property
DECLARE @PLATFORM_DELETED_PROP		AS  nvarchar(50) = N'PlatformDeleted 4'
DECLARE @PLATFORM_DELETED_OLDVAL	AS  nvarchar(50) = N'0'
DECLARE @CLIENT_IS_MEDIA_AGENT		AS	integer 	 = 0
BEGIN TRY
	SET @describeString = 'AppConfDeconf('
	   + convert(nvarchar(8), @i_clientId)
	   + ', ' +convert(nvarchar(8), @i_appTypeId)
	   + ', ' +convert(nvarchar(8), @i_instance)
	   + ', ' +convert(nvarchar(8), @i_newState)
	   + ')'
------------------------------------------
--  DO SOME BASIC PARAMETER CHECKING	--
------------------------------------------
	IF @i_clientId = 0 OR (@i_clientId = 2 AND @i_instance = 0 AND @i_appTypeId = 0)
	BEGIN
		Set @retCode = 1												-- Must at least specify clientId and you cannot deconfigure Commcell
		Set @infoString = @describeString + ': Invalid ClientId'		-- .. with this Procedure
		GOTO RETURN_RESULTS
	END
	IF @i_instance <> 0 And @i_appTypeId = 0
	BEGIN
		Set @retCode = 1												-- If you specify an istanceId, you must specify an appType (to
		Set @infoString = @describeString + ': Invalid AppType'			-- .. preserve the hierarchy)
		GOTO RETURN_RESULTS
	END
--------------------------------------------------------------------------
--	SINCE ALL WILL BE DERIVED FROM APPLICATION TABLE, EXTRACT WHAT WE 	--
--  NEED SO WE HAVE A SMALLER TABLE TO "JOIN" WITH:						--
--------------------------------------------------------------------------
	IF object_id('tempdb.dbo.#scList') IS NOT Null	DROP TABLE #scList
	CREATE TABLE #scList
	(
		clientId		integer,
		appTypeId		integer,
		instanceId		integer,
		backupsetId		integer,
		subClientId		integer,
		status			integer
	)
	INSERT #scList
		SELECT clientId, appTypeId, instance, backupset, id, subClientStatus
			FROM  App_Application
			WHERE clientId = @i_clientId
			  AND (@i_appTypeId = 0  OR appTypeId = @i_appTypeId)
			  AND (@i_instance = 0   OR instance = @i_instance)
-- 	MAKE SURE WE NEVER CHANGE THE STATUS OF THE COMMON "DEFAULT INSTANCE" !!
	UPDATE #scList
	Set [instanceId] = 0
	Where [instanceId] = 1
--  MAKE SURE WE NEVER CHANGE THE STATUS OF THE COMMON "DEFAULT VSA INSTANCE" !!
    UPDATE SCL
    SET SCL.instanceId = 0
	FROM #scList SCL
	INNER JOIN
	APP_InstanceName AI
    ON SCL.instanceId = AI.id
WHERE AI.name = 'VMInstance'
AND AI.status = 0x200000
	------------------------------------------------
	-- MORE TO DO IF CLIENT LEVEL CONFIG/DECONFIG --
	------------------------------------------------
--  09Jun2010  -SKatz  .. Don't make this conditional, as we need to "unDeconfigure" Client if ANY member is also "unDeconfigured".
--	if (@i_appTypeId + @i_instance) = 0  -- This was a client level config/deconfig
--	BEGIN
		SET @PLATFORM_DELETED_ID		= ISNULL((Select id from App_ClientProp where componentNameId = @i_clientId AND attrName = @PLATFORM_DELETED_PROP AND modified = 0), 0)
		SET @PLATFORM_DELETED_OLDVAL	= ISNULL((Select attrVal From App_clientProp where id = @PLATFORM_DELETED_ID), N'0')
		IF EXISTS (select * from MMHost Where clientId = @i_clientId)
			SET @CLIENT_IS_MEDIA_AGENT = 1
--	END
--	=======================================================
--	NOW THAT WE HAVE OUR LIST, WE CAN DO CONFIG/DECONFIG --
--	=======================================================
	--------------
	--  CONFIG  --
	--------------
	IF (@i_newState = 1)
	BEGIN
		UPDATE APP_Application														-- SubClient (config)
		SET subClientStatus = subClientStatus & ~@CV_STATUS_UNINSTALLED,
			modified = @nowTime
		   WHERE clientId = @i_clientId
			  AND (@i_appTypeId = 0  OR appTypeId = @i_appTypeId)
			  AND (@i_instance = 0   OR instance = @i_instance)
			  AND (subClientStatus  & @CV_STATUS_DELETED) = 0
		UPDATE App_BackupsetName													-- BackupSet (config)
			SET status = status & ~@CV_STATUS_UNINSTALLED, modified = @nowTime
			WHERE id in (Select Distinct [backupsetId] from #scList)
		UPDATE  App_InstanceName													-- Instance (config)
			SET status = status & ~@CV_STATUS_UNINSTALLED, modified = @nowTime
			WHERE id in (Select Distinct [instanceId] from #scList)
--		Note that for IdaNAme, Client, we are setting Config status regardless of
-- 		input parameters  if they are currently deconfigured.  This is because it makes
--		no sense to 'configure" an appMgr object if it's parents are still deconfigured!
		UPDATE App_IdaName															-- IdaName (config)
			SET status = status & ~@CV_STATUS_UNINSTALLED, modified = @nowTime
			WHERE clientId = @i_clientId
			  AND (@i_appTypeId = 0  OR appTypeId = @i_appTypeId)
			  AND (status & @CV_STATUS_UNINSTALLED) <> 0
		UPDATE App_Client															-- Client (config)
			SET status = status & ~@CV_STATUS_UNINSTALLED, modified = @nowTime
			WHERE id = @i_clientId
			  AND (status & @CV_STATUS_UNINSTALLED) <> 0
--		We Can always mark client not deleted, regardless of actual component level requested:
		IF @PLATFORM_DELETED_ID <> 0 AND (@PLATFORM_DELETED_OLDVAL = N'1')
			UPDATE App_ClientProp SET AttrVal = N'0', created = @nowTime Where id = @PLATFORM_DELETED_ID
	END
	-----------------
	--  DE-CONFIG  --
	-----------------
	ELSE IF (@i_newState = 2)
	BEGIN
		UPDATE APP_Application														-- SubClient (de-config)
		SET subClientStatus = subClientStatus | @CV_STATUS_UNINSTALLED, modified = @nowTime
		   WHERE clientId = @i_clientId
			  AND (@i_appTypeId = 0  OR appTypeId = @i_appTypeId)
			  AND (@i_instance = 0   OR instance = @i_instance)
			  AND (subClientStatus  & @CV_STATUS_DELETED) = 0
		UPDATE App_BackupsetName													-- BackupSet (de-config)
			SET status = status | @CV_STATUS_UNINSTALLED, modified = @nowTime
			WHERE id in (Select Distinct [backupsetId] from #scList)
		UPDATE  App_InstanceName													-- Instance (de-config)
			SET status = status | @CV_STATUS_UNINSTALLED, modified = @nowTime
			WHERE id in (Select Distinct [instanceId] from #scList)
		UPDATE App_IdaName															-- IdaName (de-config)
			SET status = status | @CV_STATUS_UNINSTALLED, modified = @nowTime
			WHERE clientId = @i_clientId
			  AND (@i_appTypeId = 0  OR appTypeId = @i_appTypeId)
			  AND @i_instance = 0													-- If we specified a specific instance, there may be other
																					-- instances still configured under this iDa
		UPDATE App_Client															-- Client (de-config)
			SET status = status | @CV_STATUS_UNINSTALLED, modified = @nowTime
			WHERE id = @i_clientId
			AND @i_instance = 0	 and @i_appTypeId = 0								-- If appType or instance specified, must leave client "installed"!
			AND @CLIENT_IS_MEDIA_AGENT = 0											-- .. if client is a MA, don't mark client deconfigured
--		----------------------------------------------------------
-- 		NEED TO DO MORE IF THIS WAS A CLIENT LEVEL DECONFIG:	--
--		----------------------------------------------------------
		IF @i_instance = 0	and @i_appTypeId = 0 AND @PLATFORM_DELETED_OLDVAL = '0'  -- (Don't need to do anything if client already had prop == deleted
		BEGIN
				IF @PLATFORM_DELETED_ID <> 0
					UPDATE App_ClientProp SET AttrVal = N'1', created = @nowTime Where id = @PLATFORM_DELETED_ID
				ELSE
					INSERT App_ClientProp (componentNameId, attrName, attrType, attrVal, created,  modified)
						VALUES (@i_clientId, @PLATFORM_DELETED_PROP, 2, N'1', @nowTime, 0)
		END
	END
	ELSE
	BEGIN
		set @infoString = @describeString + ': Invalid [newType]'
		set @retCode    = 1
		GOTO RETURN_RESULTS
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	set @retCode = ERROR_NUMBER()
	set @infoString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE() + @describeString
END CATCH
RETURN_RESULTS:
	IF object_id('tempdb.dbo.#scList') IS NOT Null				-- Clean up Temp Table
			DROP TABLE #scList
	return @retCode
GO


IF EXISTS (select * from GxQscripts where name = 'AppConfDeconf')
	delete from GxQscripts where name = 'AppConfDeconf'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppConfDeconf')
	delete from GXDBVersions where aliasname = 'AppConfDeconf'
GO

insert into GXDBVersions values(2, 'AppConfDeconf',  'v1.8.60.2.62.1', 'AppConfDeconf', 'v1.8.60.2.62.1')
GO

