

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCompleteClientSetupForAdvancedIndexing.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCompleteClientSetupForAdvancedIndexing.sp,v $ $Id: AppCompleteClientSetupForAdvancedIndexing.sp,v 1.1.4.2 2018/08/17 17:38:43 alakra Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppCompleteClientSetupForAdvancedIndexing <<<'

IF EXISTS (select * from sysobjects where name='AppCompleteClientSetupForAdvancedIndexing')
	drop procedure AppCompleteClientSetupForAdvancedIndexing
IF EXISTS (select * from GxQscripts where name='AppCompleteClientSetupForAdvancedIndexing')
	delete from GxQscripts where name = 'AppCompleteClientSetupForAdvancedIndexing'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCompleteClientSetupForAdvancedIndexing')
	delete from GXDBVersions where aliasname = 'AppCompleteClientSetupForAdvancedIndexing'
GO
print '... Creating Procedure: AppCompleteClientSetupForAdvancedIndexing'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCompleteClientSetupForAdvancedIndexing
  @i_userId INTEGER,
  @i_localeId INTEGER,
  @i_clientId INTEGER,
  @i_serverplanId INTEGER,
  @i_dcPlanId INTEGER,
  @o_errCode INTEGER OUTPUT,
  @o_errString NVARCHAR(1024) OUTPUT
AS
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @executionUnixTime  INT           = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))
DECLARE @rcnt				INT
SET @o_errCode = 0
SET @o_errString = 'Success'
IF NOT EXISTS (SELECT 1 FROM APP_Plan WHERE id IN (@i_serverplanId, @i_dcPlanId))
BEGIN
SET @o_errCode = (1339 | (CAST(POWER(2, 24) AS BIGINT) * 85))
	SET @o_errString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK)
WHERE messageId = (1339 | (CAST(POWER(2, 24) AS BIGINT) * 85)) AND [localeId] = @i_localeId)
	SET @o_errString = REPLACE(@o_errString, '^1%s', 'Plan Id')
	GOTO ERROR_EXIT
END
IF NOT EXISTS (SELECT 1 FROM APP_Client WHERE id=@i_clientId)
BEGIN
SET @o_errCode = (1339 | (CAST(POWER(2, 24) AS BIGINT) * 85))
	SET @o_errString = (SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK)
WHERE messageId = (1339 | (CAST(POWER(2, 24) AS BIGINT) * 85)) AND [localeId] = @i_localeId)
	SET @o_errString = REPLACE(@o_errString, '^1%s', 'Client Id')
	GOTO ERROR_EXIT
END
-- If exists is important here. execute inner case always when plan id is updated/saved in app_planprop
IF NOT EXISTS (SELECT 1 FROM APP_PlanProp WHERE componentNameId=@i_serverplanId AND attrname='Default Data classification Plan'  AND modified=0 AND attrval=CAST(@i_dcPlanId AS NVARCHAR(32)))
BEGIN
	UPDATE APP_PlanProp SET attrval = CAST(@i_dcPlanId AS NVARCHAR(32))
WHERE componentNameId=@i_serverplanId AND attrname='Default Data classification Plan'  AND modified=0
	SET @rcnt = @@ROWCOUNT
	IF (@rcnt = 0)
	BEGIN
		INSERT INTO APP_PlanProp (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (@i_serverplanId, 'Default Data classification Plan', 7, CAST(@i_dcPlanId AS NVARCHAR(32)), @executionUnixTime, 0)
	END
EXEC sec_cloneSecurityAssociationsFromEntity 2, 0, @o_errCode OUTPUT, @o_errString OUTPUT, 158, @i_serverplanId, 158, @i_dcPlanId
END
UPDATE APP_ClientProp SET attrval = CAST(@i_dcPlanId AS NVARCHAR(32))
WHERE componentNameId=@i_clientId AND attrname='Default Data classification Plan' AND modified=0
SET @rcnt = @@ROWCOUNT
IF (@rcnt = 0)
BEGIN
	INSERT INTO APP_CLIENTPROP(componentNameId, attrName, attrVal, attrType, created, modified, ccpid)
Values(@i_clientId, 'Default Data classification Plan', CAST(@i_dcPlanId AS NVARCHAR(32)), 7, @executionUnixTime, 0, 0)
END
RETURN
ERROR_EXIT:
GO

IF EXISTS (select * from GxQscripts where name = 'AppCompleteClientSetupForAdvancedIndexing')
	delete from GxQscripts where name = 'AppCompleteClientSetupForAdvancedIndexing'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCompleteClientSetupForAdvancedIndexing')
	delete from GXDBVersions where aliasname = 'AppCompleteClientSetupForAdvancedIndexing'
GO

insert into GXDBVersions values(2, 'AppCompleteClientSetupForAdvancedIndexing',  '00010001000400020000', 'AppCompleteClientSetupForAdvancedIndexing', '00010001000400020000')
GO

