

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCompanyValidateAuthCode.sp] ---------- 

-- MODIFIED FOR (CCP)
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCompanyValidateAuthCode.sp,v $ $Id: AppCompanyValidateAuthCode.sp,v 1.1.2.3 2018/03/27 08:45:29 jiechen Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppCompanyValidateAuthCode   -
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppCompanyValidateAuthCode <<<'

IF EXISTS (select * from sysobjects where name='AppCompanyValidateAuthCode')
	drop procedure AppCompanyValidateAuthCode
IF EXISTS (select * from GxQscripts where name='AppCompanyValidateAuthCode')
	delete from GxQscripts where name = 'AppCompanyValidateAuthCode'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCompanyValidateAuthCode')
	delete from GXDBVersions where aliasname = 'AppCompanyValidateAuthCode'
GO
print '... Creating Procedure: AppCompanyValidateAuthCode'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCompanyValidateAuthCode
  @i_userId INT,
  @i_localeId INT,
  @o_xmlText XML OUTPUT,
  @o_errCode INTEGER OUTPUT,
  @o_errString NVARCHAR(1024) OUTPUT
AS
  DECLARE @xmlText XML
  DECLARE @errCode INTEGER
  DECLARE @errString NVARCHAR(1024) 
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
    DECLARE @authCode NVARCHAR(64)
    DECLARE @isValidAuthCode  INTEGER = 0
    DECLARE @companyID   INTEGER = -1
    DECLARE @providerID INTEGER = dbo.AppGetOrganizationForUser(@i_userId)
    DECLARE @clientId INTEGER = 0
    SET @o_errCode = 0 -- Optimism
    SET @o_errString = '' -- Optimism
    SET @authCode = (SELECT ref.value('@authCode', 'NVARCHAR(64)')FROM @o_xmlText.nodes('Api_ValidateCompanyAuthCodeReq') R(ref))
SELECT @companyID=componentNameID FROM APP_CompanyProp WHERE attrname='Authorization Code' AND attrVal=@authCode AND modified=0
    SET @clientId = ISNULL((SELECT ref.value('@clientId', 'INTEGER')FROM @o_xmlText.nodes('Api_ValidateCompanyAuthCodeReq/client') R(ref)), 0)
    IF @clientId > 0
    BEGIN
        -- First get the Company Id for the provided client
        -- Now provided auth code should be for the company which installed this client
DECLARE @clientcompanyId INTEGER = ISNULL((SELECT CONVERT(INTEGER,attrval)  FROM APP_ClientProp WHERE attrname='Installation Company ID' AND componentNameId=@clientId AND modified=0) , -1)
        IF (@clientcompanyId > -1) AND (@companyID = @clientcompanyId)
        BEGIN
            SET @isValidAuthCode = 1
        END
    END
    ELSE
    BEGIN
        -- We are not implementing any security check right now. But , we can extend that later to see if company with provided auth code can actually be used by provided user id
        IF @companyID > -1
        BEGIN
            SET @isValidAuthCode = 1
        END
    END
IF (0 = @o_errCode)
BEGIN
SET @o_xmlText = (SELECT @isValidAuthCode AS '@isValidAuthCode',
			(SELECT @o_errCode AS '@o_errCode', @o_errString AS '@errorMessage'  FOR XML PATH('error'),TYPE)
		FOR XML PATH('Api_ValidateCompanyAuthCodeResp'),TYPE)
END
ELSE
BEGIN
    SET @o_xmlText = (SELECT @o_errCode AS '@errorCode', @o_errString AS '@errorMessage' FOR XML PATH ('error'), ROOT('Api_ValidateCompanyAuthCodeResp'))
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @o_errCode = ERROR_NUMBER()
    set @o_errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	SET @o_xmlText = (SELECT @o_errCode AS '@errorCode', @o_errString AS '@errorMessage' FOR XML PATH ('error'), ROOT('Api_ValidateCompanyAuthCodeResp'))
END CATCH
SET @xmlText             = @o_xmlText
SET @errCode             = @o_errCode
SET @errString           = @o_errString
SELECT @xmlText, @errCode, @errString
SCRIPT_EXIT:
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppCompanyValidateAuthCode')
	delete from GxQscripts where name = 'AppCompanyValidateAuthCode'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCompanyValidateAuthCode')
	delete from GXDBVersions where aliasname = 'AppCompanyValidateAuthCode'
GO

insert into GXDBVersions values(2, 'AppCompanyValidateAuthCode',  '00010001000200030000', 'AppCompanyValidateAuthCode', '00010001000200030000')
GO

