

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCompanySettingsSet.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppCompanySettingsSet()
--  | Description:  Allows for Add/Edit of company settings
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCompanySettingsSet.sp,v $ $Id: AppCompanySettingsSet.sp,v 1.1.2.8 2018/03/27 09:12:55 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppCompanySettingsSet <<<'

IF EXISTS (select * from sysobjects where name='AppCompanySettingsSet')
	drop procedure AppCompanySettingsSet
IF EXISTS (select * from GxQscripts where name='AppCompanySettingsSet')
	delete from GxQscripts where name = 'AppCompanySettingsSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCompanySettingsSet')
	delete from GXDBVersions where aliasname = 'AppCompanySettingsSet'
GO
print '... Creating Procedure: AppCompanySettingsSet'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCompanySettingsSet
  @i_userId INTEGER,
  @i_xmlText XML,
  @o_xmlText XML				    OUTPUT
AS
SET NOCOUNT ON
DECLARE @errCode    integer
DECLARE @errString	nvarchar(1024)
DECLARE @xmlText    XML
DECLARE @userRole   INTEGER
DECLARE @isMSPUserComcellAdmin INTEGER
BEGIN TRY
	-- local variables
	DECLARE @nowTime AS integer = dbo.GetUnixTime (GetUTCdate())
	DECLARE @providerId Int
--INSERT/UPDATE Operation
	BEGIN
		set @errCode = 0
		set @errString = ''
		EXEC AppGetUserRole @i_userId, @xmlText OUTPUT, @errCode OUTPUT, @errString OUTPUT -- check if user has Setting Capabitlity - Only MSP Admin or Tenant Admin can set company settings
		SET @userRole = (SELECT TOP 1 ref.value('@userRole', 'int') AS value FROM @xmlText.nodes('Api_GetUserMappings') R ( ref ))
		IF ((@errCode = 0) AND (@userRole = 0 OR @userRole=1)) --MSP Admin or Tenant Admin
			BEGIN
				SET @providerId = (SELECT TOP 1 ref.value('@id', 'int') AS value FROM @xmlText.nodes('Api_GetUserMappings') R ( ref ))
				DECLARE @tempSetTable table(componentId int, propertyTypeId int, stringVal VARCHAR(max))
				INSERT INTO @tempSetTable (componentId, propertyTypeId, stringVal)
						SELECT @providerId, R.ref.value('@name','int'), R.ref.value('@value','NVARCHAR(MAX)')
						FROM @i_xmlText.nodes('Api_SetCompanySettingsReq/settingsInfo/settingDetail') R ( ref )
where R.ref.value('@name','int') between 2400 and 2411
				MERGE APP_ComponentProp AS T
					USING @tempSetTable AS S
					ON T.propertyTypeId = S.propertyTypeId and t.componentId=s.componentId
					WHEN MATCHED THEN
						UPDATE SET T.stringVal = s.stringVal, t.modified=dbo.GetUnixTime(GetUTCDate())
					WHEN NOT MATCHED THEN
INSERT (componentType, componentId, propertyTypeId, dataType, stringVal, longVal, longlongVal, created, modified) VALUES (10, s.componentId, S.propertyTypeId, 1, s.stringVal, 0, 0, dbo.GetUnixTime(GetUTCDate()), 0);
				SET @o_xmlText = (SELECT @providerId AS '@id',
						(Select
							(select propertyTypeId AS '@name',
									stringVal	        AS '@value'
									from @tempSetTable
									FOR XML PATH('settingDetail'), TYPE)
						FOR XML PATH('settingsInfo'), TYPE),
						(SELECT @errCode AS '@errorCode', @errString AS '@errorMessage'  FOR XML PATH('error'),TYPE)
				FOR XML PATH('Api_SetCompanySettingsResp'),TYPE)
			END
		ELSE
			BEGIN
				set @errCode = 2
				set @errString = 'User does not have rights to set or update Company Settings.'
				SET @o_xmlText = ( SELECT	@errCode			as 'error/@errorCode',
					@errString			as 'error/@errorMessage'
					FOR XML PATH(''), ROOT('Api_SetCompanySettingsResp'))
			END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @errCode = ERROR_NUMBER()
    set @errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	SET @o_xmlText = ( SELECT	@errCode			as 'error/@errorCode',
						@errString			as 'error/@errorMessage'
						FOR XML PATH(''), ROOT('Api_SetCompanySettingsResp'))
	GOTO SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppCompanySettingsSet')
	delete from GxQscripts where name = 'AppCompanySettingsSet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCompanySettingsSet')
	delete from GXDBVersions where aliasname = 'AppCompanySettingsSet'
GO

insert into GXDBVersions values(2, 'AppCompanySettingsSet',  '00010001000200080000', 'AppCompanySettingsSet', '00010001000200080000')
GO

