

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCompanySettingsGet.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  AppCompanySettingsGet()
--  | Description:  Allows for GET of company settings in App_ComponentProp
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCompanySettingsGet.sp,v $ $Id: AppCompanySettingsGet.sp,v 1.1.2.5 2018/03/27 09:09:57 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppCompanySettingsGet <<<'

IF EXISTS (select * from sysobjects where name='AppCompanySettingsGet')
	drop procedure AppCompanySettingsGet
IF EXISTS (select * from GxQscripts where name='AppCompanySettingsGet')
	delete from GxQscripts where name = 'AppCompanySettingsGet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCompanySettingsGet')
	delete from GXDBVersions where aliasname = 'AppCompanySettingsGet'
GO
print '... Creating Procedure: AppCompanySettingsGet'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCompanySettingsGet
  @i_userId INTEGER,
  @i_settingIds nvarchar(1024),
  @o_xmlText XML OUTPUT
AS
SET NOCOUNT ON
DECLARE @errCode    integer
DECLARE @errString	nvarchar(1024)
BEGIN TRY
DECLARE @providerId Int
BEGIN
	SET @providerId = dbo.AppGetOrganizationForUser(@i_userId)
	SET @errCode = 0
	SET @errString = ''
	IF (@i_settingIds is not null AND len(@i_settingIds)>0)
	BEGIN
	SET @o_xmlText = (SELECT @providerId AS '@id',
				(SELECT
					(SELECT propertyTypeId AS '@name',
						stringVal      AS '@value'
from APP_ComponentProp where componentId=@providerId AND propertyTypeId in (select _ID from dbo.SplitIDs(@i_settingIds)) AND componentType=10
					 FOR XML PATH('settingDetail'), TYPE)
				FOR XML PATH('settingsInfo'), TYPE),
				(SELECT @errCode AS '@errorCode', @errString AS '@errorMessage'  FOR XML PATH('error'),TYPE)
			 FOR XML PATH('Api_GetCompanySettingsResp'),TYPE)
	END
	ELSE
	BEGIN
		SET @o_xmlText = (SELECT @providerId AS '@id',
					(SELECT
						(SELECT propertyTypeId AS '@name',
							stringVal      AS '@value'
from APP_ComponentProp WHERE componentId=@providerId AND componentType=10
						FOR XML PATH('settingDetail'), TYPE)
					FOR XML PATH('settingsInfo'), TYPE),
					(SELECT @errCode AS '@errorCode', @errString AS '@errorMessage'  FOR XML PATH('error'),TYPE)
				FOR XML PATH('Api_GetCompanySettingsResp'),TYPE)
	END
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errCode = ERROR_NUMBER()
    SET @errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	SET @o_xmlText = (SELECT @errCode			as 'error/@errorCode',
				 @errString			as 'error/@errorMessage'
			  FOR XML PATH(''), ROOT('Api_GetCompanySettingsResp'))
	GOTO SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppCompanySettingsGet')
	delete from GxQscripts where name = 'AppCompanySettingsGet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCompanySettingsGet')
	delete from GXDBVersions where aliasname = 'AppCompanySettingsGet'
GO

insert into GXDBVersions values(2, 'AppCompanySettingsGet',  '00010001000200050000', 'AppCompanySettingsGet', '00010001000200050000')
GO

