

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCompanyGetSummaryList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCompanyGetSummaryList.sp,v $ $Id: AppCompanyGetSummaryList.sp,v 1.1.2.9.4.1 2021/01/08 08:05:51 njudge Exp $";
--	+===========================================================================================+
--	|  						AppCompanyGetSummaryList											|
--	|																							|
--  |  PARAMETERS																				|
--  |    i_callerId	  = caller userId															|
--  |    i_localeID	  = localeId																|
--  |    o_xmlData	  = Api_CompanyAssociatedEntitiesReq/Api_CompanyAssociatedEntitiesResp xml	|
--	+===========================================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppCompanyGetSummaryList')
BEGIN
	print '>>> Drop Stored Procedure: AppCompanyGetSummaryList <<<'
	drop procedure AppCompanyGetSummaryList
END
IF EXISTS (select * from GxQscripts where name='AppCompanyGetSummaryList')
	delete from GxQscripts where name = 'AppCompanyGetSummaryList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCompanyGetSummaryList')
	delete from GXDBVersions where aliasname = 'AppCompanyGetSummaryList'
GO
print '... Creating Procedure: AppCompanyGetSummaryList'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppCompanyGetSummaryList
  @i_callerId INT,
  @i_localeID INT,
  @o_xmlData XML OUTPUT,
  @i_inputReq XML
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @getSelectedCompanies INT = ISNULL((SELECT @i_inputReq.exist('*/companyList/@providerId')),0)
IF OBJECT_ID('tempdb.dbo.#tempUserTable') IS NOT NULL
	DROP TABLE #tempUserTable
CREATE TABLE #tempUserTable (providerId INT, userID INT, userLogin NVARCHAR(255), userDisplayName NVARCHAR(255))
IF OBJECT_ID('tempdb.dbo.#umdsproviderslist') IS NOT NULL
	DROP TABLE #umdsproviderslist
CREATE TABLE #umdsproviderslist (nameserversId INT PRIMARY KEY)
CREATE TABLE #companyList (companyId INT PRIMARY KEY, associatedEntitiesCount INT)
EXEC sec_getNameServersForThisUser '#umdsproviderslist', @i_callerId, 0, 0 /*forViewUserOrGroupInAD*/
INSERT INTO #companyList (companyId)
	SELECT nameserversId FROM #umdsproviderslist
	LEFT JOIN @i_inputReq.nodes('App_CompanyEntityReq/companyList') R(ref) ON nameserversId = ref.value('@providerId', 'INT')
	WHERE @getSelectedCompanies = 0 OR ref.value('@providerId', 'INT') IS NOT NULL
--
IF OBJECT_ID('tempdb.dbo.#umdsproviderslist') IS NOT NULL
	DROP TABLE #umdsproviderslist
--
--
-- GET ASSOCIATED ENTITIES ----------------------------------------------------------------------------------------------------------------------------------
CREATE TABLE #associatedEntities
(
	companyId INT,
	entityType INT,
	entityId INT,
	clientType INT,
	numberOfItems INT
)
CREATE CLUSTERED INDEX idx_associatedEntities_entityType_entityId ON #associatedEntities(companyId, entityType, entityId)
--
INSERT INTO #associatedEntities (companyId, entityType, entityId, numberOfItems)
SELECT
	CE.companyId, CE.entityType, CE.entityId, 1/*count for each entity*/
	FROM App_CompanyEntities CE
	INNER JOIN #companyList C ON C.companyId = CE.companyId
WHERE entityType NOT IN (18,68,120,174,9501,
9503,35,65,9,13,15,3,7
,6,127)
	-- Ignoring USER_ENTITY and USERGROUP_ENTITY as that gets counted separately
-- GET ASSOCIATED ENTITIES ----------------------------------------------------------------------------------------------------------------------------------
--
--
-- GET ALL O365 CLIENTS -------------------------------------------------------------------------------------------------------------------------------------
DECLARE @clientType_O365_Exchange INT = 5,
		@clientType_Exchange INT = 6,
		@clientType_Archiver INT = 7,
		@clientType_GSuite_APP INT = 8,
		@clientType_Salesforce_APP INT = 9,
		@clientType_O365_SharePoint INT = 10,
		@clientType_O365_OneDrive INT = 11,
		@clientType_O365_Dynamics INT = 12,
		@clientType_O365_Teams INT = 13
INSERT INTO #associatedEntities (companyId, entityId, entityType, clientType, numberOfItems)
SELECT DISTINCT CE.companyId, A.clientId, 3, @clientType_O365_Exchange, 0
    FROM App_CompanyEntities CE
	INNER JOIN #companyList C ON C.companyId = CE.companyId
INNER JOIN APP_Application A ON A.clientId = CE.entityId AND (A.subclientStatus & 0x00004 != 0x00004)
    INNER JOIN App_Clientprop CP On CP.componentNameId = A.clientId AND CP.attrName='Office 365 Pseudo Client' AND CP.attrVal='1' AND CP.modified=0
	INNER JOIN APP_IDAName IA ON A.clientId = IA.clientId
	INNER JOIN APP_IDAProp AP ON AP.componentNameId = IA.id AND A.appTypeId = IA.appTypeId AND AP.attrName = 'Exchange Environment Type' and AP.attrval = '4' AND AP.modified=0
WHERE CE.entityType = 3 AND A.appTypeId IN (137/*Exchange V1 and V2*/)
--
INSERT INTO #associatedEntities (companyId, entityId, entityType, clientType, numberOfItems)
SELECT DISTINCT CE.companyId, A.clientId, 3, @clientType_O365_OneDrive, 0
    FROM App_CompanyEntities CE
	INNER JOIN #companyList C ON C.companyId = CE.companyId
INNER JOIN APP_Application A ON A.clientId = CE.entityId AND (A.subclientStatus & 0x00004 != 0x00004)
	INNER JOIN APP_InstanceProp IP ON IP.componentNameId = A.instance AND IP.attrName = 'Cloud Apps Instance Type' AND IP.modified = 0 AND Ip.attrVal = '7'/*One drive*/
	LEFT JOIN #associatedEntities T ON T.entityType=CE.entityType AND T.entityId = CE.entityId
WHERE CE.entityType = 3 AND A.appTypeId IN (134) AND T.entityId IS NULL /*client not present already*/
--
INSERT INTO #associatedEntities (companyId, entityId, entityType, clientType, numberOfItems)
SELECT DISTINCT CE.companyId, A.clientId, 3, @clientType_O365_SharePoint, 0
    FROM App_CompanyEntities CE
	INNER JOIN #companyList C ON C.companyId = CE.companyId
INNER JOIN APP_Application A ON A.clientId = CE.entityId AND (A.subclientStatus & 0x00004 != 0x00004) AND (A.subclientStatus & 0x00008 = 0x00008)
INNER JOIN APP_BackupSetName BK ON A.backupSet = BK.id AND (BK.status & 0x80000 = 0x80000)
	LEFT JOIN #associatedEntities T ON T.entityType=CE.entityType AND T.entityId = CE.entityId
WHERE CE.entityType = 3 AND A.appTypeId IN (78/*sharepoint*/)  AND T.entityId IS NULL /*client not present already*/
-- GET ALL O365 CLIENTS -------------------------------------------------------------------------------------------------------------------------------------
--
--
-- START - DELETE/HIDE HIERARCHICAL ENTITIES IF ENTITIES FROM ALL THE LEVELS PRESENT ------------------------------------------------------------------------
	-- If subclient/backupset/instance and client are associated to the same company then return only client
DELETE AE
FROM #associatedEntities AE
INNER JOIN App_Application APP ON APP.id = AE.entityId AND AE.entityType=7
LEFT JOIN #associatedEntities CL ON CL.entityType=3 AND CL.entityId = APP.clientId
WHERE CL.entityId IS NOT NULL
--
DELETE AE
FROM #associatedEntities AE
INNER JOIN App_Application APP ON APP.backupSet = AE.entityId AND AE.entityType=6
LEFT JOIN #associatedEntities CL ON CL.entityType=3 AND CL.entityId = APP.clientId
WHERE CL.entityId IS NOT NULL
--
DELETE AE
FROM #associatedEntities AE
INNER JOIN App_Application APP ON APP.instance = AE.entityId AND AE.entityType=5
LEFT JOIN #associatedEntities CL ON CL.entityType=3 AND CL.entityId = APP.clientId
WHERE CL.entityId IS NOT NULL
--
-- DELETE PLAN SUB ENTITIES
DELETE AE
FROM #associatedEntities AE
INNER JOIN App_PlanProp PP ON PP.modified=0 AND PP.attrName='Storage policy' AND PP.attrVal = CAST(AE.entityId AS VARCHAR(24))
LEFT JOIN #associatedEntities AP ON AP.entityType=158 AND AP.entityId = PP.componentNameId
WHERE AE.entityType = 17 AND AP.entityId IS NOT NULL
--
-- DELETE INFRA AND DELETED VM clients
--Logic taken from AppGetclientlistAndPropsForAdminConsole.sp
DECLARE @appType35Table TABLE (
		appTypeId		INT PRIMARY KEY
	)
INSERT INTO @appType35Table
	SELECT DISTINCT appTypeId
	FROM GetAppTypesForAppGroup(35,0)
DELETE AE
FROM #associatedEntities AE
INNER JOIN CT_ClientProperties CP ON AE.entityType = 3 AND CP.clientId = AE.entityId
INNER JOIN APP_Client C ON C.id = AE.entityId AND Ae.entityType = 3 AND C.status & 0x1000 <> 0x1000
INNER JOIN APP_IDAName ida	ON ida.clientId = AE.entityId
INNER JOIN @appType35Table FS ON FS.appTypeId = ida.appTypeId
LEFT OUTER JOIN (
	SELECT CId FROM LicUsage L
INNER JOIN #associatedEntities AE ON AE.entityType = 3 AND AE.entityId = L.CId
	INNER JOIN APP_IDAName I on l.CId=I.clientId and L.AppType=I.appTypeId
	INNER JOIN @appType35Table fs ON fs.appTypeId=I.appTypeId
	WHERE  L.optype = 'Install'
	UNION
	SELECT clientId FROM APP_Application AP
INNER JOIN #associatedEntities AE ON AE.entityType = 3 AND AE.entityId = AP.clientId
	INNER JOIN @appType35Table fs ON fs.appTypeId=AP.appTypeId
	INNER JOIN APP_SubClientProp ASCP
	ON ASCP.componentNameId=AP.id AND ASCP.attrName=N'Last Data Protected Time' AND ASCP.modified=0 AND ASCP.cs_attrName = CHECKSUM(N'Last Data Protected Time')
) CP1 ON Cp1.CId = AE.entityId
WHERE CP.IsInfrastructureMachine=1 AND CP1.CId IS NULL
--
--Logic taken from AppGetVMStatusInfoForUser.sp
DELETE AE
FROM #associatedEntities AE
INNER JOIN APP_ClientProp ACPVM ON AE.entityType = 3 AND ACPVM.componentNameId = AE.entityId AND ACPVM.attrName='Virtual Server Discovered Clients'
	AND ACPVM.attrval='1' AND ACPVM.modified=0
LEFT OUTER JOIN APP_ClientProp ACPJOB ON ACPJOB.componentNameId=AE.entityId AND ACPJOB.attrName='Last Backup JobID' AND ACPJOB.modified=0
LEFT OUTER JOIN APP_VMProp VMP ON VMP.VMclientId=AE.entityId AND CAST(VMP.jobId AS NVARCHAR(128))=ACPJOB.attrVal AND VMP.attrName='vmStatus'
LEFT OUTER JOIN APP_ClientProp ACP ON AE.entityId = ACP.componentnameId AND ACP.attrName='Virtual Machine Deletion Time' AND ACP.modified=0 AND ACP.attrVal<>'0'
WHERE (VMP.attrVal NOT IN ('0'/*PROTECTED*/,'3'/*BACKED_UP_WITH_ERROR */) OR VMP.attrVal IS NULL) AND ACP.attrVal IS NOT NULL
--
--
--Logic taken from AppGetDBInstanceList.sp
CREATE TABLE #tempDBInstances (instanceId INT PRIMARY KEY, name NVARCHAR(1024))
INSERT INTO #tempDBInstances
	SELECT DISTINCT I.id, I.name
	FROM #associatedEntities AE
INNER JOIN APP_InstanceName I ON AE.entityType = 5 AND I.id = AE.entityId
		INNER JOIN APP_Application SC ON I.id = SC.instance
WHERE (I.status & 0x00004) = 0 AND (I.status & 0x00010) = 0 AND (I.status & 0x00020) = 0 AND (I.status & 0x0800) = 0
		AND I.name NOT LIKE '+ASM%' AND I.name NOT LIKE '-ASM%' AND I.name <> '-MGMTDB' AND I.name <> 'LISTENER'
AND SC.appTypeId IN (22, 135, 125, 80, 104,
62,37,103, 5, 81, 61, 3)
--
--This additional name check is required as the defaultInstance of DB2 is not marked hidden or dummy
DELETE T FROM #tempDBInstances T
INNER JOIN APP_Application SC ON T.instanceId = SC.instance
WHERE T.name = 'defaultInstanceName' AND SC.appTypeId = 103 -- Exclude default instances of DB2 Multinode
--
INSERT INTO #tempDBInstances
	SELECT DISTINCT I.id, I.name
	FROM #associatedEntities AE
INNER JOIN	APP_InstanceName I ON AE.entityType = 5 AND I.id = AE.entityId
INNER JOIN APP_Application A ON I.id = A.instance AND A.appTypeId = 134
		INNER JOIN APP_InstanceProp IP ON I.id = IP.componentNameId AND IP.attrName = 'Cloud Apps Instance Type' AND IP.modified = 0
	WHERE IP.attrVal IN ('4', '22', '23', '26', '27', '28', '29', '32')
AND (I.status & 0x00004) = 0
AND (I.status & 0x00010) = 0
AND (I.status & 0x00020) = 0
DELETE AE FROM #associatedEntities AE
WHERE AE.entityType=5 AND AE.entityId NOT IN (SELECT instanceId FROM #tempDBInstances)
-- END - DELETE/HIDE HIERARCHICAL ENTITIES IF ENTITIES FROM ALL THE LEVELS PRESENT --------------------------------------------------------------------------
--
--
-- START - GET APPS -----------------------------------------------------------------------------------------------------------------------------------------
-- THERE IS NO DIRECT WAY TO DETERMINE OFFICE365 AND OTHER CLOUD APP SOLUTIONS. BELOW LOGIC IS TAKEN FROM GETOFFICE365PSEUDOCLIENTS.SP (PER MANAS MUTHA/NAGARAJU UPPU)
	/* 1. Determine if it is Office365 solution (Exchange, Sharepoint and One drive together)
	   2. Determine if it is Exchange solution
	   3. Determine if it is CLOUD APPS solution */
	UPDATE AE
		SET AE.clientType = (CASE WHEN I.attrVal='7' THEN @clientType_O365_OneDrive
								WHEN I.attrVal='35' THEN @clientType_O365_Dynamics
								ELSE @clientType_O365_Teams
							END)
	FROM #associatedEntities AE
INNER JOIN APP_Application A ON A.clientId = AE.entityId AND AE.entityType = 3
	--App::CloudAppsInstanceType enum
	INNER JOIN APP_InstanceProp I ON A.instance = I.componentNameId AND  I.attrName = 'Cloud Apps Instance Type' AND I.attrval IN ('7'/*ONEDRIVE*/,'35'/*MS_DYNAMICS_365*/,'36'/*MS_TEAMS*/) AND I.modified = 0
WHERE AE.clientType IS NULL AND (A.subclientStatus & 0x00004 != 0x00004) AND A.appTypeId = 134 AND
(A.subclientStatus & 0x00020 = 0) AND (A.subclientStatus & 0x00008 = 0x00008)
	/*--
	UPDATE AE
		SET AC.clientType = @clientType_Exchange
	FROM #associatedEntities AE
INNER JOIN APP_Application A ON A.clientId = AE.entityId AND AE.entityType = 3 AND A.appTypeId IN (53,137)
	LEFT OUTER JOIN App_Clientprop CP On CP.componentNameId = A.clientId AND CP.attrName='Office 365 Pseudo Client' AND CP.modified=0
	WHERE AC.clientType IS NULL AND CP.attrName IS NULL
	--
	UPDATE AE
		SET v.clientType = (CASE WHEN I.attrVal='1' THEN @clientType_GSuite_APP WHEN I.attrVal='3' THEN @clientType_Salesforce_APP ELSE NULL END) ----App::CloudAppsInstanceType enum
	FROM #associatedEntities AE
INNER JOIN APP_Application A ON A.clientId = AE.entityId AND AE.entityType = 3
	INNER JOIN APP_InstanceProp I ON A.instance = I.componentNameId AND  I.attrName = 'Cloud Apps Instance Type' AND I.modified = 0
	WHERE AC.clientType IS NULL*/
	-- DELETE CLIENTS WHICH ARE NOT CLOUD APP CLIENTS
DELETE FROM #associatedEntities WHERE entityType =3 AND clientType IS NULL
	-- GET NUMBER OF USERS/MAILBOXES
	UPDATE AE
		SET AE.numberOfItems = TCL.itemCount
	FROM #associatedEntities AE
	INNER JOIN
		(SELECT COUNT(E.assocId) AS itemCount, CL.entityId
			FROM #associatedEntities CL
INNER JOIN App_Application A ON A.clientId = CL.entityId AND CL.entityType = 3
			INNER JOIN APP_EmailConfigPolicyAssoc E ON A.backupset = E.backupsetId AND E.modified = 0
			WHERE A.clientId = CL.entityId AND E.mailBoxType = 1  GROUP BY CL.entityId
		) TCL ON TCL.entityId = AE.entityId
	WHERE AE.clientType = @clientType_O365_Exchange
	--
	--Sharepoint	Number of items
	UPDATE AE
		SET AE.numberOfItems = TCL.itemCount
	FROM #associatedEntities AE
	INNER JOIN
		(SELECT COUNT(distinct P.attrName) AS itemCount, CL.entityId
			FROM #associatedEntities CL
INNER JOIN APP_Application A ON A.clientId = CL.entityId AND CL.entityType = 3 AND A.subclientStatus & 0x02 != 0x02 /*UNINSTALLED*/
				AND A.subclientStatus & 0x04 != 0x04 /*DELETED*/ AND A.subclientStatus & 0x00020 != 0x00020 /*HIDDEN*/
			INNER JOIN APP_BackupSetProp P ON P.componentNameId = A.backupSet AND P.attrType = 137 AND P.modified = 0
			GROUP BY CL.entityId
		) TCL ON TCL.entityId = AE.entityId
	WHERE AE.clientType = @clientType_O365_SharePoint
	--
	--OneDrive V1 clients: Number of Items
	UPDATE AE
		SET AE.numberOfItems = TCL.itemCount
	FROM #associatedEntities AE
	INNER JOIN
		(SELECT COUNT(distinct SP.attrName) AS itemCount , CL.entityId
			FROM #associatedEntities CL
INNER JOIN APP_Application A ON A.clientId = CL.entityId AND CL.entityType = 3 AND A.appTypeId = 134  AND A.subclientStatus & 0x02 != 0x02 /*UNINSTALLED*/
				AND A.subclientStatus & 0x04 != 0x04 /*DELETED*/ AND A.subclientStatus & 0x00020 != 0x00020 /*HIDDEN*/
			INNER JOIN APP_SubClientProp (NOLOCK)  SP ON SP.componentNameId = A.id AND SP.modified=0 AND SP.attrType = 134
			GROUP BY CL.entityId
		) TCL ON TCL.entityId = AE.entityId
	WHERE AE.clientType = @clientType_O365_OneDrive
	--
	--OneDrive V2 users are stored in APP_CloudAppUserDetails table: update v2 number of users
	UPDATE AE
		SET AE.numberOfItems = TCL.itemCount
	FROM #associatedEntities AE
	INNER JOIN
		(SELECT COUNT(distinct CD.smtpAddress) AS itemCount , CL.entityId
			FROM #associatedEntities CL
INNER JOIN APP_Application A ON A.clientId = CL.entityId AND CL.entityType = 3 AND A.appTypeId = 134  AND A.subclientStatus & 0x02 != 0x02 /*UNINSTALLED*/
				AND A.subclientStatus & 0x04 != 0x04 /*DELETED*/ AND A.subclientStatus & 0x00020 != 0x00020 /*HIDDEN*/
			JOIN APP_CloudAppUserDetails CD ON A.id = CD.subClientId AND (CD.flags & 1 ) !=0 AND CD.modified = 0
			GROUP BY CL.entityId
	) TCL ON TCL.entityId = AE.entityId
	WHERE AE.clientType = @clientType_O365_OneDrive
-- END   - GET APPS -----------------------------------------------------------------------------------------------------------------------------------------=======
--
--
UPDATE C
SET associatedEntitiesCount=E.entityCount
FROM #companyList C
INNER JOIN
(	SELECT AE.companyId, SUM(numberOfItems) AS entityCount FROM #associatedEntities AE
	GROUP BY AE.companyId
) E ON E.companyId = C.companyId
--
--
INSERT INTO #tempUserTable SELECT UMU.umDSproviderId, UMU.id , UMU.login, UMU.name
						FROM UMUsers UMU  with (nolock)
						INNER JOIN UMUsersProp UUP  with (nolock)
							ON UMU.id=UUP.componentNameId
						INNER JOIN UMUserGroup UUG  with (nolock)
							ON UUG.userId=UUP.componentNameId
						INNER JOIN UMGroups UG
							ON UG.id=UUG.groupId
						INNER JOIN #companyList C
							ON C.companyId=UMU.umDSproviderId
						where UUP.attrName = 'Primary Contact' and UUP.attrVal=N'1' AND UG.groupFlags&0x10000<>0 and C.companyId IS NOT NULL
--
--
SET @o_xmlData =(SELECT
				hostName AS '@connectName',UMDS.flags AS '@flags',  UMDS.enabled AS '@enabled', serviceType AS '@serviceType',UMDS.description AS '@description',UMDS.GUID AS '@providerGUID',
				ISNULL(associatedEntitiesCount,0) AS'@associatedEntitiesCount',
				UMDS.id as 'shortName/@id', domainName as 'shortName/@domainName',
				UMDS.id as 'provider/@providerId',domainName as 'provider/@providerDomainName',
				(SELECT TUT.userDisplayName AS '@fullName' , TUT.userLogin AS 'user/@userName',TUT.userID AS 'user/@userId'
				  FROM #tempUserTable TUT where TUT.providerId=UMDS.id
				  FOR XML PATH ('primaryContacts'),TYPE)
			FROM UMDSProviders UMDS
			JOIN #companyList C ON UMDS.id=C.companyId
WHERE UMDS.id > 0 AND UMDS.flags & 0x0002 = 0 AND UMDS.serviceType = 5
			FOR XML PATH('providers'), ROOT('EVGui_UMDSProviderListResp'))
IF @o_xmlData IS NULL													-- When there is no response we need to populate an empty XML, else caller code throws exception.
	SET @o_xmlData = '<EVGui_UMDSProviderListResp/>'
select @o_xmlData
GO

IF EXISTS (select * from GxQscripts where name = 'AppCompanyGetSummaryList')
	delete from GxQscripts where name = 'AppCompanyGetSummaryList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCompanyGetSummaryList')
	delete from GXDBVersions where aliasname = 'AppCompanyGetSummaryList'
GO

insert into GXDBVersions values(2, 'AppCompanyGetSummaryList',  'v1.1.2.9.4.1', 'AppCompanyGetSummaryList', 'v1.1.2.9.4.1')
GO

