

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCompanyGetAssociatedEntities.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCompanyGetAssociatedEntities.sp,v $ $Id: AppCompanyGetAssociatedEntities.sp,v 1.1.2.10 2020/12/21 16:59:16 njain Exp $";
--	+===========================================================================================+
--	|  			          AppCompanyGetAssociatedEntities										|
--	|																							|
--  |  PARAMETERS			  																	|
--  |    x_xmlData	  = Api_CompanyAssociatedEntitiesReq/Api_CompanyAssociatedEntitiesResp xml	|
--	+===========================================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppCompanyGetAssociatedEntities')
BEGIN
	print '>>> Drop Stored Procedure: AppCompanyGetAssociatedEntities <<<'
	drop procedure AppCompanyGetAssociatedEntities
END
IF EXISTS (select * from GxQscripts where name='AppCompanyGetAssociatedEntities')
	delete from GxQscripts where name = 'AppCompanyGetAssociatedEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCompanyGetAssociatedEntities')
	delete from GXDBVersions where aliasname = 'AppCompanyGetAssociatedEntities'
GO
print '... Creating Procedure: AppCompanyGetAssociatedEntities'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppCompanyGetAssociatedEntities
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @x_xmlData XML OUTPUT 
-----------------------------------------------------------
AS
DECLARE
  @i_userId INT=0,
  @i_localeId INT=0,
  @canSeeProvider INT = 0,
  @i_getDetails INT = 0,
  @o_errCode	INT = 0,
  @o_errString NVARCHAR(MAX)='',
  @i_companyId INT = 0,
  @i_startRowNum INT = 0,
  @i_limit INT = 0,
  @endRowNum INT = 0
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @i_localeId = ISNULL (( SELECT ref.value('@localeId', 'INT')
                        FROM @x_xmlData.nodes ('/Api_CompanyAssociatedEntitiesReq/processinginstructioninfo/locale') R(ref)), 0)
SET @i_userId = ISNULL (( SELECT ref.value('@userId', 'INT')
                        FROM @x_xmlData.nodes ('/Api_CompanyAssociatedEntitiesReq/processinginstructioninfo/user') R(ref)), 0)
SET @i_companyId = ISNULL (( SELECT ref.value('@providerId', 'INT')
						FROM @x_xmlData.nodes ('/Api_CompanyAssociatedEntitiesReq/company') R(ref)), -1)
SET @i_startRowNum = ISNULL (( SELECT ref.value('@offset', 'INT')
						FROM @x_xmlData.nodes ('/Api_CompanyAssociatedEntitiesReq/pageConfig') R(ref)), 0)
SET @i_limit = ISNULL (( SELECT ref.value('@limit', 'INT')
						FROM @x_xmlData.nodes ('/Api_CompanyAssociatedEntitiesReq/pageConfig') R(ref)), 0)
DECLARE @level INT = ISNULL(@x_xmlData.value('(/Api_CompanyAssociatedEntitiesReq/@propertyLevel)[1]', 'int'), 0 /*DO NOT SEND LIST*/)
IF @i_limit > 0
BEGIN
	SET @i_startRowNum = @i_startRowNum + 1 -- This is done as the GUI will send 0 to start from beginning
	SET @endRowNum = @i_startRowNum + @i_limit
END
EXEC sec_canSeeOrManageNameServer  @i_userId, @i_companyId, 1, 0, 0, @canSeeProvider OUTPUT
IF @canSeeProvider = 0
BEGIN
SET @o_errCode = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errString =  (SELECT message FROM EvLocaleMsgs WHERE messageId = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @i_localeId)
	GOTO SCRIPT_EXIT
END
IF(@level > 0)
BEGIN
	SET @i_getDetails=1
END
SET @i_companyId = ISNULL (( SELECT ref.value('@providerId', 'INT')
                        FROM @x_xmlData.nodes ('/Api_CompanyAssociatedEntitiesReq/company ') R(ref)),0)
--
-- GET ENTITYTYPES WHICH NEEDS TO BE RETURNED ---------------------------------------------------------------------------------------------------------------
IF OBJECT_ID('tempdb.dbo.#entityType_InputTable') IS NOT NULL
        DROP TABLE #entityType_InputTable
CREATE TABLE #entityType_InputTable
(
	entityType INT	PRIMARY KEY
)
-- IGNORING THE ENTITIES WHICH WILL HAVE LINKS IN THE GUI AS WE WILL GET THE COUNTS FOR THESE FROM THE MONGO CACHE
INSERT #entityType_InputTable(entityType)
SELECT DISTINCT ref.value('(.)[1]', 'INT')FROM  @x_xmlData.nodes('/Api_CompanyAssociatedEntitiesReq/entityTypes/@val') doc(ref)
IF(@@ROWCOUNT = 0)
BEGIN
	INSERT INTO #entityType_InputTable
SELECT entityType FROM App_Entity WHERE entityType NOT IN (18,68,120,174,9501,
9503,35,65,9,13,15,3,7,
6,127)
	-- Ignoring USER_ENTITY and USERGROUP_ENTITY as that gets counted separately
END
-- GET ENTITYTYPES WHICH NEEDS TO BE RETURNED ---------------------------------------------------------------------------------------------------------------
--
--
-- GET ASSOCIATED ENTITIES ----------------------------------------------------------------------------------------------------------------------------------
CREATE TABLE #associatedEntities
(
	rowNum INT,
	entityType INT,
	entityId INT,
	entityName nvarchar(255),
	clientType INT,
	entityType1 int, entityId1 int, entityId1Name nvarchar(255),
	entityType2 int, entityId2 int, entityId2Name nvarchar(255),
	entityType3 int, entityId3 int, entityId3Name nvarchar(255),
	entityType4 int, entityId4 int, entityId4Name nvarchar(255),
	entityType5 int, entityId5 int, entityId5Name nvarchar(255),
	includeAll int, genericEntityAssociated xml, numberOfItems INT
)
CREATE CLUSTERED INDEX idx_associatedEntities_entityType_entityId ON #associatedEntities(entityType, entityId)
--
INSERT INTO #associatedEntities (rowNum, entityType, entityId, entityName, entityType1, entityId1, includeAll, numberOfItems)
SELECT
	ROW_NUMBER() OVER (ORDER BY CE.created desc), CE.entityType, CE.entityId, CE.entityName, CE.entityType, CE.entityId, 0, 1/*count for each entity*/
	FROM App_CompanyEntities CE
	INNER JOIN #entityType_InputTable ET ON ET.entityType = CE.entityType
	WHERE CE.companyId=@i_companyId
-- Note: rowNum logic is broken and will fix it in SP22
-- GET ASSOCIATED ENTITIES ----------------------------------------------------------------------------------------------------------------------------------
--
--
-- GET ALL O365 CLIENTS -------------------------------------------------------------------------------------------------------------------------------------
DECLARE @clientType_SERVER INT = 1,
		@clientType_DEVICE INT = 2,
		@clientType_HYPERVISIOR INT = 3,
		@clientType_VM INT = 4,
		@clientType_O365_Exchange INT = 5,
		@clientType_Exchange INT = 6,
		@clientType_Archiver INT = 7,
		@clientType_GSuite_APP INT = 8,
		@clientType_Salesforce_APP INT = 9,
		@clientType_O365_SharePoint INT = 10,
		@clientType_O365_OneDrive INT = 11,
		@clientType_O365_Dynamics INT = 12,
		@clientType_O365_Teams INT = 13
INSERT INTO #associatedEntities (entityId, entityType, clientType, numberOfItems)
SELECT DISTINCT A.clientId, 3, @clientType_O365_Exchange, 0
    FROM App_CompanyEntities CE
INNER JOIN APP_Application A ON A.clientId = CE.entityId AND (A.subclientStatus & 0x00004 != 0x00004)
    INNER JOIN App_Clientprop CP On CP.componentNameId = A.clientId AND CP.attrName='Office 365 Pseudo Client' AND CP.attrVal='1' AND CP.modified=0
	INNER JOIN APP_IDAName IA ON A.clientId = IA.clientId
	INNER JOIN APP_IDAProp AP ON AP.componentNameId = IA.id AND A.appTypeId = IA.appTypeId AND AP.attrName = 'Exchange Environment Type' and AP.attrval = '4' AND AP.modified=0
WHERE CE.companyId=@i_companyId AND CE.entityType = 3 AND A.appTypeId IN (137/*Exchange V1 and V2*/)
--
INSERT INTO #associatedEntities (entityId, entityType, clientType, numberOfItems)
SELECT DISTINCT A.clientId, 3, @clientType_O365_OneDrive, 0
    FROM App_CompanyEntities CE
INNER JOIN APP_Application A ON A.clientId = CE.entityId AND (A.subclientStatus & 0x00004 != 0x00004)
	INNER JOIN APP_InstanceProp IP ON IP.componentNameId = A.instance AND IP.attrName = 'Cloud Apps Instance Type' AND IP.modified = 0 AND Ip.attrVal = '7'/*One drive*/
	LEFT JOIN #associatedEntities T ON T.entityType=CE.entityType AND T.entityId = CE.entityId
WHERE CE.companyId=@i_companyId AND CE.entityType = 3 AND A.appTypeId IN (134) AND T.entityId IS NULL /*client not present already*/
--
INSERT INTO #associatedEntities (entityId, entityType, clientType, numberOfItems)
SELECT DISTINCT A.clientId, 3, @clientType_O365_SharePoint, 0
    FROM App_CompanyEntities CE
INNER JOIN APP_Application A ON A.clientId = CE.entityId AND (A.subclientStatus & 0x00004 != 0x00004) AND (A.subclientStatus & 0x00008 = 0x00008)
INNER JOIN APP_BackupSetName BK ON A.backupSet = BK.id AND (BK.status & 0x80000 = 0x80000)
	LEFT JOIN #associatedEntities T ON T.entityType=CE.entityType AND T.entityId = CE.entityId
WHERE CE.companyId=@i_companyId AND CE.entityType = 3 AND A.appTypeId IN (78/*sharepoint*/)  AND T.entityId IS NULL /*client not present already*/
-- GET ALL O365 CLIENTS -------------------------------------------------------------------------------------------------------------------------------------
--
--
-- START - DELETE/HIDE HIERARCHICAL ENTITIES IF ENTITIES FROM ALL THE LEVELS PRESENT ------------------------------------------------------------------------
	-- If subclient/backupset/instance and client are associated to the same company then return only client
DELETE AE
FROM #associatedEntities AE
INNER JOIN App_Application APP ON APP.id = AE.entityId AND AE.entityType=7
LEFT JOIN #associatedEntities CL ON CL.entityType=3 AND CL.entityId = APP.clientId
WHERE CL.entityId IS NOT NULL
--
DELETE AE
FROM #associatedEntities AE
INNER JOIN App_Application APP ON APP.backupSet = AE.entityId AND AE.entityType=6
LEFT JOIN #associatedEntities CL ON CL.entityType=3 AND CL.entityId = APP.clientId
WHERE CL.entityId IS NOT NULL
--
DELETE AE
FROM #associatedEntities AE
INNER JOIN App_Application APP ON APP.instance = AE.entityId AND AE.entityType=5
LEFT JOIN #associatedEntities CL ON CL.entityType=3 AND CL.entityId = APP.clientId
WHERE CL.entityId IS NOT NULL
--
-- DELETE PLAN SUB ENTITIES
DELETE AE
FROM #associatedEntities AE
INNER JOIN App_PlanProp PP ON PP.modified=0 AND PP.attrName='Storage policy' AND PP.attrVal = CAST(AE.entityId AS VARCHAR(24))
LEFT JOIN #associatedEntities AP ON AP.entityType=158 AND AP.entityId = PP.componentNameId
WHERE AE.entityType = 17 AND AP.entityId IS NOT NULL
--
-- DELETE INFRA AND DELETED VM clients
--Logic taken from AppGetclientlistAndPropsForAdminConsole.sp
DECLARE @appType35Table TABLE (
		appTypeId		INT PRIMARY KEY
	)
INSERT INTO @appType35Table
	SELECT DISTINCT appTypeId
	FROM GetAppTypesForAppGroup(35,0)
DELETE AE
FROM #associatedEntities AE
INNER JOIN CT_ClientProperties CP ON AE.entityType = 3 AND CP.clientId = AE.entityId
INNER JOIN APP_Client C ON C.id = AE.entityId AND Ae.entityType = 3 AND C.status & 0x1000 <> 0x1000
INNER JOIN APP_IDAName ida	ON ida.clientId = AE.entityId
INNER JOIN @appType35Table FS ON FS.appTypeId = ida.appTypeId
LEFT OUTER JOIN (
	SELECT CId FROM LicUsage L
INNER JOIN #associatedEntities AE ON AE.entityType = 3 AND AE.entityId = L.CId
	INNER JOIN APP_IDAName I on l.CId=I.clientId and L.AppType=I.appTypeId
	INNER JOIN @appType35Table fs ON fs.appTypeId=I.appTypeId
	WHERE  L.optype = 'Install'
	UNION
	SELECT clientId FROM APP_Application AP
INNER JOIN #associatedEntities AE ON AE.entityType = 3 AND AE.entityId = AP.clientId
	INNER JOIN @appType35Table fs ON fs.appTypeId=AP.appTypeId
	INNER JOIN APP_SubClientProp ASCP
	ON ASCP.componentNameId=AP.id AND ASCP.attrName=N'Last Data Protected Time' AND ASCP.modified=0 AND ASCP.cs_attrName = CHECKSUM(N'Last Data Protected Time')
) CP1 ON Cp1.CId = AE.entityId
WHERE CP.IsInfrastructureMachine=1 AND CP1.CId IS NULL
--
--Logic taken from AppGetVMStatusInfoForUser.sp
DELETE AE
FROM #associatedEntities AE
INNER JOIN APP_ClientProp ACPVM ON AE.entityType = 3 AND ACPVM.componentNameId = AE.entityId AND ACPVM.attrName='Virtual Server Discovered Clients'
	AND ACPVM.attrval='1' AND ACPVM.modified=0
LEFT OUTER JOIN APP_ClientProp ACPJOB ON ACPJOB.componentNameId=AE.entityId AND ACPJOB.attrName='Last Backup JobID' AND ACPJOB.modified=0
LEFT OUTER JOIN APP_VMProp VMP ON VMP.VMclientId=AE.entityId AND CAST(VMP.jobId AS NVARCHAR(128))=ACPJOB.attrVal AND VMP.attrName='vmStatus'
LEFT OUTER JOIN APP_ClientProp ACP ON AE.entityId = ACP.componentnameId AND ACP.attrName='Virtual Machine Deletion Time' AND ACP.modified=0 AND ACP.attrVal<>'0'
WHERE (VMP.attrVal NOT IN ('0'/*PROTECTED*/,'3'/*BACKED_UP_WITH_ERROR */) OR VMP.attrVal IS NULL) AND ACP.attrVal IS NOT NULL
--
--
--Logic taken from AppGetDBInstanceList.sp
CREATE TABLE #tempDBInstances (instanceId INT PRIMARY KEY, name NVARCHAR(1024))
INSERT INTO #tempDBInstances
	SELECT DISTINCT I.id, I.name
	FROM #associatedEntities AE
INNER JOIN APP_InstanceName I ON AE.entityType = 5 AND I.id = AE.entityId
		INNER JOIN APP_Application SC ON I.id = SC.instance
WHERE (I.status & 0x00004) = 0 AND (I.status & 0x00010) = 0 AND (I.status & 0x00020) = 0 AND (I.status & 0x0800) = 0
		AND I.name NOT LIKE '+ASM%' AND I.name NOT LIKE '-ASM%' AND I.name <> '-MGMTDB' AND I.name <> 'LISTENER'
AND SC.appTypeId IN (22, 135, 125, 80, 104,
62,37,103, 5, 81, 61, 3)
--
--This additional name check is required as the defaultInstance of DB2 is not marked hidden or dummy
DELETE T FROM #tempDBInstances T
INNER JOIN APP_Application SC ON T.instanceId = SC.instance
WHERE T.name = 'defaultInstanceName' AND SC.appTypeId = 103 -- Exclude default instances of DB2 Multinode
--
INSERT INTO #tempDBInstances
	SELECT DISTINCT I.id, I.name
	FROM #associatedEntities AE
INNER JOIN	APP_InstanceName I ON AE.entityType = 5 AND I.id = AE.entityId
INNER JOIN APP_Application A ON I.id = A.instance AND A.appTypeId = 134
		INNER JOIN APP_InstanceProp IP ON I.id = IP.componentNameId AND IP.attrName = 'Cloud Apps Instance Type' AND IP.modified = 0
	WHERE IP.attrVal IN ('4', '22', '23', '26', '27', '28', '29', '32')
AND (I.status & 0x00004) = 0
AND (I.status & 0x00010) = 0
AND (I.status & 0x00020) = 0
DELETE AE FROM #associatedEntities AE
WHERE AE.entityType=5 AND AE.entityId NOT IN (SELECT instanceId FROM #tempDBInstances)
-- END - DELETE/HIDE HIERARCHICAL ENTITIES IF ENTITIES FROM ALL THE LEVELS PRESENT --------------------------------------------------------------------------
--
--
-- START - GET APPS -----------------------------------------------------------------------------------------------------------------------------------------
-- THERE IS NO DIRECT WAY TO DETERMINE OFFICE365 AND OTHER CLOUD APP SOLUTIONS. BELOW LOGIC IS TAKEN FROM GETOFFICE365PSEUDOCLIENTS.SP (PER MANAS MUTHA/NAGARAJU UPPU)
	/* 1. Determine if it is Office365 solution (Exchange, Sharepoint and One drive together)
	   2. Determine if it is Exchange solution
	   3. Determine if it is CLOUD APPS solution */
	UPDATE AE
		SET AE.clientType = (CASE WHEN I.attrVal='7' THEN @clientType_O365_OneDrive
								WHEN I.attrVal='35' THEN @clientType_O365_Dynamics
								ELSE @clientType_O365_Teams
							END)
	FROM #associatedEntities AE
INNER JOIN APP_Application A ON A.clientId = AE.entityId AND AE.entityType = 3
	--App::CloudAppsInstanceType enum
	INNER JOIN APP_InstanceProp I ON A.instance = I.componentNameId AND  I.attrName = 'Cloud Apps Instance Type' AND I.attrval IN ('7'/*ONEDRIVE*/,'35'/*MS_DYNAMICS_365*/,'36'/*MS_TEAMS*/) AND I.modified = 0
WHERE AE.clientType IS NULL AND (A.subclientStatus & 0x00004 != 0x00004) AND A.appTypeId = 134 AND
(A.subclientStatus & 0x00020 = 0) AND (A.subclientStatus & 0x00008 = 0x00008)
	/*--
	UPDATE AE
		SET AC.clientType = @clientType_Exchange
	FROM #associatedEntities AE
INNER JOIN APP_Application A ON A.clientId = AE.entityId AND AE.entityType = 3 AND A.appTypeId IN (53,137)
	LEFT OUTER JOIN App_Clientprop CP On CP.componentNameId = A.clientId AND CP.attrName='Office 365 Pseudo Client' AND CP.modified=0
	WHERE AC.clientType IS NULL AND CP.attrName IS NULL
	--
	UPDATE AE
		SET v.clientType = (CASE WHEN I.attrVal='1' THEN @clientType_GSuite_APP WHEN I.attrVal='3' THEN @clientType_Salesforce_APP ELSE NULL END) ----App::CloudAppsInstanceType enum
	FROM #associatedEntities AE
INNER JOIN APP_Application A ON A.clientId = AE.entityId AND AE.entityType = 3
	INNER JOIN APP_InstanceProp I ON A.instance = I.componentNameId AND  I.attrName = 'Cloud Apps Instance Type' AND I.modified = 0
	WHERE AC.clientType IS NULL*/
	-- DELETE CLIENTS WHICH ARE NOT CLOUD APP CLIENTS
DELETE FROM #associatedEntities WHERE entityType =3 AND clientType IS NULL
	-- GET NUMBER OF USERS/MAILBOXES
	UPDATE AE
		SET AE.numberOfItems = TCL.itemCount
	FROM #associatedEntities AE
	INNER JOIN
		(SELECT COUNT(E.assocId) AS itemCount, CL.entityId
			FROM #associatedEntities CL
INNER JOIN App_Application A ON A.clientId = CL.entityId AND CL.entityType = 3
			INNER JOIN APP_EmailConfigPolicyAssoc E ON A.backupset = E.backupsetId AND E.modified = 0
			WHERE A.clientId = CL.entityId AND E.mailBoxType = 1  GROUP BY CL.entityId
		) TCL ON TCL.entityId = AE.entityId
	WHERE AE.clientType = @clientType_O365_Exchange
	--
	--Sharepoint	Number of items
	UPDATE AE
		SET AE.numberOfItems = TCL.itemCount
	FROM #associatedEntities AE
	INNER JOIN
		(SELECT COUNT(distinct P.attrName) AS itemCount, CL.entityId
			FROM #associatedEntities CL
INNER JOIN APP_Application A ON A.clientId = CL.entityId AND CL.entityType = 3 AND A.subclientStatus & 0x02 != 0x02 /*UNINSTALLED*/
				AND A.subclientStatus & 0x04 != 0x04 /*DELETED*/ AND A.subclientStatus & 0x00020 != 0x00020 /*HIDDEN*/
			INNER JOIN APP_BackupSetProp P ON P.componentNameId = A.backupSet AND P.attrType = 137 AND P.modified = 0
			GROUP BY CL.entityId
		) TCL ON TCL.entityId = AE.entityId
	WHERE AE.clientType = @clientType_O365_SharePoint
	--
	--OneDrive V1 clients: Number of Items
	UPDATE AE
		SET AE.numberOfItems = TCL.itemCount
	FROM #associatedEntities AE
	INNER JOIN
		(SELECT COUNT(distinct SP.attrName) AS itemCount , CL.entityId
			FROM #associatedEntities CL
INNER JOIN APP_Application A ON A.clientId = CL.entityId AND CL.entityType = 3 AND A.appTypeId = 134  AND A.subclientStatus & 0x02 != 0x02 /*UNINSTALLED*/
				AND A.subclientStatus & 0x04 != 0x04 /*DELETED*/ AND A.subclientStatus & 0x00020 != 0x00020 /*HIDDEN*/
			INNER JOIN APP_SubClientProp (NOLOCK)  SP ON SP.componentNameId = A.id AND SP.modified=0 AND SP.attrType = 134
			GROUP BY CL.entityId
		) TCL ON TCL.entityId = AE.entityId
	WHERE AE.clientType = @clientType_O365_OneDrive
	--
	--OneDrive V2 users are stored in APP_CloudAppUserDetails table: update v2 number of users
	UPDATE AE
		SET AE.numberOfItems = TCL.itemCount
	FROM #associatedEntities AE
	INNER JOIN
		(SELECT COUNT(distinct CD.smtpAddress) AS itemCount , CL.entityId
			FROM #associatedEntities CL
INNER JOIN APP_Application A ON A.clientId = CL.entityId AND CL.entityType = 3 AND A.appTypeId = 134  AND A.subclientStatus & 0x02 != 0x02 /*UNINSTALLED*/
				AND A.subclientStatus & 0x04 != 0x04 /*DELETED*/ AND A.subclientStatus & 0x00020 != 0x00020 /*HIDDEN*/
			JOIN APP_CloudAppUserDetails CD ON A.id = CD.subClientId AND (CD.flags & 1 ) !=0 AND CD.modified = 0
			GROUP BY CL.entityId
	) TCL ON TCL.entityId = AE.entityId
	WHERE AE.clientType = @clientType_O365_OneDrive
-- END   - GET APPS -----------------------------------------------------------------------------------------------------------------------------------------=======
--
--
/*
-- START - GET FILESERVERS/VM/LAPTOPS/HYPERVISORS/CLOUDAPPS -------------------------------------------------------------------------------------------------
-- Update Laptop Device Type
	-- Logic is taken from APPGetDevices
UPDATE AE SET AE.clientType=(CASE WHEN C.STATUS & 0x1000 = 0x1000 THEN @clientType_DEVICE ELSE @clientType_SERVER END)
FROM #associatedEntities AE
INNER JOIN APP_Client C ON C.id = AE.entityId AND Ae.entityType = 3
INNER JOIN APP_IDAName ida	ON ida.clientId = C.id --AND ida.appTypeId <> 13/*NDMP*/
	AND ida.appTypeId IN (
							SELECT appTypeId
							FROM dbo.GetAppTypesForAppGroup(35,0)
						 )	-- This Criteria is added from AppGetDevices SP.
-- Update HYPERVISIOR Device Type
	-- Logic is taken from AppgetVSPPseudoClients
UPDATE AE SET AE.clientType=@clientType_HYPERVISIOR
FROM #associatedEntities AE
INNER JOIN APP_IDAName IDA      ON AE.entityType = 3 AND AE.entityId = IDA.clientId
    INNER JOIN APP_Application APP  ON (APP.clientId = AE.entityId AND App.appTypeId = IDA.appTypeId)
    INNER JOIN APP_InstanceProp IP  ON (IP.componentNameId = APP.instance AND IP.attrName = 'Virtual Server Instance Type')
	INNER JOIN APP_InstanceName AIN ON (AIN.id = APP.instance)
	INNER JOIN APP_Client AC  ON (AC.id = AE.entityId)
WHERE   (IDA.appTypeId = 106 /*Vitual Server*/)
	/*AND((AC.status  & 0x00004) = 0) AND AND((AC.status  & 0x00002) = 0)
	AND((AIN.status & 0x00002)   = 0) -- instance should not be deconfigured or uninstalled
	AND((AIN.status & 0x00004)		= 0)
	AND((IDA.status & 0x00002)   = 0) -- ida should not be deconfigured or uninstalled
	AND((IDA.status & 0x00004)		= 0)*/
	AND AE.clientType IS NULL
-- Update VM Device Type
UPDATE AE
	SET AE.clientType = @clientType_VM
FROM #associatedEntities AE
INNER JOIN APP_ClientProp CP WITH(NOLOCK) ON AE.entityType = 3 AND AE.entityId = CP.componentNameId AND CP.attrName = 'Virtual Server Discovered Clients'
	AND CP.modified=0 AND CP.attrVal='1'
WHERE AE.clientType IS NULL
-- UPDATE Archiver FS
UPDATE AE
	SET AE.clientType = @clientType_Archiver
FROM #associatedEntities AE
INNER JOIN
(
	SELECT DISTINCT A.clientId FROM App_Application A
	 -- archive set
    LEFT OUTER JOIN app_backupsetProp BP
        ON A.backupset = BP.componentNameId AND BP.attrName = 'Is archiving enabled' AND BP.attrVal = '1' AND BP.modified = 0
    -- One-pass subclient (object / job oriented)
    LEFT OUTER JOIN app_subclientProp SP
        ON A.id = SP.componentNameId AND SP.attrName = N'Turbo Mode Enable Stubbing' AND SP.cs_attrName = checksum(N'Turbo Mode Enable Stubbing')
			AND SP.attrVal = '1' AND SP.modified = 0
	WHERE (BP.componentNameId is not null) or (SP.componentNameId is not null)
) CP ON CP.clientId = AE.entityId
WHERE AE.clientType IS NULL AND AE.entityType = 3
--
-- THERE IS NO DIRECT WAY TO DETERMINE OFFICE365 AND OTHER CLOUD APP SOLUTIONS. BELOW LOGIC IS TAKEN FROM GETOFFICE365PSEUDOCLIENTS.SP (PER MANAS MUTHA/NAGARAJU UPPU)
	/* 1. Determine if it is Office365 solution (Exchange, Sharepoint and One drive together)
	   2. Determine if it is Exchange solution
	   3. Determine if it is CLOUD APPS solution */
	UPDATE AE
		SET AE.clientType = @clientType_O365
	FROM #associatedEntities AE
WHERE AE.entityType = 3 AND AE.clientType IS NULL AND AE.entityId IN
	(
		SELECT A.clientId
		FROM APP_Application A
		INNER JOIN App_Clientprop CP On CP.componentNameId = A.clientId AND CP.attrName='Office 365 Pseudo Client' AND CP.attrVal='1' AND CP.modified=0
WHERE A.appTypeId IN (137, 78, 134)
		UNION
		SELECT A.clientId
			FROM APP_Application A
			INNER JOIN APP_IDAName IA ON A.clientId = IA.clientId
			INNER JOIN APP_IDAProp AP ON AP.componentNameId = IA.id  AND A.appTypeId = IA.appTypeId
WHERE (A.subclientStatus & 0x00004 != 0x00004)
AND A.appTypeId = 137 AND AP.attrName = 'Exchange Environment Type' and AP.attrval = '4'
		UNION
		SELECT A.clientId
			FROM APP_Application A
			INNER JOIN APP_BackupSetName BK ON A.backupSet = BK.id
WHERE (A.subclientStatus & 0x00004 != 0x00004) AND A.appTypeId = 78
AND (BK.status & 0x80000 = 0x80000) AND (A.subclientStatus & 0x00008 = 0x00008)
		UNION
		SELECT A.clientId
			FROM APP_Application A
			--App::CloudAppsInstanceType enum
			INNER JOIN APP_InstanceProp I ON A.instance = I.componentNameId AND  I.attrName = 'Cloud Apps Instance Type' AND I.attrval IN ('7'/*ONEDRIVE*/,'35'/*MS_DYNAMICS_365*/,'36'/*MS_TEAMS*/) AND I.modified = 0
WHERE (A.subclientStatus & 0x00004 != 0x00004) AND A.appTypeId = 134 AND
(A.subclientStatus & 0x00020 = 0) AND (A.subclientStatus & 0x00008 = 0x00008)
	)
	--
	UPDATE AE
		SET AE.clientType = @clientType_Exchange
	FROM #associatedEntities AE
INNER JOIN APP_Application A ON A.clientId = AE.entityId AND AE.entityType = 3 AND A.appTypeId IN (53,137)
	LEFT OUTER JOIN App_Clientprop CP On CP.componentNameId = A.clientId AND CP.attrName='Office 365 Pseudo Client' AND CP.modified=0
	WHERE AE.clientType IS NULL AND CP.attrName IS NULL
	--
	UPDATE AE
		SET AE.clientType = (CASE WHEN I.attrVal='1' THEN @clientType_GSuite_APP WHEN I.attrVal='3' THEN @clientType_Salesforce_APP ELSE NULL END) ----App::CloudAppsInstanceType enum
	FROM #associatedEntities AE
INNER JOIN APP_Application A ON A.clientId = AE.entityId AND AE.entityType = 3
	INNER JOIN APP_InstanceProp I ON A.instance = I.componentNameId AND  I.attrName = 'Cloud Apps Instance Type' AND I.modified = 0
	WHERE AE.clientType IS NULL
-- END - GET FILESERVERS/VM/LAPTOPS/HYPERVISORS   -----------------------------------------------------------------------------------------------------------
*/
--
--
-- START - DETERMINE TYPE OF STORAGE ------------------------------------------------------------------------------------------------------------------------
	--BELOW LOGIC TAKEN FROM MMGetStoragePools.sp AND https:--cvs.commvault.com/source/xref/11.0-win/vaultcx/Source/CommServer/EvMediaMgr/evmmguiserverlibinfo.cpp#9253
DECLARE @storageEntities TABLE (storagePoolId INT, storageType INT)
DECLARE @storageType_Tape		INT = 4,
		@storageType_HyperScale	INT = 3,
		@storageType_Cloud		INT = 2,
		@storageType_Disk		INT = 1
IF EXISTS (SELECT 1 FROM #associatedEntities WHERE entityType = 17 OR entityType =160)
BEGIN
	INSERT INTO @storageEntities (storagePoolId, storageType)
		SELECT DISTINCT AE.entityId,
		(CASE
WHEN AG.flags&33554432 = 33554432 THEN @storageType_HyperScale
WHEN LIB.LibraryTypeId=3 THEN (CASE WHEN MP.MountPathTypeId = 7/*MOUNT_PATH_EXTERNAL_REMOTE_HOST*/ THEN @storageType_Cloud ELSE @storageType_Disk END)
			ELSE @storageType_Tape
		END)
		FROM #associatedEntities AE
		INNER JOIN archgroup AG ON AG.id = entityId AND (entityType = 17 OR entityType =160)
AND ((AG.flags&33554432=33554432 OR AG.flags&256=256
OR AG.flags&16384=16384 OR AG.flags&8388608=8388608))
		INNER JOIN ArchGroupCopy AGC ON AG.id = AGC.archGroupId
		INNER JOIN MMDataPath DPath ON AGC.id = DPath.CopyId
		INNER JOIN MMDrivePool DPool ON DPath.DrivePoolId = DPool.DrivePoolId
		INNER JOIN MMMasterPool MPool ON DPool.MasterPoolId = MPool.MasterPoolId
		INNER JOIN MMLibrary LIB ON MPool.LibraryId = LIB.LibraryId
		LEFT OUTER JOIN MMMountPath MP WITH (READUNCOMMITTED) ON MP.LibraryId = LIB.LibraryId
END
-- END   - DETERMINE TYPE OF STORAGE ------------------------------------------------------------------------------------------------------------------------
--
--
DECLARE @assocEntityCountXml XML
SET @assocEntityCountXml = (SELECT
							SUM(numberOfItems) AS '@totalCount',
							(SELECT
								SUM(numberOfItems) as '@count',
								(CASE
WHEN AE.entityType =3 AND AE.clientType = @clientType_SERVER THEN 1
WHEN AE.entityType =3 AND AE.clientType = @clientType_DEVICE THEN 2
WHEN AE.entityType =3 AND AE.clientType = @clientType_HYPERVISIOR THEN 3
WHEN AE.entityType =3 AND AE.clientType = @clientType_VM THEN 4
WHEN AE.entityType =3 AND AE.clientType = @clientType_Archiver THEN 7
WHEN AE.entityType =3 AND AE.clientType = @clientType_Exchange THEN 46
WHEN AE.entityType =3 AND AE.clientType = @clientType_O365_Exchange THEN 47
WHEN AE.entityType =3 AND AE.clientType = @clientType_GSuite_APP THEN 48
WHEN AE.entityType =3 AND AE.clientType = @clientType_Salesforce_APP THEN 50
WHEN AE.entityType =3 AND AE.clientType = @clientType_O365_OneDrive THEN 51
WHEN AE.entityType =3 AND AE.clientType = @clientType_O365_SharePoint THEN 52
WHEN AE.entityType =5					THEN 27	--INSTANCE_ENTITY
WHEN AE.entityType =153					THEN 18	--ARRAY_ENTITY
WHEN AE.entityType =11				THEN 19	--MEDIAAGENT_ENTITY
									-- StoragePool and StoragePolicy is stored usin STORAGE_POLICY_ENTITY
WHEN (AE.entityType =17 OR AE.entityType =160) AND SE.storageType IS NOT NULL THEN
										(CASE
											WHEN SE.storageType = @storageType_Disk			THEN 20
											WHEN SE.storageType = @storageType_Cloud		THEN 24
											WHEN SE.storageType = @storageType_HyperScale	THEN 25
											ELSE 26 /*@storageType_Tape*/
										END)
WHEN AE.entityType =28				THEN 32	--CLIENT_GROUP_ENTITY
WHEN AE.entityType =158						THEN 33	--PLAN_ENTITY
--WHEN AE.entityType =102					THEN 34	--REGION_ENTITY
WHEN AE.entityType =64					THEN 35	--ALERT_ENTITY
WHEN AE.entityType =178	THEN 36 --KEY_MANAGEMENT_SERVER_ENTITY
WHEN AE.entityType =131				THEN 37	--REPORT_PLUS_ENTITY
WHEN AE.entityType =120						THEN 39	--ROLE_ENTITY
									ELSE 0													--UNKNOWN
								END) as '@name'
							FROM #associatedEntities AE
LEFT OUTER JOIN @storageEntities SE ON SE.storagePoolId = AE.entityId AND (AE.entityType = 17 OR AE.entitytype = 160)
							GROUP BY AE.entityType, AE.clientType, SE.storageType
							FOR XML PATH('entities'), type)
						FROM #associatedEntities
						FOR XML PATH('Api_CompanyEntitiesCount'), TYPE)
--
--
-- START - GET DETAILS OF THE ASSOCIATED ENTITIES -----------------------------------------------------------------------------------------------------------
IF @i_getDetails = 1
BEGIN
	-- PAGING
	IF @i_startRowNum > 0 AND @endRowNum > 0
	BEGIN
		DELETE #associatedEntities
		WHERE rowNum < @i_startRowNum OR rowNum >= @endRowNum
	END
	-- FOR SUBCLIENTS NEED TO FILL ALL THE DETAILS SO THAT WE SEND THE FULL HIERARCHY IN THE RESPONSE.
		-- THIS IS REQUIRED BY THE ENTITYIDTONAMECONVERTERDYNAMIC PROC
	UPDATE AE
	SET AE.entityId1 = APP.clientId, AE.entityId2 = APP.appTypeId, AE.entityId3 = APP.instance, AE.entityId4 = APP.backupset, AE.entityId5 = APP.id
	FROM #associatedEntities AE
INNER JOIN App_application APP ON APP.id = AE.entityId AND AE.entityType = 7
	--
	EXEC EntityIdToNameConverterDynamic '#associatedEntities', 'entities'
	SET @x_xmlData = (SELECT AE.genericEntityAssociated.query('.') FROM #associatedEntities AE WHERE @i_getDetails = 1 FOR XML PATH(''), TYPE)
END
-- END - GET DETAILS OF THE ASSOCIATED ENTITIES -------------------------------------------------------------------------------------------------------------
--
--
SCRIPT_EXIT:
	IF @i_getDetails = 1
	BEGIN
		DECLARE @xmlErrors XML
		IF(@o_errCode > 0)
		BEGIN
			SET @xmlerrors = (SELECT @o_errString as '@errorMessage', @o_errCode as '@errorCode' FOR XML PATH('error'),TYPE)
		END
		SET @x_xmlData = (SELECT @assocEntityCountXml.query(('element entitiesCount {Api_CompanyEntitiesCount/@*, /Api_CompanyEntitiesCount/*}')),
							@x_xmlData, @xmlErrors FOR XML PATH('') , ROOT('Api_CompanyAssociatedEntitiesResp'))
	END
	ELSE
	BEGIN
		SET @x_xmlData = (SELECT @assocEntityCountXml FOR XML PATH('') , TYPE)
	END
	select @x_xmlData
GO

IF EXISTS (select * from GxQscripts where name = 'AppCompanyGetAssociatedEntities')
	delete from GxQscripts where name = 'AppCompanyGetAssociatedEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCompanyGetAssociatedEntities')
	delete from GXDBVersions where aliasname = 'AppCompanyGetAssociatedEntities'
GO

insert into GXDBVersions values(2, 'AppCompanyGetAssociatedEntities',  '00010001000200100000', 'AppCompanyGetAssociatedEntities', '00010001000200100000')
GO

