

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCloudAppsCascadeSPO365PlanXml.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2020  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  				AppCloudAppsCascadeSPO365PlanXml			|
--	| Procedure for cascade propagating SharePoint O365 plan set for record in App_CloudAppUserDetails table
--  | To cascade for subsite or for category call:
--  |    exec [dbo].[AppCloudAppsCascadeSPO365PlanXml] '<App_CloudAppsCascadeSPO365PlanRequest userAssocId="@userAssocId" newPlanId="@newPlanId" reconcileMode="0"/>'
--  | Also, perform reconciliation of plans and updates plan for subsites matching enabled categories.
--  | To reconcile call:
--  |   |    exec [dbo].[AppCloudAppsCascadeSPO365PlanXml] '<App_CloudAppsCascadeSPO365PlanRequest reconcileMode="1" subClientId="@subClientId"/>'
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppCloudAppsCascadeSPO365PlanXml')
BEGIN
	print '>>> Drop Stored Procedure: AppCloudAppsCascadeSPO365PlanXml <<<'
	drop procedure AppCloudAppsCascadeSPO365PlanXml
END
IF EXISTS (select * from GxQscripts where name='AppCloudAppsCascadeSPO365PlanXml')
	delete from GxQscripts where name = 'AppCloudAppsCascadeSPO365PlanXml'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCloudAppsCascadeSPO365PlanXml')
	delete from GXDBVersions where aliasname = 'AppCloudAppsCascadeSPO365PlanXml'
GO
print '... Creating Procedure: AppCloudAppsCascadeSPO365PlanXml'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCloudAppsCascadeSPO365PlanXml
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @inputxml XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
DECLARE @userAssocId int=NULL;
DECLARE @newPlanId int=NULL;
DECLARE @reconcileMode int=NULL;
DECLARE @subClientId int=NULL;
DECLARE @errorCode int=0;
DECLARE @errorMessage varchar(max) = NULL;
SET @userAssocId = ISNULL((SELECT ref.value('@userAssocId', 'INTEGER')FROM @inputXML.nodes('App_CloudAppsCascadeSPO365PlanRequest') R(ref)), NULL);
SET @newPlanId = ISNULL((SELECT ref.value('@newPlanId', 'INTEGER')FROM @inputXML.nodes('App_CloudAppsCascadeSPO365PlanRequest') R(ref)), NULL);
SET @reconcileMode = ISNULL((SELECT ref.value('@reconcileMode', 'INTEGER')FROM @inputXML.nodes('App_CloudAppsCascadeSPO365PlanRequest') R(ref)), 0);
SET @subClientId = ISNULL((SELECT ref.value('@subClientId', 'INTEGER')FROM @inputXML.nodes('App_CloudAppsCascadeSPO365PlanRequest') R(ref)), NULL);
PRINT 'AppCloudAppsCascadeSPO365PlanXml Input: userAssocId=' + ISNULL(CAST(@userAssocId as varchar(10)),'NULL') +
	', newPlanId=' + ISNULL(CAST(@newPlanId as varchar(10)),'NULL') +
	', reconcileMode=' + ISNULL(CAST(@reconcileMode as varchar(10)),'NULL') +
	', subClientId=' + ISNULL(CAST(@subClientId as varchar(10)),'NULL');
exec [dbo].[AppCloudAppsCascadeSPO365Plan] @userAssocId,@newPlanId,@reconcileMode,@subClientId, @errorCode out
IF @errorCode<>0 SET @errorMessage='AppCloudAppsCascadeSPO365Plan returned error code: ' + CAST(@errorCode as varchar(16));
DECLARE @rv XML;
SET @rv= (
SELECT
	@errorCode as errorCode
	,@errorMessage as errorMessage
FOR XML PATH (''), ROOT('GenericResp'))
SELECT @rv as XMLResponse;
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppCloudAppsCascadeSPO365PlanXml')
	delete from GxQscripts where name = 'AppCloudAppsCascadeSPO365PlanXml'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCloudAppsCascadeSPO365PlanXml')
	delete from GXDBVersions where aliasname = 'AppCloudAppsCascadeSPO365PlanXml'
GO

insert into GXDBVersions values(2, 'AppCloudAppsCascadeSPO365PlanXml',  '00000000000000000000', 'AppCloudAppsCascadeSPO365PlanXml', '00000000000000000000')
GO

