

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCloudAppsCascadeSPO365Plan.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2020  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  				AppCloudAppsCascadeSPO365Plan				|
--	| Procedure for cascade propagating SharePoint O365 plan set for record in App_CloudAppUserDetails table
--  | To cascade for subsite or for category call:
--  |    exec [dbo].[AppCloudAppsCascadeSPO365Plan] @userAssocId,@newPlanId,0,NULL, @errorCode out
--  | Also, perform reconciliation of plans and updates plan for subsites matching enabled categories.
--  | To reconcile call:
--  |   exec [dbo].[AppCloudAppsCascadeSPO365Plan] 0,0,1,@subClientId, @errorCode out
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppCloudAppsCascadeSPO365Plan')
BEGIN
	print '>>> Drop Stored Procedure: AppCloudAppsCascadeSPO365Plan <<<'
	drop procedure AppCloudAppsCascadeSPO365Plan
END
IF EXISTS (select * from GxQscripts where name='AppCloudAppsCascadeSPO365Plan')
	delete from GxQscripts where name = 'AppCloudAppsCascadeSPO365Plan'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCloudAppsCascadeSPO365Plan')
	delete from GXDBVersions where aliasname = 'AppCloudAppsCascadeSPO365Plan'
GO
print '... Creating Procedure: AppCloudAppsCascadeSPO365Plan'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCloudAppsCascadeSPO365Plan
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @userAssocId int,
  @newPlanId int,
  @reconcileMode int,
  @subClientId int,
  @errorCode int output
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
set @errorCode = 0;
declare @DefaultRetentionDays int = 1825; -- 5 years default
declare @InfiniteRetentionDays int = 99999; -- ~300 years
declare @siteCollectionUrl varchar(2000);
declare @isCategory bit = 0;
declare @SPRetentionPolicyAttrName varchar(200) = 'Office 365 retention policy';--'Office 365 SharePoint retention policy';
/* 3/4/20, OVK: Rely on flags bit &8 for Manually set Plan tracking*/
DECLARE @SP_MANUAL_PLAN	INT = 8;
IF @reconcileMode=1
BEGIN
	SET @userAssocId = NULL;
	SET @newPlanId = NULL;
	-- Find first enabled category with enabled plan within subclient
	SELECT TOP 1 @userAssocId=userAssocId,@newPlanId=planId
	FROM App_CloudAppUserDetails (NOLOCK)
	WHERE subClientId=@subClientId AND modified=0
		AND [status]=0 -- Enabled
		AND planId<>0 -- With Plan
		AND itemType=0 -- Category
	IF @userAssocId IS NULL
	BEGIN
		-- 9/1/2020, OVK: Allowing to proceed with no enabled categories, so assigned plans for parent can be propagated to newly discovered children
		-- Fail-over to first category No Plan, Not Enabled is fine
		SELECT TOP 1 @userAssocId=userAssocId,@newPlanId=planId
		FROM App_CloudAppUserDetails (NOLOCK)
		WHERE subClientId=@subClientId AND modified=0
			AND itemType=0 -- Category
	END
	-- PRINT 'Reconcile Mode: ' + CAST(@userAssocId as varchar(10)) + '/' +  CAST(@newPlanId as varchar(10));
END
-- 9/14/2020, OVK: Accomodate for no default categories
IF @userAssocId IS NULL AND @reconcileMode=1
BEGIN
	-- using site record as an artificial category
	SELECT TOP 1 @userAssocId=userAssocId
	,@newPlanId=0
	,@isCategory=1
	,@siteCollectionUrl=''
	FROM App_CloudAppUserDetails (NOLOCK)
	WHERE subClientId=@subClientId AND modified=0
			AND itemType<>0 -- Site/Collection
	ORDER BY smtpAddress ASC
END
ELSE
BEGIN
	-- !ParentWebGuid was Parent SiteCollectionGud, but recently changed by Ishaan to correlate with ParentWeb.
	-- Use aliasName which is SiteCollectionUrl for grouping site collection records
	SELECT TOP 1 @subClientId=subClientId, @siteCollectionUrl=aliasName
	,@isCategory = (CASE WHEN itemType=0 THEN 1 ELSE 0 END)
	FROM App_CloudAppUserDetails (NOLOCK)
	WHERE userAssocId=@userAssocId;
END
-- Build the tree with ParentUserAssocId populated
IF OBJECT_ID('tempdb.dbo.#temp_CloudAppUserDetails') IS NOT NULL
	DROP TABLE #temp_CloudAppUserDetails
CREATE TABLE #temp_CloudAppUserDetails(
	[userAssocId] [int] NOT NULL,
	[ParentUserAssocId] [int] NULL,
	[RN] [int] NULL DEFAULT(0),
	[ManualPlan] bit NOT NULL DEFAULT(0),
	[AnyManuallySetParentPlan] bit NOT NULL DEFAULT(0),
	[BackupSetId] INT NOT NULL DEFAULT(0),
	[IsCategory] bit NOT NULL DEFAULT(0),
	[discoverByType] [int] NOT NULL,
	[isAutoDiscovered] [bit] NOT NULL,
	[subClientId] [int] NOT NULL,
	[planId] [int] NOT NULL,
	[created] [int] NOT NULL,
	[modified] [int] NOT NULL,
	[status] [int] NOT NULL,
	[flags] [int] NOT NULL,
	[deleted] [int] NOT NULL,
	[itemType] [int] NOT NULL,
	[ItemClassification] [int] NOT NULL,
	[ParentWebGuid] [varchar](40) NOT NULL,
	[smtpAddress] [nvarchar](255) NULL,
	[ParentUrl] [nvarchar](255) NULL,
	[displayName] [nvarchar](255) NULL,
	[aliasName] [nvarchar](255) NULL
)
-- If current record is category, then initially insert all, then remove other categories except current
INSERT INTO #temp_CloudAppUserDetails (
	[userAssocId],[ParentUserAssocId], [RN],[ManualPlan]
	, [BackupSetId], [IsCategory],[ParentUrl]
	,[displayName],[aliasName],[smtpAddress],[discoverByType]
	,[isAutoDiscovered],[subClientId],[planId],[created],[modified],[status],[flags]
	,[deleted]
	,[itemType],[ParentWebGuid],[ItemClassification]
	)
SELECT
	[userAssocId],0,0,(CASE WHEN (flags&@SP_MANUAL_PLAN)=0 THEN 0 ELSE 1 END) as [ManualPlan]
	,[BackupSetId],(CASE WHEN itemType=0 THEN 1 ELSE 0 END) as [IsCategory], SUBSTRING(smtpAddress,1,LEN(smtpAddress)-CHARINDEX('/',REVERSE(smtpAddress))) as [ParentUrl]
	,[displayName],[aliasName],[smtpAddress],[discoverByType]
	,[isAutoDiscovered],[subClientId],[planId],[created],[modified],[status],[flags]
	,[deleted]
	,[itemType],[ParentWebGuid],[ItemClassification]
FROM App_CloudAppUserDetails (NOLOCK)
WHERE subClientId=@subClientId AND modified=0
	AND (@isCategory=1 OR aliasName=@siteCollectionUrl)
CREATE INDEX temp_CloudAppUserDetails_userAssocId ON #temp_CloudAppUserDetails (userAssocId ASC) INCLUDE(smtpAddress);
-- Set plan for requested record or category in temp table
IF @isCategory=1
BEGIN
	-- For category - DO NOT SET ManualPlan=1
	UPDATE #temp_CloudAppUserDetails
	set PlanId=@newPlanId,ManualPlan=0,AnyManuallySetParentPlan=0
	WHERE userAssocId=@userAssocId AND @newPlanId<>0
END
ELSE
BEGIN
	-- Update specified record in temp table
	UPDATE #temp_CloudAppUserDetails
	set PlanId=@newPlanId,ManualPlan=1,AnyManuallySetParentPlan=1,flags=(flags|@SP_MANUAL_PLAN)
	WHERE userAssocId=@userAssocId
END
IF OBJECT_ID('tempdb.dbo.#temp_EnabledCategories') IS NOT NULL
	DROP TABLE #temp_EnabledCategories
-- Build small table of enabled categories
CREATE TABLE #temp_EnabledCategories(
	[userAssocId] [int] NOT NULL,
	[RN] [int] NULL DEFAULT(0),
	[RetentionDays] [int] NOT NULL DEFAULT(0),
	[displayName] [nvarchar](255) NULL,
	[discoverByType] [int] NOT NULL,
	[isAutoDiscovered] [bit] NOT NULL,
	[subClientId] [int] NOT NULL,
	[planId] [int] NOT NULL,
	[created] [int] NOT NULL,
	[modified] [int] NOT NULL,
	[status] [int] NOT NULL,
	[flags] [int] NOT NULL,
	[deleted] [int] NOT NULL
)
-- Assuming EnabledCategories: Status=0
INSERT INTO #temp_EnabledCategories (
	[userAssocId], [RN],[RetentionDays], [displayName],[discoverByType]
	,[isAutoDiscovered],[subClientId],[planId],[created],[modified],[status],[flags]
	,[deleted])
SELECT
	[userAssocId],0,@DefaultRetentionDays,[displayName],[discoverByType]
	,[isAutoDiscovered],[subClientId],[planId],[created],[modified],[status],[flags]
	,[deleted]
FROM #temp_CloudAppUserDetails
WHERE IsCategory=1 AND [status]=0
-- Correlate Category with plan details to extract [RetentionDays]
-- N.B.: Default retention policy when plan is NULL/-1 => 5 years
UPDATE #temp_EnabledCategories
SET [RetentionDays] = ISNULL(CPD.policyDetails.value('(/cloudAppPolicy/retentionPolicy/@numOfDaysForMediaPruning)[1]','int'),@DefaultRetentionDays)
FROM #temp_EnabledCategories
	JOIN  APP_Plan P ON P.id=#temp_EnabledCategories.planId
	JOIN App_PlanProp PP ON PP.componentNameId=P.id
	JOIN APP_ConfigurationPolicy CP ON CP.policyId=(CASE WHEN ISNUMERIC(PP.attrVal)=1 THEN CAST(PP.attrVal as int) ELSE -1 END)
	JOIN APP_ConfigurationPolicyDetails CPD ON CPD.componentNameId=CP.policyId
WHERE PP.attrName=@SPRetentionPolicyAttrName
       AND P.modified=0 AND PP.modified=0
	   -- 9/1/2020, OVK: Commented line below
	   --AND CP.modified=0  -- Warning: CP.modified was non-zero in some tests
	   AND CPD.modified=0
-- Correct -1 infinity into large number of x100 years, i.e. value greater than others real
UPDATE #temp_EnabledCategories
SET [RetentionDays] = @InfiniteRetentionDays
WHERE [RetentionDays]=-1
-- Remove categories except self from temp table
DELETE FROM #temp_CloudAppUserDetails WHERE IsCategory=1 AND userAssocId<>@userAssocId;
-- Populate ParentUserAssocId
UPDATE #temp_CloudAppUserDetails
SET ParentUserAssocId=P.userAssocId
from #temp_CloudAppUserDetails
	JOIN #temp_CloudAppUserDetails P ON P.smtpAddress=#temp_CloudAppUserDetails.ParentUrl AND P.aliasName=#temp_CloudAppUserDetails.aliasName AND LEN(P.smtpAddress)>0
-- Sort/determine order RN
UPDATE #temp_CloudAppUserDetails
SET RN=T.RN
FROM #temp_CloudAppUserDetails
	JOIN (SELECT userAssocId,
		ROW_NUMBER() OVER (ORDER BY smtpAddress) as RN -- SmptAdress is url, when we sort by Url Parent appear on the top with lower RN #. Categories have empty url, putting them at very top
		FROM #temp_CloudAppUserDetails) as T ON T.userAssocId=#temp_CloudAppUserDetails.userAssocId
-- RN is sorting key
-- Find all branch records below @userAssocId
-- Rely on sort order and parent knowledge
-- In sorted list find next item having the same parent as reference record (@userAssocId).
/*
example:
	/sites/oleg/AAA <= @minRN
	/sites/oleg/AAA/aaa1
	/sites/oleg/AAA/Sub1
	/sites/oleg/AAA/Sub2
	/sites/oleg/BBB/summer <= @nextRN (common parent is '/sites/oleg')
*/
declare @nextRN int = NULL;
IF @isCategory=0
BEGIN
	SET @nextRN = (select MIN(T2.RN) as Min_T2RN
	from #temp_CloudAppUserDetails T1
		JOIN #temp_CloudAppUserDetails T2 ON T2.ParentUserAssocId=T1.ParentUserAssocId AND T2.RN>T1.RN AND T2.userAssocId<>T1.userAssocId
	WHERE T1.userAssocId=@userAssocId);
END
IF @nextRN IS NULL
	SET @nextRN = 1 + (SELECT MAX(RN) FROM #temp_CloudAppUserDetails)
declare @minRN int = (SELECT MIN(RN) FROM #temp_CloudAppUserDetails WHERE userAssocId=@userAssocId);
-- Limited tree branch is defined by [@minRN..@nextRN).
-- UPDATE #temp_EnabledCategories to get sorted RN, descending by RetentionDays. I.e. longest retention - (ec)RN=1
UPDATE #temp_EnabledCategories
SET RN=T.RN
FROM #temp_EnabledCategories
	JOIN (SELECT userAssocId,
		ROW_NUMBER() OVER (ORDER BY [RetentionDays] DESC, discoverByType ASC, created ASC) as RN
		FROM #temp_EnabledCategories) as T ON T.userAssocId=#temp_EnabledCategories.userAssocId
-- For Categories - parentPlanId might differ.
-- Need extra flag AnyManualSetParent, if =0, then use matching categories with longest duration to get plan.
-- Build temp table of category plans sorted by duration DESC.
DECLARE @minECRN int, @maxECRN int;
SELECT @minECRN=MIN(RN), @maxECRN=MAX(RN) FROM #temp_EnabledCategories;
CREATE INDEX temp_CloudAppUserDetails_RN_INC_UserAssocId ON #temp_CloudAppUserDetails (RN ASC) INCLUDE (userAssocId, planId, ParentUserAssocId, IsCategory, ItemClassification);
-- Tree Branch reduces number of records to walk overall.
-- RN>=@minRN AND RN<@nextRN - defines records which to be set with @newPlanId, copied/insert first
SET NOCOUNT ON
DECLARE @RN int = @minRN+1;
WHILE @RN<@nextRN
BEGIN
	-- Get @RN record Info
	DECLARE @planId int, @parentUserAssocId int, @manualPlan int, @isCategoryRow bit, @aliasName nvarchar(255);
	-- 9/1/2020, OVK: Use siteCollectionClassification only!
	SELECT @planId=PlanId,@parentUserAssocId=ParentUserAssocId, @manualPlan=ManualPlan, @isCategoryRow=IsCategory, @aliasName=aliasName
	FROM #temp_CloudAppUserDetails
	WHERE RN=@RN;
	DECLARE @SiteCollectionClassification int;
	SELECT @SiteCollectionClassification=ItemClassification
	FROM #temp_CloudAppUserDetails
	WHERE smtpAddress=@aliasName AND itemType<>0
	IF @manualPlan=0 -- Do not override manually set plan during propagation
	BEGIN
		-- Get RN.Parent PlanId
		DECLARE @parentPlanId int, @anyManuallySetParentPlan bit=0;
		SELECT @parentPlanId=planId, @anyManuallySetParentPlan=AnyManuallySetParentPlan FROM #temp_CloudAppUserDetails WHERE userAssocId=@parentUserAssocId;
		IF @parentPlanId IS NULL OR @anyManuallySetParentPlan=0
		BEGIN
			SET @parentPlanId = 0;
			/*
				ItemClassification: 1 - regular web; 2 - team site; 3 - Project Online
				discoverByType: 9 - all sites ; 10 - Team sites; 11 - Project Online
			*/
			-- Check matching categories and use as ParentId plan with longest duration (with min RN from #temp_EnabledCategories)
			DECLARE @ecRN int = @minECRN;
			WHILE @parentPlanId=0 AND @ecRN<=@maxECRN
			BEGIN
				DECLARE @ecDiscoverByType int,@ecPlanId int;
				SELECT @ecDiscoverByType=discoverByType, @ecPlanId=planId FROM #temp_EnabledCategories WHERE RN=@ecRN;
				IF @ecDiscoverByType=9
					SET @parentPlanId = @ecPlanId
				IF @ecDiscoverByType=10 AND @SiteCollectionClassification=2
					SET @parentPlanId = @ecPlanId
				IF @ecDiscoverByType=11 AND @SiteCollectionClassification=3
					SET @parentPlanID = @ecPlanId
				-- In future - custom categories (could be in displayname)
				-- IF @ecDiscoverByType>11 AND @url LIKE REPLACE(@ecCustomCategoryTemplate,'*','%') SET @parentPlanID = @ecPlanId
				SET @ecRN = @ecRN + 1;
			END
		END
		IF @parentPlanId<>0 -- 8/5/20, OVK: Prevent propagating planId=0 (i.e. clearing)
		BEGIN
			UPDATE #temp_CloudAppUserDetails
			SET planId=@parentPlanId, AnyManuallySetParentPlan=@anyManuallySetParentPlan
			WHERE RN=@RN;
		END
	END
	ELSE
	BEGIN
		UPDATE #temp_CloudAppUserDetails
		SET AnyManuallySetParentPlan=1
		WHERE RN=@RN
	END
	SET @RN = @RN + 1;
END
-- Build strict list of records for update - only if different values, by removing not relevant records from #temp_CloudAppUserDetails
DELETE FROM #temp_CloudAppUserDetails WHERE NOT(RN>=@minRN AND RN<@nextRN)
-- Consider only PlanId and Flags (@SP_MANUAL_PLAN is relevant bit)
DELETE FROM #temp_CloudAppUserDetails
WHERE userAssocId IN (
SELECT T.userAssocId
FROM #temp_CloudAppUserDetails T
	JOIN App_CloudAppUserDetails (NOLOCK) RT ON RT.userAssocId=T.userAssocId AND RT.planId=T.planId
			AND RT.flags=T.flags
)
-- At this point #temp_CloudAppUserDetails contains only changed records for insert/update
declare @startTime datetime = GetDate();
BEGIN TRY
	BEGIN TRAN Atomic_Insert_Update
	-- Insert new records with updated PlanId,ManualPlanFlag into Real Table, then de-activate old records by setting modified
	INSERT INTO App_CloudAppUserDetails
	(
	[userGUID],[displayName],[aliasName],[smtpAddress],[discoverByType],[isAutoDiscovered]
	,[subClientId],[planId],[created],[modified],[status],[flags],[deleted]
	,[coreId],[password],[userAccountSize],[description],[CloudGroupName]
	,[xmlGeneric],[itemType],[ParentWebGuid],[BackupSetId],[ItemClassification]
	,[backupReferenceTime],[numberOfItems],[IdxCollectionTime])
	SELECT
	RT.[userGUID],RT.[displayName],RT.[aliasName],RT.[smtpAddress],RT.[discoverByType],RT.[isAutoDiscovered]
	,RT.[subClientId],  T.[planId]    ,RT.[created],RT.[modified],RT.[status],    T.[flags]   	,RT.[deleted]
	,RT.[coreId],RT.[password],RT.[userAccountSize],RT.[description],RT.[CloudGroupName]
	,RT.[xmlGeneric],RT.[itemType],RT.[ParentWebGuid],RT.[BackupSetId],RT.[ItemClassification]
	,RT.[backupReferenceTime],RT.[numberOfItems],RT.[IdxCollectionTime]
	FROM #temp_CloudAppUserDetails T
		JOIN App_CloudAppUserDetails RT ON RT.userAssocId=T.userAssocId
	declare @now datetime = GETUTCDATE();
	declare @intNow int = [dbo].[GetUnixTime](@now);
	UPDATE App_CloudAppUserDetails
	SET modified=@intNow
	WHERE userAssocId IN (SELECT userAssocId FROM #temp_CloudAppUserDetails)
	COMMIT TRAN Atomic_Insert_Update -- COMMIT inner transaction, which can be still rolled back by outer transaction
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	IF @@TRANCOUNT > 0
	ROLLBACK TRAN Atomic_Insert_Update --RollBack in case of Error
	PRINT 'Transaction rolled back due to error. ' + ERROR_MESSAGE()
	SET @errorCode = 1;
END CATCH
PRINT 'Insert/Update Lock duration (ms): ' + CAST(DATEDIFF(ms,@startTime,GetDate()) as varchar(100));
DROP TABLE #temp_CloudAppUserDetails
DROP TABLE #temp_EnabledCategories
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppCloudAppsCascadeSPO365Plan')
	delete from GxQscripts where name = 'AppCloudAppsCascadeSPO365Plan'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCloudAppsCascadeSPO365Plan')
	delete from GXDBVersions where aliasname = 'AppCloudAppsCascadeSPO365Plan'
GO

insert into GXDBVersions values(2, 'AppCloudAppsCascadeSPO365Plan',  '00000000000000000000', 'AppCloudAppsCascadeSPO365Plan', '00000000000000000000')
GO

