

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCloudAppUserDetailsSetInfoV1.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2018  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
--  +==========================================================================================+
--  |   AppCloudAppUserDetailsSetInfoV1                                                        |
--  |   Procedure to insert/update v1 cloud apps user details in App_CloudAppUserDetails table |
--  +==========================================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppCloudAppUserDetailsSetInfoV1')
BEGIN
	print '>>> Drop Stored Procedure: AppCloudAppUserDetailsSetInfoV1 <<<'
	drop procedure AppCloudAppUserDetailsSetInfoV1
END
IF EXISTS (select * from GxQscripts where name='AppCloudAppUserDetailsSetInfoV1')
	delete from GxQscripts where name = 'AppCloudAppUserDetailsSetInfoV1'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCloudAppUserDetailsSetInfoV1')
	delete from GXDBVersions where aliasname = 'AppCloudAppUserDetailsSetInfoV1'
GO
print '... Creating Procedure: AppCloudAppUserDetailsSetInfoV1'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppCloudAppUserDetailsSetInfoV1
-----------------------------------------------------------
---                  PARAMETERS                         ---
  @i_xmlString XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @o_xmlString		XML
	DECLARE @nowUTCTime			DATETIME = GETUTCDATE()
	DECLARE @nowUTCUnixTime     INT = DATEDIFF(second, '01/01/1970', @nowUtcTime)
	DECLARE @subclientId		INT = 0
	DECLARE	@backupsetId		INT = 0
	DECLARE @accountStatus		INT = 0
	DECLARE @discoverByType		INT = 0
	DECLARE @DISCOVERTYPE_USER	INT = 1
	/*Table to store incoming users from request*/
	IF OBJECT_ID('tempdb.dbo.#cloudAppV1Users_XMLDetails') IS NOT NULL
		DROP TABLE #cloudAppV1Users_XMLDetails
	CREATE TABLE #cloudAppV1Users_XMLDetails(smtpAddress NVARCHAR(255) DEFAULT '', displayName NVARCHAR(255) DEFAULT '', subclientId INT, discoverByType INT,
		backupsetId INT DEFAULT 0, backupRefTime INT DEFAULT 0, numberOfItems BIGINT DEFAULT 0, userSize BIGINT DEFAULT 0, idxCollectionTime INT DEFAULT 0)
	CREATE CLUSTERED INDEX #Idx1_cloudAppV1Users_XMLDetails_smtp_subclientId ON #cloudAppV1Users_XMLDetails(smtpAddress, subclientId)
	/*Table to store existing users in the table*/
	IF OBJECT_ID('tempdb.dbo.#cloudAppV1Users_ExistingDetails') IS NOT NULL
		DROP TABLE #cloudAppV1Users_ExistingDetails
	CREATE TABLE #cloudAppV1Users_ExistingDetails(smtpAddress NVARCHAR(255) DEFAULT '', displayName NVARCHAR(255) DEFAULT '', subclientId INT, discoverByType INT,
		backupsetId INT DEFAULT 0, backupRefTime INT DEFAULT 0, numberOfItems BIGINT DEFAULT 0, userSize BIGINT DEFAULT 0, idxCollectionTime INT DEFAULT 0)
	CREATE CLUSTERED INDEX #Idx2_cloudAppV1Users_ExistingDetails_smtp_subclientId ON #cloudAppV1Users_ExistingDetails(smtpAddress, subclientId)
	/*Temp table to update/insert users*/
	IF OBJECT_ID('tempdb.dbo.#cloudAppV1Users_tempDetails') IS NOT NULL
		DROP TABLE #cloudAppV1Users_tempDetails
	CREATE TABLE #cloudAppV1Users_tempDetails(smtpAddress NVARCHAR(255) DEFAULT '', displayName NVARCHAR(255) DEFAULT '', subclientId INT, discoverByType INT,
		backupsetId INT DEFAULT 0, backupRefTime INT DEFAULT 0, numberOfItems BIGINT DEFAULT 0, userSize BIGINT DEFAULT 0, idxCollectionTime INT DEFAULT 0)
	CREATE CLUSTERED INDEX #Idx2_cloudAppV1Users_tempDetails_smtp_subclientId ON #cloudAppV1Users_tempDetails(smtpAddress, subclientId)
	BEGIN TRY
		SELECT
			@accountStatus = ISNULL(ref.value('(cloudAppAssociation/@accountStatus)[1]', 'INT'), @accountStatus),
			@subClientId = ISNULL(ref.value('(cloudAppAssociation/subclientEntity/@subclientId)[1]', 'INT'), @subClientId),
			@backupSetId = ISNULL(ref.value('(cloudAppAssociation/subclientEntity/@backupsetId)[1]', 'INT'), @backupSetId),
			@discoverByType = ISNULL(ref.value('(cloudAppAssociation/cloudAppDiscoverinfo/@discoverByType)[1]', 'INT'), @discoverByType)
		FROM @i_xmlString.nodes('Ida_SetCloudAppV1PolicyAssociationReq') R(ref)
		/*Check if subclientId is set*/
		IF @subclientId = 0
			BEGIN
				SELECT @errorCode = 1, @errorString = 'Error: Invalid subclientId [0]'
				GOTO ERROR_EXIT
			END
		/*Check for supported discoverTypes*/
		IF @discoverByType NOT IN (@DISCOVERTYPE_USER)
			BEGIN
				SELECT @errorCode = 1, @errorString = 'Error: DiscoverType [' + CAST(@discoverByType AS VARCHAR(16)) + '] is not recognized'
				GOTO ERROR_EXIT
			END
		/*Read XML data*/
		IF @discoverByType IN (@DISCOVERTYPE_USER)
			BEGIN
				INSERT INTO #cloudAppV1Users_XMLDetails (smtpAddress, displayName, subclientId, backupsetId, discoverByType, backupRefTime, idxCollectionTime, numberOfItems, userSize)
				SELECT
					ISNULL(UA.value('@smtpAddress', 'NVARCHAR(MAX)'), '') AS smtpAddress,
					ISNULL(UA.value('@displayName', 'NVARCHAR(MAX)'), '') AS displayName,
					@subclientId, @backupsetId, @discoverByType,
					ISNULL(UA.value('(lastBackupJobRanTime[1]/@time)','INT'), 0) AS backupRefTime,
					ISNULL(UA.value('(IdxCollectionTime[1]/@time)','INT'), 0) AS idxCollectionTime,
					ISNULL(UA.value('@numberOfItems', 'BIGINT'), 0) AS numberOfItems,
					ISNULL(UA.value('@accountSize', 'BIGINT'), 0) AS userSize
				FROM @i_xmlString.nodes('Ida_SetCloudAppV1PolicyAssociationReq/cloudAppAssociation/cloudAppDiscoverinfo/userAccounts') I(UA)
			END
		/*Read existing data*/
		IF @discoverByType IN (@DISCOVERTYPE_USER)
			BEGIN
				INSERT INTO #cloudAppV1Users_ExistingDetails (smtpAddress, displayName, subclientId, backupsetId, discoverByType, backupRefTime, numberOfItems, userSize, idxCollectionTime)
				SELECT smtpAddress, displayName, subClientId, BackupSetId, discoverByType, backupReferenceTime, numberOfItems, userAccountSize, IdxCollectionTime
				FROM APP_CloudAppUserDetails(NOLOCK) WHERE subClientId = @subclientId AND discoverByType = @discoverByType AND modified = 0
			END
		IF @accountStatus = 0
			BEGIN
                /*Get new users*/
				INSERT INTO #cloudAppV1Users_tempDetails (smtpAddress, subclientId, displayName, discoverByType, backupsetId, backupRefTime, numberOfItems, userSize, idxCollectionTime)
				SELECT smtpAddress, subclientId, displayName, discoverByType, backupsetId, backupRefTime, numberOfItems, userSize, idxCollectionTime
				FROM #cloudAppV1Users_XMLDetails X
				WHERE NOT EXISTS (SELECT smtpAddress, subclientId FROM #cloudAppV1Users_ExistingDetails E WHERE X.smtpAddress = E.smtpAddress AND X.subclientId = E.subclientId)
				IF EXISTS (SELECT 1 FROM #cloudAppV1Users_tempDetails)
					BEGIN
						/*[BEGIN]Transaction: Insert new users*/
						BEGIN TRAN
							INSERT INTO APP_CloudAppUserDetails (smtpAddress, userGUID, ParentWebGuid, aliasName, xmlGeneric, subClientId, displayName, discoverByType, created, modified, status, flags, deleted, BackupSetId, backupReferenceTime, userAccountSize, numberOfItems, IdxCollectionTime)
							SELECT smtpAddress, '', '', '', '', D.subclientId, D.displayName, @discoverByType, @nowUTCUnixTime, 0, @accountStatus, 0, 0, D.backupsetId, D.backupRefTime, D.userSize, D.numberOfItems, D.idxCollectionTime
							FROM #cloudAppV1Users_tempDetails D
							SET @errorCode = @@ERROR
							IF @errorCode <> 0
								BEGIN
									ROLLBACK TRAN
									GOTO ERROR_EXIT
								END
							ELSE
								COMMIT TRAN
						/*[END]Transaction*/
					END
			END
		DELETE FROM #cloudAppV1Users_tempDetails
		IF @accountStatus = 0
			BEGIN
				/*Get updated stats for existing users*/
				INSERT INTO #cloudAppV1Users_tempDetails (smtpAddress, subclientId, backupRefTime, numberOfItems, userSize, idxCollectionTime)
				SELECT X.smtpAddress, X.subclientId,
				(CASE WHEN X.backupRefTime IS NOT NULL AND X.backupRefTime <> 0 THEN X.backupRefTime ELSE E.backupRefTime END),
				(CASE WHEN X.numberOfItems IS NOT NULL AND X.numberOfItems <> 0 THEN X.numberOfItems ELSE E.numberOfItems END),
				(CASE WHEN X.userSize IS NOT NULL AND X.userSize <> 0 THEN X.userSize ELSE E.userSize END),
				(CASE WHEN X.idxCollectionTime IS NOT NULL AND X.idxCollectionTime <> 0 THEN X.idxCollectionTime ELSE E.idxCollectionTime END)
				FROM #cloudAppV1Users_XMLDetails X
				INNER JOIN #cloudAppV1Users_ExistingDetails E ON X.subclientId = E.subclientId AND X.smtpAddress = E.smtpAddress
				IF EXISTS (SELECT 1 FROM #cloudAppV1Users_tempDetails)
					BEGIN
						/*[BEGIN]Transaction: Update existing users*/
						BEGIN TRAN
							UPDATE APP_CloudAppUserDetails
							SET backupReferenceTime = D.backupRefTime, numberOfItems = D.numberOfItems, userAccountSize = D.userSize, IdxCollectionTime = D.idxCollectionTime
							FROM #cloudAppV1Users_tempDetails D
							WHERE APP_CloudAppUserDetails.subClientId = D.subclientId AND APP_CloudAppUserDetails.smtpAddress = D.smtpAddress
							AND APP_CloudAppUserDetails.discoverByType IN (@DISCOVERTYPE_USER) AND APP_CloudAppUserDetails.modified = 0
							SET @errorCode = @@ERROR
							IF @errorCode <> 0
								BEGIN
									ROLLBACK TRAN
									GOTO ERROR_EXIT
								END
							ELSE
								COMMIT TRAN
						/*[END]Transaction*/
					END
			END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SELECT @errorCode = ERROR_NUMBER(), @errorString = ERROR_MESSAGE()
	END CATCH
	ERROR_EXIT:
		SET @o_xmlString = (SELECT(SELECT @errorCode '@errorCode', @errorString '@errorMessage'
							FOR XML PATH ('resp'),TYPE)
							FOR XML PATH(''),ROOT('Ida_CloudAppAssociationsResp'))
		SELECT @o_xmlString
		IF OBJECT_ID('tempdb.dbo.#cloudAppV1Users_XMLDetails') IS NOT NULL
			DROP TABLE #cloudAppV1Users_XMLDetails
		IF OBJECT_ID('tempdb.dbo.#cloudAppV1Users_ExistingDetails') IS NOT NULL
			DROP TABLE #cloudAppV1Users_ExistingDetails
		IF OBJECT_ID('tempdb.dbo.#cloudAppV1Users_tempDetails') IS NOT NULL
			DROP TABLE #cloudAppV1Users_tempDetails
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppCloudAppUserDetailsSetInfoV1')
	delete from GxQscripts where name = 'AppCloudAppUserDetailsSetInfoV1'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCloudAppUserDetailsSetInfoV1')
	delete from GXDBVersions where aliasname = 'AppCloudAppUserDetailsSetInfoV1'
GO

insert into GXDBVersions values(2, 'AppCloudAppUserDetailsSetInfoV1',  '00000000000000000000', 'AppCloudAppUserDetailsSetInfoV1', '00000000000000000000')
GO

