

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCloudAppConfigPolicyAssocUpdateInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  				AppCloudAppConfigPolicyAssocUpdateInfo				|
--	| Procedure for create/update a APP_CloudAppConfigPolicyAssoc table	|
--	+===================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppCloudAppConfigPolicyAssocUpdateInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppCloudAppConfigPolicyAssocUpdateInfo <<<'
	drop procedure AppCloudAppConfigPolicyAssocUpdateInfo
END
IF EXISTS (select * from GxQscripts where name='AppCloudAppConfigPolicyAssocUpdateInfo')
	delete from GxQscripts where name = 'AppCloudAppConfigPolicyAssocUpdateInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCloudAppConfigPolicyAssocUpdateInfo')
	delete from GXDBVersions where aliasname = 'AppCloudAppConfigPolicyAssocUpdateInfo'
GO
print '... Creating Procedure: AppCloudAppConfigPolicyAssocUpdateInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppCloudAppConfigPolicyAssocUpdateInfo
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE	@o_xmlString		XML
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			DATETIME = GETDATE()
	DECLARE @nowUtcTime			DATETIME = GETUTCDATE()
	DECLARE @nowUtcUnix			INT = DATEDIFF(second, '01/01/1970', @nowUtcTime)
	DECLARE @accountStatus		INT = 0
	DECLARE @requestAccountStatus INT = NULL
	DECLARE @subClientId		INT = 0
	DECLARE @backupSetId		INT = 0
	DECLARE @instanceId			INT = 0
	DECLARE @instanceType		INT = 0
	DECLARE @clientId			INT = 0
	DECLARE @policyComponentId	INT = 0
	DECLARE @planId				INT = 0
	DECLARE @requestPlanId		int = NULL -- 5/14/2020, OVK: PlanId from request
	DECLARE @discovered			INT = 0
	DECLARE @appTypeId			INT = 0
	DECLARE @userId				INT = 0
	DECLARE @discoverByType		INT = 0
DECLARE @brAlertTrace	 AS varchar(255)               = (select value from gxglobalParam (NOLOCK) Where name = 'bralertTrace')
	DECLARE @dateTime		AS DATETIME = getDate()			-- Common Date/Time Stamp for everything done here
	DECLARE @DISCOVERTYPE_USER													INT = 1
	DECLARE @DISCOVERTYPE_GROUPS												INT = 2
	DECLARE @DISCOVERTYPE_BROWSE_FOLDERS										INT = 3
	DECLARE @DISCOVERTYPE_ALL_USERS												INT = 4
	DECLARE @DISCOVERTYPE_AUTO_DISCOVER_ASSOCIATIONS							INT = 5
	DECLARE @DISCOVERTYPE_ASSOCIATED_SHAREPOINT_WEB_SITES						INT = 6
	DECLARE @DISCOVERTYPE_ALL_SHAREPOINT_WEB_SITES								INT = 7
	DECLARE @DISCOVERTYPE_AUTO_DISCOVERED_SHAREPOINT							INT = 8
	DECLARE @DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_ALL_SHAREPOINT_WEB_SITES	INT = 9
	DECLARE @DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_SHAREPOINT_TEAM_SITES		INT = 10
	DECLARE @DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_PROJECT_ONLINE_SITES		INT = 11
	DECLARE @DISCOVERTYPE_TEAM													INT = 12
	DECLARE @DISCOVERTYPE_ALL_TEAMS												INT = 13
	DECLARE @DISCOVERTYPE_DYNAMICS_365_ENTITY									INT = 14
	DECLARE @DISCOVERTYPE_DYNAMICS_365_INSTANCE									INT = 15
	DECLARE @DISCOVERTYPE_ALL_DYNAMICS_365_INSTANCES							INT = 16
	DECLARE @POLICY_TYPE_ARCHIVE			INT = 1
	DECLARE @POLICY_TYPE_CLEANUP			INT = 2
	DECLARE @POLICY_TYPE_RETENTION			INT = 3
	--Share Point ItemClassification
	DECLARE @SPItemClassification_REGULAR	INT = 1
	DECLARE @SPItemClassification_TEAM		INT = 2
	DECLARE @SPItemClassification_ONLINE	INT = 3
	--CloudApps Common flags
	DECLARE	@ONEDRIVE_ENABLED				INT = 1
	DECLARE @SP_CONTENT_NOT_ASSOCIATED		INT = 2
	DECLARE @SP_ASSOCIATED_BY_PARENT		INT = 4 -- If bit is set (flags&4!=0), then association via manually added Parent
	DECLARE @SP_MANUAL_PLAN					INT = 8;-- If bit is set (flags&8!=0), then O365 was manually associated
DECLARE @PLAN_PROP_ARCHIVE				VARCHAR(255) = 'Office 365 backup policy'
DECLARE @PLAN_PROP_CLEANUP				VARCHAR(255) = 'Office 365 cleanup policy'
DECLARE @PLAN_PROP_RETENTION			VARCHAR(255) = 'Office 365 retention policy'
	IF @brAlertTrace <> 0									-- Put a copy of input data to table TrackNotificationProcs
	BEGIN
		DECLARE @inputString		NVARCHAR(MAX) = CAST(@i_xmlString AS NVARCHAR(MAX))
		EXEC br_ntTrace '.. AppCloudAppConfigPolicyAssocUpdateInfo', 0, @nowTime, 0, 0, @inputString
	END
	SELECT
		@userId = ISNULL(ref.value('(processinginstructioninfo/user/@userId)[1]', 'INT'), @userId),
		@subClientId = ISNULL(ref.value('(cloudAppAssociation/subclientEntity/@subclientId)[1]', 'INT'), @subClientId),
		@discoverByType = ISNULL(ref.value('(cloudAppAssociation/cloudAppDiscoverinfo/@discoverByType)[1]', 'INT'), @discoverByType),
		@accountStatus = ISNULL(ref.value('(cloudAppAssociation/@accountStatus)[1]', 'INT'), @accountStatus),
		@requestAccountStatus = ISNULL(ref.value('(cloudAppAssociation/@accountStatus)[1]', 'INT'), NULL), -- 5/14/2020, OVK: accountStatus from request
		@planId	= ISNULL(ref.value('(cloudAppAssociation/plan/@planId)[1]', 'INT'), @planId),
		@requestPlanId = ISNULL(ref.value('(cloudAppAssociation/plan/@planId)[1]', 'INT'), NULL),-- 5/14/2020, OVK: PlanId from request
		@appTypeId = ISNULL(ref.value('(cloudAppAssociation/subclientEntity/@applicationId)[1]', 'INT'), @appTypeId),
		@instanceId = ISNULL(ref.value('(cloudAppAssociation/subclientEntity/@instanceId)[1]', 'INT'), @instanceId),
		@backupSetId = ISNULL(ref.value('(cloudAppAssociation/subclientEntity/@backupsetId)[1]', 'INT'), @backupSetId),
		@clientId = ISNULL(ref.value('(cloudAppAssociation/subclientEntity/@clientId)[1]', 'INT'), @clientId)
	FROM @i_xmlString.nodes('Ida_UpdateCloudAppPolicyAssociationReq') R(ref)
	-- DECLARE @oldPlanId int = 0; -- For checking if AppCloudAppsCascadeSPO365Plan when @planId<>@oldPlanId for SharePoint
	-- DECLARE @userAssocId int = 0; -- Reference record Id for calling AppCloudAppsCascadeSPO365Plan for SharePoint
	IF object_id('tempdb.dbo.#RequestedUserAssocPlans') is not null
		DROP TABLE #RequestedUserAssocPlans
	CREATE TABLE #RequestedUserAssocPlans (id int IDENTITY(1,1) NOT NULL, userGUID VARCHAR(40), userAssocId int, oldPlanId int);
	DECLARE @isSharePointDiscoveryType int = 0;
	IF @discoverByType IN (@DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_ALL_SHAREPOINT_WEB_SITES,@DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_SHAREPOINT_TEAM_SITES,@DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_PROJECT_ONLINE_SITES,@DISCOVERTYPE_ASSOCIATED_SHAREPOINT_WEB_SITES) SET @isSharePointDiscoveryType=1;
	--CREATE TEMP TABLE TO INSERT XML INPUT
	IF object_id('tempdb.dbo.#cloudAppConfiguration_XMLDetailsTable') is not null
		DROP TABLE #cloudAppConfiguration_UserDetailsTable
	CREATE TABLE #cloudAppConfiguration_XMLDetailsTable
(userGUID VARCHAR(40) DEFAULT '', displayName NVARCHAR(255) NULL DEFAULT '', aliasName NVARCHAR(255) NULL DEFAULT '', smtpAddress NVARCHAR(255) NULL DEFAULT '',
			discoverByType INT NULL DEFAULT 0, isAutoDiscoveredUser INT NULL DEFAULT 0,commonFlags INT NULL DEFAULT 0, userAccountSize BIGINT NULL DEFAULT 0,
itemtype INT NULL DEFAULT 0, ParentWebGuid NVARCHAR(255) NULL DEFAULT '',ItemClassification INT NULL DEFAULT 0,BackupSetId INT NULL DEFAULT 0, xmlGeneric XML NULL DEFAULT '',
			planId INT NULL DEFAULT 0, accountStatus INT NULL DEFAULT 0,bkpRefTime BIGINT NULL DEFAULT 0, nItems BIGINT NULL DEFAULT 0, IdxColTime BIGINT NULL DEFAULT 0)
	CREATE CLUSTERED INDEX #cloudAppConfiguration_XMLDetailsTable_userGuid_discoverByType_Index1 ON #cloudAppConfiguration_XMLDetailsTable ([userGuid], [discoverByType])
	IF object_id('tempdb.dbo.#PoliciesTable') is not null
		DROP TABLE #PoliciesTable
	CREATE TABLE #PoliciesTable
		(policyId INT, cloudAppPolicyType INT )
	IF object_id('tempdb.dbo.#output_PolicyAssocTable') is not null
		DROP TABLE #output_PolicyAssocTable
	CREATE TABLE #output_PolicyAssocTable
(assocId INT, userGuid VARCHAR(255),displayName NVARCHAR(255) NULL DEFAULT '')
	IF object_id('tempdb.dbo.#cloudAppConfiguration_DetailsCompareTable') is not null
	DROP TABLE #cloudAppConfiguration_DetailsCompareTable
	CREATE TABLE #cloudAppConfiguration_DetailsCompareTable
(userAssocId INT DEFAULT 0,userGUID VARCHAR(40) DEFAULT '', displayName NVARCHAR(255) NULL DEFAULT '', aliasName NVARCHAR(255) NULL DEFAULT '', smtpAddress NVARCHAR(255) NULL DEFAULT '',
			discoverByType INT NULL DEFAULT 0, isAutoDiscoveredUser INT NULL DEFAULT 0,commonFlags INT NULL DEFAULT 0, userAccountSize BIGINT NULL DEFAULT 0,
itemtype INT NULL DEFAULT 0, ParentWebGuid NVARCHAR(255) NULL DEFAULT '',ItemClassification INT NULL DEFAULT 0,BackupSetId INT NULL DEFAULT 0, xmlGeneric XML NULL DEFAULT '',
			planId INT NULL DEFAULT 0, accountStatus INT NULL DEFAULT 0,Deleted INT NULL DEFAULT 0,bkpRefTime BIGINT NULL DEFAULT 0, nItems BIGINT NULL DEFAULT 0, IdxColTime BIGINT NULL DEFAULT 0)
	IF @planId > 0
	BEGIN
		INSERT INTO #PoliciesTable
		SELECT CAST(attrVal AS INT) policyId,
			CASE attrName
				WHEN @PLAN_PROP_ARCHIVE THEN @POLICY_TYPE_ARCHIVE
				WHEN @PLAN_PROP_CLEANUP THEN @POLICY_TYPE_CLEANUP
				WHEN @PLAN_PROP_RETENTION THEN @POLICY_TYPE_RETENTION
			END policyType
		FROM App_PlanProp (NOLOCK)
			WHERE attrName IN (@PLAN_PROP_ARCHIVE, @PLAN_PROP_CLEANUP, @PLAN_PROP_RETENTION)
		AND componentNameId = @planId
AND attrType = 7
		AND modified = 0
	END
	ELSE
	BEGIN
		INSERT INTO #PoliciesTable
		SELECT pe.value('@policyId', 'INT') policyId, dt.value('@cloudAppPolicyType', 'INT') policyType
		FROM    @i_xmlString.nodes('Ida_UpdateCloudAppPolicyAssociationReq/cloudAppAssociation/policies/cloudAppPolicies') R(ref)
		CROSS APPLY ref.nodes('./detail/cloudAppPolicy') D(dt)
		CROSS APPLY ref.nodes('./policyEntity') P(pe)
	END
	IF @discoverByType IN (@DISCOVERTYPE_USER,@DISCOVERTYPE_ASSOCIATED_SHAREPOINT_WEB_SITES, @DISCOVERTYPE_TEAM, @DISCOVERTYPE_DYNAMICS_365_ENTITY, @DISCOVERTYPE_DYNAMICS_365_INSTANCE)
	BEGIN
		INSERT #cloudAppConfiguration_XMLDetailsTable (userGUID, displayName, aliasName, smtpAddress,discoverByType, isAutoDiscoveredUser,commonFlags, userAccountSize,
				itemtype, ParentWebGuid,ItemClassification,BackupSetId,xmlGeneric, planId, accountStatus)
			SELECT
				ISNULL(ua.value('user[1]/@userGUID', 'NVARCHAR(40)'), '') userGUID,
				ISNULL(ua.value('@displayName', 'NVARCHAR(MAX)'),'') displayName,
				ISNULL(ua.value('@aliasName', 'NVARCHAR(MAX)'),'') aliasName,
				ISNULL(ua.value('@smtpAddress', 'NVARCHAR(MAX)'),'') smtpAddress,
				ISNULL(ref.value('@discoverByType', 'INT'),0) discoverByType,
				ISNULL(ua.value('@isAutoDiscoveredUser', 'INT'),'') isAutoDiscoveredUser,
				ISNULL(ua.value('@commonFlags', 'INT'),0) commonFlags,
				ISNULL(ua.value('@accountSize','BIGINT'),0) userAccountSize,
				ISNULL(ua.value('@itemType', 'INT'),0) itemtype,
				ISNULL(ua.value('@ParentWebGuid', 'NVARCHAR(MAX)'),'') ParentWebGuid,
				ISNULL(ua.value('@ItemClassification', 'INT'),0) ItemClassification,
				CASE WHEN @discoverByType IN( @DISCOVERTYPE_USER, @DISCOVERTYPE_TEAM, @DISCOVERTYPE_DYNAMICS_365_ENTITY, @DISCOVERTYPE_DYNAMICS_365_INSTANCE) THEN @backupSetId ELSE ISNULL(ua.value('@BackupSetId', 'INT'), 0) END BackupSetId,
				--ua.value('@xmlGeneric', 'XML') xmlGeneric,
				CASE WHEN @discoverByType IN( @DISCOVERTYPE_USER, @DISCOVERTYPE_DYNAMICS_365_ENTITY, @DISCOVERTYPE_DYNAMICS_365_INSTANCE) THEN ua.query('groups')
				WHEN @discoverByType = @DISCOVERTYPE_TEAM THEN ua.query('msTeamsInfo')
				ELSE ua.query('EVGui_SharePointItem') END xmlGeneric,
				@planId,
				@accountStatus
			FROM @i_xmlString.nodes ('Ida_UpdateCloudAppPolicyAssociationReq/cloudAppAssociation/cloudAppDiscoverinfo') R(ref)
			CROSS APPLY ref.nodes('./userAccounts') I(ua)
			DELETE T FROM #cloudAppConfiguration_XMLDetailsTable T
			WHERE userGuid IS NULL OR LEN(userGUID) = 0
		IF @isSharePointDiscoveryType=1 AND @planId<>0
		BEGIN
			-- 3/27/2020, OVK: Get reference @userAssocId and @oldPlanId
			INSERT INTO #RequestedUserAssocPlans -- 6/24/2020, OVK: Multiple records request - place into table
			SELECT DISTINCT A.userGUID,A.userAssocId,A.planId
			FROM APP_CloudAppUserDetails A (NOLOCK)
				JOIN #cloudAppConfiguration_XMLDetailsTable T ON T.userGUID=A.userGUID
					AND T.discoverByType=A.discoverByType
			WHERE A.modified=0 AND A.subClientId=@subClientId
		END
		-- 5/14/2020, OVK: Auto-correct planId/accountStatus for "existing records" if @requestPlanId/requestAccountStatus IS NULL
		IF (@requestPlanId IS NULL OR @requestPlanId = -1 OR @requestAccountStatus IS NULL)
		BEGIN
			UPDATE #cloudAppConfiguration_XMLDetailsTable
			SET planId=(CASE WHEN @requestPlanId IS NULL  OR @requestPlanId = -1
				THEN A.planId
				ELSE #cloudAppConfiguration_XMLDetailsTable.planId END)
				,accountStatus=(CASE WHEN @requestAccountStatus IS NULL
					THEN A.[status]
					ELSE #cloudAppConfiguration_XMLDetailsTable.accountStatus END)
			FROM APP_CloudAppUserDetails A (NOLOCK)
			WHERE A.modified=0 AND A.subClientId=@subClientId
				AND #cloudAppConfiguration_XMLDetailsTable.userGUID=A.userGUID
				AND #cloudAppConfiguration_XMLDetailsTable.discoverByType=A.discoverByType
		END
		/* 3/3/2020, OVK: For SharePoint manually added - find & associate children */
		IF @discoverByType=@DISCOVERTYPE_ASSOCIATED_SHAREPOINT_WEB_SITES
		BEGIN
			DECLARE @flags0 int,@isAutoDiscoveredUser0 int;
			SELECT TOP 1 @flags0=commonFlags,@isAutoDiscoveredUser0=isAutoDiscoveredUser FROM #cloudAppConfiguration_XMLDetailsTable;
			IF @flags0&@SP_CONTENT_NOT_ASSOCIATED=0 AND @isAutoDiscoveredUser0=0 -- meaning association being set AND manually (from GUI)
			BEGIN
				-- Propagate association to childrens, use Url matching, limit to subclient!
				INSERT INTO #cloudAppConfiguration_XMLDetailsTable (userGUID, displayName, aliasName, smtpAddress,discoverByType, isAutoDiscoveredUser,
					commonFlags, userAccountSize,
					itemtype, ParentWebGuid,ItemClassification,BackupSetId,xmlGeneric, planId, accountStatus)
				SELECT userGUID, displayName, aliasName, smtpAddress,discoverByType, isAutoDiscovered,
					((flags & ~@SP_CONTENT_NOT_ASSOCIATED)|@SP_ASSOCIATED_BY_PARENT), userAccountSize,
					itemtype, ParentWebGuid,ItemClassification,BackupSetId,xmlGeneric, planId, [status]
				FROM APP_CloudAppUserDetails (NOLOCK)
				WHERE userAssocId IN (
					SELECT DISTINCT RT.userAssocId -- Distinct needed when parent and children selected manually already
					FROM #cloudAppConfiguration_XMLDetailsTable XT
						JOIN APP_CloudAppUserDetails RT (NOLOCK) ON RT.subClientId=@subClientId
							AND RT.modified=0
							AND RT.isAutoDiscovered=1
							AND (RT.flags&@SP_CONTENT_NOT_ASSOCIATED)!=0 -- Not associated yet
							AND RT.aliasName=XT.aliasName -- the same site collection
							AND RT.userGUID<>XT.userGUID
							AND LEN(RT.smtpAddress)>LEN(XT.smtpAddress)
							AND SUBSTRING(RT.smtpAddress,1,LEN(XT.smtpAddress)+1)=XT.smtpAddress + '/'
						LEFT JOIN #cloudAppConfiguration_XMLDetailsTable XT2 ON XT2.smtpAddress=RT.smtpAddress
						WHERE XT2.userGUID IS NULL
						)
			END
			-- Auto correct @SP_ASSOCIATED_BY_PARENT=0, when @SP_CONTENT_NOT_ASSOCIATED is set
			UPDATE #cloudAppConfiguration_XMLDetailsTable
			SET commonFlags = (commonFlags & ~@SP_ASSOCIATED_BY_PARENT)
			WHERE (commonFlags&@SP_CONTENT_NOT_ASSOCIATED)<>0
		END
	END
	ELSE
	IF @discoverByType IN (@DISCOVERTYPE_GROUPS,@DISCOVERTYPE_ALL_USERS,@DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_ALL_SHAREPOINT_WEB_SITES,@DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_SHAREPOINT_TEAM_SITES,@DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_PROJECT_ONLINE_SITES, @DISCOVERTYPE_ALL_TEAMS, @DISCOVERTYPE_ALL_DYNAMICS_365_INSTANCES, @DISCOVERTYPE_DYNAMICS_365_INSTANCE)
	BEGIN
		INSERT #cloudAppConfiguration_XMLDetailsTable (userGUID, displayName,discoverByType,planId, accountStatus)
			SELECT
				ISNULL(gr.value('@id','NVARCHAR(MAX)'), '') userGUID,
				gr.value('@name','NVARCHAR(MAX)') displayName,
				ref.value('@discoverByType', 'INT') discoverByType,
				@planId,
				@accountStatus
			FROM @i_xmlString.nodes ('Ida_UpdateCloudAppPolicyAssociationReq/cloudAppAssociation/cloudAppDiscoverinfo') R(ref)
			CROSS APPLY ref.nodes('./groups') O(gr)
		IF @isSharePointDiscoveryType=1 AND @planId<>0
		BEGIN
			-- 3/27/2020, OVK: Get reference @userAssocId and @oldPlanId
			INSERT INTO #RequestedUserAssocPlans -- 6/24/2020, OVK: Multiple records request - place into table
			SELECT DISTINCT A.userGUID,A.userAssocId,A.planId
			FROM APP_CloudAppUserDetails A (NOLOCK)
				JOIN #cloudAppConfiguration_XMLDetailsTable T ON T.userGUID=A.userGUID
					AND T.discoverByType=A.discoverByType
			WHERE A.modified=0 AND A.subClientId=@subClientId
		END
		-- 8/5/2020, OVK: Auto-correct planId/accountStatus for "existing records" (categories) if @requestPlanId/requestAccountStatus IS NULL
		IF (@requestPlanId IS NULL OR @requestPlanId = -1 OR @requestAccountStatus IS NULL)
		BEGIN
			UPDATE #cloudAppConfiguration_XMLDetailsTable
			SET planId=(CASE WHEN @requestPlanId IS NULL  OR @requestPlanId = -1
				THEN A.planId
				ELSE #cloudAppConfiguration_XMLDetailsTable.planId END)
				,accountStatus=(CASE WHEN @requestAccountStatus IS NULL
					THEN A.[status]
					ELSE #cloudAppConfiguration_XMLDetailsTable.accountStatus END)
			FROM APP_CloudAppUserDetails A (NOLOCK)
			WHERE A.modified=0 AND A.subClientId=@subClientId
				AND #cloudAppConfiguration_XMLDetailsTable.userGUID=A.userGUID -- 8/5/20, OVK: For categories, userGUID is the same, but displayName/discoverByType differ
				AND #cloudAppConfiguration_XMLDetailsTable.displayName=A.displayName
				AND #cloudAppConfiguration_XMLDetailsTable.discoverByType=A.discoverByType
		END
	END
	ELSE
	IF @discoverByType = @DISCOVERTYPE_BROWSE_FOLDERS
	BEGIN
		INSERT #cloudAppConfiguration_XMLDetailsTable (userGUID, displayName, discoverByType,planId, accountStatus)
			SELECT
				fd.value('@folderId','NVARCHAR(MAX)') userGUID,
				fd.value('@folderTitle','NVARCHAR(MAX)') displayName,
				ref.value('@discoverByType', 'INT') discoverByType,
				@planId,
				@accountStatus
			FROM @i_xmlString.nodes ('Ida_UpdateCloudAppPolicyAssociationReq/cloudAppAssociation/cloudAppDiscoverinfo') R(ref)
			CROSS APPLY ref.nodes('./folders') O(fd)
	END
	INSERT INTO #cloudAppConfiguration_DetailsCompareTable (userAssocId,userGUID, displayName, aliasName, smtpAddress,discoverByType, isAutoDiscoveredUser,commonFlags,
			itemtype, ParentWebGuid,ItemClassification,BackupSetId, xmlGeneric,planId, accountStatus,Deleted)
			SELECT CD.userAssocId,CD.userGUID,CD.displayName,CD.aliasName,CD.smtpAddress,CD.discoverByType,CD.isAutoDiscovered,CD.flags,
			CD.itemType,CD.ParentWebGuid,CD.ItemClassification,CD.BackupSetId,CD.xmlGeneric,CD.planId,CD.status,0
			FROM #cloudAppConfiguration_XMLDetailsTable XDT
			JOIN APP_CloudAppUserDetails (READUNCOMMITTED) CD ON CD.modified = 0 AND CD.subClientId = @subClientId AND XDT.discoverByType = CD.discoverByType
			AND ((XDT.discoverByType IN (@DISCOVERTYPE_BROWSE_FOLDERS,@DISCOVERTYPE_GROUPS,@DISCOVERTYPE_USER,@DISCOVERTYPE_ASSOCIATED_SHAREPOINT_WEB_SITES, @DISCOVERTYPE_TEAM, @DISCOVERTYPE_DYNAMICS_365_ENTITY, @DISCOVERTYPE_DYNAMICS_365_INSTANCE) AND LEN(XDT.userGUID)>0 AND CD.userGUID = XDT.userGUID)
				OR (XDT.discoverByType IN (@DISCOVERTYPE_ALL_USERS,@DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_ALL_SHAREPOINT_WEB_SITES,@DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_SHAREPOINT_TEAM_SITES,@DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_PROJECT_ONLINE_SITES, @DISCOVERTYPE_ALL_TEAMS, @DISCOVERTYPE_ALL_DYNAMICS_365_INSTANCES) AND CD.displayName = XDT.displayName))
	IF @discoverByType IN (@DISCOVERTYPE_USER,@DISCOVERTYPE_ASSOCIATED_SHAREPOINT_WEB_SITES, @DISCOVERTYPE_TEAM, @DISCOVERTYPE_DYNAMICS_365_ENTITY, @DISCOVERTYPE_DYNAMICS_365_INSTANCE)
	BEGIN
		DELETE #cloudAppConfiguration_XMLDetailsTable
		FROM #cloudAppConfiguration_DetailsCompareTable CT
		JOIN #cloudAppConfiguration_XMLDetailsTable XT ON CT.userGUID = XT.userGUID AND CT.displayName = XT.displayName
			AND (CT.aliasName = XT.aliasName OR ((CT.aliasName IS NULL OR LEN(CT.aliasName) = 0 ) AND (XT.aliasName IS NULL OR LEN(XT.aliasName) = 0))) AND CT.smtpAddress = XT.smtpAddress
			AND CT.discoverByType = XT.discoverByType AND CT.isAutoDiscoveredUser = XT.isAutoDiscoveredUser AND CT.commonFlags = XT.commonFlags
			AND CT.itemtype = XT.itemtype AND CT.ParentWebGuid = XT.ParentWebGuid AND CT.ItemClassification = XT.ItemClassification AND CT.BackupSetId = XT.BackupSetId AND CAST(CT.xmlGeneric AS nvarchar(MAX)) = CAST(XT.xmlGeneric AS nvarchar(MAX))
			AND CT.accountStatus = XT.accountStatus AND CT.planId = XT.planId
	END
	ELSE
	BEGIN
		DELETE #cloudAppConfiguration_XMLDetailsTable
		FROM #cloudAppConfiguration_DetailsCompareTable CT
		JOIN #cloudAppConfiguration_XMLDetailsTable XT ON CT.displayName = XT.displayName AND CT.discoverByType = XT.discoverByType
		AND CT.accountStatus = XT.accountStatus AND CT.planId = XT.planId
		AND ((CT.discoverByType IN (@DISCOVERTYPE_BROWSE_FOLDERS,@DISCOVERTYPE_GROUPS, @DISCOVERTYPE_DYNAMICS_365_INSTANCE) AND (CT.userGUID = XT.userGUID))
			OR (CT.userGUID IS NULL AND XT.userGUID IS NULL) OR (LEN(CT.userGUID)=0 AND LEN(XT.userGUID)=0))
	END
	UPDATE #cloudAppConfiguration_XMLDetailsTable
	SET bkpRefTime = ISNULL(CD.backupReferenceTime,0),
		nItems = ISNULL(CD.numberOfItems,0),
		userAccountSize = ISNULL(CD.userAccountSize,0),
		IdxColTime =ISNULL(CD.IdxCollectionTime,0)
		FROM APP_CloudAppUserDetails CD
		WHERE CD.modified = 0 AND LEN(#cloudAppConfiguration_XMLDetailsTable.userGUID) > 0
			AND #cloudAppConfiguration_XMLDetailsTable.userGUID = CD.userGUID
			AND CD.subClientId = @subClientId AND CD.discoverByType = @discoverByType
BEGIN TRAN
	IF @discoverByType IN (@DISCOVERTYPE_USER,@DISCOVERTYPE_ASSOCIATED_SHAREPOINT_WEB_SITES, @DISCOVERTYPE_TEAM, @DISCOVERTYPE_DYNAMICS_365_ENTITY, @DISCOVERTYPE_DYNAMICS_365_INSTANCE)
	BEGIN
		UPDATE APP_CloudAppUserDetails
		SET modified = @nowUtcUnix,
		status = (CASE WHEN @isSharePointDiscoveryType = 1 THEN @accountStatus ELSE status END )
		FROM #cloudAppConfiguration_XMLDetailsTable XDT
		WHERE APP_CloudAppUserDetails.modified = 0 AND APP_CloudAppUserDetails.userGUID = XDT.userGUID
			AND APP_CloudAppUserDetails.discoverByType = XDT.discoverByType AND APP_CloudAppUserDetails.subClientId = @subClientId
		SET @errorCode = @@ERROR
		IF @errorCode != 0
			BEGIN
				GOTO ERROR
			END
		MERGE APP_CloudAppUserDetails CAD
		USING
		(
			SELECT C.* FROM  #cloudAppConfiguration_XMLDetailsTable C
		) AS PA ON  CAD.userGUID = PA.userGUID AND CAD.subClientId = @subclientId AND CAD.discoverByType = PA.discoverByType AND  CAD.modified = 0
		WHEN NOT MATCHED THEN
			INSERT (userGUID,displayName,aliasName,smtpAddress,discoverByType,isAutoDiscovered,subClientId,planId,created,modified,status,flags,userAccountSize,
					xmlGeneric,itemType,ParentWebGuid,BackupSetId,ItemClassification,backupReferenceTime,IdxCollectionTime,numberOfItems)
			VALUES(PA.userGUID,PA.displayName,PA.aliasName,PA.smtpAddress,PA.discoverByType,PA.isAutoDiscoveredUser,@subClientId,PA.planId,@nowUtcUnix,0,PA.accountStatus,PA.commonFlags,PA.userAccountSize,
					PA.xmlGeneric,PA.itemType,PA.ParentWebGuid,
					CASE WHEN PA.discoverByType IN( @DISCOVERTYPE_USER, @DISCOVERTYPE_TEAM, @DISCOVERTYPE_DYNAMICS_365_ENTITY, @DISCOVERTYPE_DYNAMICS_365_INSTANCE) THEN @backupSetId ELSE PA.BackupSetId END,
					PA.ItemClassification, PA.bkpRefTime, PA.IdxColTime, PA.nItems)
			OUTPUT	INSERTED.userAssocId, INSERTED.userGuid,INSERTED.displayName INTO #output_PolicyAssocTable;
		SET @errorCode = @@ERROR
		IF @errorCode != 0
			BEGIN
				GOTO ERROR
			END
		UPDATE #cloudAppConfiguration_DetailsCompareTable SET userAssocId = OT.assocId
		FROM #output_PolicyAssocTable OT
		WHERE #cloudAppConfiguration_DetailsCompareTable.userGUID = OT.userGuid
		SET @errorCode = @@ERROR
		IF @errorCode != 0
			BEGIN
				GOTO ERROR
			END
	END
	ELSE IF @discoverByType IN (@DISCOVERTYPE_BROWSE_FOLDERS,@DISCOVERTYPE_GROUPS, @DISCOVERTYPE_DYNAMICS_365_INSTANCE)
	BEGIN
		UPDATE APP_CloudAppUserDetails
		SET status = XT.accountStatus, planId = XT.planId, isAutoDiscovered = XT.isAutoDiscoveredUser, displayName = XT.displayName,BackupSetId = @backupSetId,flags = XT.commonFlags, modified = @nowUtcUnix
		FROM #cloudAppConfiguration_XMLDetailsTable XT
		JOIN APP_CloudAppUserDetails CAD ON CAD.modified = 0 AND CAD.userGUID = XT.userGUID AND CAD.subClientId = @subClientId AND CAD.discoverByType = XT.discoverByType
		SET @errorCode = @@ERROR
		IF @errorCode != 0
			BEGIN
				GOTO ERROR
			END
		MERGE APP_CloudAppUserDetails CAD
		USING
		(
			SELECT C.* FROM  #cloudAppConfiguration_XMLDetailsTable C
		) AS PA ON  CAD.userGUID = PA.userGUID AND CAD.subClientId = @subclientId AND CAD.discoverByType = PA.discoverByType AND  CAD.modified = 0
		WHEN NOT MATCHED THEN
			INSERT (userGUID,displayName,aliasName,smtpAddress,discoverByType,isAutoDiscovered,subClientId,planId,created,modified,status,flags,userAccountSize,
					xmlGeneric,itemType,ParentWebGuid,BackupSetId,ItemClassification,backupReferenceTime,IdxCollectionTime,numberOfItems)
			VALUES(PA.userGUID,PA.displayName,PA.aliasName,PA.smtpAddress,PA.discoverByType,PA.isAutoDiscoveredUser,@subClientId,PA.planId,@nowUtcUnix,0,PA.accountStatus,PA.commonFlags,PA.userAccountSize,
					PA.xmlGeneric,PA.itemType,PA.ParentWebGuid,
					CASE WHEN PA.discoverByType IN( @DISCOVERTYPE_BROWSE_FOLDERS,@DISCOVERTYPE_GROUPS, @DISCOVERTYPE_DYNAMICS_365_INSTANCE) THEN @backupSetId ELSE PA.BackupSetId END,
					PA.ItemClassification, PA.bkpRefTime, PA.IdxColTime, PA.nItems);
		SET @errorCode = @@ERROR
		IF @errorCode != 0
			BEGIN
				GOTO ERROR
			END
	END
	ELSE
	BEGIN
		UPDATE APP_CloudAppUserDetails
		SET status = XT.accountStatus, planId = XT.planId,BackupSetId = @backupSetId,flags = XT.commonFlags
		FROM #cloudAppConfiguration_XMLDetailsTable XT
		JOIN APP_CloudAppUserDetails CAD ON CAD.modified = 0 AND CAD.displayName = XT.displayName AND CAD.subClientId = @subClientId AND CAD.discoverByType = XT.discoverByType
		SET @errorCode = @@ERROR
		IF @errorCode != 0
			BEGIN
				GOTO ERROR
			END
	END
	-- 8/17/2020, OVK: Consider only SiteCollection ItemClassification for category match
	IF @discoverByType IN (@DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_ALL_SHAREPOINT_WEB_SITES,@DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_SHAREPOINT_TEAM_SITES,@DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_PROJECT_ONLINE_SITES) AND @requestAccountStatus IS NOT NULL
	BEGIN
		IF object_id('tempdb.dbo.#SharePointClassifications') is not null
				DROP TABLE #SharePointClassifications
		CREATE TABLE #SharePointClassifications (userAssocId int, SiteCollectionClassification int, itemClassification int, smtpAddress nvarchar(255), aliasName nvarchar(255));
		INSERT INTO #SharePointClassifications
		SELECT userAssocId, NULL as SiteCollectionClassification, ItemClassification, smtpAddress, aliasName
		FROM APP_CloudAppUserDetails (nolock)
		WHERE modified = 0 AND isAutoDiscovered = 1 AND subClientId = @subClientId AND discoverByType = @DISCOVERTYPE_ASSOCIATED_SHAREPOINT_WEB_SITES
		UPDATE #SharePointClassifications
		SET SiteCollectionClassification=T.itemClassification
		FROM (SELECT aliasName,itemClassification FROM #SharePointClassifications WHERE aliasName=smtpAddress) as T
		WHERE #SharePointClassifications.aliasName=T.aliasName
	END
	IF @discoverByType IN (@DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_ALL_SHAREPOINT_WEB_SITES,@DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_SHAREPOINT_TEAM_SITES,@DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_PROJECT_ONLINE_SITES) AND @accountStatus = 0  AND @requestAccountStatus IS NOT NULL -- 8/5/2020, OVK
	BEGIN
		UPDATE APP_CloudAppUserDetails
		SET flags = (flags & ~(@SP_CONTENT_NOT_ASSOCIATED))
		FROM #SharePointClassifications
		WHERE modified = 0 AND isAutoDiscovered = 1 AND subClientId = @subClientId AND discoverByType = @DISCOVERTYPE_ASSOCIATED_SHAREPOINT_WEB_SITES
			AND #SharePointClassifications.userAssocId=APP_CloudAppUserDetails.userAssocId
			AND (flags & @SP_CONTENT_NOT_ASSOCIATED) = @SP_CONTENT_NOT_ASSOCIATED
			AND
			( /* 3/2/2020, OVK: Enabled @DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_ALL_SHAREPOINT_WEB_SITES covers ALL Webs regardless of ItemClassification. */
				(@discoverByType = @DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_ALL_SHAREPOINT_WEB_SITES /*AND ItemClassification = @SPItemClassification_REGULAR*/)
				OR
				(@discoverByType = @DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_SHAREPOINT_TEAM_SITES AND #SharePointClassifications.SiteCollectionClassification = @SPItemClassification_TEAM)
				OR
				(@discoverByType = @DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_PROJECT_ONLINE_SITES AND #SharePointClassifications.SiteCollectionClassification = @SPItemClassification_ONLINE))
	END
	IF @discoverByType IN (@DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_ALL_SHAREPOINT_WEB_SITES,@DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_SHAREPOINT_TEAM_SITES,@DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_PROJECT_ONLINE_SITES) AND @accountStatus <> 0  AND @requestAccountStatus IS NOT NULL -- 8/5/2020, OVK
	BEGIN
		/* 3/2/2020, OVK: When disabling categories must check if item still matches some other enabled category */
		DECLARE @isAllWebsEnabled int = (SELECT CASE WHEN [status]=0 THEN 1 ELSE 0 END
			FROM APP_CloudAppUserDetails (NOLOCK)
			WHERE  modified = 0 AND  subClientId = @subClientId AND discoverByType = @DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_ALL_SHAREPOINT_WEB_SITES);
		DECLARE @isTeamsEnabled int = (SELECT CASE WHEN [status]=0  THEN 1 ELSE 0 END
			FROM APP_CloudAppUserDetails (NOLOCK)
			WHERE  modified = 0 AND  subClientId = @subClientId AND discoverByType = @DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_SHAREPOINT_TEAM_SITES);
		DECLARE @isProjectsEnabled int = (SELECT CASE WHEN [status]=0  THEN 1 ELSE 0 END
			FROM APP_CloudAppUserDetails (NOLOCK)
			WHERE  modified = 0 AND  subClientId = @subClientId AND discoverByType = @DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_PROJECT_ONLINE_SITES);
		IF @discoverByType = @DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_ALL_SHAREPOINT_WEB_SITES
			SET @isAllWebsEnabled=0;
		IF @discoverByType = @DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_SHAREPOINT_TEAM_SITES
			SET @isTeamsEnabled=0;
		IF @discoverByType = @DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_PROJECT_ONLINE_SITES
			SET @isProjectsEnabled=0;
		-- 9/21/2020, OVK: Accomodate for No default categories
		SET @isAllWebsEnabled=ISNULL(@isAllWebsEnabled,0);
		SET @isTeamsEnabled=ISNULL(@isTeamsEnabled,0);
		SET @isProjectsEnabled=ISNULL(@isProjectsEnabled,0);
		UPDATE APP_CloudAppUserDetails
		SET flags = (flags | @SP_CONTENT_NOT_ASSOCIATED)
		FROM #SharePointClassifications
		WHERE modified = 0 AND isAutoDiscovered = 1 AND  subClientId = @subClientId AND discoverByType = @DISCOVERTYPE_ASSOCIATED_SHAREPOINT_WEB_SITES
			AND #SharePointClassifications.userAssocId=APP_CloudAppUserDetails.userAssocId
			AND (flags & @SP_CONTENT_NOT_ASSOCIATED) != @SP_CONTENT_NOT_ASSOCIATED
			AND
			((@discoverByType = @DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_ALL_SHAREPOINT_WEB_SITES /* AND ItemClassification = @SPItemClassification_REGULAR*/)
				OR
				(@discoverByType = @DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_SHAREPOINT_TEAM_SITES AND #SharePointClassifications.SiteCollectionClassification = @SPItemClassification_TEAM)
				OR
				(@discoverByType = @DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_PROJECT_ONLINE_SITES AND #SharePointClassifications.SiteCollectionClassification = @SPItemClassification_ONLINE))
			AND NOT (
					(@isTeamsEnabled=1 AND #SharePointClassifications.SiteCollectionClassification = @SPItemClassification_TEAM)
				OR (@isProjectsEnabled=1 AND #SharePointClassifications.SiteCollectionClassification = @SPItemClassification_ONLINE)
				OR (@isAllWebsEnabled=1)
			)
			AND (flags&@SP_ASSOCIATED_BY_PARENT)=0 -- Disabling category should not clear association for Associated by parent (added manually)
	END
	IF object_id('tempdb.dbo.#SharePointClassifications') is not null
		DROP TABLE #SharePointClassifications
	DECLARE @maxRequestedId int = ISNULL((SELECT MAX(id) FROM #RequestedUserAssocPlans),0);
	IF @isSharePointDiscoveryType=1 AND @planId<>0 AND @maxRequestedId>0
	BEGIN
		-- 6/24/20, OVK: Loop thru table #RequestedUserAssocPlans
		DECLARE @requestedId int = 1;
		WHILE @requestedId<=@maxRequestedId
		BEGIN
			DECLARE @userAssocId int = NULL, @oldPlanId int = NULL, @userGUID varchar(100)=NULL;
			SELECT TOP 1 @userAssocId=userAssocId,@oldPlanId=oldPlanId,@userGUID=userGUID
			FROM #RequestedUserAssocPlans
			WHERE id=@requestedId
			PRINT 'Processing RequestedId: ' + CAST(@requestedId as varchar(10));
			SET @requestedId = @requestedId + 1;
			IF @oldPlanId<>@planId AND @userAssocId IS NOT NULL
			BEGIN
				-- 4/22/20, OVK: Refresh @userAssocId as new record could be inserted above
				DECLARE @newUserAssocId int = @userAssocId;
				SELECT TOP 1 @newUserAssocId=A.userAssocId
				FROM APP_CloudAppUserDetails A (NOLOCK)
						JOIN APP_CloudAppUserDetails B (NOLOCK) ON B.userGUID=A.userGUID
							AND B.discoverByType=A.discoverByType AND B.subClientId=A.subClientId
				WHERE A.modified=0 AND A.subClientId=@subClientId AND B.userAssocId=@userAssocId
				ORDER BY A.userAssocId DESC -- MAX - latest record;
				IF @newUserAssocId<>@userAssocId
				BEGIN
						PRINT 'UserAssocId changed to ' + CAST(@newUserAssocId as varchar(10)) + ' from ' + CAST(@userAssocId as varchar(10));
						SET @userAssocId = @newUserAssocId;
				END
				PRINT 'SharePoint Cascade call pending: userAssocId=' + CAST(@userAssocId as varchar(10));
				EXEC dbo.AppCloudAppsCascadeSPO365Plan @userAssocId,@planId,0,NULL, @errorCode out
				-- Don't fail whole stored proc on error, client side will call AppCloudAppsCascadeSPO365Plan in reconcile mode each 24 hours.
			END
		END
	END
	-- 8/5/2020, OVK: Force reconciliation for enabling/disabling category
	IF @discoverByType IN (@DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_ALL_SHAREPOINT_WEB_SITES,@DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_SHAREPOINT_TEAM_SITES,@DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_PROJECT_ONLINE_SITES) AND @requestAccountStatus IS NOT NULL
	BEGIN
		EXEC dbo.AppCloudAppsCascadeSPO365Plan NULL,NULL,1,@subClientId, @errorCode out
	END
ERROR:
IF @errorCode <>0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
ERROR_EXIT:
	SET @o_xmlString =
	(
		SELECT
		(SELECT @errorCode '@errorCode',
				@errorString '@errorMessage'
				FOR XML PATH ('resp'),TYPE
				)
			FOR XML PATH(''),ROOT('Ida_CloudAppAssociationsResp')
	)
	SELECT @o_xmlString
	IF object_id('tempdb.dbo.#cloudAppConfiguration_XMLDetailsTable') is not null
         DROP TABLE #cloudAppConfiguration_XMLDetailsTable
	IF object_id('tempdb.dbo.#PoliciesTable') is not null
		DROP TABLE #PoliciesTable
	IF object_id('tempdb.dbo.#cloudAppConfiguration_DetailsCompareTable') is not null
		DROP TABLE #cloudAppConfiguration_DetailsCompareTable
	IF object_id('tempdb.dbo.#output_PolicyAssocTable') is not null
		DROP TABLE #output_PolicyAssocTable
	IF object_id('tempdb.dbo.#RequestedUserAssocPlans') is not null
		DROP TABLE #RequestedUserAssocPlans
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppCloudAppConfigPolicyAssocUpdateInfo')
	delete from GxQscripts where name = 'AppCloudAppConfigPolicyAssocUpdateInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCloudAppConfigPolicyAssocUpdateInfo')
	delete from GXDBVersions where aliasname = 'AppCloudAppConfigPolicyAssocUpdateInfo'
GO

insert into GXDBVersions values(2, 'AppCloudAppConfigPolicyAssocUpdateInfo',  '00000000000000000000', 'AppCloudAppConfigPolicyAssocUpdateInfo', '00000000000000000000')
GO

