

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCloudAppConfigPolicyAssocSetInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  				AppCloudAppConfigPolicyAssocSetInfo					|
--	| Procedure for create/update a APP_CloudAppConfigPolicyAssoc table	|
--	+===================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppCloudAppConfigPolicyAssocSetInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppCloudAppConfigPolicyAssocSetInfo <<<'
	drop procedure AppCloudAppConfigPolicyAssocSetInfo
END
IF EXISTS (select * from GxQscripts where name='AppCloudAppConfigPolicyAssocSetInfo')
	delete from GxQscripts where name = 'AppCloudAppConfigPolicyAssocSetInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCloudAppConfigPolicyAssocSetInfo')
	delete from GXDBVersions where aliasname = 'AppCloudAppConfigPolicyAssocSetInfo'
GO
print '... Creating Procedure: AppCloudAppConfigPolicyAssocSetInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppCloudAppConfigPolicyAssocSetInfo
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE	@o_xmlString		XML
	DECLARE @errorCode			INT = 0
	DECLARE @errorString		NVARCHAR(MAX) = ''
	DECLARE @nowTime			DATETIME = GETDATE()
	DECLARE @nowUtcTime			DATETIME = GETUTCDATE()
	DECLARE @nowUtcUnix			INT = DATEDIFF(second, '01/01/1970', @nowUtcTime)
	DECLARE @accountStatus		INT = 0
	DECLARE @subClientId		INT = 0
	DECLARE @backupSetId		INT = 0
	DECLARE @instanceId			INT = 0
	DECLARE @instanceType		INT = 0
	DECLARE @clientId			INT = 0
	DECLARE @policyComponentId	INT = 0
	DECLARE @planId				INT = 0
	DECLARE @discovered			INT = 0
	DECLARE @appTypeId			INT = 0
	DECLARE @userId				INT = 0
	DECLARE @discoverByType		INT = 0
DECLARE @brAlertTrace	 AS varchar(255)               = (select value from gxglobalParam (NOLOCK) Where name = 'bralertTrace')
	DECLARE @dateTime		AS DATETIME = getDate()							-- Common Date/Time Stamp for everything done here
	DECLARE @DISCOVERTYPE_USER													INT = 1
	DECLARE @DISCOVERTYPE_GROUPS												INT = 2
	DECLARE @DISCOVERTYPE_BROWSE_FOLDERS										INT = 3
	DECLARE @DISCOVERTYPE_ALL_USERS												INT = 4
	DECLARE @DISCOVERTYPE_AUTO_DISCOVER_ASSOCIATIONS							INT = 5
	DECLARE @DISCOVERTYPE_ASSOCIATED_SHAREPOINT_WEB_SITES						INT = 6
	DECLARE @DISCOVERTYPE_ALL_SHAREPOINT_WEB_SITES								INT = 7
	DECLARE @DISCOVERTYPE_AUTO_DISCOVERED_SHAREPOINT							INT = 8
	DECLARE @DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_ALL_SHAREPOINT_WEB_SITES	INT = 9
	DECLARE @DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_SHAREPOINT_TEAM_SITES		INT = 10
	DECLARE @DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_PROJECT_ONLINE_SITES		INT = 11
	DECLARE @DISCOVERTYPE_TEAM													INT = 12
	DECLARE @DISCOVERTYPE_ALL_TEAMS												INT = 13
	DECLARE @DISCOVERTYPE_DYNAMICS_365_ENTITY									INT = 14
	DECLARE @DISCOVERTYPE_DYNAMICS_365_INSTANCE									INT = 15
	DECLARE @DISCOVERTYPE_ALL_DYNAMICS_365_INSTANCES							INT = 16
	DECLARE @POLICY_TYPE_ARCHIVE			INT = 1
	DECLARE @POLICY_TYPE_CLEANUP			INT = 2
	DECLARE @POLICY_TYPE_RETENTION			INT = 3
DECLARE @PLAN_PROP_ARCHIVE				VARCHAR(255) = 'Office 365 backup policy'
DECLARE @PLAN_PROP_CLEANUP				VARCHAR(255) = 'Office 365 cleanup policy'
DECLARE @PLAN_PROP_RETENTION			VARCHAR(255) = 'Office 365 retention policy'
	IF @brAlertTrace <> 0									-- Put a copy of input data to table TrackNotificationProcs
	BEGIN
		DECLARE @inputString		NVARCHAR(MAX) = CAST(@i_xmlString AS NVARCHAR(MAX))
		EXEC br_ntTrace '.. AppCloudAppConfigPolicyAssocSetInfo', 0, @nowTime, 0, 0, @inputString
	END
	SELECT
		@userId = ISNULL(ref.value('(processinginstructioninfo/user/@userId)[1]', 'INT'), @userId),
		@subClientId = ISNULL(ref.value('(cloudAppAssociation/subclientEntity/@subclientId)[1]', 'INT'), @subClientId),
		@discoverByType = ISNULL(ref.value('(cloudAppAssociation/cloudAppDiscoverinfo/@discoverByType)[1]', 'INT'), @discoverByType),
		@discovered = ISNULL(ref.value('@discovered', 'INT'), @discovered),
		@accountStatus = ISNULL(ref.value('(cloudAppAssociation/@accountStatus)[1]', 'INT'), @accountStatus),
		@planId	= ISNULL(ref.value('(cloudAppAssociation/plan/@planId)[1]', 'INT'), @planId),
		@appTypeId = ISNULL(ref.value('(cloudAppAssociation/subclientEntity/@applicationId)[1]', 'INT'), @appTypeId),
		@instanceId = ISNULL(ref.value('(cloudAppAssociation/subclientEntity/@instanceId)[1]', 'INT'), @instanceId),
		@backupSetId = ISNULL(ref.value('(cloudAppAssociation/subclientEntity/@backupsetId)[1]', 'INT'), @backupSetId),
		@clientId = ISNULL(ref.value('(cloudAppAssociation/subclientEntity/@clientId)[1]', 'INT'), @clientId)
	FROM @i_xmlString.nodes('Ida_SetCloudAppPolicyAssociationReq') R(ref)
	--CREATE TEMP TABLE TO INSERT XML INPUT
	IF object_id('tempdb.dbo.#cloudAppConfiguration_XMLDetailsTable') is not null
		DROP TABLE #cloudAppConfiguration_UserDetailsTable
	CREATE TABLE #cloudAppConfiguration_XMLDetailsTable
(userGUID VARCHAR(40) DEFAULT '', displayName NVARCHAR(255) NULL DEFAULT '', aliasName NVARCHAR(255) NULL DEFAULT '', smtpAddress NVARCHAR(255) NULL DEFAULT '',
			discoverByType INT NULL DEFAULT 0, isAutoDiscoveredUser INT NULL DEFAULT 0,commonFlags INT NULL DEFAULT 0, userAccountSize BIGINT NULL DEFAULT 0,
itemtype INT NULL DEFAULT 0, ParentWebGuid NVARCHAR(255) NULL DEFAULT '',ItemClassification INT NULL DEFAULT 0,BackupSetId INT NULL DEFAULT 0, xmlGeneric XML NULL DEFAULT '',
			planId INT NULL DEFAULT 0, accountStatus INT NULL DEFAULT 0)
	CREATE CLUSTERED INDEX #cloudAppConfiguration_XMLDetailsTable_userGuid_discoverByType_Index1 ON #cloudAppConfiguration_XMLDetailsTable ([userGuid], [discoverByType])
	IF object_id('tempdb.dbo.#PoliciesTable') is not null
		DROP TABLE #PoliciesTable
	CREATE TABLE #PoliciesTable
		(policyId INT, cloudAppPolicyType INT )
	IF object_id('tempdb.dbo.#output_PolicyAssocTable') is not null
		DROP TABLE #output_PolicyAssocTable
	CREATE TABLE #output_PolicyAssocTable
(assocId INT, userGuid VARCHAR(255),displayName NVARCHAR(255) NULL DEFAULT '')
	IF object_id('tempdb.dbo.#cloudAppConfiguration_DetailsCompareTable') is not null
		DROP TABLE #cloudAppConfiguration_DetailsCompareTable
	CREATE TABLE #cloudAppConfiguration_DetailsCompareTable
(userAssocId INT DEFAULT 0,userGUID VARCHAR(40) DEFAULT '', displayName NVARCHAR(255) NULL DEFAULT '', smtpAddress NVARCHAR(255) NULL DEFAULT '', discoverByType INT NULL DEFAULT 0)
	CREATE CLUSTERED INDEX #cloudAppConfiguration_DetailsCompareTable_userGuid_discoverByType_Index1 ON #cloudAppConfiguration_DetailsCompareTable ([userGuid], [discoverByType])
	IF @planId > 0
	BEGIN
		INSERT INTO #PoliciesTable
		SELECT CAST(attrVal AS INT) policyId,
			CASE attrName
				WHEN @PLAN_PROP_ARCHIVE THEN @POLICY_TYPE_ARCHIVE
				WHEN @PLAN_PROP_CLEANUP THEN @POLICY_TYPE_CLEANUP
				WHEN @PLAN_PROP_RETENTION THEN @POLICY_TYPE_RETENTION
			END policyType
		FROM App_PlanProp (NOLOCK)
			WHERE attrName IN (@PLAN_PROP_ARCHIVE, @PLAN_PROP_CLEANUP, @PLAN_PROP_RETENTION)
		AND componentNameId = @planId
AND attrType = 7
		AND modified = 0
	END
	ELSE
	BEGIN
		INSERT INTO #PoliciesTable
		SELECT pe.value('@policyId', 'INT') policyId, dt.value('@cloudAppPolicyType', 'INT') policyType
		FROM    @i_xmlString.nodes('Ida_SetCloudAppPolicyAssociationReq/cloudAppAssociation/policies/cloudAppPolicies') R(ref)
		CROSS APPLY ref.nodes('./detail/cloudAppPolicy') D(dt)
		CROSS APPLY ref.nodes('./policyEntity') P(pe)
	END
	IF @discoverByType IN (@DISCOVERTYPE_USER,@DISCOVERTYPE_ASSOCIATED_SHAREPOINT_WEB_SITES, @DISCOVERTYPE_TEAM, @DISCOVERTYPE_DYNAMICS_365_ENTITY, @DISCOVERTYPE_DYNAMICS_365_INSTANCE)
	BEGIN
		INSERT #cloudAppConfiguration_XMLDetailsTable (userGUID, displayName, aliasName, smtpAddress,discoverByType, isAutoDiscoveredUser,commonFlags, userAccountSize,
				itemtype, ParentWebGuid,ItemClassification,BackupSetId,xmlGeneric, planId, accountStatus)
			SELECT
				ISNULL(ua.value('user[1]/@userGUID', 'NVARCHAR(40)'), '') userGUID,
				ISNULL(ua.value('@displayName', 'NVARCHAR(MAX)'), '') displayName,
				ISNULL(ua.value('@aliasName', 'NVARCHAR(MAX)'), '') aliasName,
				ISNULL(ua.value('@smtpAddress', 'NVARCHAR(MAX)'), '') smtpAddress,
				ISNULL(ref.value('@discoverByType', 'INT'),0) discoverByType,
				ISNULL(ua.value('@isAutoDiscoveredUser', 'INT'),0) isAutoDiscoveredUser,
				ISNULL(ua.value('@commonFlags', 'INT'),0) commonFlags,
				ISNULL(ua.value('@accountSize','BIGINT'),0) userAccountSize,
				ISNULL(ua.value('@itemType', 'INT'), '') itemtype,
				ISNULL(ua.value('@ParentWebGuid', 'NVARCHAR(MAX)'), '') ParentWebGuid,
				ISNULL(ua.value('@ItemClassification', 'INT'),0) ItemClassification,
				ISNULL(ua.value('@BackupSetId', 'INT'),0) BackupSetId,
				--ua.value('@xmlGeneric', 'XML') xmlGeneric,
				CASE WHEN @discoverByType IN (@DISCOVERTYPE_USER, @DISCOVERTYPE_DYNAMICS_365_ENTITY, @DISCOVERTYPE_DYNAMICS_365_INSTANCE)  THEN ua.query('groups')
				WHEN @discoverByType = @DISCOVERTYPE_TEAM THEN ua.query('msTeamsInfo')
				ELSE ua.query('EVGui_SharePointItem') END xmlGeneric,
				@planId,
				@accountStatus
			FROM @i_xmlString.nodes ('Ida_SetCloudAppPolicyAssociationReq/cloudAppAssociation/cloudAppDiscoverinfo') R(ref)
			CROSS APPLY ref.nodes('./userAccounts') I(ua)
			DELETE T FROM #cloudAppConfiguration_XMLDetailsTable T
			WHERE userGuid IS NULL OR LEN(userGUID) = 0
		-- 8/4/2020, OVK: Use latest (by modified) Deleted matching UserGUID to inherit: planId (if @planId=0) & flags & isAutoDiscovered
		-- 8/18/2020, OVK: Only for SharePoint, in future consider if the scenario applicable to OneDrive.
		IF @accountStatus=0 AND @discoverByType=@DISCOVERTYPE_ASSOCIATED_SHAREPOINT_WEB_SITES
		BEGIN
			IF object_id('tempdb.dbo.#LatestDeleted') is not null
				DROP TABLE #LatestDeleted
			-- 9/23/2020, OVK: Ensure that status=1 records with the same Url have modified<>0
			UPDATE APP_CloudAppUserDetails
			SET modified=@nowUtcUnix
			FROM #cloudAppConfiguration_XMLDetailsTable
			WHERE APP_CloudAppUserDetails.status=1 and APP_CloudAppUserDetails.modified=0
				AND APP_CloudAppUserDetails.subClientId=@subClientId
				AND APP_CloudAppUserDetails.smtpAddress=#cloudAppConfiguration_XMLDetailsTable.smtpAddress
				AND APP_CloudAppUserDetails.userGUID<>#cloudAppConfiguration_XMLDetailsTable.userGUID -- 9/24/2020, OVK: Only for mismatching Guids
			-- 9/23/2020, OVK: Rely on smtpAddress (url) instead of UserGUID due to Guid generation changes.
			CREATE TABLE #LatestDeleted (smtpAddress nvarchar(255), flags INT, planId int, isAutoDiscovered int, RN int,
				userGUID varchar(40), userAccountSize bigint, backupReferenceTime int, numberOfItems bigint, IdxCollectionTime int);
			INSERT INTO #LatestDeleted
			SELECT CAD.smtpAddress,CAD.flags,CAD.planId,CAD.isAutoDiscovered
				,ROW_NUMBER() OVER (PARTITION BY CAD.smtpAddress ORDER BY CAD.modified DESC) as RN
				,CAD.userGUID,CAD.userAccountSize,CAD.backupReferenceTime,CAD.numberOfItems,CAD.IdxCollectionTime -- 9/24/2020, OVK
			FROM #cloudAppConfiguration_XMLDetailsTable T
				JOIN APP_CloudAppUserDetails CAD (nolock) ON CAD.smtpAddress=T.smtpAddress AND CAD.subClientId=@subClientId AND CAD.status=1
			DELETE FROM #LatestDeleted WHERE RN<>1
			-- Now apply latest deleted flags & planId & isAutoDiscovered
			UPDATE #cloudAppConfiguration_XMLDetailsTable
			SET commonFlags=#LatestDeleted.flags
				,planId=CASE WHEN @planId=0 THEN #LatestDeleted.planId ELSE @planId END
				,isAutoDiscoveredUser = #LatestDeleted.isAutoDiscovered
			FROM #LatestDeleted
			WHERE #cloudAppConfiguration_XMLDetailsTable.smtpAddress=#LatestDeleted.smtpAddress
			-- 9/24/2020, OVK: If Guid matches, then inherit - userAccountSize,backupReferenceTime,numberOfItems,IdxCollectionTime
			UPDATE #cloudAppConfiguration_XMLDetailsTable
			SET userAccountSize=#LatestDeleted.userAccountSize
				--backupReferenceTime=#LatestDeleted.backupReferenceTime,
				--numberOfItems=#LatestDeleted.numberOfItems,
				--IdxCollectionTime=#LatestDeleted.IdxCollectionTime
			FROM #LatestDeleted
			WHERE #cloudAppConfiguration_XMLDetailsTable.smtpAddress=#LatestDeleted.smtpAddress
			AND #cloudAppConfiguration_XMLDetailsTable.userGUID=#LatestDeleted.userGUID
			DROP TABLE #LatestDeleted
		END
	END
	ELSE
	IF @discoverByType IN (@DISCOVERTYPE_GROUPS,@DISCOVERTYPE_ALL_USERS,@DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_ALL_SHAREPOINT_WEB_SITES,@DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_SHAREPOINT_TEAM_SITES,@DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_PROJECT_ONLINE_SITES,@DISCOVERTYPE_ALL_TEAMS, @DISCOVERTYPE_ALL_DYNAMICS_365_INSTANCES)
	BEGIN
		INSERT #cloudAppConfiguration_XMLDetailsTable (userGUID, displayName,discoverByType,planId, accountStatus,isAutoDiscoveredUser)
			SELECT
				ISNULL(gr.value('@id','NVARCHAR(MAX)'), '') userGUID,
				gr.value('@name','NVARCHAR(MAX)') displayName,
				ref.value('@discoverByType', 'INT') discoverByType,
				@planId,
				@accountStatus,
				CASE WHEN @discoverByType IN( @DISCOVERTYPE_GROUPS, @DISCOVERTYPE_DYNAMICS_365_INSTANCE) THEN @discovered ELSE 1 END
			FROM @i_xmlString.nodes ('Ida_SetCloudAppPolicyAssociationReq/cloudAppAssociation/cloudAppDiscoverinfo') R(ref)
			CROSS APPLY ref.nodes('./groups') O(gr)
		IF @discoverByType IN (@DISCOVERTYPE_ALL_TEAMS, @DISCOVERTYPE_ALL_DYNAMICS_365_INSTANCES)
			BEGIN
				DECLARE @SubClientGUIDHashed VARCHAR(40) = ''
				DECLARE @DefaultAppendHashKey VARCHAR(40) = ''
				SET @SubClientGUIDHashed = ISNULL((SELECT TOP 1 userGuid FROM APP_CloudAppUserDetails where subClientId = @subClientId and discoverByType = @discoverByType),'')
				IF (@SubClientGUIDHashed IS NOT NULL AND @SubClientGUIDHashed != '')
					UPDATE #cloudAppConfiguration_XMLDetailsTable SET userGuid = @SubClientGUIDHashed
				ELSE
				BEGIN
					SET @DefaultAppendHashKey = CASE @discoverByType
					WHEN @DISCOVERTYPE_ALL_USERS THEN 'ONEDRIVE_DISCOVERTYPE_ALL_USERS'
					WHEN @DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_ALL_SHAREPOINT_WEB_SITES THEN 'DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_ALL_SHAREPOINT_WEB_SITES'
					WHEN @DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_SHAREPOINT_TEAM_SITES THEN 'DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_SHAREPOINT_TEAM_SITES'
					WHEN @DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_PROJECT_ONLINE_SITES THEN 'DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_PROJECT_ONLINE_SITES'
					WHEN @DISCOVERTYPE_ALL_TEAMS THEN 'DISCOVERTYPE_ALL_TEAMS'
					WHEN @DISCOVERTYPE_ALL_DYNAMICS_365_INSTANCES THEN 'DISCOVERTYPE_ALL_DYNAMICS_365_INSTANCES' END
					SET @SubClientGUIDHashed =
						(
							SELECT REPLACE(CONVERT(UNIQUEIDENTIFIER, HashBytes('MD5',@DefaultAppendHashKey+ CONVERT(VARCHAR(40),AA.GUID))),'-','X')
							FROM APP_Application (NOLOCK) AA
							WHERE AA.id = @subClientId --AND AA.appTypeId = @appTypeId
						)
					IF (@SubClientGUIDHashed IS NOT NULL AND @SubClientGUIDHashed != '')
						UPDATE #cloudAppConfiguration_XMLDetailsTable SET userGuid = @SubClientGUIDHashed
				END
		END
	END
	ELSE
	IF @discoverByType = @DISCOVERTYPE_BROWSE_FOLDERS
	BEGIN
		INSERT #cloudAppConfiguration_XMLDetailsTable (userGUID, displayName, discoverByType,planId, accountStatus,isAutoDiscoveredUser)
			SELECT
				fd.value('@folderId','NVARCHAR(MAX)') userGUID,
				fd.value('@folderTitle','NVARCHAR(MAX)') displayName,
				ref.value('@discoverByType', 'INT') discoverByType,
				@planId,
				@accountStatus,
				@discovered
			FROM @i_xmlString.nodes ('Ida_SetCloudAppPolicyAssociationReq/cloudAppAssociation/cloudAppDiscoverinfo') R(ref)
			CROSS APPLY ref.nodes('./folders') O(fd)
	END
	IF @discoverByType IN (@DISCOVERTYPE_BROWSE_FOLDERS,@DISCOVERTYPE_GROUPS,@DISCOVERTYPE_USER,@DISCOVERTYPE_ASSOCIATED_SHAREPOINT_WEB_SITES,@DISCOVERTYPE_TEAM ,@DISCOVERTYPE_DYNAMICS_365_ENTITY, @DISCOVERTYPE_DYNAMICS_365_INSTANCE)
	BEGIN
		INSERT INTO #cloudAppConfiguration_DetailsCompareTable (userAssocId,userGUID, displayName, smtpAddress, discoverByType)
		SELECT EA.userAssocId,EA.userGUID,EA.displayName,EA.smtpAddress,EA.discoverByType
		FROM
		(
			SELECT CUD.userAssocId,CUD.userGUID,CUD.displayName,CUD.smtpAddress,CUD.discoverByType
			FROM #cloudAppConfiguration_XMLDetailsTable AS TXD
			JOIN APP_CloudAppUserDetails (READUNCOMMITTED) AS CUD ON CUD.modified = 0 AND LEN(CUD.userGUID)>0 AND CUD.userGUID = TXD.userGUID AND CUD.discoverByType = TXD.discoverByType AND CUD.subClientId = @subClientId
		) EA
	END
BEGIN TRAN
BEGIN TRY
	IF @discoverByType IN (@DISCOVERTYPE_BROWSE_FOLDERS,@DISCOVERTYPE_GROUPS,@DISCOVERTYPE_USER,@DISCOVERTYPE_ASSOCIATED_SHAREPOINT_WEB_SITES, @DISCOVERTYPE_TEAM ,@DISCOVERTYPE_DYNAMICS_365_ENTITY, @DISCOVERTYPE_DYNAMICS_365_INSTANCE)
	BEGIN
		UPDATE APP_CloudAppUserDetails
			set modified = @nowUtcUnix
		FROM #cloudAppConfiguration_DetailsCompareTable TCT
		WHERE APP_CloudAppUserDetails.userAssocId = TCT.userAssocId
			AND APP_CloudAppUserDetails.userGUID = TCT.userGUID
			AND APP_CloudAppUserDetails.modified = 0
		SET @errorCode = @@ERROR
		IF @errorCode != 0
		BEGIN
			GOTO ERROR
		END
	END
	ELSE IF @discoverByType IN (@DISCOVERTYPE_ALL_USERS ,@DISCOVERTYPE_ALL_TEAMS, @DISCOVERTYPE_ALL_DYNAMICS_365_INSTANCES) AND @accountStatus = 0
	BEGIN
	UPDATE APP_CloudAppUserDetails
			set modified = @nowUtcUnix
		WHERE APP_CloudAppUserDetails.subClientId = @subClientId
		AND APP_CloudAppUserDetails.discoverByType IN (@DISCOVERTYPE_ALL_USERS ,@DISCOVERTYPE_ALL_TEAMS, @DISCOVERTYPE_ALL_DYNAMICS_365_INSTANCES)
			AND APP_CloudAppUserDetails.modified = 0
			AND APP_CloudAppUserDetails.status <> @accountStatus
		SET @errorCode = @@ERROR
		IF @errorCode != 0
		BEGIN
			GOTO ERROR
		END
	END
	MERGE APP_CloudAppUserDetails CD
	USING
	(
		SELECT C.* FROM #cloudAppConfiguration_XMLDetailsTable C
	) AS PA ON ((PA.userGUID IS NOT NULL AND LEN(PA.userGUID)>0 AND CD.userGUID = PA.userGUID) OR (LEN(PA.userGUID)=0))
	AND CD.subclientId = @subclientId
	AND CD.modified = 0
	AND CD.discoverByType = @discoverByType
	WHEN NOT MATCHED THEN
	INSERT (userGUID,displayName,aliasName,smtpAddress,discoverByType,isAutoDiscovered,subClientId,planId,created,modified,status,flags,deleted,userAccountSize,
			xmlGeneric,itemType,ParentWebGuid,BackupSetId,ItemClassification)
	VALUES(ISNULL(PA.userGUID, ''),PA.displayName,PA.aliasName, PA.smtpAddress,PA.discoverByType,PA.isAutoDiscoveredUser,@subclientId,PA.planId, @nowUtcUnix , 0,PA.accountStatus,PA.commonFlags,0,
			PA.userAccountSize,PA.xmlGeneric,PA.itemtype,PA.ParentWebGuid,
			CASE WHEN PA.discoverByType = @DISCOVERTYPE_ASSOCIATED_SHAREPOINT_WEB_SITES THEN PA.BackupSetId ELSE @backupSetId END,
			ItemClassification
			)
	OUTPUT	INSERTED.userAssocId, INSERTED.userGuid,INSERTED.displayName INTO #output_PolicyAssocTable;
	SET @errorCode = @@ERROR
	IF @errorCode != 0
	BEGIN
		GOTO ERROR
	END
	END TRY
    BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
        SELECT @errorCode = ERROR_NUMBER(), @errorString = ERROR_MESSAGE()
    END CATCH
	SET @errorCode = @@ERROR
	IF @errorCode != 0
	BEGIN
		GOTO ERROR
	END
ERROR:
IF @errorCode <>0
	ROLLBACK TRAN
ELSE
	COMMIT TRAN
ERROR_EXIT:
	SET @o_xmlString =
	(
		SELECT
		(SELECT @errorCode '@errorCode',
				@errorString '@errorMessage'
				FOR XML PATH ('resp'),TYPE
				)
			FOR XML PATH(''),ROOT('Ida_CloudAppAssociationsResp')
	)
	SELECT @o_xmlString
	IF object_id('tempdb.dbo.#cloudAppConfiguration_XMLDetailsTable') is not null
         DROP TABLE #cloudAppConfiguration_XMLDetailsTable
	IF object_id('tempdb.dbo.#PoliciesTable') is not null
		DROP TABLE #PoliciesTable
	IF object_id('tempdb.dbo.#cloudAppConfiguration_DetailsCompareTable') is not null
		DROP TABLE #cloudAppConfiguration_DetailsCompareTable
	IF object_id('tempdb.dbo.#output_PolicyAssocTable') is not null
		DROP TABLE #output_PolicyAssocTable
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppCloudAppConfigPolicyAssocSetInfo')
	delete from GxQscripts where name = 'AppCloudAppConfigPolicyAssocSetInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCloudAppConfigPolicyAssocSetInfo')
	delete from GXDBVersions where aliasname = 'AppCloudAppConfigPolicyAssocSetInfo'
GO

insert into GXDBVersions values(2, 'AppCloudAppConfigPolicyAssocSetInfo',  '00000000000000000000', 'AppCloudAppConfigPolicyAssocSetInfo', '00000000000000000000')
GO

