

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCloudAppConfigPolicyAssocGetInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	|  				AppCloudAppConfigPolicyAssocGetInfo					|
--	| Procedure for create/update a APP_CloudAppConfigPolicyAssoc table	|
--	+===================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppCloudAppConfigPolicyAssocGetInfo')
BEGIN
	print '>>> Drop Stored Procedure: AppCloudAppConfigPolicyAssocGetInfo <<<'
	drop procedure AppCloudAppConfigPolicyAssocGetInfo
END
IF EXISTS (select * from GxQscripts where name='AppCloudAppConfigPolicyAssocGetInfo')
	delete from GxQscripts where name = 'AppCloudAppConfigPolicyAssocGetInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCloudAppConfigPolicyAssocGetInfo')
	delete from GXDBVersions where aliasname = 'AppCloudAppConfigPolicyAssocGetInfo'
GO
print '... Creating Procedure: AppCloudAppConfigPolicyAssocGetInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppCloudAppConfigPolicyAssocGetInfo
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE @o_xmlString			XML = NULL
	DECLARE	@errorCode				INT = 0
	DECLARE @userId					INT = (SELECT TOP 1 id FROM UMUsers (NOLOCK) WHERE flags&0x40=0x40)
	DECLARE @errorString			NVARCHAR(MAX) = ''
	DECLARE @nowTime				INT = datediff(second,'01/01/1970',GETDATE())
	DECLARE @subClientId			INT = 0
	DECLARE @discoverByType			INT = 0
	DECLARE @ClientId				INT = 0
	DECLARE @appType				INT = 0
	DECLARE @instanceId				INT = 0
	DECLARE @instanceType			INT = 0
	DECLARE @assocId				INT = 0
	DECLARE	@backupSetId			INT = 0
	DECLARE @INSUFFICIENT_PERMISSIONS	INT = 111
	DECLARE @DISCOVERTYPE_USER													INT = 1
	DECLARE @DISCOVERTYPE_GROUPS												INT = 2
	DECLARE @DISCOVERTYPE_BROWSE_FOLDERS										INT = 3
	DECLARE @DISCOVERTYPE_ALL_USERS												INT = 4
	DECLARE @DISCOVERTYPE_AUTO_DISCOVER_ASSOCIATIONS							INT = 5
	DECLARE @DISCOVERTYPE_ASSOCIATED_SHAREPOINT_WEB_SITES						INT = 6
	DECLARE @DISCOVERTYPE_ALL_SHAREPOINT_WEB_SITES								INT = 7
	DECLARE @DISCOVERTYPE_AUTO_DISCOVERED_SHAREPOINT							INT = 8
	DECLARE @DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_ALL_SHAREPOINT_WEB_SITES	INT = 9
	DECLARE @DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_SHAREPOINT_TEAM_SITES		INT = 10
	DECLARE @DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_PROJECT_ONLINE_SITES		INT = 11
	DECLARE @DISCOVERTYPE_TEAM													INT = 12
	DECLARE @DISCOVERTYPE_ALL_TEAMS												INT = 13
	DECLARE @DISCOVERTYE_DYNAMICS_365_ENTITY									INT = 14
	DECLARE @DISCOVERTYPE_DYNAMICS_365_INSTANCE									INT = 15
	DECLARE @DISCOVERTYPE_ALL_DYNAMICS_365_INSTANCES							INT = 16
	--Sort Columns
	DECLARE @O365Field_DISPLAYNAME INT = 1
	DECLARE @O365Field_URL INT = 2
	DECLARE @O365Field_WEBTYPE INT = 3
	DECLARE @O365Field_ITEMTYPE INT = 4
	DECLARE @O365Field_STATUS INT = 5
	DECLARE @O365Field_SIZE	  INT = 6
	DECLARE @O365Field_PLAN	INT = 7
	DECLARE @O365Field_BACKUP_REF_TIME INT = 8
	DECLARE @O365Field_AUTO_DISCOVER  INT = 9
	DECLARE @O365Field_ONEDRIVE_QUOTA INT = 10
	DECLARE @O365Field_NUMBER_OF_FILES INT = 11
	DECLARE @O365Field_PARENT INT = 19
	DECLARE @ONE_DRIVE_ENABLED					INT = 1
	DECLARE @SHAREPOINT_CONTENT_NOT_ASSOCIATED	INT = 2
	DECLARE @SHAREPOINT_CONTENT_DELETED	INT = 1
	DECLARE @SubclientPropXML XML	=	NULL
	DECLARE @SubclientGUID VARCHAR(MAX)
	DECLARE @pageNo								INT = 0
	DECLARE @pageSz								INT = 0
	DECLARE @search 							INT = 0
	DECLARE @searchKey							NVARCHAR(MAX) = ''
	DECLARE @filterColumn 					INT = 0
	DECLARE	@filterString 						NVARCHAR(40) = ''
	DECLARE @SortColumn						INT = 0
	DECLARE @SortOrder 						INT  = 0
	DECLARE @bIncludeDeleted				INT = 0
	DECLARE @oneDriveQuotaFilter INT = -1
	DECLARE @groupId NVARCHAR(MAX) = ''
	--Prepare FIlter list table
	DECLARE @filtertbl TABLE (filter xml)
	DECLARE @filterlisttbl TABLE (fCol nvarchar(max), fStr nvarchar(max), rangeMin BIGINT, rangeMax BIGINT)
	INSERT INTO @filtertbl SELECT R.ref.query('.') AS filter
	FROM @i_xmlString.nodes ('Ida_GetCloudAppPolicyAssociationReq/filterInfoList') R(ref)
	INSERT INTO @filterlisttbl SELECT DISTINCT
		filter.value ('filterInfoList[1]/@filterColumn', 'INT') AS fCol ,
		filter.value('filterInfoList[1]/@filterString', 'nvarchar(max)') AS fStr,
		filter.value ('filterInfoList[1]/@filterRangeMin', 'BIGINT') AS rangeMin ,
		filter.value('filterInfoList[1]/@filterRangeMax', 'BIGINT') AS rangeMax
    FROM @filtertbl
	Update @filterlisttbl set rangeMax = 9223372036854775807 -- maxBigInt value
	WHERE fCol IN (@O365Field_SIZE, @O365Field_NUMBER_OF_FILES, @O365Field_BACKUP_REF_TIME) AND (rangeMax IS NULL OR rangeMax = 0)
	Update @filterlisttbl set rangeMin = 0
	WHERE fCol IN (@O365Field_SIZE, @O365Field_NUMBER_OF_FILES, @O365Field_BACKUP_REF_TIME) AND rangeMin IS NULL
	SET @oneDriveQuotaFilter = ISNULL((select CONVERT(INTEGER, fStr) from @filterlisttbl WHERE fCOl = @O365Field_ONEDRIVE_QUOTA), -1)
	IF EXISTS (SELECT TOP 1 1 FROM @filterlisttbl) set @filterColumn = 1
	SELECT	@subClientId = ISNULL(ref.value('cloudAppAssociation[1]/subclientEntity[1]/@subclientId', 'INT'),0),
			@instanceId = ISNULL(ref.value('cloudAppAssociation[1]/subclientEntity[1]/@instanceId','INT'),0),
			@backupSetId = ISNULL(ref.value('cloudAppAssociation[1]/subclientEntity[1]/@backupsetId','INT'),0),
			@ClientId = ISNULL(ref.value('cloudAppAssociation[1]/subclientEntity[1]/@clientId','INT'),0),
			@appType = ISNULL(ref.value('cloudAppAssociation[1]/subclientEntity[1]/@applicationId','INT'),0),
			@discoverByType = ISNULL(ref.value('@discoverByType', 'NVARCHAR(MAX)'),0),
			@userId = ISNULL(ref.value('processinginstructioninfo[1]/user[1]/@userId', 'int'), @userId),
			@pageNo = ISNULL(ref.value('pagingInfo[1]/@pageNumber', 'INTEGER'),0),
			@pageSz = ISNULL(ref.value('pagingInfo[1]/@pageSize', 'INTEGER'),0),
			@search = ISNULL(ref.value('searchInfo[1]/@isSearch', 'INTEGER'),0),
			@searchKey = ISNULL(ref.value('searchInfo[1]/@searchKey', 'NVARCHAR(MAX)'),0),
--@filterColumn = ISNULL(ref.value('filterInfo[1]/@filterColumn', 'INTEGER'),0),
	--		@filterString = ISNULL(ref.value('filterInfo[1]/@filterString', 'NVARCHAR(MAX)'),0),
			@SortColumn = ISNULL(ref.value('sortInfo[1]/@sortColumn', 'INTEGER'),0),
			@SortOrder = ISNULL(ref.value('sortInfo[1]/@sortOrder', 'INTEGER'),0),
			@bIncludeDeleted = ISNULL(ref.value('@bIncludeDeleted', 'INT'),0),
			@groupId = ISNULL(ref.value('groupInfo[1]/@id', 'NVARCHAR(MAX)'), '') -- groudId when set with DISCOVERTYPE_USER returns only users of that group
		FROM @i_xmlString.nodes ('Ida_GetCloudAppPolicyAssociationReq') R(ref)
	IF @subClientId <=0
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error : Invalid Subclient Id ['+CAST(@subClientId as VARCHAR(10))+']'
		GOTO ERROR_EXIT
	END
	IF @backupSetId <=0
		SELECT @backupSetId = backupSet, @SubclientGUID = GUID FROM APP_Application (NOLOCK) WHERE id = @subClientId
	IF @backupSetId <=0
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error : Invalid BackupSetId Id ['+CAST(@backupSetId as VARCHAR(10))+']'
		GOTO ERROR_EXIT
	END
	IF EXISTS  (select TOP 1 1 FROM @filterlisttbl WHERE fCOl = @O365Field_STATUS AND CONVERT(INTEGER, fStr)  = 1)
	SET @bIncludeDeleted = 1
	SELECT @appType = appTypeId , @ClientId = clientId , @backupSetId = backupset , @instanceId = instance
	FROM App_Application (NOLOCK) where id = @subclientId
	DECLARE @hasPermission INT = 0
EXEC sec_checkPermissionOnEntity @userId, 0, @hasPermission OUTPUT, 3, @ClientId, 4, @appType, 5, @instanceId, 6, @backupsetId, 7, @subclientId
	IF @hasPermission <> 1
	BEGIN
			SET @errorCode = @INSUFFICIENT_PERMISSIONS
			SET @errorString = 'Error : User does not have required permission to perform this operation'
			GOTO ERROR_EXIT
	END
	IF @pageNo < 0  SET @pageNo = 0 --default page number none
	IF @pageSz <= 0 SET @pageSz = 0 -- default page size none
	IF @search = 1 AND @searchKey = ''
	BEGIN
	SET @errorCode = 1
		SET @errorString = 'Error : Invalid Search key'
		GOTO ERROR_EXIT
	END
	DECLARE @isSharePointDiscoveryType int = 0;
	IF @discoverByType IN (@DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_ALL_SHAREPOINT_WEB_SITES,@DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_SHAREPOINT_TEAM_SITES,@DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_PROJECT_ONLINE_SITES,@DISCOVERTYPE_ASSOCIATED_SHAREPOINT_WEB_SITES, @DISCOVERTYPE_ALL_SHAREPOINT_WEB_SITES, @DISCOVERTYPE_AUTO_DISCOVERED_SHAREPOINT) SET @isSharePointDiscoveryType=1;
	--get cloud Instance Type here
	DECLARE @cloudInstanceType INT = 0
	SELECT @cloudInstanceType =  ISNULL(I.attrval , 0)
	FROM	APP_Application A (NOLOCK) 	JOIN APP_InstanceProp I (NOLOCK) ON I.componentNameId = A.Instance
	WHERE A.id = @subClientId AND I.AttrName = 'Cloud Apps Instance Type' AND I.modified = 0
	IF OBJECT_ID('tempdb.dbo.#SubClientStats') IS NOT NULL
		DROP TABLE #SubClientStats
	CREATE TABLE #SubClientStats (SubClientGUID VARCHAR(MAX),ItemsIndexed BIGINT, ItemsContentIndexed BIGINT, ApplicationSize BIGINT,  lastBackupJobTime BIGINT, idxCollectionTime BIGINT, NumberOfUsers BIGINT)
	--No need of cluster, One Client wont be having more subclients
	IF @discoverByType IN (@DISCOVERTYPE_GROUPS, @DISCOVERTYPE_ALL_USERS, @DISCOVERTYPE_USER, @DISCOVERTYPE_AUTO_DISCOVER_ASSOCIATIONS, @DISCOVERTYPE_BROWSE_FOLDERS, @DISCOVERTYPE_ASSOCIATED_SHAREPOINT_WEB_SITES, @DISCOVERTYPE_AUTO_DISCOVERED_SHAREPOINT, @DISCOVERTYPE_TEAM,  @DISCOVERTYPE_ALL_TEAMS , @DISCOVERTYE_DYNAMICS_365_ENTITY, @DISCOVERTYPE_DYNAMICS_365_INSTANCE, @DISCOVERTYPE_ALL_DYNAMICS_365_INSTANCES)
	BEGIN
		SET @SubclientPropXML =
		(
			SELECT TOP 1 IDS.properties FROM IdxDbState (NOLOCK) IDS
			JOIN App_IndexDBInfo (NOLOCK) AII ON AII.id = IDS.dbId AND  AII.backupSetId = @backupSetId
		)
		INSERT INTO #SubClientStats (SubClientGUID,ItemsIndexed, ItemsContentIndexed, ApplicationSize, lastBackupJobTime, idxCollectionTime)
		SELECT	AP.value('@appGUID', 'NVARCHAR(MAX)') SubClientGUID,
				AP.value('stat[1]/@itemsIndexed', 'BIGINT') ItemsIndexed,
				AP.value('stat[1]/@itemsContentIndexed', 'BIGINT') ItemsContentIndexed,
				AP.value('stat[1]/@applicationSize', 'BIGINT') ApplicationSize,
				ref.value('@lastCompletedBkpTime','BIGINT') lastBackupJobTime,
				AP.value('@lastPlayedBkpJobTime','BIGINT') idxCollectionTime
			FROM @SubclientPropXML.nodes('Indexing_DbStats') R(ref)
			CROSS APPLY ref.nodes('./apps') I(AP)
		UPDATE #SubClientStats set NumberOfUsers = ISNULL(T.totalUsers,0) FROM
		(
			select count(userAssocId) as totalUsers
			FROM APP_CloudAppUserDetails A (NOLOCK)
			WHERE A.subClientId = @subClientId AND A.modified = 0
			AND ((@isSharePointDiscoveryType = 0 AND A.status <> 1 ) OR (@isSharePointDiscoveryType =1 AND (A.flags&2=0)))
			AND A.discoverByType = (CASE WHEN @discoverByType IN (@DISCOVERTYPE_ASSOCIATED_SHAREPOINT_WEB_SITES, @DISCOVERTYPE_AUTO_DISCOVERED_SHAREPOINT) THEN @DISCOVERTYPE_ASSOCIATED_SHAREPOINT_WEB_SITES
												WHEN @discoverByType = @DISCOVERTYPE_AUTO_DISCOVER_ASSOCIATIONS
														THEN (CASE WHEN @cloudInstanceType = 7  /*OneDrive*/ THEN @DISCOVERTYPE_USER
																		WHEN @cloudInstanceType = 36  /* TEAMS*/   THEN @DISCOVERTYPE_TEAM
																		WHEN @cloudInstanceType = 35  /*D365*/      THEN @DISCOVERTYE_DYNAMICS_365_ENTITY END)
												WHEN @discoverByType IN (@DISCOVERTYPE_USER, @DISCOVERTYPE_TEAM, @DISCOVERTYE_DYNAMICS_365_ENTITY ) THEN 	@discoverByType END)
		) T
	END
	BEGIN
	SET @o_xmlString =
		(
		SELECT(
			SELECT CA.discoverByType '@discoverByType',CA.status '@accountStatus',
			CASE WHEN CA.discoverByType IN (@DISCOVERTYPE_USER,@DISCOVERTYPE_ASSOCIATED_SHAREPOINT_WEB_SITES, @DISCOVERTYPE_TEAM, @DISCOVERTYE_DYNAMICS_365_ENTITY, @DISCOVERTYPE_DYNAMICS_365_INSTANCE)
			THEN
			(
				SELECT CA.displayName '@displayName', CA.aliasName '@aliasName' , CA.smtpAddress '@smtpAddress',CA.isAutoDiscovered '@isAutoDiscoveredUser',
				CA.flags '@commonFlags',CA.userAccountSize '@accountSize',CA.itemType '@itemType',CA.ParentWebGuid '@ParentWebGuid',CA.BackupSetId '@BackupSetId',
				CA.ItemClassification '@ItemClassification', CA.numberOfItems '@numberOfItems',
				( SELECT CA.backupReferenceTime as '@time'  FOR XML PATH ('lastBackupJobRanTime'), TYPE ),
				( SELECT CA.IdxCollectionTime as '@time'  FOR XML PATH ('IdxCollectionTime'), TYPE ),
				(
					SELECT 13 '@_type_', CA.userGuid '@userGUID'
					FOR XML PATH('user'), TYPE
				),
				(
					SELECT CA.xmlGeneric
				),
				(
					SELECT  CA.xmlGeneric.value('(msTeamsInfo/@teamsCreatedTime)[1]', 'INTEGER') as '@teamsCreatedTime',
					CA.xmlGeneric.value('(msTeamsInfo/@visibility)[1]', 'INTEGER') as '@visibility'
					FOR XML PATH('msTeamsInfo'), TYPE
				)
				FOR XML PATH('userAccountInfo'), TYPE
			)END,
			CASE WHEN CA.discoverByType = @DISCOVERTYPE_BROWSE_FOLDERS
			THEN
			(
				SELECT CA.userGuid '@folderId',CA.displayName '@folderTitle',CA.isAutoDiscovered '@isAutoDiscoveredUser', CA.flags '@commonFlags'
				FOR XML PATH('folders'), TYPE
			)END,
			CASE WHEN CA.discoverByType IN (@DISCOVERTYPE_GROUPS,@DISCOVERTYPE_ALL_USERS,@DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_ALL_SHAREPOINT_WEB_SITES,@DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_SHAREPOINT_TEAM_SITES,@DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_PROJECT_ONLINE_SITES, @DISCOVERTYPE_ALL_TEAMS, @DISCOVERTYPE_DYNAMICS_365_INSTANCE, @DISCOVERTYPE_ALL_DYNAMICS_365_INSTANCES)
			THEN
			(
				SELECT CA.userGuid '@id',CA.displayName '@name',CA.isAutoDiscovered '@isAutoDiscoveredUser', CA.flags '@commonFlags', CA.userCount '@userCount'
				FOR XML PATH('groups'), TYPE
			)END,
			(
				SELECT
				(
					SELECT 6 '@policyType',
					(
						SELECT CP.PolicyType 'cloudAppPolicy/@cloudAppPolicyType'
						FOR XML PATH ('detail'), TYPE
					),
					(
						SELECT CP.policyId '@policyId' , CP.policyName '@policyName'
						FOR XML PATH ('policyEntity') , TYPE
					)
					FROM
					(
						SELECT T.policyId , T.policyName, T.PolicyType
						FROM APP_ConfigurationPolicy (READUNCOMMITTED) T
						JOIN APP_ConfigurationPolicyDetails (READUNCOMMITTED) C ON C.componentNameId = T.policyId
						JOIN App_PlanProp (READUNCOMMITTED) P ON  P.attrVal = T.policyId AND P.componentNameId = CA.planId
						WHERE  P.attrName IN( 'Office 365 backup policy', 'Office 365 retention policy') AND C.modified = 0
					)CP
					FOR XML PATH ('cloudAppPolicies'), TYPE
				)
				FOR XML PATH ('policies') , TYPE
			),
			(
				SELECT CA.subClientId '@subClientId',
				CASE WHEN CA.discoverByType IN (@DISCOVERTYPE_ASSOCIATED_SHAREPOINT_WEB_SITES,@DISCOVERTYPE_ALL_SHAREPOINT_WEB_SITES,@DISCOVERTYPE_AUTO_DISCOVERED_SHAREPOINT) THEN CA.BackupSetId ELSE @backupSetId END '@backupsetId'
				FOR XML PATH ('subclientEntity') , TYPE
			),
			(
					SELECT CA.planId '@planId', CA.name '@planName'
					FOR XML PATH('plan'), TYPE
			),
			( SELECT CA.TotalRows as '@totalRecords' FOR XML PATH ('pagingInfo'), TYPE )
			FROM
			(
				SELECT R.*, ROW_NUMBER() OVER ( ORDER BY CASE WHEN @SortColumn = @O365Field_DISPLAYNAME AND @SortOrder = 1 THEN displayName END DESC,
				CASE WHEN @SortColumn = @O365Field_DISPLAYNAME AND @SortOrder = 0 THEN displayName END ,
				CASE WHEN @SortColumn = @O365Field_URL AND @SortOrder = 1 THEN smtpAddress END DESC,
				CASE WHEN @SortColumn = @O365Field_URL AND @SortOrder = 0 THEN smtpAddress END ,
				CASE WHEN @SortColumn = @O365Field_WEBTYPE AND @SortOrder = 1 THEN aliasName END DESC,
				CASE WHEN @SortColumn = @O365Field_WEBTYPE AND @SortOrder = 0  THEN aliasName END,
				CASE WHEN @SortColumn = @O365Field_ITEMTYPE AND @SortOrder = 1 THEN  CAST(itemType AS NVARCHAR(max)) END DESC,
				CASE WHEN @SortColumn = @O365Field_ITEMTYPE AND @SortOrder = 0 THEN  CAST(itemType AS NVARCHAR(max)) END ,
				CASE WHEN @SortColumn = @O365Field_STATUS  AND @SortOrder = 1 THEN  status  END DESC,
				CASE WHEN @SortColumn = @O365Field_STATUS  AND @SortOrder = 0 THEN  status  END ,
				CASE WHEN @SortColumn = @O365Field_AUTO_DISCOVER AND @SortOrder = 1 THEN   isAutoDiscovered   END DESC,
				CASE WHEN @SortColumn = @O365Field_AUTO_DISCOVER AND @SortOrder = 0 THEN   isAutoDiscovered   END ,
				CASE WHEN @SortColumn = @O365Field_SIZE AND @SortOrder = 1  THEN   userAccountSize  END DESC,
				CASE WHEN @SortColumn = @O365Field_SIZE AND @SortOrder = 0  THEN   userAccountSize  END ,
				CASE WHEN @SortColumn = @O365Field_BACKUP_REF_TIME AND @SortOrder = 1 THEN backupReferenceTime END DESC,
				CASE WHEN @SortColumn = @O365Field_BACKUP_REF_TIME AND @SortOrder = 0 THEN  backupReferenceTime  END ,
				CASE WHEN @SortColumn = @O365Field_PLAN	AND @SortOrder = 1 THEN CAST(name	AS NVARCHAR(max)) END DESC,
				CASE WHEN @SortColumn = @O365Field_PLAN	AND @SortOrder = 0 THEN CAST(name	AS NVARCHAR(max)) END,
				CASE WHEN @SortColumn = @O365Field_NUMBER_OF_FILES	AND @SortOrder = 1 THEN numberOfItems END DESC,
				CASE WHEN @SortColumn = @O365Field_NUMBER_OF_FILES	AND @SortOrder = 0 THEN numberOfItems END,
				CASE WHEN @SortColumn = @O365Field_ONEDRIVE_QUOTA	AND @SortOrder = 1 THEN flags  END DESC,
				CASE WHEN @SortColumn = @O365Field_ONEDRIVE_QUOTA	AND @SortOrder = 0 THEN flags END ,
				CASE WHEN @SortColumn = @O365Field_PARENT AND @SortOrder = 1 THEN ParentWebGuid END DESC,
				CASE WHEN @SortColumn = @O365Field_PARENT AND @SortOrder = 0 THEN ParentWebGuid END) AS RowNum FROM
				(
				SELECT  U.userAssocId , U.userGuid , U.displayName , U.aliasName , U.smtpAddress , U.discoverByType , U.isAutoDiscovered ,
				U.subClientId , U.planId , U.flags, U.status , U.deleted , U.userAccountSize, U.xmlGeneric,U.itemType,U.ParentWebGuid,U.BackupSetId,U.ItemClassification, PP.name,
				U.backupReferenceTime, U.IdxCollectionTime,U.numberOfItems, COUNT(U.userAssocId) OVER (PARTITION BY 1) as TotalRows,
				(CASE WHEN U.discoverByType IN (@DISCOVERTYPE_GROUPS, @DISCOVERTYPE_ALL_USERS) AND @discoverByType IN (@DISCOVERTYPE_GROUPS, @DISCOVERTYPE_ALL_USERS, @DISCOVERTYPE_AUTO_DISCOVER_ASSOCIATIONS)
					THEN (SELECT COUNT(*) FROM APP_CloudAppUserDetails (READUNCOMMITTED) WHERE discoverByType = @DISCOVERTYPE_USER AND subClientId = @subClientId AND (xmlGeneric.value('(/groups/@id)[1]', 'NVARCHAR(MAX)') = U.userGUID))
				END) AS userCount
				FROM APP_CloudAppUserDetails U (READUNCOMMITTED)
				LEFT JOIN App_Plan (NOLOCK) PP ON PP.id = U.planId
				WHERE (((U.modified = 0 AND U.status <> 1)  OR (@bIncludeDeleted = 1 AND  U.status = 1)) AND (
				-- 9/24/2020, OVK: For SharePoint ensure only latest record too
					(@isSharePointDiscoveryType=1 AND U.userAssocId in (SELECT max(AC.userAssocId) FROM APP_CloudAppUserDetails AC (NOLOCK) WHERE AC.subClientId = @subClientId GROUP BY userGUID,discoverByType))
					OR (@isSharePointDiscoveryType=0 AND U.userAssocId in (SELECT max(AC.userAssocId) FROM APP_CloudAppUserDetails AC (NOLOCK) WHERE AC.subClientId = @subClientId GROUP BY userGUID) ))) AND U.subClientId = @subClientId
				AND ((@discoverByType IN (@DISCOVERTYPE_USER,@DISCOVERTYPE_GROUPS,@DISCOVERTYPE_BROWSE_FOLDERS,@DISCOVERTYPE_ALL_USERS,@DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_ALL_SHAREPOINT_WEB_SITES,@DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_SHAREPOINT_TEAM_SITES,@DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_PROJECT_ONLINE_SITES, @DISCOVERTYPE_TEAM,@DISCOVERTYPE_ALL_TEAMS, @DISCOVERTYE_DYNAMICS_365_ENTITY, @DISCOVERTYPE_DYNAMICS_365_INSTANCE, @DISCOVERTYPE_ALL_DYNAMICS_365_INSTANCES) AND U.discoverByType = @discoverByType)
					OR (@discoverByType = @DISCOVERTYPE_ALL_SHAREPOINT_WEB_SITES AND U.discoverByType =  @DISCOVERTYPE_ASSOCIATED_SHAREPOINT_WEB_SITES)
					OR (@discoverByType = @DISCOVERTYPE_AUTO_DISCOVER_ASSOCIATIONS AND U.discoverByType IN (@DISCOVERTYPE_GROUPS,@DISCOVERTYPE_BROWSE_FOLDERS,@DISCOVERTYPE_ALL_USERS, @DISCOVERTYPE_ALL_TEAMS, @DISCOVERTYPE_DYNAMICS_365_INSTANCE, @DISCOVERTYPE_ALL_DYNAMICS_365_INSTANCES))
					OR (@discoverByType = @DISCOVERTYPE_AUTO_DISCOVERED_SHAREPOINT AND U.discoverByType IN (@DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_ALL_SHAREPOINT_WEB_SITES,@DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_SHAREPOINT_TEAM_SITES,@DISCOVERTYPE_ASSOCIATE_AUTO_DISCOVERED_PROJECT_ONLINE_SITES))
					OR (@discoverByType = @DISCOVERTYPE_ASSOCIATED_SHAREPOINT_WEB_SITES AND U.discoverByType =  @DISCOVERTYPE_ASSOCIATED_SHAREPOINT_WEB_SITES AND U.flags & @SHAREPOINT_CONTENT_NOT_ASSOCIATED != @SHAREPOINT_CONTENT_NOT_ASSOCIATED))
				AND ((@search = 0) OR  (@search = 1 AND  (U.displayName LIKE @searchKey OR U.smtpAddress LIKE @searchKey OR U.aliasName like @searchKey)   ))
				AND ( (@filterColumn = 0 )
						OR (	(  U.displayName LIKE ISNULL((select fStr from @filterlisttbl WHERE fCOl = @O365Field_DISPLAYNAME),  '%%' ))
							AND	(  U.smtpAddress LIKE ISNULL((select fStr from @filterlisttbl WHERE fCOl = @O365Field_URL) , '%%' ))
							AND	(  (U.ItemClassification IN (select CONVERT(INTEGER, fStr) from @filterlisttbl WHERE fCOl = @O365Field_WEBTYPE)) OR  (@O365Field_WEBTYPE NOT IN (select fCol from @filterlisttbl) AND (@filterColumn > 0) )  )
							AND	(  (U.itemType IN (select CONVERT(INTEGER, fStr) from @filterlisttbl WHERE fCOl = @O365Field_ITEMTYPE)) OR  (@O365Field_ITEMTYPE NOT IN (select fCol from @filterlisttbl) AND (@filterColumn > 0) )  )
							AND ( ( @oneDriveQuotaFilter = 1  AND (U.flags & 1 = 1)) OR ( (@oneDriveQuotaFilter = 0)  AND (U.flags & 1 <> 1)) OR    ((@O365Field_ONEDRIVE_QUOTA NOT IN (select fCol from @filterlisttbl) AND (@filterColumn > 0)))  )
							AND	(  (pp.name IN (select fStr from @filterlisttbl WHERE fCOl = @O365Field_PLAN)) OR (@O365Field_PLAN NOT IN (select fCol from @filterlisttbl) AND (@filterColumn > 0) )  )
							AND	(  (U.status IN (select CONVERT(INTEGER, fStr) from @filterlisttbl WHERE fCOl = @O365Field_STATUS)) OR  (@O365Field_STATUS NOT IN (select fCol from @filterlisttbl) AND (@filterColumn > 0) )  )
							AND	(  (U.isAutoDiscovered IN (select CONVERT(INTEGER, fStr) from @filterlisttbl WHERE fCOl = @O365Field_AUTO_DISCOVER)) OR  (@O365Field_AUTO_DISCOVER NOT IN (select fCol from @filterlisttbl) AND (@filterColumn > 0) )  )
							AND	(  ( EXISTS (SELECT 1 fCol from @filterlisttbl WHERE fCol = @O365Field_SIZE AND U.userAccountSize  >= rangeMin AND U.userAccountSize <= rangeMax)  ) OR   (@O365Field_SIZE NOT IN (select fCol from @filterlisttbl) AND (@filterColumn > 0)))
							AND	(  ( EXISTS (SELECT 1 fCol from @filterlisttbl WHERE fCol = @O365Field_NUMBER_OF_FILES AND U.numberOfItems  >= rangeMin AND U.numberOfItems <= rangeMax)  ) OR   (@O365Field_NUMBER_OF_FILES NOT IN (select fCol from @filterlisttbl) AND (@filterColumn > 0)))
							AND	(  ( EXISTS (SELECT 1 fCol from @filterlisttbl WHERE fCol = @O365Field_BACKUP_REF_TIME AND (((U.backupReferenceTime IS NULL OR U.backupReferenceTime = 0) AND rangeMax = -1 AND rangeMin = -1) OR (U.backupReferenceTime  >= rangeMin AND U.backupReferenceTime <= rangeMax)))  ) OR   (@O365Field_BACKUP_REF_TIME NOT IN (select fCol from @filterlisttbl) AND (@filterColumn > 0)))
							AND (  U.ParentWebGuid LIKE ISNULL((select fStr from @filterlisttbl WHERE fCOl = @O365Field_PARENT),  '%%' ))
							))
				AND (@groupId = '' OR (xmlGeneric.value('(/groups/@id)[1]', 'NVARCHAR(MAX)') = @groupId))
					)AS R
			)CA
			WHERE   (@pageSz = 0) OR (RowNum > (@pageNo * @pageSz)	AND RowNum <= ((@pageNo * @pageSz)+ @pageSz))
			ORDER BY RowNum
			FOR XML PATH('associations'), type
		),
		(
			SELECT ItemsIndexed '@ItemIndexed',  ItemsContentIndexed '@ItemsContentIndexed',  ApplicationSize '@ApplicationSize', lastBackupJobTime '@lastArchiveJobRanTime', idxCollectionTime '@indexCreationTime', NumberOfUsers '@numberOfItems'
				FROM #SubClientStats WHERE SubClientGUID = @SubclientGUID
			FOR XML PATH('SubclientStats'), Type
		)
		FOR XML PATH('Ida_GetCloudAppAssociationsResp')
	)
	END
ERROR_EXIT:
	IF @o_xmlString IS NULL
	BEGIN
		SET @o_xmlString =
		(
			SELECT
				(
					SELECT @errorCode '@errorCode', @errorString '@errorString'
					FOR XML PATH('resp'), Type
				)
				FOR XML PATH('Ida_GetCloudAppAssociationsResp')
		)
	END
	SELECT @o_xmlString
	IF OBJECT_ID('tempdb.dbo.#SubClientStats') IS NOT NULL
		DROP TABLE #SubClientStats
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppCloudAppConfigPolicyAssocGetInfo')
	delete from GxQscripts where name = 'AppCloudAppConfigPolicyAssocGetInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCloudAppConfigPolicyAssocGetInfo')
	delete from GXDBVersions where aliasname = 'AppCloudAppConfigPolicyAssocGetInfo'
GO

insert into GXDBVersions values(2, 'AppCloudAppConfigPolicyAssocGetInfo',  '00000000000000000000', 'AppCloudAppConfigPolicyAssocGetInfo', '00000000000000000000')
GO

