

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCloneSubclientProperties.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- -----------------------------------------------------------------------
-- This SP will copy subclient properties from @sourceSubclientId to @destinationSubclientId
-- It will copy only those properties from @sourceSubclientId which are not present on @destinationSubclientId
-- Properties will copied from APP_SubClientProp table.
-- @sourceSubclientId will be from selected source server for filer migration.
-- @destinationSubclientId will be from filer migrated target server.
------------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppCloneSubclientProperties')
BEGIN
	print '>>> Drop Stored Procedure: AppCloneSubclientProperties <<<'
	drop procedure AppCloneSubclientProperties
END
IF EXISTS (select * from GxQscripts where name='AppCloneSubclientProperties')
	delete from GxQscripts where name = 'AppCloneSubclientProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCloneSubclientProperties')
	delete from GXDBVersions where aliasname = 'AppCloneSubclientProperties'
GO
print '... Creating Procedure: AppCloneSubclientProperties'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppCloneSubclientProperties
-- Input arguments
  @sourceSubclientId INT,
  @destinationSubclientId INT
AS
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
DECLARE @nowTime integer = dbo.GetUnixTime (GetUTCdate())
DECLARE @spIdFromsourceSubclient INT = 0 -- Copy storagePolicyId from sourceSubclientId to destinationSubclientId
DECLARE @destinationSubclientIdProps TABLE (attrName NVARCHAR(MAX), cs_attrName INT)
DECLARE @skipSubclientProp TABLE (attrName NVARCHAR(MAX), cs_attrName INT)
-- Do not copy job related properties from sourceSubclientId to destinationSubclientId.
INSERT INTO @skipSubclientProp (attrName, cs_attrName)
VALUES ('Last Data Protected Time', CHECKSUM(N'Last Data Protected Time')),
('Last Backup Job Info', CHECKSUM(N'Last Backup Job Info')),
('sys:last incr jobId',  CHECKSUM(N'sys:last incr jobId')),
('sys:last full jobId',  CHECKSUM(N'sys:last full jobId')),
('sys:jobIds updated',   CHECKSUM(N'sys:jobIds updated'))
INSERT INTO @destinationSubclientIdProps (attrName, cs_attrName)
SELECT ASCP.attrName, ASCP.cs_attrName
FROM APP_SubClientProp  ASCP WITH(NOLOCK)
WHERE ASCP.componentNameId = @destinationSubclientId AND modified = 0
INSERT INTO APP_SubClientProp(componentNameId, attrName, attrType, attrVal, created, modified)
	SELECT @destinationSubclientId, ASCP.attrName, ASCP.attrType, ASCP.attrVal, @nowTime , 0
	FROM APP_SubClientProp ASCP WITH(NOLOCK)
	LEFT JOIN @destinationSubclientIdProps Props ON Props.attrName = ASCP.attrName AND Props.cs_attrName = ASCP.cs_attrName
	LEFT JOIN @skipSubclientProp skipProps ON skipProps.attrName = ASCP.attrName AND skipProps.cs_attrName = ASCP.cs_attrName
	WHERE ASCP.componentNameId = @sourceSubclientId
		AND modified = 0
		AND Props.attrName IS NULL
		AND skipProps.attrName IS NULL
SELECT  @spIdFromsourceSubclient = dataArchGrpID
FROM APP_Application WITH(NOLOCK)
WHERE id = @sourceSubclientId
IF @spIdFromsourceSubclient > 0
BEGIN
	-- Copying storagePolicyId from sourceSubclientId to destinationSubclientId
	UPDATE APP_Application
	SET dataArchGrpID = @spIdFromsourceSubclient
	WHERE id = @destinationSubclientId
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppCloneSubclientProperties')
	delete from GxQscripts where name = 'AppCloneSubclientProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCloneSubclientProperties')
	delete from GXDBVersions where aliasname = 'AppCloneSubclientProperties'
GO

insert into GXDBVersions values(2, 'AppCloneSubclientProperties',  '00000000000000000000', 'AppCloneSubclientProperties', '00000000000000000000')
GO

