

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCloneBackupSetProperties.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- -----------------------------------------------------------------------
-- This SP will copy backupSet properties from @sourceBackupSetId to @destinationBackupSetId
-- It will copy only those properties from @sourceBackupSetId which are not present on @destinationBackupSetId
-- Properties will copied from APP_BackupSetProp table.
-- @sourceBackupSetId will be from selected source server for filer migration.
-- @destinationBackupSetId will be from filer migrated target server.
------------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppCloneBackupSetProperties')
BEGIN
	print '>>> Drop Stored Procedure: AppCloneBackupSetProperties <<<'
	drop procedure AppCloneBackupSetProperties
END
IF EXISTS (select * from GxQscripts where name='AppCloneBackupSetProperties')
	delete from GxQscripts where name = 'AppCloneBackupSetProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCloneBackupSetProperties')
	delete from GXDBVersions where aliasname = 'AppCloneBackupSetProperties'
GO
print '... Creating Procedure: AppCloneBackupSetProperties'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppCloneBackupSetProperties
-- Input arguments
  @sourceBackupSetId INT,
  @destinationBackupSetId INT
AS
  DECLARE @errorCode INT 
  DECLARE @errorString NVARCHAR(MAX)
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @nowTime integer = dbo.GetUnixTime (GetUTCdate())
SET @errorCode = 0
SET @errorString = N'Successful'
DECLARE @destinationBackupSetIdProps TABLE (attrName NVARCHAR(MAX))
INSERT INTO @destinationBackupSetIdProps (attrName)
SELECT ABSP.attrName
FROM APP_BackupSetProp  ABSP WITH(NOLOCK)
WHERE ABSP.componentNameId = @destinationBackupSetId AND ABSP.modified = 0
INSERT INTO APP_BackupSetProp(componentNameId, attrName, attrType, attrVal, created, modified)
	SELECT @destinationBackupSetId, ABSP.attrName, ABSP.attrType, ABSP.attrVal, @nowTime , 0
	FROM APP_BackupSetProp ABSP WITH(NOLOCK)
	LEFT JOIN @destinationBackupSetIdProps Props ON Props.attrName = ABSP.attrName
	WHERE ABSP.componentNameId = @sourceBackupSetId AND ABSP.modified = 0 AND Props.attrName IS NULL
SELECT @errorCode as 'errorCode', @errorString as 'errorString'
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppCloneBackupSetProperties')
	delete from GxQscripts where name = 'AppCloneBackupSetProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCloneBackupSetProperties')
	delete from GXDBVersions where aliasname = 'AppCloneBackupSetProperties'
GO

insert into GXDBVersions values(2, 'AppCloneBackupSetProperties',  '00000000000000000000', 'AppCloneBackupSetProperties', '00000000000000000000')
GO

