

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppClearTurboModeStubLastIncr.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppClearTurboModeStubLastIncr.sp,v $ $Id: AppClearTurboModeStubLastIncr.sp,v 1.2.60.2 2018/03/22 01:41:37 jiechen Exp $";
--	+===================================================================================+
--	| AppClearTurboModeStubLastIncr  If Turbo Mode Stubbing is enabled, purge			|
--	|                                "last incr" subClient Props for selected client 	|
--	+===================================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppClearTurboModeStubLastIncr <<<'

IF EXISTS (select * from sysobjects where name='AppClearTurboModeStubLastIncr')
	drop procedure AppClearTurboModeStubLastIncr
IF EXISTS (select * from GxQscripts where name='AppClearTurboModeStubLastIncr')
	delete from GxQscripts where name = 'AppClearTurboModeStubLastIncr'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppClearTurboModeStubLastIncr')
	delete from GXDBVersions where aliasname = 'AppClearTurboModeStubLastIncr'
GO
print '... Creating Procedure: AppClearTurboModeStubLastIncr'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppClearTurboModeStubLastIncr
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @xmlString XML OUTPUT
-----------------------------------------------------------
AS
SET NOCOUNT ON
-----------------------------------------------------------
--- LOCALS                                              ---
-----------------------------------------------------------
DECLARE	@function       AS varchar(80)				= 'AppClearTurboModeStubLastIncr'
DECLARE @retCode		AS integer					= 0								-- BE OPTIMISTIC
DECLARE @msgString	AS varchar(2048)			= ''
--DECLARE @brAlertTrace	AS varchar(256)				= (select value from gxglobalParam Where name = 'bralertTrace')
--DECLARE @dateTime		AS DATETIME					= getDate()
DECLARE @ATTR_LASTINCR	AS nvarchar(80)				= N'sys:last incr'
DECLARE @ATTR_TURBOMOD	AS nvarchar(80)				= N'Turbo Mode Enable Stubbing'
DECLARE @clientId		int
DECLARE @clientName		AS varchar(256)
-----------------------------------------------------------
/*
if @brAlertTrace <> 0
BEGIN
	DECLARE @input varchar(MAX) = CONVERT(varchar(MAX), @xmlString)
	exec br_ntTrace '.. AppClearTurboModeStubLastIncr', 0, @dateTime, 0, 0, @input
END
*/
BEGIN TRY
-----------------------------------------------
--- EXTRACT FROM THE XML					---
-----------------------------------------------
-- e.g.  <CvEntities_ClientEntity _type_="3" clientId="3" clientName="jewelfish_cn" />
--
	SET @clientId = ISNULL (( SELECT ref.value('@clientId', 'INT')
					FROM @xmlString.nodes ('CvEntities_ClientEntity') R(ref)), 0)
	SET @clientName = ISNULL (( SELECT ref.value('@clientName', 'NVARCHAR(1024)')
					FROM @xmlString.nodes ('CvEntities_ClientEntity') R(ref)), '')
	IF @clientId = 0
			SET @clientId = ISNULL((Select id from APP_Client where name = @clientName), 0)
	IF @clientId = 0
	BEGIN
		SET @retCode = 0x030001     --  CV_CLIENT_NOT_FOUND
		SET @msgString = 'No client with the name [' + @clientName + '] can be found on this Commserve'
		GOTO PROC_EXIT
	END
------------------------------------------------------
--	SET THE ENABLE/DISABLE MEMBERS BASED ON THE		--
--  .. XMLENTITIES LIST OF THE APPROPRIATE ALERT:	--
------------------------------------------------------
	DELETE APP_SubClientProp
	WHERE attrName = @ATTR_LASTINCR
	  AND cs_attrName = checksum(@ATTR_LASTINCR)
	 AND componentNameId in
		(select componentNameId from APP_SubClientProp
		  where componentNameId in
		          ( select id from APP_Application where appTypeId in (42,33,11,34, 43) and clientId  = @clientId)
 			and attrName =   @ATTR_TURBOMOD  and cs_attrName = checksum(@ATTR_TURBOMOD) and modified = 0 and attrVal = '1')
END TRY
--=====================================================================
--==============  COME HERE IF THERE WAS A PROBLEM!     ===============
--=====================================================================
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @retCode	 = ERROR_NUMBER()
	SET @msgString  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
PROC_EXIT:
SELECT  1                  as TAG,
        NULL               as Parent,
    @retCode               as [App_GenericResp!1!errorCode],
    @msgString             as [App_GenericResp!1!errorMessage]
FOR XML EXPLICIT
--------------------------------------------
-- SOME CODE, FOR STANDALONE DEBUGGING  ----
--------------------------------------------
/*
IF EXISTS (Select * from sysObjects where name = 'AppClearTurboModeStubLastIncr')
	Drop proc AppClearTurboModeStubLastIncr
GO
DECLARE @tId as int = 243
DECLARE @xmlString as nvarchar(max) = (Select message from TrackNotificationProcs where id = @tId)
SET @xmlString = '<CvEntities_ClientEntity _type_="" clientId="" clientName="jewelfish_2_cn"/>'
DECLARE @xml as XML = CONVERT(xml, @xmlString)
--Select @xmlString
BEGIN TRAN
exec AppClearTurboModeStubLastIncr @xml
ROLLBACK TRAN
*/
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppClearTurboModeStubLastIncr')
	delete from GxQscripts where name = 'AppClearTurboModeStubLastIncr'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppClearTurboModeStubLastIncr')
	delete from GXDBVersions where aliasname = 'AppClearTurboModeStubLastIncr'
GO

insert into GXDBVersions values(2, 'AppClearTurboModeStubLastIncr',  '00010002006000020000', 'AppClearTurboModeStubLastIncr', '00010002006000020000')
GO

