

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCleanupSettingsforDeletedCompany.sp] ---------- 

--  +===========================================================================+
--  |		 		 Name:  AppMarkProviderForDelete()
--  | Description:  Mark Provider For Delete. will be deleted by EVMGRS Thread.
--  +===========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCleanupSettingsforDeletedCompany.sp,v $ $Id: AppCleanupSettingsforDeletedCompany.sp,v 1.1.2.1 2019/03/24 16:35:49 nshah Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppCleanupSettingsforDeletedCompany')
BEGIN
	print '>>> Drop Stored Procedure: AppCleanupSettingsforDeletedCompany <<<'
	drop procedure AppCleanupSettingsforDeletedCompany
END
IF EXISTS (select * from GxQscripts where name='AppCleanupSettingsforDeletedCompany')
	delete from GxQscripts where name = 'AppCleanupSettingsforDeletedCompany'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCleanupSettingsforDeletedCompany')
	delete from GXDBVersions where aliasname = 'AppCleanupSettingsforDeletedCompany'
GO
print '... Creating Procedure: AppCleanupSettingsforDeletedCompany'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCleanupSettingsforDeletedCompany
  @i_company INTEGER
AS
  DECLARE @errorCode INTEGER
  DECLARE @errorString NVARCHAR(1024)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
DECLARE @nowTime   integer
SET     @nowTime  =   dbo.GetUnixTime (GetUTCdate())
IF object_id('tempdb.dbo.#SettingsTbl') IS NOT null DROP TABLE #SettingsTbl
CREATE TABLE #SettingsTbl (settingsId int, entityId int)
INSERT INTO #SettingsTbl(settingsId, entityId)
SELECT ID, entityId FROM app_advancesettings where relativePath = 'WebConsole\Customization' AND keyName = cast(@i_company as nvarchar(20))
UNION
SELECT ID, entityId  FROM app_advancesettings where relativePath = 'WebConsole\Customization' AND value like cast(@i_company as nvarchar(20))
--mark the key deleted
UPDATE app_advancesettings set deleted=1 WHERE id in (SELECT settingsId from #SettingsTbl )
--push the registry key to remove the deleted keys from the registry
INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
SELECT DISTINCT entityId, 6 /*WORK_TOKEN_REGISTRY*/, '', @nowTime, 0, 0, 0, -1
FROM #SettingsTbl
IF object_id('tempdb.dbo.#SettingsTbl') IS NOT null DROP TABLE #SettingsTbl
--delete email templates
DELETE FROM App_EmailTemplateProp WHERE componentNameId IN (SELECT id FROM App_EmailTemplate WHERE ownerCompanyId = @i_company and @i_company != 0)
DELETE FROM App_EmailTemplate WHERE id IN (SELECT ID FROM App_EmailTemplate WHERE ownerCompanyId = @i_company and @i_company != 0)
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppCleanupSettingsforDeletedCompany')
	delete from GxQscripts where name = 'AppCleanupSettingsforDeletedCompany'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCleanupSettingsforDeletedCompany')
	delete from GXDBVersions where aliasname = 'AppCleanupSettingsforDeletedCompany'
GO

insert into GXDBVersions values(2, 'AppCleanupSettingsforDeletedCompany',  '00010001000200010000', 'AppCleanupSettingsforDeletedCompany', '00010001000200010000')
GO

