

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCleanupIncompleteReplicationGroups.sp] ---------- 

-- MODIFIED FOR (CCP)
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppCleanupIncompleteReplicationGroups   - cleanup replication groups which are incomplete.
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppCleanupIncompleteReplicationGroups')
BEGIN
	print '>>> Drop Stored Procedure: AppCleanupIncompleteReplicationGroups <<<'
	drop procedure AppCleanupIncompleteReplicationGroups
END
IF EXISTS (select * from GxQscripts where name='AppCleanupIncompleteReplicationGroups')
	delete from GxQscripts where name = 'AppCleanupIncompleteReplicationGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCleanupIncompleteReplicationGroups')
	delete from GXDBVersions where aliasname = 'AppCleanupIncompleteReplicationGroups'
GO
print '... Creating Procedure: AppCleanupIncompleteReplicationGroups'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCleanupIncompleteReplicationGroups
AS
DECLARE @errorCode    INT = 0
DECLARE @errorString  NVARCHAR(1024) = ''
DECLARE @o_xml		  XML
SET NOCOUNT ON
BEGIN TRY
	IF OBJECT_ID('tempdb.dbo.#IncompleteRepGroupPlanTbl') IS NOT NULL
		DROP TABLE #IncompleteRepGroupPlanTbl
	IF OBJECT_ID('tempdb.dbo.#IncompleteRepGroupTasksTbl') IS NOT NULL
		DROP TABLE #IncompleteRepGroupTasksTbl
	CREATE TABLE #IncompleteRepGroupPlanTbl (planId INT, storagePolicyId INT, PRIMARY KEY (planId))
	CREATE TABLE #IncompleteRepGroupTasksTbl (taskId INT, PRIMARY KEY (taskId))
	--Get all incomplete replication plans
	INSERT INTO #IncompleteRepGroupPlanTbl
SELECT P.id, CONVERT(INT,PP.attrVal) FROM APP_Plan P WITH(NOLOCK) LEFT JOIN APP_PlanProp PP WITH(NOLOCK) ON P.id = PP.componentNameId AND PP.attrName = 'Storage policy'
LEFT JOIN App_ReplicationGroupProp REPPROP WITH(NOLOCK) ON CAST(P.id AS NVARCHAR(12)) = REPPROP.attrVal AND REPPROP.attrName = 'Associated Plan'
WHERE P.subType = 83918853 AND (P.flag & 0x40000000) = 0 AND REPPROP.attrVal IS NULL
	IF (@@ROWCOUNT > 0)
	BEGIN
		--Find both replication task and schedule policy associated with the incomplete replication groups
		INSERT INTO #IncompleteRepGroupTasksTbl
			SELECT TMASSOC.taskId FROM TM_AssocEntity TMASSOC WITH(NOLOCK) JOIN App_Application APP WITH(NOLOCK) ON APP.id = TMASSOC.subClientId
				JOIN #IncompleteRepGroupPlanTbl P WITH(NOLOCK) ON P.storagePolicyId = APP.dataArchGrpID
WHERE APP.subClientStatus & 0x00008 = 0
		-- MARK BLRPAIR DELETED FOR CONTINUOUS REPLICATION GROUP
		UPDATE BlrPair
			SET flags = flags | 2 -- #define BLR_PAIR_FLAG_MARKED_DELETION   (1<<1)
			FROM BlrPair blr
			JOIN App_Application app WITH(NOLOCK) ON app.id = blr.subClientId
			JOIN #IncompleteRepGroupPlanTbl P WITH(NOLOCK) ON P.storagePolicyId = app.dataArchGrpID
			WHERE blr.flags & 2 = 0
		-- NEED TO MARK SUBCLIENT AS DELETED FIRST, OTHERWISE PLAN DELETION IS NOT ALLOWED
		UPDATE App_Application
SET subclientStatus = subclientStatus | 0x00004
			FROM App_Application app
			JOIN #IncompleteRepGroupPlanTbl P ON P.storagePolicyId = app.dataArchGrpID
WHERE (subclientStatus & 0x00008 = 0) AND (subclientStatus & 0x00004 = 0)
		UPDATE App_Application
			SET dataArchGrpID = 1, logArchGrpID = 1
			FROM App_Application app
			JOIN #IncompleteRepGroupPlanTbl P ON P.storagePolicyId = app.dataArchGrpID
			WHERE app.dataArchGrpID <> 1 OR app.logArchGrpID <> 1
		-- REMOVE ASSOCIATION BETWEEN PLAN AND COMPANY, SO THAT WE CAN MARK THE PLAN SCHEDULE TO BE DELETED
		DELETE umsecassoc
		FROM UMSecurityAssociations umsecassoc
JOIN UMDSgroups grps WITH(NOLOCK) ON umsecassoc.entityType1 = 158 AND umsecassoc.isUser = 0 AND umsecassoc.userOrGroupId = grps.id
		JOIN #IncompleteRepGroupPlanTbl P WITH(NOLOCK) ON P.planId = umsecassoc.entityId1
		WHERE grps.umdsProviderId <> 0
		DELETE umsecassoc
		FROM UMSecurityAssociations umsecassoc
JOIN UMUsers users WITH(NOLOCK) ON umsecassoc.entityType1 = 158 AND umsecassoc.isUser = 1 AND umsecassoc.userOrGroupId = users.id
		JOIN #IncompleteRepGroupPlanTbl P WITH(NOLOCK) ON P.planId = umsecassoc.entityId1
		WHERE users.umdsProviderId <> 0
		DECLARE DeleteReplicationPlanCursor CURSOR FOR
		SELECT planId FROM #IncompleteRepGroupPlanTbl
		DECLARE @planId INT = 0
		OPEN DeleteReplicationPlanCursor
			FETCH NEXT FROM DeleteReplicationPlanCursor INTO @planId
		WHILE @@FETCH_STATUS = 0
		BEGIN
			-- MARK THE PLAN SCHEDULED TO BE DELETED USING USERID 1 SINCE THESE PLANS ARE ASSOCIATED TO INCOMPLETE REP GROUPS
			DECLARE @xmlText XML
			EXEC AppPlanScheduleDeleteV2 @planId, 1, 0, @xmlText OUTPUT, 0
		FETCH NEXT FROM DeleteReplicationPlanCursor INTO @planId
		END --END DeleteReplicationPlanCursor fetch loop
		CLOSE DeleteReplicationPlanCursor
		DEALLOCATE DeleteReplicationPlanCursor
		-- MARK SCHEDULE POLICIES AND REPLICATION TASKS FOR DELETION
UPDATE TM_Task SET deleted = 1, flags &= ~(536870912)
			FROM TM_Task T JOIN #IncompleteRepGroupTasksTbl IT ON IT.taskId = T.taskId
		-- TRIGGER TM MAINTENANCE TO CLEAN UP RECORDS IN APP_VSAREPLICATION TABLE
		DECLARE @tmpOutputTable TABLE (outputString XML)
		INSERT INTO @tmpOutputTable
		EXEC TM_maintenance
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- check if cursor exists
    IF ( CURSOR_STATUS('global', 'DeleteReplicationPlanCursor') >= 0   OR CURSOR_STATUS('local', 'DeleteReplicationPlanCursor') >= 0 )  -- CLOSE CURSOR IF OPEN
        CLOSE DeleteReplicationPlanCursor
    IF ( CURSOR_STATUS('global','DeleteReplicationPlanCursor') = -1     OR CURSOR_STATUS('local','DeleteReplicationPlanCursor') = -1 )
        DEALLOCATE DeleteReplicationPlanCursor
	set @errorCode = ERROR_NUMBER()
    set @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	IF @errorCode = 1205  --DEADLOCK error
	BEGIN
		;THROW;   -- rethrow the DEADLOCK so XE captures.
	END
END CATCH
ERROR_EXIT:
	IF @errorCode <> 0 AND @errorString = ''
	BEGIN
		SET @errorString = (SELECT Message FROM EvLocaleMsgs WHERE MessageId = @errorCode AND [localeId] = 0)
	END
SET @o_xml = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage' FOR XML PATH ( 'App_GenericResp' ))
SELECT @o_xml  as o_xmlString
GO

IF EXISTS (select * from GxQscripts where name = 'AppCleanupIncompleteReplicationGroups')
	delete from GxQscripts where name = 'AppCleanupIncompleteReplicationGroups'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCleanupIncompleteReplicationGroups')
	delete from GXDBVersions where aliasname = 'AppCleanupIncompleteReplicationGroups'
GO

insert into GXDBVersions values(2, 'AppCleanupIncompleteReplicationGroups',  '00000000000000000000', 'AppCleanupIncompleteReplicationGroups', '00000000000000000000')
GO

